/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.twitter;

import android.util.Base64;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MappedFileReader {
    private FileInputStream fileIn;
    private MappedByteBuffer mappedBuf;
    private long fileLength;
    private int arraySize;
    private byte[] array;

    public MappedFileReader(String fileName, int arraySize) throws IOException {
        this.fileIn = new FileInputStream(fileName);
        FileChannel fileChannel = this.fileIn.getChannel();
        this.fileLength = fileChannel.size();
        this.mappedBuf = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.fileLength);
        this.arraySize = arraySize;
    }

    public int read() throws IOException {
        int n = this.mappedBuf.limit();
        int n2 = this.mappedBuf.position();
        if (n2 == n) {
            return -1;
        }
        if (n - n2 > this.arraySize) {
            this.array = new byte[this.arraySize];
            this.mappedBuf.get(this.array);
            return this.arraySize;
        }
        this.array = new byte[n - n2];
        this.mappedBuf.get(this.array);
        return n - n2;
    }

    public void close() throws IOException {
        this.fileIn.close();
    }

    public byte[] getArray() {
        return this.array;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public static String byteToBase64(byte[] bytePart) {
        return Base64.encodeToString((byte[])bytePart, (int)0);
    }
}

