/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.CipherSuite;
import cn.jmessage.support.okhttp3.Handshake;
import cn.jmessage.support.okhttp3.Headers;
import cn.jmessage.support.okhttp3.HttpUrl;
import cn.jmessage.support.okhttp3.MediaType;
import cn.jmessage.support.okhttp3.Protocol;
import cn.jmessage.support.okhttp3.Request;
import cn.jmessage.support.okhttp3.Response;
import cn.jmessage.support.okhttp3.ResponseBody;
import cn.jmessage.support.okhttp3.TlsVersion;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.cache.CacheRequest;
import cn.jmessage.support.okhttp3.internal.cache.CacheStrategy;
import cn.jmessage.support.okhttp3.internal.cache.DiskLruCache;
import cn.jmessage.support.okhttp3.internal.cache.InternalCache;
import cn.jmessage.support.okhttp3.internal.http.HttpHeaders;
import cn.jmessage.support.okhttp3.internal.http.HttpMethod;
import cn.jmessage.support.okhttp3.internal.http.StatusLine;
import cn.jmessage.support.okhttp3.internal.io.FileSystem;
import cn.jmessage.support.okhttp3.internal.platform.Platform;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSink;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.ByteString;
import cn.jmessage.support.okio.ForwardingSink;
import cn.jmessage.support.okio.ForwardingSource;
import cn.jmessage.support.okio.Okio;
import cn.jmessage.support.okio.Sink;
import cn.jmessage.support.okio.Source;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class Cache
implements Closeable,
Flushable {
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    final InternalCache internalCache = new InternalCache(){

        @Override
        public Response get(Request request) throws IOException {
            return Cache.this.get(request);
        }

        @Override
        public CacheRequest put(Response response) throws IOException {
            return Cache.this.put(response);
        }

        @Override
        public void remove(Request request) throws IOException {
            Cache.this.remove(request);
        }

        @Override
        public void update(Response response, Response response2) {
            Cache.this.update(response, response2);
        }

        @Override
        public void trackConditionalCacheHit() {
            Cache.this.trackConditionalCacheHit();
        }

        @Override
        public void trackResponse(CacheStrategy cacheStrategy) {
            Cache.this.trackResponse(cacheStrategy);
        }
    };
    final DiskLruCache cache;
    int writeSuccessCount;
    int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;
    private static final String[] z;

    public Cache(File file, long l2) {
        this(file, l2, FileSystem.SYSTEM);
    }

    Cache(File file, long l2, FileSystem fileSystem) {
        this.cache = DiskLruCache.create(fileSystem, file, 201105, 2, l2);
    }

    public static String key(HttpUrl httpUrl) {
        return ByteString.encodeUtf8(httpUrl.toString()).md5().hex();
    }

    @Nullable
    final Response get(Request request) {
        Entry entry;
        Object object = Cache.key(request.url());
        try {
            object = this.cache.get((String)object);
            if (object == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            entry = new Entry(((DiskLruCache.Snapshot)object).getSource(0));
        }
        catch (IOException iOException) {
            Util.closeQuietly((Closeable)object);
            return null;
        }
        object = entry.response((DiskLruCache.Snapshot)object);
        if (!entry.matches(request, (Response)object)) {
            Util.closeQuietly(((Response)object).body());
            return null;
        }
        return object;
    }

    @Nullable
    final CacheRequest put(Response response) {
        Object object = response.request().method();
        if (HttpMethod.invalidatesCache(response.request().method())) {
            try {
                this.remove(response.request());
            }
            catch (IOException iOException) {}
            return null;
        }
        if (!((String)object).equals(z[0])) {
            return null;
        }
        if (HttpHeaders.hasVaryAll(response)) {
            return null;
        }
        object = new Entry(response);
        DiskLruCache.Editor editor = null;
        try {
            editor = this.cache.edit(Cache.key(response.request().url()));
            if (editor == null) {
                return null;
            }
            ((Entry)object).writeTo(editor);
            return new CacheRequestImpl(editor);
        }
        catch (IOException iOException) {
            this.abortQuietly(editor);
            return null;
        }
    }

    final void remove(Request request) throws IOException {
        this.cache.remove(Cache.key(request.url()));
    }

    final void update(Response closeable, Response object) {
        object = new Entry((Response)object);
        closeable = ((CacheResponseBody)((Response)closeable).body()).snapshot;
        DiskLruCache.Editor editor = null;
        try {
            editor = ((DiskLruCache.Snapshot)closeable).edit();
            if (editor != null) {
                ((Entry)object).writeTo(editor);
                editor.commit();
            }
            return;
        }
        catch (IOException iOException) {
            this.abortQuietly(editor);
            return;
        }
    }

    private void abortQuietly(@Nullable DiskLruCache.Editor editor) {
        try {
            if (editor != null) {
                editor.abort();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public final void initialize() throws IOException {
        this.cache.initialize();
    }

    public final void delete() throws IOException {
        this.cache.delete();
    }

    public final void evictAll() throws IOException {
        this.cache.evictAll();
    }

    public final Iterator<String> urls() throws IOException {
        return new Iterator<String>(){
            final Iterator<DiskLruCache.Snapshot> delegate;
            @Nullable
            String nextUrl;
            boolean canRemove;
            private static final String z;
            {
                this.delegate = Cache.this.cache.snapshots();
            }

            @Override
            public boolean hasNext() {
                if (this.nextUrl != null) {
                    return true;
                }
                this.canRemove = false;
                while (this.delegate.hasNext()) {
                    try (DiskLruCache.Snapshot snapshot = this.delegate.next();){
                        BufferedSource bufferedSource = Okio.buffer(snapshot.getSource(0));
                        this.nextUrl = bufferedSource.readUtf8LineStrict();
                        return true;
                    }
                }
                return false;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String string = this.nextUrl;
                this.nextUrl = null;
                this.canRemove = true;
                return string;
            }

            @Override
            public void remove() {
                if (!this.canRemove) {
                    throw new IllegalStateException(z);
                }
                this.delegate.remove();
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                char[] cArray;
                block10: {
                    int n2;
                    int n3;
                    char[] cArray2;
                    int n4;
                    block9: {
                        char[] cArray3 = "h\u007fI@n\u007f2\r\u000fz\u007f|K]}:tAWl23".toCharArray();
                        n4 = 0;
                        int n5 = cArray3.length;
                        cArray2 = cArray3;
                        n3 = n5;
                        if (n5 <= 1) break block9;
                        cArray = cArray2;
                        n2 = n3;
                        if (n3 <= n4) break block10;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n6 = n4;
                        while (true) {
                            int n7;
                            char c2 = cArray4[n6];
                            switch (n4 % 5) {
                                case 0: {
                                    n7 = 26;
                                    break;
                                }
                                case 1: {
                                    n7 = 26;
                                    break;
                                }
                                case 2: {
                                    n7 = 36;
                                    break;
                                }
                                case 3: {
                                    n7 = 47;
                                    break;
                                }
                                default: {
                                    n7 = 24;
                                }
                            }
                            cArray4[n6] = (char)(c2 ^ n7);
                            ++n4;
                            cArray2 = cArray5;
                            n3 = n3;
                            if (n3 != 0) break;
                            cArray5 = cArray2;
                            n2 = n3;
                            n6 = n3;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n2 = n3;
                    } while (n3 > n4);
                }
                z = new String(cArray).intern();
            }
        };
    }

    public final synchronized int writeAbortCount() {
        return this.writeAbortCount;
    }

    public final synchronized int writeSuccessCount() {
        return this.writeSuccessCount;
    }

    public final long size() throws IOException {
        return this.cache.size();
    }

    public final long maxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public final void flush() throws IOException {
        this.cache.flush();
    }

    @Override
    public final void close() throws IOException {
        this.cache.close();
    }

    public final File directory() {
        return this.cache.getDirectory();
    }

    public final boolean isClosed() {
        return this.cache.isClosed();
    }

    final synchronized void trackResponse(CacheStrategy cacheStrategy) {
        ++this.requestCount;
        if (cacheStrategy.networkRequest != null) {
            ++this.networkCount;
            return;
        }
        if (cacheStrategy.cacheResponse != null) {
            ++this.hitCount;
        }
    }

    final synchronized void trackConditionalCacheHit() {
        ++this.hitCount;
    }

    public final synchronized int networkCount() {
        return this.networkCount;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int requestCount() {
        return this.requestCount;
    }

    static int readInt(BufferedSource object) throws IOException {
        try {
            long l2 = object.readDecimalLong();
            object = object.readUtf8LineStrict();
            if (l2 < 0L || l2 > Integer.MAX_VALUE || !((String)object).isEmpty()) {
                throw new IOException(z[1] + l2 + (String)object + "\"");
            }
            return (int)l2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u000e\t\"";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 73;
                                break;
                            }
                            case 1: {
                                n9 = 76;
                                break;
                            }
                            case 2: {
                                n9 = 118;
                                break;
                            }
                            case 3: {
                                n9 = 88;
                                break;
                            }
                            default: {
                                n9 = 36;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = ",4\u0006=G=)\u0012xE'l\u001f6Pi.\u0003,\u0004>-\u0005x\u0006";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    private static class CacheResponseBody
    extends ResponseBody {
        final DiskLruCache.Snapshot snapshot;
        private final BufferedSource bodySource;
        @Nullable
        private final String contentType;
        @Nullable
        private final String contentLength;

        CacheResponseBody(final DiskLruCache.Snapshot snapshot, String object, String string) {
            this.snapshot = snapshot;
            this.contentType = object;
            this.contentLength = string;
            object = snapshot.getSource(1);
            this.bodySource = Okio.buffer(new ForwardingSource((Source)object){

                @Override
                public void close() throws IOException {
                    snapshot.close();
                    super.close();
                }
            });
        }

        @Override
        public MediaType contentType() {
            if (this.contentType != null) {
                return MediaType.parse(this.contentType);
            }
            return null;
        }

        @Override
        public long contentLength() {
            try {
                if (this.contentLength != null) {
                    return Long.parseLong(this.contentLength);
                }
                return -1L;
            }
            catch (NumberFormatException numberFormatException) {
                return -1L;
            }
        }

        @Override
        public BufferedSource source() {
            return this.bodySource;
        }
    }

    private static final class Entry {
        private static final String SENT_MILLIS;
        private static final String RECEIVED_MILLIS;
        private final String url;
        private final Headers varyHeaders;
        private final String requestMethod;
        private final Protocol protocol;
        private final int code;
        private final String message;
        private final Headers responseHeaders;
        @Nullable
        private final Handshake handshake;
        private final long sentRequestMillis;
        private final long receivedResponseMillis;
        private static final String[] z;

        Entry(Source source) throws IOException {
            try {
                Object object = Okio.buffer(source);
                this.url = object.readUtf8LineStrict();
                this.requestMethod = object.readUtf8LineStrict();
                Object object2 = new Headers.Builder();
                int n2 = Cache.readInt(object);
                for (int i2 = 0; i2 < n2; ++i2) {
                    ((Headers.Builder)object2).addLenient(object.readUtf8LineStrict());
                }
                this.varyHeaders = ((Headers.Builder)object2).build();
                StatusLine statusLine = StatusLine.parse(object.readUtf8LineStrict());
                this.protocol = statusLine.protocol;
                this.code = statusLine.code;
                this.message = statusLine.message;
                object2 = new Headers.Builder();
                n2 = Cache.readInt(object);
                for (int i3 = 0; i3 < n2; ++i3) {
                    ((Headers.Builder)object2).addLenient(object.readUtf8LineStrict());
                }
                Object object3 = ((Headers.Builder)object2).get(SENT_MILLIS);
                Object object4 = ((Headers.Builder)object2).get(RECEIVED_MILLIS);
                ((Headers.Builder)object2).removeAll(SENT_MILLIS);
                ((Headers.Builder)object2).removeAll(RECEIVED_MILLIS);
                this.sentRequestMillis = object3 != null ? Long.parseLong((String)object3) : 0L;
                this.receivedResponseMillis = object4 != null ? Long.parseLong((String)object4) : 0L;
                this.responseHeaders = ((Headers.Builder)object2).build();
                if (this.isHttps()) {
                    object2 = object.readUtf8LineStrict();
                    if (((String)object2).length() > 0) {
                        throw new IOException(z[4] + (String)object2 + "\"");
                    }
                    object2 = CipherSuite.forJavaName(object.readUtf8LineStrict());
                    object4 = this.readCertificateList((BufferedSource)object);
                    object3 = this.readCertificateList((BufferedSource)object);
                    object = !object.exhausted() ? TlsVersion.forJavaName(object.readUtf8LineStrict()) : TlsVersion.SSL_3_0;
                    this.handshake = Handshake.get((TlsVersion)((Object)object), (CipherSuite)object2, (List<Certificate>)object4, (List<Certificate>)object3);
                } else {
                    this.handshake = null;
                }
                return;
            }
            finally {
                source.close();
            }
        }

        Entry(Response response) {
            this.url = response.request().url().toString();
            this.varyHeaders = HttpHeaders.varyHeaders(response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
            this.sentRequestMillis = response.sentRequestAtMillis();
            this.receivedResponseMillis = response.receivedResponseAtMillis();
        }

        public final void writeTo(DiskLruCache.Editor object) throws IOException {
            int n2;
            object = Okio.buffer(((DiskLruCache.Editor)object).newSink(0));
            object.writeUtf8(this.url).writeByte(10);
            object.writeUtf8(this.requestMethod).writeByte(10);
            object.writeDecimalLong(this.varyHeaders.size()).writeByte(10);
            int n3 = this.varyHeaders.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object.writeUtf8(this.varyHeaders.name(n2)).writeUtf8(z[5]).writeUtf8(this.varyHeaders.value(n2)).writeByte(10);
            }
            object.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
            object.writeDecimalLong(this.responseHeaders.size() + 2).writeByte(10);
            n3 = this.responseHeaders.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object.writeUtf8(this.responseHeaders.name(n2)).writeUtf8(z[5]).writeUtf8(this.responseHeaders.value(n2)).writeByte(10);
            }
            object.writeUtf8(SENT_MILLIS).writeUtf8(z[5]).writeDecimalLong(this.sentRequestMillis).writeByte(10);
            object.writeUtf8(RECEIVED_MILLIS).writeUtf8(z[5]).writeDecimalLong(this.receivedResponseMillis).writeByte(10);
            if (this.isHttps()) {
                object.writeByte(10);
                object.writeUtf8(this.handshake.cipherSuite().javaName()).writeByte(10);
                this.writeCertList((BufferedSink)object, this.handshake.peerCertificates());
                this.writeCertList((BufferedSink)object, this.handshake.localCertificates());
                object.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
            }
            object.close();
        }

        private boolean isHttps() {
            return this.url.startsWith(z[2]);
        }

        private List<Certificate> readCertificateList(BufferedSource bufferedSource) throws IOException {
            int n2 = Cache.readInt(bufferedSource);
            if (n2 == -1) {
                return Collections.emptyList();
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance(z[3]);
                ArrayList<Certificate> arrayList = new ArrayList<Certificate>(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = bufferedSource.readUtf8LineStrict();
                    Buffer buffer = new Buffer();
                    buffer.write(ByteString.decodeBase64(string));
                    arrayList.add(certificateFactory.generateCertificate(buffer.inputStream()));
                }
                return arrayList;
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
        }

        private void writeCertList(BufferedSink bufferedSink, List<Certificate> list) throws IOException {
            try {
                bufferedSink.writeDecimalLong(list.size()).writeByte(10);
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = ByteString.of(list.get(i2).getEncoded()).base64();
                    bufferedSink.writeUtf8(string).writeByte(10);
                }
                return;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException(certificateEncodingException.getMessage());
            }
        }

        public final boolean matches(Request request, Response response) {
            return this.url.equals(request.url().toString()) && this.requestMethod.equals(request.method()) && HttpHeaders.varyMatches(response, this.varyHeaders, request);
        }

        public final Response response(DiskLruCache.Snapshot snapshot) {
            String string = this.responseHeaders.get(z[0]);
            String string2 = this.responseHeaders.get(z[1]);
            Request request = new Request.Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
            return new Response.Builder().request(request).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody(snapshot, string, string2)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String string2;
            int n2;
            String[] stringArray = new String[6];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n3 = 0;
            String string3 = "o=qUAB&2u]\\7";
            int n4 = -1;
            block22: while (true) {
                char[] cArray;
                block31: {
                    int n5;
                    int n6;
                    char[] cArray2;
                    block30: {
                        char[] cArray3 = string3.toCharArray();
                        n2 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n6 = n7;
                        if (n7 <= 1) break block30;
                        cArray = cArray2;
                        n5 = n6;
                        if (n6 <= n2) break block31;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n2;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n2 % 5) {
                                case 0: {
                                    n9 = 44;
                                    break;
                                }
                                case 1: {
                                    n9 = 82;
                                    break;
                                }
                                case 2: {
                                    n9 = 31;
                                    break;
                                }
                                case 3: {
                                    n9 = 33;
                                    break;
                                }
                                default: {
                                    n9 = 36;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n2;
                            cArray2 = cArray5;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray5 = cArray2;
                            n5 = n6;
                            n8 = n6;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n5 = n6;
                    } while (n6 > n2);
                }
                string2 = new String(cArray);
                switch (n4) {
                    default: {
                        stringArray2[n3] = string2.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n3 = 1;
                        string3 = "o=qUAB&2mAB5kI";
                        n4 = 0;
                        continue block22;
                    }
                    case 0: {
                        stringArray2[n3] = string2.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n3 = 2;
                        string3 = "D&kQW\u0016}0";
                        n4 = 1;
                        continue block22;
                    }
                    case 1: {
                        stringArray2[n3] = string2.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n3 = 3;
                        string3 = "t|*\u0011\u001d";
                        n4 = 2;
                        continue block22;
                    }
                    case 2: {
                        stringArray2[n3] = string2.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n3 = 4;
                        string3 = "I*oDGX7{\u0001\u0006\u000er}TP\f%~R\u0004\u000e";
                        n4 = 3;
                        continue block22;
                    }
                    case 3: {
                        stringArray2[n3] = string2.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n3 = 5;
                        string3 = "\u0016r";
                        n4 = 4;
                        continue block22;
                    }
                    case 4: 
                }
                break;
            }
            stringArray2[n3] = string2.intern();
            z = stringArray3;
            StringBuilder stringBuilder = new StringBuilder().append(Platform.get().getPrefix());
            String string4 = "\u0001\u0001zOP\u0001\u001fvMHE!";
            int n10 = -1;
            block25: while (true) {
                char[] cArray;
                block33: {
                    int n11;
                    int n12;
                    char[] cArray6;
                    block32: {
                        char[] cArray7 = string4.toCharArray();
                        n2 = 0;
                        int n13 = cArray7.length;
                        cArray6 = cArray7;
                        n12 = n13;
                        if (n13 <= 1) break block32;
                        cArray = cArray6;
                        n11 = n12;
                        if (n12 <= n2) break block33;
                    }
                    do {
                        char[] cArray8 = cArray6;
                        char[] cArray9 = cArray6;
                        int n14 = n2;
                        while (true) {
                            int n15;
                            char c3 = cArray8[n14];
                            switch (n2 % 5) {
                                case 0: {
                                    n15 = 44;
                                    break;
                                }
                                case 1: {
                                    n15 = 82;
                                    break;
                                }
                                case 2: {
                                    n15 = 31;
                                    break;
                                }
                                case 3: {
                                    n15 = 33;
                                    break;
                                }
                                default: {
                                    n15 = 36;
                                }
                            }
                            cArray8[n14] = (char)(c3 ^ n15);
                            ++n2;
                            cArray6 = cArray9;
                            n12 = n12;
                            if (n12 != 0) break;
                            cArray9 = cArray6;
                            n11 = n12;
                            n14 = n12;
                            cArray8 = cArray6;
                        }
                        cArray = cArray6;
                        n11 = n12;
                    } while (n12 > n2);
                }
                string = new String(cArray).intern();
                switch (n10) {
                    default: {
                        SENT_MILLIS = stringBuilder.append(string).toString();
                        stringBuilder = new StringBuilder().append(Platform.get().getPrefix());
                        string4 = "\u0001\u0000zBAE$zE\ta;sMM_";
                        n10 = 0;
                        continue block25;
                    }
                    case 0: 
                }
                break;
            }
            RECEIVED_MILLIS = stringBuilder.append(string).toString();
        }
    }

    private final class CacheRequestImpl
    implements CacheRequest {
        private final DiskLruCache.Editor editor;
        private Sink cacheOut;
        private Sink body;
        boolean done;

        CacheRequestImpl(final DiskLruCache.Editor editor) {
            this.editor = editor;
            this.cacheOut = editor.newSink(1);
            this.body = new ForwardingSink(this.cacheOut){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    Cache cache = Cache.this;
                    synchronized (cache) {
                        if (CacheRequestImpl.this.done) {
                            return;
                        }
                        CacheRequestImpl.this.done = true;
                        ++Cache.this.writeSuccessCount;
                    }
                    super.close();
                    editor.commit();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void abort() {
            Cache cache = Cache.this;
            synchronized (cache) {
                if (this.done) {
                    return;
                }
                this.done = true;
                ++Cache.this.writeAbortCount;
            }
            Util.closeQuietly(this.cacheOut);
            try {
                this.editor.abort();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        @Override
        public final Sink body() {
            return this.body;
        }
    }
}

