/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.HttpUrl;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.tls.CertificateChainCleaner;
import cn.jmessage.support.okio.ByteString;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class CertificatePinner {
    public static final CertificatePinner DEFAULT;
    private final Set<Pin> pins;
    @Nullable
    private final CertificateChainCleaner certificateChainCleaner;
    private static final String[] z;

    CertificatePinner(Set<Pin> set, @Nullable CertificateChainCleaner certificateChainCleaner) {
        this.pins = set;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    public final boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof CertificatePinner && Util.equal(this.certificateChainCleaner, ((CertificatePinner)object).certificateChainCleaner) && this.pins.equals(((CertificatePinner)object).pins);
    }

    public final int hashCode() {
        int n2 = this.certificateChainCleaner != null ? this.certificateChainCleaner.hashCode() : 0;
        return 31 * n2 + this.pins.hashCode();
    }

    public final void check(String string, List<Certificate> list) throws SSLPeerUnverifiedException {
        Object object;
        List<Pin> list2 = this.findMatchingPins(string);
        if (list2.isEmpty()) {
            return;
        }
        if (this.certificateChainCleaner != null) {
            list = this.certificateChainCleaner.clean(list, string);
        }
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            X509Certificate x509Certificate = (X509Certificate)list.get(i2);
            object = null;
            ByteString byteString = null;
            int n3 = list2.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                Pin pin = list2.get(i3);
                if (pin.hashAlgorithm.equals(z[4])) {
                    if (byteString == null) {
                        byteString = CertificatePinner.sha256(x509Certificate);
                    }
                    if (!pin.hash.equals(byteString)) continue;
                    return;
                }
                if (pin.hashAlgorithm.equals(z[1])) {
                    if (object == null) {
                        object = CertificatePinner.sha1(x509Certificate);
                    }
                    if (!pin.hash.equals(object)) continue;
                    return;
                }
                throw new AssertionError((Object)(z[3] + pin.hashAlgorithm));
            }
        }
        StringBuilder stringBuilder = new StringBuilder(z[5]);
        int n4 = list.size();
        for (n2 = 0; n2 < n4; ++n2) {
            object = (X509Certificate)list.get(n2);
            stringBuilder.append(z[0]).append(CertificatePinner.pin((Certificate)object)).append(z[2]).append(((X509Certificate)object).getSubjectDN().getName());
        }
        stringBuilder.append(z[6]).append(string).append(":");
        n4 = list2.size();
        for (n2 = 0; n2 < n4; ++n2) {
            object = list2.get(n2);
            stringBuilder.append(z[0]).append(object);
        }
        throw new SSLPeerUnverifiedException(stringBuilder.toString());
    }

    public final void check(String string, Certificate ... certificateArray) throws SSLPeerUnverifiedException {
        this.check(string, Arrays.asList(certificateArray));
    }

    final List<Pin> findMatchingPins(String string) {
        List<Pin> list = Collections.emptyList();
        for (Pin pin : this.pins) {
            if (!pin.matches(string)) continue;
            if (list.isEmpty()) {
                list = new ArrayList<Pin>();
            }
            list.add(pin);
        }
        return list;
    }

    final CertificatePinner withCertificateChainCleaner(@Nullable CertificateChainCleaner certificateChainCleaner) {
        if (Util.equal(this.certificateChainCleaner, certificateChainCleaner)) {
            return this;
        }
        return new CertificatePinner(this.pins, certificateChainCleaner);
    }

    public static String pin(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException(z[7]);
        }
        return z[4] + CertificatePinner.sha256((X509Certificate)certificate).base64();
    }

    static ByteString sha1(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha1();
    }

    static ByteString sha256(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha256();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\t\u0005>9I";
        int n3 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block19;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 3;
                                break;
                            }
                            case 1: {
                                n9 = 37;
                                break;
                            }
                            case 2: {
                                n9 = 30;
                                break;
                            }
                            case 3: {
                                n9 = 25;
                                break;
                            }
                            default: {
                                n9 = 105;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "pM\u007f(F";
                    n3 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "9\u0005";
                    n3 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "vKml\u0019sJlm\fg\u0005vx\u001akdr~\u0006qLjq\u00049\u0005";
                    n3 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "pM\u007f+\\5\n";
                    n3 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "@@lm\u0000eL}x\u001df\u0005np\u0007mLp~IeDwu\u001cq@?\u0013I#u{|\u001b#F{k\u001djCwz\bw@>z\u0001bLp#";
                    n3 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\t\u0005>I\u0000mK{}I`@lm\u0000eL}x\u001dfV>\u007f\u0006q\u0005";
                    n3 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "@@lm\u0000eL}x\u001df\u0005np\u0007mLp~Iq@ol\u0000q@m916\u0015'9\nfWjp\u000fjF\u007fm\fp";
                    n3 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        DEFAULT = new Builder().build();
    }

    public static final class Builder {
        private final List<Pin> pins = new ArrayList<Pin>();
        private static final String z;

        public final Builder add(String string, String ... stringArray) {
            if (string == null) {
                throw new NullPointerException(z);
            }
            for (String string2 : stringArray) {
                this.pins.add(new Pin(string, string2));
            }
            return this;
        }

        public final CertificatePinner build() {
            return new CertificatePinner(new LinkedHashSet<Pin>(this.pins), null);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "L|\\\u001a\u0007Ns\bS_\u001cs]\u0002\u000e".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 60;
                                break;
                            }
                            case 1: {
                                n7 = 29;
                                break;
                            }
                            case 2: {
                                n7 = 40;
                                break;
                            }
                            case 3: {
                                n7 = 110;
                                break;
                            }
                            default: {
                                n7 = 98;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }

    static final class Pin {
        private static final String WILDCARD;
        final String pattern;
        final String canonicalHostname;
        final String hashAlgorithm;
        final ByteString hash;
        private static final String[] z;

        Pin(String string, String string2) {
            this.pattern = string;
            String string3 = this.canonicalHostname = string.startsWith(WILDCARD) ? HttpUrl.get(z[4] + string.substring(2)).host() : HttpUrl.get(z[4] + string).host();
            if (string2.startsWith(z[3])) {
                this.hashAlgorithm = z[3];
                this.hash = ByteString.decodeBase64(string2.substring(5));
            } else if (string2.startsWith(z[1])) {
                this.hashAlgorithm = z[1];
                this.hash = ByteString.decodeBase64(string2.substring(7));
            } else {
                throw new IllegalArgumentException(z[2] + string2);
            }
            if (this.hash == null) {
                throw new IllegalArgumentException(z[0] + string2);
            }
        }

        final boolean matches(String string) {
            if (this.pattern.startsWith(WILDCARD)) {
                int n2 = string.indexOf(46);
                return string.length() - n2 - 1 == this.canonicalHostname.length() && string.regionMatches(false, n2 + 1, this.canonicalHostname, 0, this.canonicalHostname.length());
            }
            return string.equals(this.canonicalHostname);
        }

        public final boolean equals(Object object) {
            return object instanceof Pin && this.pattern.equals(((Pin)object).pattern) && this.hashAlgorithm.equals(((Pin)object).hashAlgorithm) && this.hash.equals(((Pin)object).hash);
        }

        public final int hashCode() {
            int n2 = 527 + this.pattern.hashCode();
            n2 = 31 * n2 + this.hashAlgorithm.hashCode();
            return 31 * n2 + this.hash.hashCode();
        }

        public final String toString() {
            return this.hashAlgorithm + this.hash.base64();
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[5];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "LO";
            int n3 = 4;
            block13: while (true) {
                char[] cArray;
                block18: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block17: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block17;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block18;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 102;
                                    break;
                                }
                                case 1: {
                                    n9 = 97;
                                    break;
                                }
                                case 2: {
                                    n9 = 54;
                                    break;
                                }
                                case 3: {
                                    n9 = 114;
                                    break;
                                }
                                default: {
                                    n9 = 102;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    case 4: {
                        WILDCARD = string.intern();
                        string2 = "\u0016\bX\u0001F\u000b\u0014E\u0006F\u0004\u0004\u0016\u0010\u0007\u0015\u0004\u0000F\\F";
                        n3 = -1;
                        continue block13;
                    }
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "\u0015\tW@SPN";
                        n3 = 0;
                        continue block13;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "\u0016\bX\u0001F\u000b\u0014E\u0006F\u0015\u0015W\u0000\u0012F\u0016_\u0006\u000eFFE\u001a\u0007TT\u0000]AF\u000eDRA\u0015\tWCIA[\u0016";
                        n3 = 1;
                        continue block13;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "\u0015\tWCI";
                        n3 = 2;
                        continue block13;
                    }
                    case 2: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = "\u000e\u0015B\u0002\\IN";
                        n3 = 3;
                        continue block13;
                    }
                    case 3: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

