/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class CipherSuite {
    static final Comparator<String> ORDER_BY_NAME;
    private static final Map<String, CipherSuite> INSTANCES;
    public static final CipherSuite TLS_RSA_WITH_NULL_MD5;
    public static final CipherSuite TLS_RSA_WITH_NULL_SHA;
    public static final CipherSuite TLS_RSA_EXPORT_WITH_RC4_40_MD5;
    public static final CipherSuite TLS_RSA_WITH_RC4_128_MD5;
    public static final CipherSuite TLS_RSA_WITH_RC4_128_SHA;
    public static final CipherSuite TLS_RSA_EXPORT_WITH_DES40_CBC_SHA;
    public static final CipherSuite TLS_RSA_WITH_DES_CBC_SHA;
    public static final CipherSuite TLS_RSA_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA;
    public static final CipherSuite TLS_DHE_DSS_WITH_DES_CBC_SHA;
    public static final CipherSuite TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA;
    public static final CipherSuite TLS_DHE_RSA_WITH_DES_CBC_SHA;
    public static final CipherSuite TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite TLS_DH_anon_EXPORT_WITH_RC4_40_MD5;
    public static final CipherSuite TLS_DH_anon_WITH_RC4_128_MD5;
    public static final CipherSuite TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA;
    public static final CipherSuite TLS_DH_anon_WITH_DES_CBC_SHA;
    public static final CipherSuite TLS_DH_anon_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite TLS_KRB5_WITH_DES_CBC_SHA;
    public static final CipherSuite TLS_KRB5_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite TLS_KRB5_WITH_RC4_128_SHA;
    public static final CipherSuite TLS_KRB5_WITH_DES_CBC_MD5;
    public static final CipherSuite TLS_KRB5_WITH_3DES_EDE_CBC_MD5;
    public static final CipherSuite TLS_KRB5_WITH_RC4_128_MD5;
    public static final CipherSuite TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA;
    public static final CipherSuite TLS_KRB5_EXPORT_WITH_RC4_40_SHA;
    public static final CipherSuite TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5;
    public static final CipherSuite TLS_KRB5_EXPORT_WITH_RC4_40_MD5;
    public static final CipherSuite TLS_RSA_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_DH_anon_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_RSA_WITH_AES_256_CBC_SHA;
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_256_CBC_SHA;
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_256_CBC_SHA;
    public static final CipherSuite TLS_DH_anon_WITH_AES_256_CBC_SHA;
    public static final CipherSuite TLS_RSA_WITH_NULL_SHA256;
    public static final CipherSuite TLS_RSA_WITH_AES_128_CBC_SHA256;
    public static final CipherSuite TLS_RSA_WITH_AES_256_CBC_SHA256;
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_128_CBC_SHA256;
    public static final CipherSuite TLS_RSA_WITH_CAMELLIA_128_CBC_SHA;
    public static final CipherSuite TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA;
    public static final CipherSuite TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA;
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_128_CBC_SHA256;
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_256_CBC_SHA256;
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_256_CBC_SHA256;
    public static final CipherSuite TLS_DH_anon_WITH_AES_128_CBC_SHA256;
    public static final CipherSuite TLS_DH_anon_WITH_AES_256_CBC_SHA256;
    public static final CipherSuite TLS_RSA_WITH_CAMELLIA_256_CBC_SHA;
    public static final CipherSuite TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA;
    public static final CipherSuite TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA;
    public static final CipherSuite TLS_PSK_WITH_RC4_128_SHA;
    public static final CipherSuite TLS_PSK_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite TLS_PSK_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_PSK_WITH_AES_256_CBC_SHA;
    public static final CipherSuite TLS_RSA_WITH_SEED_CBC_SHA;
    public static final CipherSuite TLS_RSA_WITH_AES_128_GCM_SHA256;
    public static final CipherSuite TLS_RSA_WITH_AES_256_GCM_SHA384;
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_128_GCM_SHA256;
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_256_GCM_SHA384;
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_128_GCM_SHA256;
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_256_GCM_SHA384;
    public static final CipherSuite TLS_DH_anon_WITH_AES_128_GCM_SHA256;
    public static final CipherSuite TLS_DH_anon_WITH_AES_256_GCM_SHA384;
    public static final CipherSuite TLS_EMPTY_RENEGOTIATION_INFO_SCSV;
    public static final CipherSuite TLS_FALLBACK_SCSV;
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_NULL_SHA;
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_RC4_128_SHA;
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA;
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_NULL_SHA;
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_RC4_128_SHA;
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA;
    public static final CipherSuite TLS_ECDH_RSA_WITH_NULL_SHA;
    public static final CipherSuite TLS_ECDH_RSA_WITH_RC4_128_SHA;
    public static final CipherSuite TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite TLS_ECDH_RSA_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_ECDH_RSA_WITH_AES_256_CBC_SHA;
    public static final CipherSuite TLS_ECDHE_RSA_WITH_NULL_SHA;
    public static final CipherSuite TLS_ECDHE_RSA_WITH_RC4_128_SHA;
    public static final CipherSuite TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA;
    public static final CipherSuite TLS_ECDH_anon_WITH_NULL_SHA;
    public static final CipherSuite TLS_ECDH_anon_WITH_RC4_128_SHA;
    public static final CipherSuite TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA;
    public static final CipherSuite TLS_ECDH_anon_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_ECDH_anon_WITH_AES_256_CBC_SHA;
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256;
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384;
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256;
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384;
    public static final CipherSuite TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256;
    public static final CipherSuite TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384;
    public static final CipherSuite TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256;
    public static final CipherSuite TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384;
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256;
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384;
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256;
    public static final CipherSuite TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384;
    public static final CipherSuite TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256;
    public static final CipherSuite TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384;
    public static final CipherSuite TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256;
    public static final CipherSuite TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384;
    public static final CipherSuite TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA;
    public static final CipherSuite TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA;
    public static final CipherSuite TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256;
    public static final CipherSuite TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256;
    public static final CipherSuite TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256;
    final String javaName;

    public static synchronized CipherSuite forJavaName(String string) {
        CipherSuite cipherSuite = INSTANCES.get(string);
        if (cipherSuite == null) {
            cipherSuite = new CipherSuite(string);
            INSTANCES.put(string, cipherSuite);
        }
        return cipherSuite;
    }

    static List<CipherSuite> forJavaNames(String ... stringArray) {
        ArrayList<CipherSuite> arrayList = new ArrayList<CipherSuite>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(CipherSuite.forJavaName(string));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private CipherSuite(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.javaName = string;
    }

    private static CipherSuite of(String string, int n2) {
        return CipherSuite.forJavaName(string);
    }

    public final String javaName() {
        return this.javaName;
    }

    public final String toString() {
        return this.javaName;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        ORDER_BY_NAME = new Comparator<String>(){

            @Override
            public final int compare(String string, String string2) {
                int n2;
                int n3 = Math.min(string.length(), string2.length());
                for (n2 = 4; n2 < n3; ++n2) {
                    char c2;
                    char c3 = string.charAt(n2);
                    if (c3 == (c2 = string2.charAt(n2))) continue;
                    if (c3 < c2) {
                        return -1;
                    }
                    return 1;
                }
                n2 = string.length();
                if (n2 != (n3 = string2.length())) {
                    if (n2 < n3) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
        };
        INSTANCES = new TreeMap<String, CipherSuite>(ORDER_BY_NAME);
        String string2 = "\u001c\u0014\u007f\fD\u001c\u0006l\u0004_\u001b\u000fl\u001dC\u0003\u000bl\u001eRz";
        int n2 = -1;
        block120: while (true) {
            char[] cArray;
            block125: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block124: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block124;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block125;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 79;
                                break;
                            }
                            case 1: {
                                n8 = 71;
                                break;
                            }
                            case 2: {
                                n8 = 51;
                                break;
                            }
                            case 3: {
                                n8 = 83;
                                break;
                            }
                            default: {
                                n8 = 22;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray).intern();
            switch (n2) {
                default: {
                    TLS_RSA_WITH_NULL_MD5 = CipherSuite.of(string, 1);
                    string2 = "\u001c\u0014\u007f\fD\u001c\u0006l\u0004_\u001b\u000fl\u001dC\u0003\u000bl\u0000^\u000e";
                    n2 = 0;
                    continue block120;
                }
                case 0: {
                    TLS_RSA_WITH_NULL_SHA = CipherSuite.of(string, 2);
                    string2 = "\u001c\u0014\u007f\fD\u001c\u0006l\u0016N\u001f\ba\u0007I\u0018\u000eg\u001bI\u001d\u0004\u0007\f\"\u007f\u0018~\u0017#";
                    n2 = 1;
                    continue block120;
                }
                case 1: {
                    TLS_RSA_EXPORT_WITH_RC4_40_MD5 = CipherSuite.of(string, 3);
                    string2 = "\u001c\u0014\u007f\fD\u001c\u0006l\u0004_\u001b\u000fl\u0001U{\u0018\u0002a.\u0010\nwf";
                    n2 = 2;
                    continue block120;
                }
                case 2: {
                    TLS_RSA_WITH_RC4_128_MD5 = CipherSuite.of(string, 4);
                    string2 = "\u001c\u0014\u007f\fD\u001c\u0006l\u0004_\u001b\u000fl\u0001U{\u0018\u0002a.\u0010\u0014{\u0012";
                    n2 = 3;
                    continue block120;
                }
                case 3: {
                    TLS_RSA_WITH_RC4_128_SHA = CipherSuite.of(string, 5);
                    string2 = "\u001c\u0014\u007f\fD\u001c\u0006l\u0016N\u001f\ba\u0007I\u0018\u000eg\u001bI\u000b\u0002`g&\u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 4;
                    continue block120;
                }
                case 4: {
                    TLS_RSA_EXPORT_WITH_DES40_CBC_SHA = CipherSuite.of(string, 8);
                    string2 = "\u001c\u0014\u007f\fD\u001c\u0006l\u0004_\u001b\u000fl\u0017S\u001c\u0018p\u0011U\u0010\u0014{\u0012";
                    n2 = 5;
                    continue block120;
                }
                case 5: {
                    TLS_RSA_WITH_DES_CBC_SHA = CipherSuite.of(string, 9);
                    string2 = "\u001c\u0014\u007f\fD\u001c\u0006l\u0004_\u001b\u000fl`R\n\u0014l\u0016R\n\u0018p\u0011U\u0010\u0014{\u0012";
                    n2 = 6;
                    continue block120;
                }
                case 6: {
                    TLS_RSA_WITH_3DES_EDE_CBC_SHA = CipherSuite.of(string, 10);
                    string2 = "\u001c\u0014\u007f\fR\u0007\u0002l\u0017E\u001c\u0018v\u000bF\u0000\u0015g\fA\u0006\u0013{\fR\n\u0014\u0007cI\f\u0005p\fE\u0007\u0006";
                    n2 = 7;
                    continue block120;
                }
                case 7: {
                    TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = CipherSuite.of(string, 17);
                    string2 = "\u001c\u0014\u007f\fR\u0007\u0002l\u0017E\u001c\u0018d\u001aB\u0007\u0018w\u0016E\u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 8;
                    continue block120;
                }
                case 8: {
                    TLS_DHE_DSS_WITH_DES_CBC_SHA = CipherSuite.of(string, 18);
                    string2 = "\u001c\u0014\u007f\fR\u0007\u0002l\u0017E\u001c\u0018d\u001aB\u0007\u0018\u0000\u0017S\u001c\u0018v\u0017S\u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 9;
                    continue block120;
                }
                case 9: {
                    TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = CipherSuite.of(string, 19);
                    string2 = "\u001c\u0014\u007f\fR\u0007\u0002l\u0001E\u000e\u0018v\u000bF\u0000\u0015g\fA\u0006\u0013{\fR\n\u0014\u0007cI\f\u0005p\fE\u0007\u0006";
                    n2 = 10;
                    continue block120;
                }
                case 10: {
                    TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = CipherSuite.of(string, 20);
                    string2 = "\u001c\u0014\u007f\fR\u0007\u0002l\u0001E\u000e\u0018d\u001aB\u0007\u0018w\u0016E\u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 11;
                    continue block120;
                }
                case 11: {
                    TLS_DHE_RSA_WITH_DES_CBC_SHA = CipherSuite.of(string, 21);
                    string2 = "\u001c\u0014\u007f\fR\u0007\u0002l\u0001E\u000e\u0018d\u001aB\u0007\u0018\u0000\u0017S\u001c\u0018v\u0017S\u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 12;
                    continue block120;
                }
                case 12: {
                    TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = CipherSuite.of(string, 22);
                    string2 = "\u001c\u0014\u007f\fR\u0007\u0018R=y!\u0018v\u000bF\u0000\u0015g\fA\u0006\u0013{\fD\fslg&\u0010\nwf";
                    n2 = 13;
                    continue block120;
                }
                case 13: {
                    TLS_DH_anon_EXPORT_WITH_RC4_40_MD5 = CipherSuite.of(string, 23);
                    string2 = "\u001c\u0014\u007f\fR\u0007\u0018R=y!\u0018d\u001aB\u0007\u0018a\u0010\"\u0010v\u0001kI\u0002\u0003\u0006";
                    n2 = 14;
                    continue block120;
                }
                case 14: {
                    TLS_DH_anon_WITH_RC4_128_MD5 = CipherSuite.of(string, 24);
                    string2 = "\u001c\u0014\u007f\fR\u0007\u0018R=y!\u0018v\u000bF\u0000\u0015g\fA\u0006\u0013{\fR\n\u0014\u0007cI\f\u0005p\fE\u0007\u0006";
                    n2 = 15;
                    continue block120;
                }
                case 15: {
                    TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA = CipherSuite.of(string, 25);
                    string2 = "\u001c\u0014\u007f\fR\u0007\u0018R=y!\u0018d\u001aB\u0007\u0018w\u0016E\u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 16;
                    continue block120;
                }
                case 16: {
                    TLS_DH_anon_WITH_DES_CBC_SHA = CipherSuite.of(string, 26);
                    string2 = "\u001c\u0014\u007f\fR\u0007\u0018R=y!\u0018d\u001aB\u0007\u0018\u0000\u0017S\u001c\u0018v\u0017S\u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 17;
                    continue block120;
                }
                case 17: {
                    TLS_DH_anon_WITH_3DES_EDE_CBC_SHA = CipherSuite.of(string, 27);
                    string2 = "\u001b\u000b`\f]\u001d\u0005\u0006\fA\u0006\u0013{\fR\n\u0014l\u0010T\f\u0018`\u001bW";
                    n2 = 18;
                    continue block120;
                }
                case 18: {
                    TLS_KRB5_WITH_DES_CBC_SHA = CipherSuite.of(string, 30);
                    string2 = "\u001b\u000b`\f]\u001d\u0005\u0006\fA\u0006\u0013{\f%\u000b\u0002`\fS\u000b\u0002l\u0010T\f\u0018`\u001bW";
                    n2 = 19;
                    continue block120;
                }
                case 19: {
                    TLS_KRB5_WITH_3DES_EDE_CBC_SHA = CipherSuite.of(string, 31);
                    string2 = "\u001b\u000b`\f]\u001d\u0005\u0006\fA\u0006\u0013{\fD\fslb$w\u0018`\u001bW";
                    n2 = 20;
                    continue block120;
                }
                case 20: {
                    TLS_KRB5_WITH_RC4_128_SHA = CipherSuite.of(string, 32);
                    string2 = "\u001b\u000b`\f]\u001d\u0005\u0006\fA\u0006\u0013{\fR\n\u0014l\u0010T\f\u0018~\u0017#";
                    n2 = 21;
                    continue block120;
                }
                case 21: {
                    TLS_KRB5_WITH_DES_CBC_MD5 = CipherSuite.of(string, 34);
                    string2 = "\u001b\u000b`\f]\u001d\u0005\u0006\fA\u0006\u0013{\f%\u000b\u0002`\fS\u000b\u0002l\u0010T\f\u0018~\u0017#";
                    n2 = 22;
                    continue block120;
                }
                case 22: {
                    TLS_KRB5_WITH_3DES_EDE_CBC_MD5 = CipherSuite.of(string, 35);
                    string2 = "\u001b\u000b`\f]\u001d\u0005\u0006\fA\u0006\u0013{\fD\fslb$w\u0018~\u0017#";
                    n2 = 23;
                    continue block120;
                }
                case 23: {
                    TLS_KRB5_WITH_RC4_128_MD5 = CipherSuite.of(string, 36);
                    string2 = "\u001b\u000b`\f]\u001d\u0005\u0006\fS\u0017\u0017|\u0001B\u0010\u0010z\u0007^\u0010\u0003v\u0000I\f\u0005p\f\"\u007f\u0018`\u001bW";
                    n2 = 24;
                    continue block120;
                }
                case 24: {
                    TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA = CipherSuite.of(string, 38);
                    string2 = "\u001b\u000b`\f]\u001d\u0005\u0006\fS\u0017\u0017|\u0001B\u0010\u0010z\u0007^\u0010\u0015pgI{wl\u0000^\u000e";
                    n2 = 25;
                    continue block120;
                }
                case 25: {
                    TLS_KRB5_EXPORT_WITH_RC4_40_SHA = CipherSuite.of(string, 40);
                    string2 = "\u001b\u000b`\f]\u001d\u0005\u0006\fS\u0017\u0017|\u0001B\u0010\u0010z\u0007^\u0010\u0003v\u0000I\f\u0005p\f\"\u007f\u0018~\u0017#";
                    n2 = 26;
                    continue block120;
                }
                case 26: {
                    TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5 = CipherSuite.of(string, 41);
                    string2 = "\u001b\u000b`\f]\u001d\u0005\u0006\fS\u0017\u0017|\u0001B\u0010\u0010z\u0007^\u0010\u0015pgI{wl\u001eRz";
                    n2 = 27;
                    continue block120;
                }
                case 27: {
                    TLS_KRB5_EXPORT_WITH_RC4_40_MD5 = CipherSuite.of(string, 43);
                    string2 = "\u001b\u000b`\fD\u001c\u0006l\u0004_\u001b\u000fl\u0012S\u001c\u0018\u0002a.\u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 28;
                    continue block120;
                }
                case 28: {
                    TLS_RSA_WITH_AES_128_CBC_SHA = CipherSuite.of(string, 47);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0017E\u001c\u0018d\u001aB\u0007\u0018r\u0016E\u0010v\u0001kI\f\u0005p\fE\u0007\u0006";
                    n2 = 29;
                    continue block120;
                }
                case 29: {
                    TLS_DHE_DSS_WITH_AES_128_CBC_SHA = CipherSuite.of(string, 50);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0001E\u000e\u0018d\u001aB\u0007\u0018r\u0016E\u0010v\u0001kI\f\u0005p\fE\u0007\u0006";
                    n2 = 30;
                    continue block120;
                }
                case 30: {
                    TLS_DHE_RSA_WITH_AES_128_CBC_SHA = CipherSuite.of(string, 51);
                    string2 = "\u001b\u000b`\fR\u0007\u0018R=y!\u0018d\u001aB\u0007\u0018r\u0016E\u0010v\u0001kI\f\u0005p\fE\u0007\u0006";
                    n2 = 31;
                    continue block120;
                }
                case 31: {
                    TLS_DH_anon_WITH_AES_128_CBC_SHA = CipherSuite.of(string, 52);
                    string2 = "\u001b\u000b`\fD\u001c\u0006l\u0004_\u001b\u000fl\u0012S\u001c\u0018\u0001f \u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 32;
                    continue block120;
                }
                case 32: {
                    TLS_RSA_WITH_AES_256_CBC_SHA = CipherSuite.of(string, 53);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0017E\u001c\u0018d\u001aB\u0007\u0018r\u0016E\u0010u\u0006eI\f\u0005p\fE\u0007\u0006";
                    n2 = 33;
                    continue block120;
                }
                case 33: {
                    TLS_DHE_DSS_WITH_AES_256_CBC_SHA = CipherSuite.of(string, 56);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0001E\u000e\u0018d\u001aB\u0007\u0018r\u0016E\u0010u\u0006eI\f\u0005p\fE\u0007\u0006";
                    n2 = 34;
                    continue block120;
                }
                case 34: {
                    TLS_DHE_RSA_WITH_AES_256_CBC_SHA = CipherSuite.of(string, 57);
                    string2 = "\u001b\u000b`\fR\u0007\u0018R=y!\u0018d\u001aB\u0007\u0018r\u0016E\u0010u\u0006eI\f\u0005p\fE\u0007\u0006";
                    n2 = 35;
                    continue block120;
                }
                case 35: {
                    TLS_DH_anon_WITH_AES_256_CBC_SHA = CipherSuite.of(string, 58);
                    string2 = "\u001b\u000b`\fD\u001c\u0006l\u0004_\u001b\u000fl\u001dC\u0003\u000bl\u0000^\u000eu\u0006e";
                    n2 = 36;
                    continue block120;
                }
                case 36: {
                    TLS_RSA_WITH_NULL_SHA256 = CipherSuite.of(string, 59);
                    string2 = "\u001b\u000b`\fD\u001c\u0006l\u0004_\u001b\u000fl\u0012S\u001c\u0018\u0002a.\u0010\u0004q\u0010I\u001c\u000fra#y";
                    n2 = 37;
                    continue block120;
                }
                case 37: {
                    TLS_RSA_WITH_AES_128_CBC_SHA256 = CipherSuite.of(string, 60);
                    string2 = "\u001b\u000b`\fD\u001c\u0006l\u0004_\u001b\u000fl\u0012S\u001c\u0018\u0001f \u0010\u0004q\u0010I\u001c\u000fra#y";
                    n2 = 38;
                    continue block120;
                }
                case 38: {
                    TLS_RSA_WITH_AES_256_CBC_SHA256 = CipherSuite.of(string, 61);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0017E\u001c\u0018d\u001aB\u0007\u0018r\u0016E\u0010v\u0001kI\f\u0005p\fE\u0007\u0006\u0001f ";
                    n2 = 39;
                    continue block120;
                }
                case 39: {
                    TLS_DHE_DSS_WITH_AES_128_CBC_SHA256 = CipherSuite.of(string, 64);
                    string2 = "\u001b\u000b`\fD\u001c\u0006l\u0004_\u001b\u000fl\u0010W\u0002\u0002\u007f\u001f_\u000e\u0018\u0002a.\u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 40;
                    continue block120;
                }
                case 40: {
                    TLS_RSA_WITH_CAMELLIA_128_CBC_SHA = CipherSuite.of(string, 65);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0017E\u001c\u0018d\u001aB\u0007\u0018p\u0012[\n\u000b\u007f\u001aW\u0010v\u0001kI\f\u0005p\fE\u0007\u0006";
                    n2 = 41;
                    continue block120;
                }
                case 41: {
                    TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = CipherSuite.of(string, 68);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0001E\u000e\u0018d\u001aB\u0007\u0018p\u0012[\n\u000b\u007f\u001aW\u0010v\u0001kI\f\u0005p\fE\u0007\u0006";
                    n2 = 42;
                    continue block120;
                }
                case 42: {
                    TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = CipherSuite.of(string, 69);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0001E\u000e\u0018d\u001aB\u0007\u0018r\u0016E\u0010v\u0001kI\f\u0005p\fE\u0007\u0006\u0001f ";
                    n2 = 43;
                    continue block120;
                }
                case 43: {
                    TLS_DHE_RSA_WITH_AES_128_CBC_SHA256 = CipherSuite.of(string, 103);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0017E\u001c\u0018d\u001aB\u0007\u0018r\u0016E\u0010u\u0006eI\f\u0005p\fE\u0007\u0006\u0001f ";
                    n2 = 44;
                    continue block120;
                }
                case 44: {
                    TLS_DHE_DSS_WITH_AES_256_CBC_SHA256 = CipherSuite.of(string, 106);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0001E\u000e\u0018d\u001aB\u0007\u0018r\u0016E\u0010u\u0006eI\f\u0005p\fE\u0007\u0006\u0001f ";
                    n2 = 45;
                    continue block120;
                }
                case 45: {
                    TLS_DHE_RSA_WITH_AES_256_CBC_SHA256 = CipherSuite.of(string, 107);
                    string2 = "\u001b\u000b`\fR\u0007\u0018R=y!\u0018d\u001aB\u0007\u0018r\u0016E\u0010v\u0001kI\f\u0005p\fE\u0007\u0006\u0001f ";
                    n2 = 46;
                    continue block120;
                }
                case 46: {
                    TLS_DH_anon_WITH_AES_128_CBC_SHA256 = CipherSuite.of(string, 108);
                    string2 = "\u001b\u000b`\fR\u0007\u0018R=y!\u0018d\u001aB\u0007\u0018r\u0016E\u0010u\u0006eI\f\u0005p\fE\u0007\u0006\u0001f ";
                    n2 = 47;
                    continue block120;
                }
                case 47: {
                    TLS_DH_anon_WITH_AES_256_CBC_SHA256 = CipherSuite.of(string, 109);
                    string2 = "\u001b\u000b`\fD\u001c\u0006l\u0004_\u001b\u000fl\u0010W\u0002\u0002\u007f\u001f_\u000e\u0018\u0001f \u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 48;
                    continue block120;
                }
                case 48: {
                    TLS_RSA_WITH_CAMELLIA_256_CBC_SHA = CipherSuite.of(string, 132);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0017E\u001c\u0018d\u001aB\u0007\u0018p\u0012[\n\u000b\u007f\u001aW\u0010u\u0006eI\f\u0005p\fE\u0007\u0006";
                    n2 = 49;
                    continue block120;
                }
                case 49: {
                    TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = CipherSuite.of(string, 135);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0001E\u000e\u0018d\u001aB\u0007\u0018p\u0012[\n\u000b\u007f\u001aW\u0010u\u0006eI\f\u0005p\fE\u0007\u0006";
                    n2 = 50;
                    continue block120;
                }
                case 50: {
                    TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = CipherSuite.of(string, 136);
                    string2 = "\u001b\u000b`\fF\u001c\fl\u0004_\u001b\u000fl\u0001U{\u0018\u0002a.\u0010\u0014{\u0012";
                    n2 = 51;
                    continue block120;
                }
                case 51: {
                    TLS_PSK_WITH_RC4_128_SHA = CipherSuite.of(string, 138);
                    string2 = "\u001b\u000b`\fF\u001c\fl\u0004_\u001b\u000fl`R\n\u0014l\u0016R\n\u0018p\u0011U\u0010\u0014{\u0012";
                    n2 = 52;
                    continue block120;
                }
                case 52: {
                    TLS_PSK_WITH_3DES_EDE_CBC_SHA = CipherSuite.of(string, 139);
                    string2 = "\u001b\u000b`\fF\u001c\fl\u0004_\u001b\u000fl\u0012S\u001c\u0018\u0002a.\u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 53;
                    continue block120;
                }
                case 53: {
                    TLS_PSK_WITH_AES_128_CBC_SHA = CipherSuite.of(string, 140);
                    string2 = "\u001b\u000b`\fF\u001c\fl\u0004_\u001b\u000fl\u0012S\u001c\u0018\u0001f \u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 54;
                    continue block120;
                }
                case 54: {
                    TLS_PSK_WITH_AES_256_CBC_SHA = CipherSuite.of(string, 141);
                    string2 = "\u001b\u000b`\fD\u001c\u0006l\u0004_\u001b\u000fl\u0000S\n\u0003l\u0010T\f\u0018`\u001bW";
                    n2 = 55;
                    continue block120;
                }
                case 55: {
                    TLS_RSA_WITH_SEED_CBC_SHA = CipherSuite.of(string, 150);
                    string2 = "\u001b\u000b`\fD\u001c\u0006l\u0004_\u001b\u000fl\u0012S\u001c\u0018\u0002a.\u0010\u0000p\u001eI\u001c\u000fra#y";
                    n2 = 56;
                    continue block120;
                }
                case 56: {
                    TLS_RSA_WITH_AES_128_GCM_SHA256 = CipherSuite.of(string, 156);
                    string2 = "\u001b\u000b`\fD\u001c\u0006l\u0004_\u001b\u000fl\u0012S\u001c\u0018\u0001f \u0010\u0000p\u001eI\u001c\u000fr`.{";
                    n2 = 57;
                    continue block120;
                }
                case 57: {
                    TLS_RSA_WITH_AES_256_GCM_SHA384 = CipherSuite.of(string, 157);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0001E\u000e\u0018d\u001aB\u0007\u0018r\u0016E\u0010v\u0001kI\b\u0004~\fE\u0007\u0006\u0001f ";
                    n2 = 58;
                    continue block120;
                }
                case 58: {
                    TLS_DHE_RSA_WITH_AES_128_GCM_SHA256 = CipherSuite.of(string, 158);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0001E\u000e\u0018d\u001aB\u0007\u0018r\u0016E\u0010u\u0006eI\b\u0004~\fE\u0007\u0006\u0000k\"";
                    n2 = 59;
                    continue block120;
                }
                case 59: {
                    TLS_DHE_RSA_WITH_AES_256_GCM_SHA384 = CipherSuite.of(string, 159);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0017E\u001c\u0018d\u001aB\u0007\u0018r\u0016E\u0010v\u0001kI\b\u0004~\fE\u0007\u0006\u0001f ";
                    n2 = 60;
                    continue block120;
                }
                case 60: {
                    TLS_DHE_DSS_WITH_AES_128_GCM_SHA256 = CipherSuite.of(string, 162);
                    string2 = "\u001b\u000b`\fR\u0007\u0002l\u0017E\u001c\u0018d\u001aB\u0007\u0018r\u0016E\u0010u\u0006eI\b\u0004~\fE\u0007\u0006\u0000k\"";
                    n2 = 61;
                    continue block120;
                }
                case 61: {
                    TLS_DHE_DSS_WITH_AES_256_GCM_SHA384 = CipherSuite.of(string, 163);
                    string2 = "\u001b\u000b`\fR\u0007\u0018R=y!\u0018d\u001aB\u0007\u0018r\u0016E\u0010v\u0001kI\b\u0004~\fE\u0007\u0006\u0001f ";
                    n2 = 62;
                    continue block120;
                }
                case 62: {
                    TLS_DH_anon_WITH_AES_128_GCM_SHA256 = CipherSuite.of(string, 166);
                    string2 = "\u001b\u000b`\fR\u0007\u0018R=y!\u0018d\u001aB\u0007\u0018r\u0016E\u0010u\u0006eI\b\u0004~\fE\u0007\u0006\u0000k\"";
                    n2 = 63;
                    continue block120;
                }
                case 63: {
                    TLS_DH_anon_WITH_AES_256_GCM_SHA384 = CipherSuite.of(string, 167);
                    string2 = "\u001b\u000b`\fS\u0002\u0017g\nI\u001d\u0002}\u0016Q\u0000\u0013z\u0012B\u0006\b}\f_\u0001\u0001|\fE\f\u0014e";
                    n2 = 64;
                    continue block120;
                }
                case 64: {
                    TLS_EMPTY_RENEGOTIATION_INFO_SCSV = CipherSuite.of(string, 255);
                    string2 = "\u001b\u000b`\fP\u000e\u000b\u007f\u0011W\f\fl\u0000U\u001c\u0011";
                    n2 = 65;
                    continue block120;
                }
                case 65: {
                    TLS_FALLBACK_SCSV = CipherSuite.of(string, 22016);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fS\f\u0003`\u0012I\u0018\u000eg\u001bI\u0001\u0012\u007f\u001fI\u001c\u000fr";
                    n2 = 66;
                    continue block120;
                }
                case 66: {
                    TLS_ECDH_ECDSA_WITH_NULL_SHA = CipherSuite.of(string, 49153);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fS\f\u0003`\u0012I\u0018\u000eg\u001bI\u001d\u0004\u0007\f'}\u007fl\u0000^\u000e";
                    n2 = 67;
                    continue block120;
                }
                case 67: {
                    TLS_ECDH_ECDSA_WITH_RC4_128_SHA = CipherSuite.of(string, 49154);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fS\f\u0003`\u0012I\u0018\u000eg\u001bI|\u0003v\u0000I\n\u0003v\fU\r\u0004l\u0000^\u000e";
                    n2 = 68;
                    continue block120;
                }
                case 68: {
                    TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA = CipherSuite.of(string, 49155);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fS\f\u0003`\u0012I\u0018\u000eg\u001bI\u000e\u0002`\f'}\u007fl\u0010T\f\u0018`\u001bW";
                    n2 = 69;
                    continue block120;
                }
                case 69: {
                    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA = CipherSuite.of(string, 49156);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fS\f\u0003`\u0012I\u0018\u000eg\u001bI\u000e\u0002`\f$zql\u0010T\f\u0018`\u001bW";
                    n2 = 70;
                    continue block120;
                }
                case 70: {
                    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA = CipherSuite.of(string, 49157);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\n\u0004w\u0000W\u0010\u0010z\u0007^\u0010\tf\u001fZ\u0010\u0014{\u0012";
                    n2 = 71;
                    continue block120;
                }
                case 71: {
                    TLS_ECDHE_ECDSA_WITH_NULL_SHA = CipherSuite.of(string, 49158);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\n\u0004w\u0000W\u0010\u0010z\u0007^\u0010\u0015pgI~u\u000b\fE\u0007\u0006";
                    n2 = 72;
                    continue block120;
                }
                case 72: {
                    TLS_ECDHE_ECDSA_WITH_RC4_128_SHA = CipherSuite.of(string, 49159);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\n\u0004w\u0000W\u0010\u0010z\u0007^\u0010tw\u0016E\u0010\u0002w\u0016I\f\u0005p\fE\u0007\u0006";
                    n2 = 73;
                    continue block120;
                }
                case 73: {
                    TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA = CipherSuite.of(string, 49160);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\n\u0004w\u0000W\u0010\u0010z\u0007^\u0010\u0006v\u0000I~u\u000b\fU\r\u0004l\u0000^\u000e";
                    n2 = 74;
                    continue block120;
                }
                case 74: {
                    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = CipherSuite.of(string, 49161);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\n\u0004w\u0000W\u0010\u0010z\u0007^\u0010\u0006v\u0000I}r\u0005\fU\r\u0004l\u0000^\u000e";
                    n2 = 75;
                    continue block120;
                }
                case 75: {
                    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = CipherSuite.of(string, 49162);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fD\u001c\u0006l\u0004_\u001b\u000fl\u001dC\u0003\u000bl\u0000^\u000e";
                    n2 = 76;
                    continue block120;
                }
                case 76: {
                    TLS_ECDH_RSA_WITH_NULL_SHA = CipherSuite.of(string, 49163);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fD\u001c\u0006l\u0004_\u001b\u000fl\u0001U{\u0018\u0002a.\u0010\u0014{\u0012";
                    n2 = 77;
                    continue block120;
                }
                case 77: {
                    TLS_ECDH_RSA_WITH_RC4_128_SHA = CipherSuite.of(string, 49164);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fD\u001c\u0006l\u0004_\u001b\u000fl`R\n\u0014l\u0016R\n\u0018p\u0011U\u0010\u0014{\u0012";
                    n2 = 78;
                    continue block120;
                }
                case 78: {
                    TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA = CipherSuite.of(string, 49165);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fD\u001c\u0006l\u0004_\u001b\u000fl\u0012S\u001c\u0018\u0002a.\u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 79;
                    continue block120;
                }
                case 79: {
                    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA = CipherSuite.of(string, 49166);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fD\u001c\u0006l\u0004_\u001b\u000fl\u0012S\u001c\u0018\u0001f \u0010\u0004q\u0010I\u001c\u000fr";
                    n2 = 80;
                    continue block120;
                }
                case 80: {
                    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA = CipherSuite.of(string, 49167);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\u001d\u0014r\fA\u0006\u0013{\fX\u001a\u000b\u007f\fE\u0007\u0006";
                    n2 = 81;
                    continue block120;
                }
                case 81: {
                    TLS_ECDHE_RSA_WITH_NULL_SHA = CipherSuite.of(string, 49168);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\u001d\u0014r\fA\u0006\u0013{\fD\fslb$w\u0018`\u001bW";
                    n2 = 82;
                    continue block120;
                }
                case 82: {
                    TLS_ECDHE_RSA_WITH_RC4_128_SHA = CipherSuite.of(string, 49169);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\u001d\u0014r\fA\u0006\u0013{\f%\u000b\u0002`\fS\u000b\u0002l\u0010T\f\u0018`\u001bW";
                    n2 = 83;
                    continue block120;
                }
                case 83: {
                    TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA = CipherSuite.of(string, 49170);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\u001d\u0014r\fA\u0006\u0013{\fW\n\u0014lb$w\u0018p\u0011U\u0010\u0014{\u0012";
                    n2 = 84;
                    continue block120;
                }
                case 84: {
                    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA = CipherSuite.of(string, 49171);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\u001d\u0014r\fA\u0006\u0013{\fW\n\u0014la#y\u0018p\u0011U\u0010\u0014{\u0012";
                    n2 = 85;
                    continue block120;
                }
                case 85: {
                    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA = CipherSuite.of(string, 49172);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fw!(]\fA\u0006\u0013{\fX\u001a\u000b\u007f\fE\u0007\u0006";
                    n2 = 86;
                    continue block120;
                }
                case 86: {
                    TLS_ECDH_anon_WITH_NULL_SHA = CipherSuite.of(string, 49173);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fw!(]\fA\u0006\u0013{\fD\fslb$w\u0018`\u001bW";
                    n2 = 87;
                    continue block120;
                }
                case 87: {
                    TLS_ECDH_anon_WITH_RC4_128_SHA = CipherSuite.of(string, 49174);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fw!(]\fA\u0006\u0013{\f%\u000b\u0002`\fS\u000b\u0002l\u0010T\f\u0018`\u001bW";
                    n2 = 88;
                    continue block120;
                }
                case 88: {
                    TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA = CipherSuite.of(string, 49175);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fw!(]\fA\u0006\u0013{\fW\n\u0014lb$w\u0018p\u0011U\u0010\u0014{\u0012";
                    n2 = 89;
                    continue block120;
                }
                case 89: {
                    TLS_ECDH_anon_WITH_AES_128_CBC_SHA = CipherSuite.of(string, 49176);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fw!(]\fA\u0006\u0013{\fW\n\u0014la#y\u0018p\u0011U\u0010\u0014{\u0012";
                    n2 = 90;
                    continue block120;
                }
                case 90: {
                    TLS_ECDH_anon_WITH_AES_256_CBC_SHA = CipherSuite.of(string, 49177);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\n\u0004w\u0000W\u0010\u0010z\u0007^\u0010\u0006v\u0000I~u\u000b\fU\r\u0004l\u0000^\u000eu\u0006e";
                    n2 = 91;
                    continue block120;
                }
                case 91: {
                    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 = CipherSuite.of(string, 49187);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\n\u0004w\u0000W\u0010\u0010z\u0007^\u0010\u0006v\u0000I}r\u0005\fU\r\u0004l\u0000^\u000et\u000bg";
                    n2 = 92;
                    continue block120;
                }
                case 92: {
                    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 = CipherSuite.of(string, 49188);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fS\f\u0003`\u0012I\u0018\u000eg\u001bI\u000e\u0002`\f'}\u007fl\u0010T\f\u0018`\u001bW}r\u0005";
                    n2 = 93;
                    continue block120;
                }
                case 93: {
                    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256 = CipherSuite.of(string, 49189);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fS\f\u0003`\u0012I\u0018\u000eg\u001bI\u000e\u0002`\f$zql\u0010T\f\u0018`\u001bW|\u007f\u0007";
                    n2 = 94;
                    continue block120;
                }
                case 94: {
                    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384 = CipherSuite.of(string, 49190);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\u001d\u0014r\fA\u0006\u0013{\fW\n\u0014lb$w\u0018p\u0011U\u0010\u0014{\u0012$zq";
                    n2 = 95;
                    continue block120;
                }
                case 95: {
                    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = CipherSuite.of(string, 49191);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\u001d\u0014r\fA\u0006\u0013{\fW\n\u0014la#y\u0018p\u0011U\u0010\u0014{\u0012%ws";
                    n2 = 96;
                    continue block120;
                }
                case 96: {
                    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = CipherSuite.of(string, 49192);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fD\u001c\u0006l\u0004_\u001b\u000fl\u0012S\u001c\u0018\u0002a.\u0010\u0004q\u0010I\u001c\u000fra#y";
                    n2 = 97;
                    continue block120;
                }
                case 97: {
                    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256 = CipherSuite.of(string, 49193);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fD\u001c\u0006l\u0004_\u001b\u000fl\u0012S\u001c\u0018\u0001f \u0010\u0004q\u0010I\u001c\u000fr`.{";
                    n2 = 98;
                    continue block120;
                }
                case 98: {
                    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384 = CipherSuite.of(string, 49194);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\n\u0004w\u0000W\u0010\u0010z\u0007^\u0010\u0006v\u0000I~u\u000b\fQ\f\nl\u0000^\u000eu\u0006e";
                    n2 = 99;
                    continue block120;
                }
                case 99: {
                    TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = CipherSuite.of(string, 49195);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\n\u0004w\u0000W\u0010\u0010z\u0007^\u0010\u0006v\u0000I}r\u0005\fQ\f\nl\u0000^\u000et\u000bg";
                    n2 = 100;
                    continue block120;
                }
                case 100: {
                    TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = CipherSuite.of(string, 49196);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fS\f\u0003`\u0012I\u0018\u000eg\u001bI\u000e\u0002`\f'}\u007fl\u0014U\u0002\u0018`\u001bW}r\u0005";
                    n2 = 101;
                    continue block120;
                }
                case 101: {
                    TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = CipherSuite.of(string, 49197);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fS\f\u0003`\u0012I\u0018\u000eg\u001bI\u000e\u0002`\f$zql\u0014U\u0002\u0018`\u001bW|\u007f\u0007";
                    n2 = 102;
                    continue block120;
                }
                case 102: {
                    TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = CipherSuite.of(string, 49198);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\u001d\u0014r\fA\u0006\u0013{\fW\n\u0014lb$w\u0018t\u0010[\u0010\u0014{\u0012$zq";
                    n2 = 103;
                    continue block120;
                }
                case 103: {
                    TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = CipherSuite.of(string, 49199);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\u001d\u0014r\fA\u0006\u0013{\fW\n\u0014la#y\u0018t\u0010[\u0010\u0014{\u0012%ws";
                    n2 = 104;
                    continue block120;
                }
                case 104: {
                    TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = CipherSuite.of(string, 49200);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fD\u001c\u0006l\u0004_\u001b\u000fl\u0012S\u001c\u0018\u0002a.\u0010\u0000p\u001eI\u001c\u000fra#y";
                    n2 = 105;
                    continue block120;
                }
                case 105: {
                    TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256 = CipherSuite.of(string, 49201);
                    string2 = "\u001b\u000b`\fS\f\u0003{\fD\u001c\u0006l\u0004_\u001b\u000fl\u0012S\u001c\u0018\u0001f \u0010\u0000p\u001eI\u001c\u000fr`.{";
                    n2 = 106;
                    continue block120;
                }
                case 106: {
                    TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384 = CipherSuite.of(string, 49202);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\u001f\u0014x\fA\u0006\u0013{\fW\n\u0014lb$w\u0018p\u0011U\u0010\u0014{\u0012";
                    n2 = 107;
                    continue block120;
                }
                case 107: {
                    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA = CipherSuite.of(string, 49205);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\u001f\u0014x\fA\u0006\u0013{\fW\n\u0014la#y\u0018p\u0011U\u0010\u0014{\u0012";
                    n2 = 108;
                    continue block120;
                }
                case 108: {
                    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA = CipherSuite.of(string, 49206);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\u001d\u0014r\fA\u0006\u0013{\fU\u0007\u0006p\u001bW}wl\u0003Y\u0003\u001e\u0002`&z\u0018`\u001bW}r\u0005";
                    n2 = 109;
                    continue block120;
                }
                case 109: {
                    TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = CipherSuite.of(string, 52392);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\n\u0004w\u0000W\u0010\u0010z\u0007^\u0010\u0004{\u0012U\u0007\u0006\u0001cI\u001f\b\u007f\n'|w\u0006\fE\u0007\u0006\u0001f ";
                    n2 = 110;
                    continue block120;
                }
                case 110: {
                    TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = CipherSuite.of(string, 52393);
                    string2 = "\u001b\u000b`\fS\f\u0003{\u0016I\u001f\u0014x\fA\u0006\u0013{\fU\u0007\u0006p\u001bW}wl\u0003Y\u0003\u001e\u0002`&z\u0018`\u001bW}r\u0005";
                    n2 = 111;
                    continue block120;
                }
                case 111: 
            }
            break;
        }
        TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = CipherSuite.of(string, 52396);
    }
}

