/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.Address;
import cn.jmessage.support.okhttp3.Route;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.connection.RealConnection;
import cn.jmessage.support.okhttp3.internal.connection.RouteDatabase;
import cn.jmessage.support.okhttp3.internal.connection.StreamAllocation;
import cn.jmessage.support.okhttp3.internal.platform.Platform;
import java.lang.ref.Reference;
import java.net.Socket;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ConnectionPool {
    private static final Executor executor;
    private final int maxIdleConnections;
    private final long keepAliveDurationNs;
    private final Runnable cleanupRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l2;
            while ((l2 = ConnectionPool.this.cleanup(System.nanoTime())) != -1L) {
                if (l2 <= 0L) continue;
                long l3 = l2 / 1000000L;
                l2 -= l3 * 1000000L;
                ConnectionPool connectionPool = ConnectionPool.this;
                synchronized (connectionPool) {
                    try {
                        ConnectionPool.this.wait(l3, (int)l2);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return;
        }
    };
    private final Deque<RealConnection> connections = new ArrayDeque<RealConnection>();
    final RouteDatabase routeDatabase = new RouteDatabase();
    boolean cleanupRunning;
    private static final String[] z;

    public ConnectionPool() {
        this(5, 5L, TimeUnit.MINUTES);
    }

    public ConnectionPool(int n2, long l2, TimeUnit timeUnit) {
        this.maxIdleConnections = n2;
        this.keepAliveDurationNs = timeUnit.toNanos(l2);
        if (l2 <= 0L) {
            throw new IllegalArgumentException(z[2] + l2);
        }
    }

    public final synchronized int idleConnectionCount() {
        int n2 = 0;
        Iterator<RealConnection> iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().allocations.isEmpty()) continue;
            ++n2;
        }
        return n2;
    }

    public final synchronized int connectionCount() {
        return this.connections.size();
    }

    @Nullable
    final RealConnection get(Address address, StreamAllocation streamAllocation, Route route) {
        assert (Thread.holdsLock(this));
        for (RealConnection realConnection : this.connections) {
            if (!realConnection.isEligible(address, route)) continue;
            streamAllocation.acquire(realConnection, true);
            return realConnection;
        }
        return null;
    }

    @Nullable
    final Socket deduplicate(Address address, StreamAllocation streamAllocation) {
        assert (Thread.holdsLock(this));
        for (RealConnection realConnection : this.connections) {
            if (!realConnection.isEligible(address, null) || !realConnection.isMultiplexed() || realConnection == streamAllocation.connection()) continue;
            return streamAllocation.releaseAndAcquire(realConnection);
        }
        return null;
    }

    final void put(RealConnection realConnection) {
        assert (Thread.holdsLock(this));
        if (!this.cleanupRunning) {
            this.cleanupRunning = true;
            executor.execute(this.cleanupRunnable);
        }
        this.connections.add(realConnection);
    }

    final boolean connectionBecameIdle(RealConnection realConnection) {
        assert (Thread.holdsLock(this));
        if (realConnection.noNewStreams || this.maxIdleConnections == 0) {
            this.connections.remove(realConnection);
            return true;
        }
        this.notifyAll();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void evictAll() {
        ArrayList<RealConnection> arrayList = new ArrayList<RealConnection>();
        Object object = this;
        synchronized (object) {
            Iterator<RealConnection> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                RealConnection realConnection = iterator.next();
                if (!realConnection.allocations.isEmpty()) continue;
                realConnection.noNewStreams = true;
                arrayList.add(realConnection);
                iterator.remove();
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            Util.closeQuietly(((RealConnection)object.next()).socket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long cleanup(long l2) {
        int n2 = 0;
        int n3 = 0;
        RealConnection realConnection = null;
        long l3 = Long.MIN_VALUE;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            for (RealConnection realConnection2 : this.connections) {
                if (this.pruneAndGetAllocationCount(realConnection2, l2) > 0) {
                    ++n2;
                    continue;
                }
                ++n3;
                long l4 = l2 - realConnection2.idleAtNanos;
                if (l4 <= l3) continue;
                l3 = l4;
                realConnection = realConnection2;
            }
            if (l3 < this.keepAliveDurationNs && n3 <= this.maxIdleConnections) {
                if (n3 > 0) {
                    return this.keepAliveDurationNs - l3;
                }
                if (n2 > 0) {
                    return this.keepAliveDurationNs;
                }
                this.cleanupRunning = false;
                return -1L;
            }
            this.connections.remove(realConnection);
        }
        Util.closeQuietly(realConnection.socket());
        return 0L;
    }

    private int pruneAndGetAllocationCount(RealConnection realConnection, long l2) {
        List<Reference<StreamAllocation>> list = realConnection.allocations;
        int n2 = 0;
        while (n2 < list.size()) {
            StreamAllocation.StreamAllocationReference streamAllocationReference = list.get(n2);
            if (streamAllocationReference.get() != null) {
                ++n2;
                continue;
            }
            streamAllocationReference = streamAllocationReference;
            String string = z[0] + realConnection.route().address().url() + z[1];
            Platform.get().logCloseableLeak(string, streamAllocationReference.callStackTrace);
            list.remove(n2);
            realConnection.noNewStreams = true;
            if (!list.isEmpty()) continue;
            realConnection.idleAtNanos = l2 - this.keepAliveDurationNs;
            return 0;
        }
        return list.size();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "sh/Dq\\-/_v]&l_p\u0012";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 50;
                                break;
                            }
                            case 1: {
                                n9 = 72;
                                break;
                            }
                            case 2: {
                                n9 = 76;
                                break;
                            }
                            case 3: {
                                n9 = 43;
                                break;
                            }
                            default: {
                                n9 = 31;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0012?-X?^--@zVflovVh5Dj\u0012.#YxW<l_p\u0012+ DlWh-\u000bmW;<DqA-lIpV1s";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "Y-)[^^!:N[G:-_v]&l\u0017\"\u0012xv\u000b";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "}#\u0004_kBh\u000fDq\\-/_v]&\u001cDp^";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory(z[3], true));
    }
}

