/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.Call;
import cn.jmessage.support.okhttp3.RealCall;
import cn.jmessage.support.okhttp3.internal.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Dispatcher {
    private int maxRequests = 64;
    private int maxRequestsPerHost = 5;
    @Nullable
    private Runnable idleCallback;
    @Nullable
    private ExecutorService executorService;
    private final Deque<RealCall.AsyncCall> readyAsyncCalls = new ArrayDeque<RealCall.AsyncCall>();
    private final Deque<RealCall.AsyncCall> runningAsyncCalls = new ArrayDeque<RealCall.AsyncCall>();
    private final Deque<RealCall> runningSyncCalls = new ArrayDeque<RealCall>();
    private static final String[] z;

    public Dispatcher(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Dispatcher() {
    }

    public final synchronized ExecutorService executorService() {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory(z[2], false));
        }
        return this.executorService;
    }

    public final synchronized void setMaxRequests(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException(z[1] + n2);
        }
        this.maxRequests = n2;
        this.promoteCalls();
    }

    public final synchronized int getMaxRequests() {
        return this.maxRequests;
    }

    public final synchronized void setMaxRequestsPerHost(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException(z[1] + n2);
        }
        this.maxRequestsPerHost = n2;
        this.promoteCalls();
    }

    public final synchronized int getMaxRequestsPerHost() {
        return this.maxRequestsPerHost;
    }

    public final synchronized void setIdleCallback(@Nullable Runnable runnable) {
        this.idleCallback = runnable;
    }

    final synchronized void enqueue(RealCall.AsyncCall asyncCall) {
        if (this.runningAsyncCalls.size() < this.maxRequests && this.runningCallsForHost(asyncCall) < this.maxRequestsPerHost) {
            this.runningAsyncCalls.add(asyncCall);
            this.executorService().execute(asyncCall);
            return;
        }
        this.readyAsyncCalls.add(asyncCall);
    }

    public final synchronized void cancelAll() {
        Iterator<Object> iterator = this.readyAsyncCalls.iterator();
        while (iterator.hasNext()) {
            iterator.next().get().cancel();
        }
        iterator = this.runningAsyncCalls.iterator();
        while (iterator.hasNext()) {
            iterator.next().get().cancel();
        }
        iterator = this.runningSyncCalls.iterator();
        while (iterator.hasNext()) {
            ((RealCall)iterator.next()).cancel();
        }
    }

    private void promoteCalls() {
        if (this.runningAsyncCalls.size() >= this.maxRequests) {
            return;
        }
        if (this.readyAsyncCalls.isEmpty()) {
            return;
        }
        Iterator<RealCall.AsyncCall> iterator = this.readyAsyncCalls.iterator();
        while (iterator.hasNext()) {
            RealCall.AsyncCall asyncCall = iterator.next();
            if (this.runningCallsForHost(asyncCall) < this.maxRequestsPerHost) {
                iterator.remove();
                this.runningAsyncCalls.add(asyncCall);
                this.executorService().execute(asyncCall);
            }
            if (this.runningAsyncCalls.size() < this.maxRequests) continue;
            return;
        }
    }

    private int runningCallsForHost(RealCall.AsyncCall asyncCall) {
        int n2 = 0;
        for (RealCall.AsyncCall asyncCall2 : this.runningAsyncCalls) {
            if (asyncCall2.get().forWebSocket || !asyncCall2.host().equals(asyncCall.host())) continue;
            ++n2;
        }
        return n2;
    }

    final synchronized void executed(RealCall realCall) {
        this.runningSyncCalls.add(realCall);
    }

    final void finished(RealCall.AsyncCall asyncCall) {
        this.finished(this.runningAsyncCalls, asyncCall, true);
    }

    final void finished(RealCall realCall) {
        this.finished(this.runningSyncCalls, realCall, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void finished(Deque<T> deque, T object, boolean bl) {
        int n2;
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (!deque.remove(object)) {
                throw new AssertionError((Object)z[0]);
            }
            if (bl) {
                this.promoteCalls();
            }
            n2 = this.runningCallsCount();
            object = this.idleCallback;
        }
        if (n2 == 0 && object != null) {
            object.run();
        }
    }

    public final synchronized List<Call> queuedCalls() {
        ArrayList<RealCall> arrayList = new ArrayList<RealCall>();
        for (RealCall.AsyncCall asyncCall : this.readyAsyncCalls) {
            arrayList.add(asyncCall.get());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final synchronized List<Call> runningCalls() {
        ArrayList<RealCall> arrayList = new ArrayList<RealCall>();
        arrayList.addAll(this.runningSyncCalls);
        for (RealCall.AsyncCall asyncCall : this.runningAsyncCalls) {
            arrayList.add(asyncCall.get());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final synchronized int queuedCallsCount() {
        return this.readyAsyncCalls.size();
    }

    public final synchronized int runningCallsCount() {
        return this.runningAsyncCalls.size() + this.runningSyncCalls.size();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "TL\u0019/\u0016`L\u0006-\u0011c\r\u001c-\u001bqA\u001c$^c\f";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 23;
                                break;
                            }
                            case 1: {
                                n9 = 45;
                                break;
                            }
                            case 2: {
                                n9 = 117;
                                break;
                            }
                            case 3: {
                                n9 = 67;
                                break;
                            }
                            default: {
                                n9 = 54;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "zL\rc\n7\u001cOc";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "XF=7Bg\r1*EgL\u0001 ^r_";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

