/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.http.HttpDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class Headers {
    private final String[] namesAndValues;
    private static final String[] z;

    Headers(Builder builder) {
        this.namesAndValues = builder.namesAndValues.toArray(new String[builder.namesAndValues.size()]);
    }

    private Headers(String[] stringArray) {
        this.namesAndValues = stringArray;
    }

    @Nullable
    public final String get(String string) {
        return Headers.get(this.namesAndValues, string);
    }

    @Nullable
    public final Date getDate(String string) {
        if ((string = this.get(string)) != null) {
            return HttpDate.parse(string);
        }
        return null;
    }

    public final int size() {
        return this.namesAndValues.length / 2;
    }

    public final String name(int n2) {
        return this.namesAndValues[n2 * 2];
    }

    public final String value(int n2) {
        return this.namesAndValues[n2 * 2 + 1];
    }

    public final Set<String> names() {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            treeSet.add(this.name(i2));
        }
        return Collections.unmodifiableSet(treeSet);
    }

    public final List<String> values(String string) {
        ArrayList<String> arrayList = null;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equalsIgnoreCase(this.name(i2))) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>(2);
            }
            arrayList.add(this.value(i2));
        }
        if (arrayList != null) {
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    public final long byteCount() {
        long l2 = this.namesAndValues.length * 2;
        int n2 = this.namesAndValues.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 += (long)this.namesAndValues[i2].length();
        }
        return l2;
    }

    public final Builder newBuilder() {
        Builder builder = new Builder();
        Collections.addAll(builder.namesAndValues, this.namesAndValues);
        return builder;
    }

    public final boolean equals(@Nullable Object object) {
        return object instanceof Headers && Arrays.equals(((Headers)object).namesAndValues, this.namesAndValues);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.namesAndValues);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(this.name(i2)).append(z[3]).append(this.value(i2)).append("\n");
        }
        return stringBuilder.toString();
    }

    public final Map<String, List<String>> toMultimap() {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.name(i2).toLowerCase(Locale.US);
            ArrayList<String> arrayList = (ArrayList<String>)treeMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>(2);
                treeMap.put(string, arrayList);
            }
            arrayList.add(this.value(i2));
        }
        return treeMap;
    }

    private static String get(String[] stringArray, String string) {
        for (int i2 = stringArray.length - 2; i2 >= 0; i2 -= 2) {
            if (!string.equalsIgnoreCase(stringArray[i2])) continue;
            return stringArray[i2 + 1];
        }
        return null;
    }

    public static Headers of(String ... stringArray) {
        int n2;
        if (stringArray == null) {
            throw new NullPointerException(z[1]);
        }
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException(z[2]);
        }
        stringArray = (String[])stringArray.clone();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] == null) {
                throw new IllegalArgumentException(z[0]);
            }
            stringArray[n2] = stringArray[n2].trim();
        }
        for (n2 = 0; n2 < stringArray.length; n2 += 2) {
            String string = stringArray[n2];
            String string2 = stringArray[n2 + 1];
            if (string.length() != 0 && string.indexOf(0) == -1 && string2.indexOf(0) == -1) continue;
            throw new IllegalArgumentException(z[4] + string + z[3] + string2);
        }
        return new Headers(stringArray);
    }

    public static Headers of(Map<String, String> object) {
        if (object == null) {
            throw new NullPointerException(z[5]);
        }
        String[] stringArray = new String[object.size() * 2];
        int n2 = 0;
        for (Map.Entry entry : object.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException(z[0]);
            }
            String string = ((String)entry.getKey()).trim();
            String object2 = ((String)entry.getValue()).trim();
            if (string.length() == 0 || string.indexOf(0) != -1 || object2.indexOf(0) != -1) {
                throw new IllegalArgumentException(z[4] + string + z[3] + object2);
            }
            stringArray[n2] = string;
            stringArray[n2 + 1] = object2;
            n2 += 2;
        }
        return new Headers(stringArray);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "0ErLW\nS3KS\u0016N|\\\u0012\u001aE3FG\u0014L";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 120;
                                break;
                            }
                            case 1: {
                                n9 = 32;
                                break;
                            }
                            case 2: {
                                n9 = 19;
                                break;
                            }
                            case 3: {
                                n9 = 40;
                                break;
                            }
                            default: {
                                n9 = 50;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0016A~MA9Nw~S\u0014Uv[\u0012E\u001d3FG\u0014L";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "=XcMQ\fEw\bS\u0014TvZ\\\u0019TzFUXHvIV\u001dR3FS\u0015E`\bS\u0016D3^S\u0014Uv[";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "B\u0000";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "-NvPB\u001dCgMVXHvIV\u001dR)\b";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0010ErLW\nS3\u0015\u000fXNfD^";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    public static final class Builder {
        final List<String> namesAndValues = new ArrayList<String>(20);
        private static final String[] z;

        final Builder addLenient(String string) {
            int n2 = string.indexOf(":", 1);
            if (n2 != -1) {
                return this.addLenient(string.substring(0, n2), string.substring(n2 + 1));
            }
            if (string.startsWith(":")) {
                return this.addLenient("", string.substring(1));
            }
            return this.addLenient("", string);
        }

        public final Builder add(String string) {
            int n2 = string.indexOf(":");
            if (n2 == -1) {
                throw new IllegalArgumentException(z[0] + string);
            }
            return this.add(string.substring(0, n2).trim(), string.substring(n2 + 1));
        }

        public final Builder add(String string, String string2) {
            this.checkNameAndValue(string, string2);
            return this.addLenient(string, string2);
        }

        public final Builder addAll(Headers headers) {
            int n2 = headers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.addLenient(headers.name(i2), headers.value(i2));
            }
            return this;
        }

        final Builder addLenient(String string, String string2) {
            this.namesAndValues.add(string);
            this.namesAndValues.add(string2.trim());
            return this;
        }

        public final Builder removeAll(String string) {
            for (int i2 = 0; i2 < this.namesAndValues.size(); i2 += 2) {
                if (!string.equalsIgnoreCase(this.namesAndValues.get(i2))) continue;
                this.namesAndValues.remove(i2);
                this.namesAndValues.remove(i2);
                i2 -= 2;
            }
            return this;
        }

        public final Builder set(String string, String string2) {
            this.checkNameAndValue(string, string2);
            this.removeAll(string);
            this.addLenient(string, string2);
            return this;
        }

        private void checkNameAndValue(String string, String string2) {
            char c2;
            int n2;
            if (string == null) {
                throw new NullPointerException(z[5]);
            }
            if (string.isEmpty()) {
                throw new IllegalArgumentException(z[4]);
            }
            int n3 = string.length();
            for (n2 = 0; n2 < n3; ++n2) {
                c2 = string.charAt(n2);
                if (c2 > ' ' && c2 < '\u007f') continue;
                throw new IllegalArgumentException(Util.format(z[3], c2, n2, string));
            }
            if (string2 == null) {
                throw new NullPointerException(z[2] + string + z[1]);
            }
            n3 = string2.length();
            for (n2 = 0; n2 < n3; ++n2) {
                c2 = string2.charAt(n2);
                if ((c2 > '\u001f' || c2 == '\t') && c2 < '\u007f') continue;
                throw new IllegalArgumentException(Util.format(z[6], c2, n2, string, string2));
            }
        }

        public final String get(String string) {
            for (int i2 = this.namesAndValues.size() - 2; i2 >= 0; i2 -= 2) {
                if (!string.equalsIgnoreCase(this.namesAndValues.get(i2))) continue;
                return this.namesAndValues.get(i2 + 1);
            }
            return null;
        }

        public final Headers build() {
            return new Headers(this);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[7];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "41\u0015v2\u0004<\u0004k&A7\u0015o&\u0004-J.";
            int n3 = -1;
            block14: while (true) {
                char[] cArray;
                block19: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block18: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block18;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block19;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 97;
                                    break;
                                }
                                case 1: {
                                    n9 = 95;
                                    break;
                                }
                                case 2: {
                                    n9 = 112;
                                    break;
                                }
                                case 3: {
                                    n9 = 14;
                                    break;
                                }
                                default: {
                                    n9 = 66;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "AbM.,\u00143\u001c";
                        n3 = 0;
                        continue block14;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "\u0017>\u001c{'A9\u001f|b\u000f>\u001dkb";
                        n3 = 1;
                        continue block14;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "41\u0015v2\u0004<\u0004k&A<\u0018o0AzS>v\u0019\u007f\u0011zbD;Pg,A7\u0015o&\u0004-P`#\f:J.g\u0012";
                        n3 = 2;
                        continue block14;
                    }
                    case 2: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = "\u000f>\u001dkb\b,Pk/\u0011+\t";
                        n3 = 3;
                        continue block14;
                    }
                    case 3: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 5;
                        string2 = "\u000f>\u001dkb\\bP`7\r3";
                        n3 = 4;
                        continue block14;
                    }
                    case 4: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 6;
                        string2 = "41\u0015v2\u0004<\u0004k&A<\u0018o0AzS>v\u0019\u007f\u0011zbD;Pg,Az\u0003.4\u00003\u0005kxAz\u0003";
                        n3 = 5;
                        continue block14;
                    }
                    case 5: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

