/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import cn.jmessage.support.okio.Buffer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class HttpUrl {
    private static final char[] HEX_DIGITS;
    static final String USERNAME_ENCODE_SET;
    static final String PASSWORD_ENCODE_SET;
    static final String PATH_SEGMENT_ENCODE_SET;
    static final String PATH_SEGMENT_ENCODE_SET_URI;
    static final String QUERY_ENCODE_SET;
    static final String QUERY_COMPONENT_REENCODE_SET;
    static final String QUERY_COMPONENT_ENCODE_SET;
    static final String QUERY_COMPONENT_ENCODE_SET_URI;
    static final String FORM_ENCODE_SET;
    static final String FRAGMENT_ENCODE_SET = "";
    static final String FRAGMENT_ENCODE_SET_URI;
    final String scheme;
    private final String username;
    private final String password;
    final String host;
    final int port;
    private final List<String> pathSegments;
    @Nullable
    private final List<String> queryNamesAndValues;
    @Nullable
    private final String fragment;
    private final String url;
    private static final String[] z;

    HttpUrl(Builder builder) {
        this.scheme = builder.scheme;
        this.username = HttpUrl.percentDecode(builder.encodedUsername, false);
        this.password = HttpUrl.percentDecode(builder.encodedPassword, false);
        this.host = builder.host;
        this.port = builder.effectivePort();
        this.pathSegments = this.percentDecode(builder.encodedPathSegments, false);
        this.queryNamesAndValues = builder.encodedQueryNamesAndValues != null ? this.percentDecode(builder.encodedQueryNamesAndValues, true) : null;
        this.fragment = builder.encodedFragment != null ? HttpUrl.percentDecode(builder.encodedFragment, false) : null;
        this.url = builder.toString();
    }

    public final URL url() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public final URI uri() {
        String string = this.newBuilder().reencodeForUri().toString();
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                return URI.create(string.replaceAll(z[2], FRAGMENT_ENCODE_SET));
            }
            catch (Exception exception) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
    }

    public final String scheme() {
        return this.scheme;
    }

    public final boolean isHttps() {
        return this.scheme.equals(z[0]);
    }

    public final String encodedUsername() {
        if (this.username.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int n2 = this.scheme.length() + 3;
        int n3 = Util.delimiterOffset(this.url, n2, this.url.length(), z[5]);
        return this.url.substring(n2, n3);
    }

    public final String username() {
        return this.username;
    }

    public final String encodedPassword() {
        if (this.password.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int n2 = this.url.indexOf(58, this.scheme.length() + 3) + 1;
        int n3 = this.url.indexOf(64);
        return this.url.substring(n2, n3);
    }

    public final String password() {
        return this.password;
    }

    public final String host() {
        return this.host;
    }

    public final int port() {
        return this.port;
    }

    public static int defaultPort(String string) {
        if (string.equals(z[3])) {
            return 80;
        }
        if (string.equals(z[0])) {
            return 443;
        }
        return -1;
    }

    public final int pathSize() {
        return this.pathSegments.size();
    }

    public final String encodedPath() {
        int n2 = this.url.indexOf(47, this.scheme.length() + 3);
        int n3 = Util.delimiterOffset(this.url, n2, this.url.length(), z[4]);
        return this.url.substring(n2, n3);
    }

    static void pathSegmentsToString(StringBuilder stringBuilder, List<String> list) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append('/');
            stringBuilder.append(list.get(i2));
        }
    }

    public final List<String> encodedPathSegments() {
        int n2 = this.url.indexOf(47, this.scheme.length() + 3);
        int n3 = Util.delimiterOffset(this.url, n2, this.url.length(), z[4]);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n2 < n3) {
            int n4 = Util.delimiterOffset(this.url, ++n2, n3, '/');
            arrayList.add(this.url.substring(n2, n4));
            n2 = n4;
        }
        return arrayList;
    }

    public final List<String> pathSegments() {
        return this.pathSegments;
    }

    @Nullable
    public final String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int n2 = this.url.indexOf(63) + 1;
        int n3 = Util.delimiterOffset(this.url, n2, this.url.length(), '#');
        return this.url.substring(n2, n3);
    }

    static void namesAndValuesToQueryString(StringBuilder stringBuilder, List<String> list) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            String string = list.get(i2);
            String string2 = list.get(i2 + 1);
            if (i2 > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(string);
            if (string2 == null) continue;
            stringBuilder.append('=');
            stringBuilder.append(string2);
        }
    }

    static List<String> queryStringToNamesAndValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 <= string.length()) {
            int n3;
            int n4 = string.indexOf(38, n2);
            if (n4 == -1) {
                n4 = string.length();
            }
            if ((n3 = string.indexOf(61, n2)) == -1 || n3 > n4) {
                arrayList.add(string.substring(n2, n4));
                arrayList.add(null);
            } else {
                arrayList.add(string.substring(n2, n3));
                arrayList.add(string.substring(n3 + 1, n4));
            }
            n2 = n4 + 1;
        }
        return arrayList;
    }

    @Nullable
    public final String query() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        HttpUrl.namesAndValuesToQueryString(stringBuilder, this.queryNamesAndValues);
        return stringBuilder.toString();
    }

    public final int querySize() {
        if (this.queryNamesAndValues != null) {
            return this.queryNamesAndValues.size() / 2;
        }
        return 0;
    }

    @Nullable
    public final String queryParameter(String string) {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int n2 = this.queryNamesAndValues.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            if (!string.equals(this.queryNamesAndValues.get(i2))) continue;
            return this.queryNamesAndValues.get(i2 + 1);
        }
        return null;
    }

    public final Set<String> queryParameterNames() {
        if (this.queryNamesAndValues == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n2 = this.queryNamesAndValues.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            linkedHashSet.add(this.queryNamesAndValues.get(i2));
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public final List<String> queryParameterValues(String string) {
        if (this.queryNamesAndValues == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.queryNamesAndValues.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            if (!string.equals(this.queryNamesAndValues.get(i2))) continue;
            arrayList.add(this.queryNamesAndValues.get(i2 + 1));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final String queryParameterName(int n2) {
        if (this.queryNamesAndValues == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.queryNamesAndValues.get(n2 * 2);
    }

    public final String queryParameterValue(int n2) {
        if (this.queryNamesAndValues == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.queryNamesAndValues.get(n2 * 2 + 1);
    }

    @Nullable
    public final String encodedFragment() {
        if (this.fragment == null) {
            return null;
        }
        int n2 = this.url.indexOf(35) + 1;
        return this.url.substring(n2);
    }

    @Nullable
    public final String fragment() {
        return this.fragment;
    }

    public final String redact() {
        return this.newBuilder(z[6]).username(FRAGMENT_ENCODE_SET).password(FRAGMENT_ENCODE_SET).build().toString();
    }

    @Nullable
    public final HttpUrl resolve(String object) {
        if ((object = this.newBuilder((String)object)) != null) {
            return ((Builder)object).build();
        }
        return null;
    }

    public final Builder newBuilder() {
        Builder builder = new Builder();
        new Builder().scheme = this.scheme;
        builder.encodedUsername = this.encodedUsername();
        builder.encodedPassword = this.encodedPassword();
        builder.host = this.host;
        builder.port = this.port != HttpUrl.defaultPort(this.scheme) ? this.port : -1;
        builder.encodedPathSegments.clear();
        builder.encodedPathSegments.addAll(this.encodedPathSegments());
        builder.encodedQuery(this.encodedQuery());
        builder.encodedFragment = this.encodedFragment();
        return builder;
    }

    @Nullable
    public final Builder newBuilder(String string) {
        try {
            return new Builder().parse(this, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Nullable
    public static HttpUrl parse(String string) {
        try {
            return HttpUrl.get(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static HttpUrl get(String string) {
        return new Builder().parse(null, string).build();
    }

    @Nullable
    public static HttpUrl get(URL uRL) {
        return HttpUrl.parse(uRL.toString());
    }

    @Nullable
    public static HttpUrl get(URI uRI) {
        return HttpUrl.parse(uRI.toString());
    }

    public final boolean equals(@Nullable Object object) {
        return object instanceof HttpUrl && ((HttpUrl)object).url.equals(this.url);
    }

    public final int hashCode() {
        return this.url.hashCode();
    }

    public final String toString() {
        return this.url;
    }

    @Nullable
    public final String topPrivateDomain() {
        if (Util.verifyAsIpAddress(this.host)) {
            return null;
        }
        return PublicSuffixDatabase.get().getEffectiveTldPlusOne(this.host);
    }

    static String percentDecode(String string, boolean bl) {
        return HttpUrl.percentDecode(string, 0, string.length(), bl);
    }

    private List<String> percentDecode(List<String> list, boolean bl) {
        int n2 = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = list.get(i2);
            arrayList.add(string != null ? HttpUrl.percentDecode(string, bl) : null);
        }
        return Collections.unmodifiableList(arrayList);
    }

    static String percentDecode(String string, int n2, int n3, boolean bl) {
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '%' && (c2 != '+' || !bl)) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string, n2, i2);
            HttpUrl.percentDecode(buffer, string, i2, n3, bl);
            return buffer.readUtf8();
        }
        return string.substring(n2, n3);
    }

    static void percentDecode(Buffer buffer, String string, int n2, int n3, boolean bl) {
        for (int i2 = n2; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (n2 == 37 && i2 + 2 < n3) {
                int n4 = Util.decodeHexDigit(string.charAt(i2 + 1));
                int n5 = Util.decodeHexDigit(string.charAt(i2 + 2));
                if (n4 != -1 && n5 != -1) {
                    buffer.writeByte((n4 << 4) + n5);
                    i2 += 2;
                    continue;
                }
            } else if (n2 == 43 && bl) {
                buffer.writeByte(32);
                continue;
            }
            buffer.writeUtf8CodePoint(n2);
        }
    }

    static boolean percentEncoded(String string, int n2, int n3) {
        return n2 + 2 < n3 && string.charAt(n2) == '%' && Util.decodeHexDigit(string.charAt(n2 + 1)) != -1 && Util.decodeHexDigit(string.charAt(n2 + 2)) != -1;
    }

    static String canonicalize(String string, int n2, int n3, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Charset charset) {
        int n4;
        for (int i2 = n2; i2 < n3; i2 += Character.charCount(n4)) {
            n4 = string.codePointAt(i2);
            if (!(n4 < 32 || n4 == 127 || n4 >= 128 && bl4 || string2.indexOf(n4) != -1 || n4 == 37 && (!bl || bl2 && !HttpUrl.percentEncoded(string, i2, n3))) && (n4 != 43 || !bl3)) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string, n2, i2);
            HttpUrl.canonicalize(buffer, string, i2, n3, string2, bl, bl2, bl3, bl4, charset);
            return buffer.readUtf8();
        }
        return string.substring(n2, n3);
    }

    static void canonicalize(Buffer buffer, String string, int n2, int n3, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Charset charset) {
        Buffer buffer2 = null;
        for (int i2 = n2; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (bl && (n2 == 9 || n2 == 10 || n2 == 12 || n2 == 13)) continue;
            if (n2 == 43 && bl3) {
                buffer.writeUtf8(bl ? "+" : z[1]);
                continue;
            }
            if (n2 < 32 || n2 == 127 || n2 >= 128 && bl4 || string2.indexOf(n2) != -1 || n2 == 37 && (!bl || bl2 && !HttpUrl.percentEncoded(string, i2, n3))) {
                if (buffer2 == null) {
                    buffer2 = new Buffer();
                }
                if (charset == null || charset.equals(Util.UTF_8)) {
                    buffer2.writeUtf8CodePoint(n2);
                } else {
                    buffer2.writeString(string, i2, i2 + Character.charCount(n2), charset);
                }
                while (!buffer2.exhausted()) {
                    int n4 = buffer2.readByte() & 0xFF;
                    buffer.writeByte(37);
                    buffer.writeByte(HEX_DIGITS[n4 >> 4 & 0xF]);
                    buffer.writeByte(HEX_DIGITS[n4 & 0xF]);
                }
                continue;
            }
            buffer.writeUtf8CodePoint(n2);
        }
    }

    static String canonicalize(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Charset charset) {
        return HttpUrl.canonicalize(string, 0, string.length(), string2, bl, bl2, bl3, bl4, charset);
    }

    static String canonicalize(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return HttpUrl.canonicalize(string, 0, string.length(), string2, bl, bl2, bl3, bl4, null);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "[=\b\u000e\u0011G\"\u0011tq&AOOW\u00070s\u000b\t";
        int n3 = 6;
        block24: while (true) {
            char[] cArray;
            block29: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block28: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block28;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block29;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 123;
                                break;
                            }
                            case 1: {
                                n9 = 31;
                                break;
                            }
                            case 2: {
                                n9 = 47;
                                break;
                            }
                            case 3: {
                                n9 = 52;
                                break;
                            }
                            default: {
                                n9 = 42;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 6: {
                    USERNAME_ENCODE_SET = string.intern();
                    string2 = "'AOOV\u0006";
                    n3 = 7;
                    continue block24;
                }
                case 7: {
                    QUERY_COMPONENT_ENCODE_SET_URI = string.intern();
                    string2 = "[=\b\b\u0014X9\u0012";
                    n3 = 8;
                    continue block24;
                }
                case 8: {
                    QUERY_COMPONENT_REENCODE_SET = string.intern();
                    string2 = "[=\u0013\nt\u001bdRH\u0005' \f";
                    n3 = 9;
                    continue block24;
                }
                case 9: {
                    PATH_SEGMENT_ENCODE_SET = string.intern();
                    string2 = "[>\r\u0017\u000e]8\u0007\u001d\u0006T%\u0014\b\u0017E oow'AOOV\u0006a";
                    n3 = 10;
                    continue block24;
                }
                case 10: {
                    QUERY_COMPONENT_ENCODE_SET = string.intern();
                    string2 = "[=\f\b\u0014'AOOV\u0006";
                    n3 = 11;
                    continue block24;
                }
                case 11: {
                    FRAGMENT_ENCODE_SET_URI = string.intern();
                    string2 = " B";
                    n3 = 12;
                    continue block24;
                }
                case 12: {
                    PATH_SEGMENT_ENCODE_SET_URI = string.intern();
                    string2 = "[=\b\u000e\u0011G\"\u0011tq&AOOW\u00070s\u000b\t]>\u000b\u001c\u0003Wa";
                    n3 = 13;
                    continue block24;
                }
                case 13: {
                    FORM_ENCODE_SET = string.intern();
                    string2 = "[=\b\u000e\u0011G\"\u0011tq&AOOW\u00070s\u000b\t";
                    n3 = 14;
                    continue block24;
                }
                case 14: {
                    PASSWORD_ENCODE_SET = string.intern();
                    string2 = "[=\b\b\u0014X";
                    n3 = 15;
                    continue block24;
                }
                case 15: {
                    QUERY_ENCODE_SET = string.intern();
                    string2 = "\u0013k[DY";
                    n3 = -1;
                    continue block24;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "^-m";
                    n3 = 0;
                    continue block24;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = " CZ\u0004\u001aK/\u0002h_K/\u001erv\u000e/\u001f\u0003lVCZ\u0004\u001aBYsDQ\u0011~YU}\u0013v[QY\u000b~LQW&";
                    n3 = 1;
                    continue block24;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0013k[D";
                    n3 = 2;
                    continue block24;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "D<";
                    n3 = 3;
                    continue block24;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "A_";
                    n3 = 4;
                    continue block24;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "T1\u0001\u001a";
                    n3 = 5;
                    continue block24;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    public static final class Builder {
        @Nullable
        String scheme;
        String encodedUsername = "";
        String encodedPassword = "";
        @Nullable
        String host;
        int port = -1;
        final List<String> encodedPathSegments = new ArrayList<String>();
        @Nullable
        List<String> encodedQueryNamesAndValues;
        @Nullable
        String encodedFragment;
        static final String INVALID_HOST;
        private static final String[] z;

        public Builder() {
            this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
        }

        public final Builder scheme(String string) {
            if (string == null) {
                throw new NullPointerException(z[12]);
            }
            if (string.equalsIgnoreCase(z[16])) {
                this.scheme = z[16];
            } else if (string.equalsIgnoreCase(z[15])) {
                this.scheme = z[15];
            } else {
                throw new IllegalArgumentException(z[14] + string);
            }
            return this;
        }

        public final Builder username(String string) {
            if (string == null) {
                throw new NullPointerException(z[30]);
            }
            this.encodedUsername = HttpUrl.canonicalize(string, z[1], false, false, false, true);
            return this;
        }

        public final Builder encodedUsername(String string) {
            if (string == null) {
                throw new NullPointerException(z[2]);
            }
            this.encodedUsername = HttpUrl.canonicalize(string, z[1], true, false, false, true);
            return this;
        }

        public final Builder password(String string) {
            if (string == null) {
                throw new NullPointerException(z[39]);
            }
            this.encodedPassword = HttpUrl.canonicalize(string, z[1], false, false, false, true);
            return this;
        }

        public final Builder encodedPassword(String string) {
            if (string == null) {
                throw new NullPointerException(z[10]);
            }
            this.encodedPassword = HttpUrl.canonicalize(string, z[1], true, false, false, true);
            return this;
        }

        public final Builder host(String string) {
            if (string == null) {
                throw new NullPointerException(z[11]);
            }
            String string2 = Builder.canonicalizeHost(string, 0, string.length());
            if (string2 == null) {
                throw new IllegalArgumentException(z[13] + string);
            }
            this.host = string2;
            return this;
        }

        public final Builder port(int n2) {
            if (n2 <= 0 || n2 > 65535) {
                throw new IllegalArgumentException(z[9] + n2);
            }
            this.port = n2;
            return this;
        }

        final int effectivePort() {
            if (this.port != -1) {
                return this.port;
            }
            return HttpUrl.defaultPort(this.scheme);
        }

        public final Builder addPathSegment(String string) {
            if (string == null) {
                throw new NullPointerException(z[19]);
            }
            this.push(string, 0, string.length(), false, false);
            return this;
        }

        public final Builder addPathSegments(String string) {
            if (string == null) {
                throw new NullPointerException(z[33]);
            }
            return this.addPathSegments(string, false);
        }

        public final Builder addEncodedPathSegment(String string) {
            if (string == null) {
                throw new NullPointerException(z[4]);
            }
            this.push(string, 0, string.length(), false, true);
            return this;
        }

        public final Builder addEncodedPathSegments(String string) {
            if (string == null) {
                throw new NullPointerException(z[20]);
            }
            return this.addPathSegments(string, true);
        }

        private Builder addPathSegments(String string, boolean bl) {
            int n2;
            int n3 = 0;
            do {
                boolean bl2 = (n2 = Util.delimiterOffset(string, n3, string.length(), z[5])) < string.length();
                this.push(string, n3, n2, bl2, bl);
            } while ((n3 = n2 + 1) <= string.length());
            return this;
        }

        public final Builder setPathSegment(int n2, String string) {
            if (string == null) {
                throw new NullPointerException(z[19]);
            }
            String string2 = HttpUrl.canonicalize(string, 0, string.length(), z[0], false, false, false, true, null);
            if (this.isDot(string2) || this.isDotDot(string2)) {
                throw new IllegalArgumentException(z[3] + string);
            }
            this.encodedPathSegments.set(n2, string2);
            return this;
        }

        public final Builder setEncodedPathSegment(int n2, String string) {
            if (string == null) {
                throw new NullPointerException(z[4]);
            }
            String string2 = HttpUrl.canonicalize(string, 0, string.length(), z[0], true, false, false, true, null);
            this.encodedPathSegments.set(n2, string2);
            if (this.isDot(string2) || this.isDotDot(string2)) {
                throw new IllegalArgumentException(z[3] + string);
            }
            return this;
        }

        public final Builder removePathSegment(int n2) {
            this.encodedPathSegments.remove(n2);
            if (this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
            return this;
        }

        public final Builder encodedPath(String string) {
            if (string == null) {
                throw new NullPointerException(z[37]);
            }
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException(z[38] + string);
            }
            this.resolvePath(string, 0, string.length());
            return this;
        }

        public final Builder query(@Nullable String string) {
            this.encodedQueryNamesAndValues = string != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(string, z[6], false, false, true, true)) : null;
            return this;
        }

        public final Builder encodedQuery(@Nullable String string) {
            this.encodedQueryNamesAndValues = string != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(string, z[6], true, false, true, true)) : null;
            return this;
        }

        public final Builder addQueryParameter(String string, @Nullable String string2) {
            if (string == null) {
                throw new NullPointerException(z[31]);
            }
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(HttpUrl.canonicalize(string, z[32], false, false, true, true));
            this.encodedQueryNamesAndValues.add(string2 != null ? HttpUrl.canonicalize(string2, z[32], false, false, true, true) : null);
            return this;
        }

        public final Builder addEncodedQueryParameter(String string, @Nullable String string2) {
            if (string == null) {
                throw new NullPointerException(z[8]);
            }
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(HttpUrl.canonicalize(string, z[7], true, false, true, true));
            this.encodedQueryNamesAndValues.add(string2 != null ? HttpUrl.canonicalize(string2, z[7], true, false, true, true) : null);
            return this;
        }

        public final Builder setQueryParameter(String string, @Nullable String string2) {
            this.removeAllQueryParameters(string);
            this.addQueryParameter(string, string2);
            return this;
        }

        public final Builder setEncodedQueryParameter(String string, @Nullable String string2) {
            this.removeAllEncodedQueryParameters(string);
            this.addEncodedQueryParameter(string, string2);
            return this;
        }

        public final Builder removeAllQueryParameters(String string) {
            if (string == null) {
                throw new NullPointerException(z[31]);
            }
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            string = HttpUrl.canonicalize(string, z[32], false, false, true, true);
            this.removeAllCanonicalQueryParameters(string);
            return this;
        }

        public final Builder removeAllEncodedQueryParameters(String string) {
            if (string == null) {
                throw new NullPointerException(z[8]);
            }
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            this.removeAllCanonicalQueryParameters(HttpUrl.canonicalize(string, z[7], true, false, true, true));
            return this;
        }

        private void removeAllCanonicalQueryParameters(String string) {
            for (int i2 = this.encodedQueryNamesAndValues.size() - 2; i2 >= 0; i2 -= 2) {
                if (!string.equals(this.encodedQueryNamesAndValues.get(i2))) continue;
                this.encodedQueryNamesAndValues.remove(i2 + 1);
                this.encodedQueryNamesAndValues.remove(i2);
                if (!this.encodedQueryNamesAndValues.isEmpty()) continue;
                this.encodedQueryNamesAndValues = null;
                return;
            }
        }

        public final Builder fragment(@Nullable String string) {
            this.encodedFragment = string != null ? HttpUrl.canonicalize(string, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false, false) : null;
            return this;
        }

        public final Builder encodedFragment(@Nullable String string) {
            this.encodedFragment = string != null ? HttpUrl.canonicalize(string, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false, false) : null;
            return this;
        }

        final Builder reencodeForUri() {
            String string;
            int n2;
            int n3 = this.encodedPathSegments.size();
            for (n2 = 0; n2 < n3; ++n2) {
                string = this.encodedPathSegments.get(n2);
                this.encodedPathSegments.set(n2, HttpUrl.canonicalize(string, z[35], true, true, false, true));
            }
            if (this.encodedQueryNamesAndValues != null) {
                n3 = this.encodedQueryNamesAndValues.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    string = this.encodedQueryNamesAndValues.get(n2);
                    if (string == null) continue;
                    this.encodedQueryNamesAndValues.set(n2, HttpUrl.canonicalize(string, z[34], true, true, true, true));
                }
            }
            if (this.encodedFragment != null) {
                this.encodedFragment = HttpUrl.canonicalize(this.encodedFragment, z[36], true, true, false, false);
            }
            return this;
        }

        public final HttpUrl build() {
            if (this.scheme == null) {
                throw new IllegalStateException(z[12]);
            }
            if (this.host == null) {
                throw new IllegalStateException(z[11]);
            }
            return new HttpUrl(this);
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.scheme);
            stringBuilder.append(z[18]);
            if (!this.encodedUsername.isEmpty() || !this.encodedPassword.isEmpty()) {
                stringBuilder.append(this.encodedUsername);
                if (!this.encodedPassword.isEmpty()) {
                    stringBuilder.append(':');
                    stringBuilder.append(this.encodedPassword);
                }
                stringBuilder.append('@');
            }
            if (this.host.indexOf(58) != -1) {
                stringBuilder.append('[');
                stringBuilder.append(this.host);
                stringBuilder.append(']');
            } else {
                stringBuilder.append(this.host);
            }
            int n2 = this.effectivePort();
            if (n2 != HttpUrl.defaultPort(this.scheme)) {
                stringBuilder.append(':');
                stringBuilder.append(n2);
            }
            HttpUrl.pathSegmentsToString(stringBuilder, this.encodedPathSegments);
            if (this.encodedQueryNamesAndValues != null) {
                stringBuilder.append('?');
                HttpUrl.namesAndValuesToQueryString(stringBuilder, this.encodedQueryNamesAndValues);
            }
            if (this.encodedFragment != null) {
                stringBuilder.append('#');
                stringBuilder.append(this.encodedFragment);
            }
            return stringBuilder.toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final Builder parse(@Nullable HttpUrl httpUrl, String string) {
            int n2;
            int n3;
            int n4;
            block19: {
                n4 = Util.skipLeadingAsciiWhitespace(string, 0, string.length());
                int n5 = Builder.schemeDelimiterOffset(string, n4, n3 = Util.skipTrailingAsciiWhitespace(string, n4, string.length()));
                if (n5 != -1) {
                    if (string.regionMatches(true, n4, z[26], 0, 6)) {
                        this.scheme = z[15];
                        n4 += 6;
                    } else {
                        if (!string.regionMatches(true, n4, z[23], 0, 5)) throw new IllegalArgumentException(z[25] + string.substring(0, n5) + "'");
                        this.scheme = z[16];
                        n4 += 5;
                    }
                } else {
                    if (httpUrl == null) throw new IllegalArgumentException(z[21]);
                    this.scheme = httpUrl.scheme;
                }
                n5 = 0;
                boolean bl = false;
                n2 = Builder.slashCount(string, n4, n3);
                if (n2 >= 2 || httpUrl == null || !httpUrl.scheme.equals(this.scheme)) {
                    n4 += n2;
                    while (true) {
                        int n6;
                        switch ((n6 = Util.delimiterOffset(string, n4, n3, z[22])) != n3 ? (int)string.charAt(n6) : -1) {
                            case 64: {
                                if (!bl) {
                                    n2 = Util.delimiterOffset(string, n4, n6, ':');
                                    String string2 = HttpUrl.canonicalize(string, n4, n2, z[1], true, false, false, true, null);
                                    String string3 = this.encodedUsername = n5 != 0 ? this.encodedUsername + z[29] + string2 : string2;
                                    if (n2 != n6) {
                                        bl = true;
                                        this.encodedPassword = HttpUrl.canonicalize(string, n2 + 1, n6, z[1], true, false, false, true, null);
                                    }
                                    n5 = 1;
                                } else {
                                    this.encodedPassword = this.encodedPassword + z[29] + HttpUrl.canonicalize(string, n4, n6, z[1], true, false, false, true, null);
                                }
                                n4 = n6 + 1;
                                break;
                            }
                            case -1: 
                            case 35: 
                            case 47: 
                            case 63: 
                            case 92: {
                                n2 = Builder.portColonOffset(string, n4, n6);
                                if (n2 + 1 < n6) {
                                    this.host = Builder.canonicalizeHost(string, n4, n2);
                                    this.port = Builder.parsePort(string, n2 + 1, n6);
                                    if (this.port == -1) {
                                        throw new IllegalArgumentException(z[24] + string.substring(n2 + 1, n6) + '\"');
                                    }
                                } else {
                                    this.host = Builder.canonicalizeHost(string, n4, n2);
                                    this.port = HttpUrl.defaultPort(this.scheme);
                                }
                                if (this.host == null) {
                                    throw new IllegalArgumentException(z[28] + string.substring(n4, n2) + '\"');
                                }
                                n4 = n6;
                                break block19;
                            }
                        }
                    }
                }
                this.encodedUsername = httpUrl.encodedUsername();
                this.encodedPassword = httpUrl.encodedPassword();
                this.host = httpUrl.host;
                this.port = httpUrl.port;
                this.encodedPathSegments.clear();
                this.encodedPathSegments.addAll(httpUrl.encodedPathSegments());
                if (n4 == n3 || string.charAt(n4) == '#') {
                    this.encodedQuery(httpUrl.encodedQuery());
                }
            }
            int n7 = Util.delimiterOffset(string, n4, n3, z[27]);
            this.resolvePath(string, n4, n7);
            n4 = n7;
            if (n4 < n3 && string.charAt(n4) == '?') {
                n2 = Util.delimiterOffset(string, n4, n3, '#');
                this.encodedQueryNamesAndValues = HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(string, n4 + 1, n2, z[6], true, false, true, true, null));
                n4 = n2;
            }
            if (n4 >= n3 || string.charAt(n4) != '#') return this;
            this.encodedFragment = HttpUrl.canonicalize(string, n4 + 1, n3, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false, false, null);
            return this;
        }

        private void resolvePath(String string, int n2, int n3) {
            if (n2 == n3) {
                return;
            }
            int n4 = string.charAt(n2);
            if (n4 == 47 || n4 == 92) {
                this.encodedPathSegments.clear();
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
                ++n2;
            } else {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
            }
            while (n2 < n3) {
                n4 = Util.delimiterOffset(string, n2, n3, z[5]);
                boolean bl = n4 < n3;
                this.push(string, n2, n4, bl, true);
                n2 = n4;
                if (!bl) continue;
                ++n2;
            }
        }

        private void push(String string, int n2, int n3, boolean bl, boolean bl2) {
            if (this.isDot(string = HttpUrl.canonicalize(string, n2, n3, z[0], bl2, false, false, true, null))) {
                return;
            }
            if (this.isDotDot(string)) {
                this.pop();
                return;
            }
            if (this.encodedPathSegments.get(this.encodedPathSegments.size() - 1).isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, string);
            } else {
                this.encodedPathSegments.add(string);
            }
            if (bl) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
        }

        private boolean isDot(String string) {
            return string.equals(".") || string.equalsIgnoreCase(z[17]);
        }

        private boolean isDotDot(String string) {
            return string.equals(z[40]) || string.equalsIgnoreCase(z[42]) || string.equalsIgnoreCase(z[43]) || string.equalsIgnoreCase(z[41]);
        }

        private void pop() {
            if (this.encodedPathSegments.remove(this.encodedPathSegments.size() - 1).isEmpty() && !this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
                return;
            }
            this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
        }

        private static int schemeDelimiterOffset(String string, int n2, int n3) {
            if (n3 - n2 < 2) {
                return -1;
            }
            char c2 = string.charAt(n2);
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                return -1;
            }
            ++n2;
            while (n2 < n3) {
                c2 = string.charAt(n2);
                if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '+' || c2 == '-' || c2 == '.')) {
                    if (c2 == ':') {
                        return n2;
                    }
                    return -1;
                }
                ++n2;
            }
            return -1;
        }

        private static int slashCount(String string, int n2, int n3) {
            char c2;
            int n4 = 0;
            while (n2 < n3 && ((c2 = string.charAt(n2)) == '\\' || c2 == '/')) {
                ++n4;
                ++n2;
            }
            return n4;
        }

        private static int portColonOffset(String string, int n2, int n3) {
            while (n2 < n3) {
                switch (string.charAt(n2)) {
                    case '[': {
                        while (++n2 < n3 && string.charAt(n2) != ']') {
                        }
                        break;
                    }
                    case ':': {
                        return n2;
                    }
                }
                ++n2;
            }
            return n3;
        }

        private static String canonicalizeHost(String string, int n2, int n3) {
            return Util.canonicalizeHost(HttpUrl.percentDecode(string, n2, n3, false));
        }

        private static int parsePort(String string, int n2, int n3) {
            try {
                int n4 = Integer.parseInt(HttpUrl.canonicalize(string, n2, n3, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false, true, null));
                if (n4 > 0 && n4 <= 65535) {
                    return n4;
                }
                return -1;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[44];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "\fL\u001d%8,FK\u0011\u0006\t\u0002\u0003+'1";
            int n3 = 43;
            block52: while (true) {
                char[] cArray;
                block57: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block56: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block56;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block57;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 69;
                                    break;
                                }
                                case 1: {
                                    n9 = 34;
                                    break;
                                }
                                case 2: {
                                    n9 = 107;
                                    break;
                                }
                                case 3: {
                                    n9 = 68;
                                    break;
                                }
                                default: {
                                    n9 = 84;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    case 43: {
                        INVALID_HOST = string.intern();
                        string2 = "e\u0000Wz\n%Y\u00168{\u0019\u001dH";
                        n3 = -1;
                        continue block52;
                    }
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "e\u0000L~oy\u001fU\u0004\u000f\u0018|\u000b?)9\r7{w";
                        n3 = 0;
                        continue block52;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = " L\b+0 F>717L\n)1e\u001fVd:0N\u0007";
                        n3 = 1;
                        continue block52;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "0L\u000e<$ A\u001f!0eR\n0<eQ\u000e#9 L\u001f~t";
                        n3 = 2;
                        continue block52;
                    }
                    case 2: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = " L\b+0 F;% -q\u000e#9 L\u001fdix\u0002\u000518)";
                        n3 = 3;
                        continue block52;
                    }
                    case 3: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 5;
                        string2 = "j~";
                        n3 = 4;
                        continue block52;
                    }
                    case 4: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 6;
                        string2 = "e\u0000Lxjf";
                        n3 = 5;
                        continue block52;
                    }
                    case 5: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 7;
                        string2 = "e\u0000Lxjf\u0004V";
                        n3 = 6;
                        continue block52;
                    }
                    case 6: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 8;
                        string2 = " L\b+0 F%%9 \u0002Vyt+W\u0007(";
                        n3 = 7;
                        continue block52;
                    }
                    case 7: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 9;
                        string2 = "0L\u000e<$ A\u001f!0eR\u00046 \u007f\u0002";
                        n3 = 8;
                        continue block52;
                    }
                    case 8: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 10;
                        string2 = " L\b+0 F;%'6U\u000460e\u001fVd:0N\u0007";
                        n3 = 9;
                        continue block52;
                    }
                    case 9: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 11;
                        string2 = "-M\u00180tx\u001fK*!)N";
                        n3 = 10;
                        continue block52;
                    }
                    case 10: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 12;
                        string2 = "6A\u0003!9 \u0002Vyt+W\u0007(";
                        n3 = 11;
                        continue block52;
                    }
                    case 11: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 13;
                        string2 = "0L\u000e<$ A\u001f!0eJ\u00047 \u007f\u0002";
                        n3 = 12;
                        continue block52;
                    }
                    case 12: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 14;
                        string2 = "0L\u000e<$ A\u001f!0eQ\b,1(GQd";
                        n3 = 13;
                        continue block52;
                    }
                    case 13: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 15;
                        string2 = "-V\u001f4'";
                        n3 = 14;
                        continue block52;
                    }
                    case 14: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 16;
                        string2 = "-V\u001f4";
                        n3 = 15;
                        continue block52;
                    }
                    case 15: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 17;
                        string2 = "`\u0010\u000e";
                        n3 = 16;
                        continue block52;
                    }
                    case 16: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 18;
                        string2 = "\u007f\rD";
                        n3 = 17;
                        continue block52;
                    }
                    case 17: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 19;
                        string2 = "5C\u001f,\u0007 E\u0006!:1\u0002Vyt+W\u0007(";
                        n3 = 18;
                        continue block52;
                    }
                    case 18: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 20;
                        string2 = " L\b+0 F;% -q\u000e#9 L\u001f7tx\u001fK*!)N";
                        n3 = 19;
                        continue block52;
                    }
                    case 19: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 21;
                        string2 = "\u0000Z\u001b!71G\u000fd\u0001\u0017nK77-G\u0006!tbJ\u001f0$b\u0002\u00046tbJ\u001f0$6\u0005K&!1\u0002\u0005+t&M\u0007+:eU\n7t#M\u001e*0";
                        n3 = 20;
                        continue block52;
                    }
                    case 20: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 22;
                        string2 = "\u0005\r7{w";
                        n3 = 21;
                        continue block52;
                    }
                    case 21: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 23;
                        string2 = "-V\u001f4n";
                        n3 = 22;
                        continue block52;
                    }
                    case 22: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 24;
                        string2 = "\fL\u001d%8,FK\u0011\u0006\t\u0002\u001b+&1\u0018Kf";
                        n3 = 23;
                        continue block52;
                    }
                    case 23: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 25;
                        string2 = "\u0000Z\u001b!71G\u000fd\u0001\u0017nK77-G\u0006!tbJ\u001f0$b\u0002\u00046tbJ\u001f0$6\u0005K&!1\u0002\u001c%'e\u0005";
                        n3 = 24;
                        continue block52;
                    }
                    case 24: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 26;
                        string2 = "-V\u001f4'\u007f";
                        n3 = 25;
                        continue block52;
                    }
                    case 25: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 27;
                        string2 = "z\u0001";
                        n3 = 26;
                        continue block52;
                    }
                    case 26: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 28;
                        string2 = "\fL\u001d%8,FK\u0011\u0006\t\u0002\u0003+'1\u0018Kf";
                        n3 = 27;
                        continue block52;
                    }
                    case 27: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 29;
                        string2 = "`\u0016[";
                        n3 = 28;
                        continue block52;
                    }
                    case 28: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 30;
                        string2 = "0Q\u000e6:$O\u000edix\u0002\u000518)";
                        n3 = 29;
                        continue block52;
                    }
                    case 29: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 31;
                        string2 = "+C\u0006!tx\u001fK*!)N";
                        n3 = 30;
                        continue block52;
                    }
                    case 30: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 32;
                        string2 = "e\u0003Igpc\u0005Cmxj\u0018Pxi{\u001d+\u001f\t\u0019|\u000b?(8\\";
                        n3 = 31;
                        continue block52;
                    }
                    case 31: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 33;
                        string2 = "5C\u001f,\u0007 E\u0006!:1QKyieL\u001e(8";
                        n3 = 32;
                        continue block52;
                    }
                    case 32: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 34;
                        string2 = "\u0019|\u000b?(8";
                        n3 = 33;
                        continue block52;
                    }
                    case 33: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 35;
                        string2 = "\u001e\u007f";
                        n3 = 34;
                        continue block52;
                    }
                    case 34: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 36;
                        string2 = "e\u0000Hxj\u0019|\u000b?(8";
                        n3 = 35;
                        continue block52;
                    }
                    case 35: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 37;
                        string2 = " L\b+0 F;% -\u0002Vyt+W\u0007(";
                        n3 = 36;
                        continue block52;
                    }
                    case 36: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 38;
                        string2 = "0L\u000e<$ A\u001f!0eG\u0005';!G\u000f\u001451JQd";
                        n3 = 37;
                        continue block52;
                    }
                    case 37: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 39;
                        string2 = "5C\u00187#*P\u000fdix\u0002\u000518)";
                        n3 = 38;
                        continue block52;
                    }
                    case 38: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 40;
                        string2 = "k\f";
                        n3 = 39;
                        continue block52;
                    }
                    case 39: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 41;
                        string2 = "`\u0010\u000eaf ";
                        n3 = 40;
                        continue block52;
                    }
                    case 40: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 42;
                        string2 = "`\u0010\u000ej";
                        n3 = 41;
                        continue block52;
                    }
                    case 41: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 43;
                        string2 = "k\u0007Y!";
                        n3 = 42;
                        continue block52;
                    }
                    case 42: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

