/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.Headers;
import cn.jmessage.support.okhttp3.MediaType;
import cn.jmessage.support.okhttp3.RequestBody;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSink;
import cn.jmessage.support.okio.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class MultipartBody
extends RequestBody {
    public static final MediaType MIXED;
    public static final MediaType ALTERNATIVE;
    public static final MediaType DIGEST;
    public static final MediaType PARALLEL;
    public static final MediaType FORM;
    private static final byte[] COLONSPACE;
    private static final byte[] CRLF;
    private static final byte[] DASHDASH;
    private final ByteString boundary;
    private final MediaType originalType;
    private final MediaType contentType;
    private final List<Part> parts;
    private long contentLength = -1L;
    private static final String[] z;

    MultipartBody(ByteString byteString, MediaType mediaType, List<Part> list) {
        this.boundary = byteString;
        this.originalType = mediaType;
        this.contentType = MediaType.get(mediaType + z[2] + byteString.utf8());
        this.parts = Util.immutableList(list);
    }

    public final MediaType type() {
        return this.originalType;
    }

    public final String boundary() {
        return this.boundary.utf8();
    }

    public final int size() {
        return this.parts.size();
    }

    public final List<Part> parts() {
        return this.parts;
    }

    public final Part part(int n2) {
        return this.parts.get(n2);
    }

    @Override
    public final MediaType contentType() {
        return this.contentType;
    }

    @Override
    public final long contentLength() throws IOException {
        long l2 = this.contentLength;
        if (l2 != -1L) {
            return l2;
        }
        this.contentLength = this.writeOrCountBytes(null, true);
        return this.contentLength;
    }

    @Override
    public final void writeTo(BufferedSink bufferedSink) throws IOException {
        this.writeOrCountBytes(bufferedSink, false);
    }

    private long writeOrCountBytes(@Nullable BufferedSink bufferedSink, boolean bl) throws IOException {
        long l2 = 0L;
        Buffer buffer = null;
        if (bl) {
            buffer = new Buffer();
            bufferedSink = buffer;
        }
        int n2 = this.parts.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3;
            MediaType mediaType;
            Object object = this.parts.get(i2);
            Headers headers = ((Part)object).headers;
            object = ((Part)object).body;
            bufferedSink.write(DASHDASH);
            bufferedSink.write(this.boundary);
            bufferedSink.write(CRLF);
            if (headers != null) {
                int n3 = headers.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    bufferedSink.writeUtf8(headers.name(i3)).write(COLONSPACE).writeUtf8(headers.value(i3)).write(CRLF);
                }
            }
            if ((mediaType = ((RequestBody)object).contentType()) != null) {
                bufferedSink.writeUtf8(z[1]).writeUtf8(mediaType.toString()).write(CRLF);
            }
            if ((l3 = ((RequestBody)object).contentLength()) != -1L) {
                bufferedSink.writeUtf8(z[0]).writeDecimalLong(l3).write(CRLF);
            } else if (bl) {
                buffer.clear();
                return -1L;
            }
            bufferedSink.write(CRLF);
            if (bl) {
                l2 += l3;
            } else {
                ((RequestBody)object).writeTo(bufferedSink);
            }
            bufferedSink.write(CRLF);
        }
        bufferedSink.write(DASHDASH);
        bufferedSink.write(this.boundary);
        bufferedSink.write(DASHDASH);
        bufferedSink.write(CRLF);
        if (bl) {
            l2 += buffer.size();
            buffer.clear();
        }
        return l2;
    }

    static StringBuilder appendQuotedString(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        int n2 = string.length();
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\n': {
                    stringBuilder.append(z[5]);
                    continue block5;
                }
                case '\r': {
                    stringBuilder.append(z[4]);
                    continue block5;
                }
                case '\"': {
                    stringBuilder.append(z[3]);
                    continue block5;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        stringBuilder.append('\"');
        return stringBuilder;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String string2;
        int n2;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n3 = 0;
        String string3 = "\r\u000bV\u000e\r \u0010\u00156\r \u0003L\u0012Rn";
        int n4 = -1;
        block25: while (true) {
            char[] cArray;
            block34: {
                int n5;
                int n6;
                char[] cArray2;
                block33: {
                    char[] cArray3 = string3.toCharArray();
                    n2 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n6 = n7;
                    if (n7 <= 1) break block33;
                    cArray = cArray2;
                    n5 = n6;
                    if (n6 <= n2) break block34;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n2;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n2 % 5) {
                            case 0: {
                                n9 = 78;
                                break;
                            }
                            case 1: {
                                n9 = 100;
                                break;
                            }
                            case 2: {
                                n9 = 56;
                                break;
                            }
                            case 3: {
                                n9 = 122;
                                break;
                            }
                            default: {
                                n9 = 104;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n2;
                        cArray2 = cArray5;
                        n6 = n6;
                        if (n6 != 0) break;
                        cArray5 = cArray2;
                        n5 = n6;
                        n8 = n6;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n5 = n6;
                } while (n6 > n2);
            }
            string2 = new String(cArray);
            switch (n4) {
                default: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 1;
                    string3 = "\r\u000bV\u000e\r \u0010\u0015.\u0011>\u0001\u0002Z";
                    n4 = 0;
                    continue block25;
                }
                case 0: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 2;
                    string3 = "uDZ\u0015\u001d \u0000Y\b\u0011s";
                    n4 = 1;
                    continue block25;
                }
                case 1: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 3;
                    string3 = "kV\n";
                    n4 = 2;
                    continue block25;
                }
                case 2: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 4;
                    string3 = "kT|";
                    n4 = 3;
                    continue block25;
                }
                case 3: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 5;
                    string3 = "kTy";
                    n4 = 4;
                    continue block25;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n3] = string2.intern();
        z = stringArray3;
        String string4 = "#\u0011T\u000e\u0001>\u0005J\u000eG#\r@\u001f\f";
        int n10 = -1;
        block28: while (true) {
            char[] cArray;
            block36: {
                int n11;
                int n12;
                char[] cArray6;
                block35: {
                    char[] cArray7 = string4.toCharArray();
                    n2 = 0;
                    int n13 = cArray7.length;
                    cArray6 = cArray7;
                    n12 = n13;
                    if (n13 <= 1) break block35;
                    cArray = cArray6;
                    n11 = n12;
                    if (n12 <= n2) break block36;
                }
                do {
                    char[] cArray8 = cArray6;
                    char[] cArray9 = cArray6;
                    int n14 = n2;
                    while (true) {
                        int n15;
                        char c3 = cArray8[n14];
                        switch (n2 % 5) {
                            case 0: {
                                n15 = 78;
                                break;
                            }
                            case 1: {
                                n15 = 100;
                                break;
                            }
                            case 2: {
                                n15 = 56;
                                break;
                            }
                            case 3: {
                                n15 = 122;
                                break;
                            }
                            default: {
                                n15 = 104;
                            }
                        }
                        cArray8[n14] = (char)(c3 ^ n15);
                        ++n2;
                        cArray6 = cArray9;
                        n12 = n12;
                        if (n12 != 0) break;
                        cArray9 = cArray6;
                        n11 = n12;
                        n14 = n12;
                        cArray8 = cArray6;
                    }
                    cArray = cArray6;
                    n11 = n12;
                } while (n12 > n2);
            }
            string = new String(cArray).intern();
            switch (n10) {
                default: {
                    MIXED = MediaType.get(string);
                    string4 = "#\u0011T\u000e\u0001>\u0005J\u000eG/\bL\u001f\u001a \u0005L\u0013\u001e+";
                    n10 = 0;
                    continue block28;
                }
                case 0: {
                    ALTERNATIVE = MediaType.get(string);
                    string4 = "#\u0011T\u000e\u0001>\u0005J\u000eG*\r_\u001f\u001b:";
                    n10 = 1;
                    continue block28;
                }
                case 1: {
                    DIGEST = MediaType.get(string);
                    string4 = "#\u0011T\u000e\u0001>\u0005J\u000eG>\u0005J\u001b\u0004\"\u0001T";
                    n10 = 2;
                    continue block28;
                }
                case 2: {
                    PARALLEL = MediaType.get(string);
                    string4 = "#\u0011T\u000e\u0001>\u0005J\u000eG(\u000bJ\u0017E*\u0005L\u001b";
                    n10 = 3;
                    continue block28;
                }
                case 3: 
            }
            break;
        }
        FORM = MediaType.get(string);
        COLONSPACE = new byte[]{58, 32};
        CRLF = new byte[]{13, 10};
        DASHDASH = new byte[]{45, 45};
    }

    public static final class Builder {
        private final ByteString boundary;
        private MediaType type = MIXED;
        private final List<Part> parts = new ArrayList<Part>();
        private static final String[] z;

        public Builder() {
            this(UUID.randomUUID().toString());
        }

        public Builder(String string) {
            this.boundary = ByteString.encodeUtf8(string);
        }

        public final Builder setType(MediaType mediaType) {
            if (mediaType == null) {
                throw new NullPointerException(z[3]);
            }
            if (!mediaType.type().equals(z[4])) {
                throw new IllegalArgumentException(z[2] + mediaType);
            }
            this.type = mediaType;
            return this;
        }

        public final Builder addPart(RequestBody requestBody) {
            return this.addPart(Part.create(requestBody));
        }

        public final Builder addPart(@Nullable Headers headers, RequestBody requestBody) {
            return this.addPart(Part.create(headers, requestBody));
        }

        public final Builder addFormDataPart(String string, String string2) {
            return this.addPart(Part.createFormData(string, string2));
        }

        public final Builder addFormDataPart(String string, @Nullable String string2, RequestBody requestBody) {
            return this.addPart(Part.createFormData(string, string2, requestBody));
        }

        public final Builder addPart(Part part) {
            if (part == null) {
                throw new NullPointerException(z[1]);
            }
            this.parts.add(part);
            return this;
        }

        public final MultipartBody build() {
            if (this.parts.isEmpty()) {
                throw new IllegalStateException(z[0]);
            }
            return new MultipartBody(this.boundary, this.type, this.parts);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[5];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "7@\u001cg\u007f\nT\u0002g6\u0018Z\u0014j6\u0017@\u0003g6\u0012T\u0006v6\u001bAP\u007fs\u001bF\u00043y\u0014PPcw\bA^";
            int n3 = -1;
            block12: while (true) {
                char[] cArray;
                block17: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block16: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block16;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block17;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 122;
                                    break;
                                }
                                case 1: {
                                    n9 = 53;
                                    break;
                                }
                                case 2: {
                                    n9 = 112;
                                    break;
                                }
                                case 3: {
                                    n9 = 19;
                                    break;
                                }
                                default: {
                                    n9 = 22;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "\nT\u0002g6G\bP}c\u0016Y";
                        n3 = 0;
                        continue block12;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "\u0017@\u001cg\u007f\nT\u0002g6[\bP";
                        n3 = 1;
                        continue block12;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "\u000eL\u0000v6G\bP}c\u0016Y";
                        n3 = 2;
                        continue block12;
                    }
                    case 2: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = "\u0017@\u001cg\u007f\nT\u0002g";
                        n3 = 3;
                        continue block12;
                    }
                    case 3: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }

    public static final class Part {
        @Nullable
        final Headers headers;
        final RequestBody body;
        private static final String[] z;

        public static Part create(RequestBody requestBody) {
            return Part.create(null, requestBody);
        }

        public static Part create(@Nullable Headers headers, RequestBody requestBody) {
            if (requestBody == null) {
                throw new NullPointerException(z[1]);
            }
            if (headers != null && headers.get(z[3]) != null) {
                throw new IllegalArgumentException(z[0]);
            }
            if (headers != null && headers.get(z[4]) != null) {
                throw new IllegalArgumentException(z[2]);
            }
            return new Part(headers, requestBody);
        }

        public static Part createFormData(String string, String string2) {
            return Part.createFormData(string, null, RequestBody.create(null, string2));
        }

        public static Part createFormData(String string, @Nullable String string2, RequestBody requestBody) {
            if (string == null) {
                throw new NullPointerException(z[7]);
            }
            StringBuilder stringBuilder = new StringBuilder(z[8]);
            MultipartBody.appendQuotedString(stringBuilder, string);
            if (string2 != null) {
                stringBuilder.append(z[5]);
                MultipartBody.appendQuotedString(stringBuilder, string2);
            }
            return Part.create(Headers.of(z[6], stringBuilder.toString()), requestBody);
        }

        private Part(@Nullable Headers headers, RequestBody requestBody) {
            this.headers = headers;
            this.body = requestBody;
        }

        @Nullable
        public final Headers headers() {
            return this.headers;
        }

        public final RequestBody body() {
            return this.body;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[9];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "&\u0014\u0003\u00067\u0016\u0019\u0012\u001b#S\u0012\u0003\u001f#\u0016\b\\^\u0004\u001c\u0014\u0012\u001b)\u0007W2\u00077\u0016";
            int n3 = -1;
            block16: while (true) {
                char[] cArray;
                block21: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block20: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block20;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block21;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 115;
                                    break;
                                }
                                case 1: {
                                    n9 = 122;
                                    break;
                                }
                                case 2: {
                                    n9 = 102;
                                    break;
                                }
                                case 3: {
                                    n9 = 126;
                                    break;
                                }
                                default: {
                                    n9 = 71;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "\u0011\u0015\u0002\u0007gNGF\u00102\u001f\u0016";
                        n3 = 0;
                        continue block16;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "&\u0014\u0003\u00067\u0016\u0019\u0012\u001b#S\u0012\u0003\u001f#\u0016\b\\^\u0004\u001c\u0014\u0012\u001b)\u0007W*\u001b)\u0014\u000e\u000e";
                        n3 = 1;
                        continue block16;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "0\u0015\b\n\"\u001d\u000eK*>\u0003\u001f";
                        n3 = 2;
                        continue block16;
                    }
                    case 2: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = "0\u0015\b\n\"\u001d\u000eK2\"\u001d\u001d\u0012\u0016";
                        n3 = 3;
                        continue block16;
                    }
                    case 3: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 5;
                        string2 = "HZ\u0000\u0017+\u0016\u0014\u0007\u0013\"N";
                        n3 = 4;
                        continue block16;
                    }
                    case 4: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 6;
                        string2 = "0\u0015\b\n\"\u001d\u000eK:.\u0000\n\t\r.\u0007\u0013\t\u0010";
                        n3 = 5;
                        continue block16;
                    }
                    case 5: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 7;
                        string2 = "\u001d\u001b\u000b\u001bgNGF\u00102\u001f\u0016";
                        n3 = 6;
                        continue block16;
                    }
                    case 6: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 8;
                        string2 = "\u0015\u0015\u0014\u0013j\u0017\u001b\u0012\u001f|S\u0014\u0007\u0013\"N";
                        n3 = 7;
                        continue block16;
                    }
                    case 7: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

