/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.Address;
import cn.jmessage.support.okhttp3.Authenticator;
import cn.jmessage.support.okhttp3.Cache;
import cn.jmessage.support.okhttp3.Call;
import cn.jmessage.support.okhttp3.CertificatePinner;
import cn.jmessage.support.okhttp3.ConnectionPool;
import cn.jmessage.support.okhttp3.ConnectionSpec;
import cn.jmessage.support.okhttp3.CookieJar;
import cn.jmessage.support.okhttp3.Dispatcher;
import cn.jmessage.support.okhttp3.Dns;
import cn.jmessage.support.okhttp3.EventListener;
import cn.jmessage.support.okhttp3.Headers;
import cn.jmessage.support.okhttp3.Interceptor;
import cn.jmessage.support.okhttp3.Protocol;
import cn.jmessage.support.okhttp3.RealCall;
import cn.jmessage.support.okhttp3.Request;
import cn.jmessage.support.okhttp3.Response;
import cn.jmessage.support.okhttp3.Route;
import cn.jmessage.support.okhttp3.WebSocket;
import cn.jmessage.support.okhttp3.WebSocketListener;
import cn.jmessage.support.okhttp3.internal.Internal;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.cache.InternalCache;
import cn.jmessage.support.okhttp3.internal.connection.RealConnection;
import cn.jmessage.support.okhttp3.internal.connection.RouteDatabase;
import cn.jmessage.support.okhttp3.internal.connection.StreamAllocation;
import cn.jmessage.support.okhttp3.internal.platform.Platform;
import cn.jmessage.support.okhttp3.internal.tls.CertificateChainCleaner;
import cn.jmessage.support.okhttp3.internal.tls.OkHostnameVerifier;
import cn.jmessage.support.okhttp3.internal.ws.RealWebSocket;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class OkHttpClient
implements Call.Factory,
WebSocket.Factory,
Cloneable {
    static final List<Protocol> DEFAULT_PROTOCOLS;
    static final List<ConnectionSpec> DEFAULT_CONNECTION_SPECS;
    final Dispatcher dispatcher;
    @Nullable
    final Proxy proxy;
    final List<Protocol> protocols;
    final List<ConnectionSpec> connectionSpecs;
    final List<Interceptor> interceptors;
    final List<Interceptor> networkInterceptors;
    final EventListener.Factory eventListenerFactory;
    final ProxySelector proxySelector;
    final CookieJar cookieJar;
    @Nullable
    final Cache cache;
    @Nullable
    final InternalCache internalCache;
    final SocketFactory socketFactory;
    @Nullable
    final SSLSocketFactory sslSocketFactory;
    @Nullable
    final CertificateChainCleaner certificateChainCleaner;
    final HostnameVerifier hostnameVerifier;
    final CertificatePinner certificatePinner;
    final Authenticator proxyAuthenticator;
    final Authenticator authenticator;
    final ConnectionPool connectionPool;
    final Dns dns;
    final boolean followSslRedirects;
    final boolean followRedirects;
    final boolean retryOnConnectionFailure;
    final int connectTimeout;
    final int readTimeout;
    final int writeTimeout;
    final int pingInterval;
    private static final String[] z;

    public OkHttpClient() {
        this(new Builder());
    }

    OkHttpClient(Builder builder) {
        this.dispatcher = builder.dispatcher;
        this.proxy = builder.proxy;
        this.protocols = builder.protocols;
        this.connectionSpecs = builder.connectionSpecs;
        this.interceptors = Util.immutableList(builder.interceptors);
        this.networkInterceptors = Util.immutableList(builder.networkInterceptors);
        this.eventListenerFactory = builder.eventListenerFactory;
        this.proxySelector = builder.proxySelector;
        this.cookieJar = builder.cookieJar;
        this.cache = builder.cache;
        this.internalCache = builder.internalCache;
        this.socketFactory = builder.socketFactory;
        boolean bl = false;
        for (ConnectionSpec connectionSpec : this.connectionSpecs) {
            bl = bl || connectionSpec.isTls();
        }
        if (builder.sslSocketFactory != null || !bl) {
            this.sslSocketFactory = builder.sslSocketFactory;
            this.certificateChainCleaner = builder.certificateChainCleaner;
        } else {
            X509TrustManager x509TrustManager = Util.platformTrustManager();
            this.sslSocketFactory = OkHttpClient.newSslSocketFactory(x509TrustManager);
            this.certificateChainCleaner = CertificateChainCleaner.get(x509TrustManager);
        }
        if (this.sslSocketFactory != null) {
            Platform.get().configureSslSocketFactory(this.sslSocketFactory);
        }
        this.hostnameVerifier = builder.hostnameVerifier;
        this.certificatePinner = builder.certificatePinner.withCertificateChainCleaner(this.certificateChainCleaner);
        this.proxyAuthenticator = builder.proxyAuthenticator;
        this.authenticator = builder.authenticator;
        this.connectionPool = builder.connectionPool;
        this.dns = builder.dns;
        this.followSslRedirects = builder.followSslRedirects;
        this.followRedirects = builder.followRedirects;
        this.retryOnConnectionFailure = builder.retryOnConnectionFailure;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.pingInterval = builder.pingInterval;
        if (this.interceptors.contains(null)) {
            throw new IllegalStateException(z[1] + this.interceptors);
        }
        if (this.networkInterceptors.contains(null)) {
            throw new IllegalStateException(z[0] + this.networkInterceptors);
        }
    }

    private static SSLSocketFactory newSslSocketFactory(X509TrustManager x509TrustManager) {
        try {
            SSLContext sSLContext = Platform.get().getSSLContext();
            sSLContext.init(null, new TrustManager[]{x509TrustManager}, null);
            return sSLContext.getSocketFactory();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Util.assertionError(z[2], generalSecurityException);
        }
    }

    public int connectTimeoutMillis() {
        return this.connectTimeout;
    }

    public int readTimeoutMillis() {
        return this.readTimeout;
    }

    public int writeTimeoutMillis() {
        return this.writeTimeout;
    }

    public int pingIntervalMillis() {
        return this.pingInterval;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public ProxySelector proxySelector() {
        return this.proxySelector;
    }

    public CookieJar cookieJar() {
        return this.cookieJar;
    }

    @Nullable
    public Cache cache() {
        return this.cache;
    }

    InternalCache internalCache() {
        if (this.cache != null) {
            return this.cache.internalCache;
        }
        return this.internalCache;
    }

    public Dns dns() {
        return this.dns;
    }

    public SocketFactory socketFactory() {
        return this.socketFactory;
    }

    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    public HostnameVerifier hostnameVerifier() {
        return this.hostnameVerifier;
    }

    public CertificatePinner certificatePinner() {
        return this.certificatePinner;
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public Authenticator proxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public ConnectionPool connectionPool() {
        return this.connectionPool;
    }

    public boolean followSslRedirects() {
        return this.followSslRedirects;
    }

    public boolean followRedirects() {
        return this.followRedirects;
    }

    public boolean retryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public Dispatcher dispatcher() {
        return this.dispatcher;
    }

    public List<Protocol> protocols() {
        return this.protocols;
    }

    public List<ConnectionSpec> connectionSpecs() {
        return this.connectionSpecs;
    }

    public List<Interceptor> interceptors() {
        return this.interceptors;
    }

    public List<Interceptor> networkInterceptors() {
        return this.networkInterceptors;
    }

    public EventListener.Factory eventListenerFactory() {
        return this.eventListenerFactory;
    }

    @Override
    public Call newCall(Request request) {
        return RealCall.newRealCall(this, request, false);
    }

    @Override
    public WebSocket newWebSocket(Request object, WebSocketListener webSocketListener) {
        object = new RealWebSocket((Request)object, webSocketListener, new Random(), this.pingInterval);
        ((RealWebSocket)object).connect(this);
        return object;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "+)Er%\u000b9]ij\u00177\twk\u00119[}`\u0015(Fl?E";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 101;
                                break;
                            }
                            case 1: {
                                n9 = 92;
                                break;
                            }
                            case 2: {
                                n9 = 41;
                                break;
                            }
                            case 3: {
                                n9 = 30;
                                break;
                            }
                            default: {
                                n9 = 5;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "+)Er%\f2]{w\u00069Yjj\u0017f\t";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "+3\tM|\u0016(Ls%1\u0010z";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        DEFAULT_PROTOCOLS = Util.immutableList(Protocol.HTTP_2, Protocol.HTTP_1_1);
        DEFAULT_CONNECTION_SPECS = Util.immutableList(ConnectionSpec.MODERN_TLS, ConnectionSpec.CLEARTEXT);
        Internal.instance = new Internal(){
            private static final String z;

            @Override
            public final void addLenient(Headers.Builder builder, String string) {
                builder.addLenient(string);
            }

            @Override
            public final void addLenient(Headers.Builder builder, String string, String string2) {
                builder.addLenient(string, string2);
            }

            @Override
            public final void setCache(Builder builder, InternalCache internalCache) {
                builder.setInternalCache(internalCache);
            }

            @Override
            public final boolean connectionBecameIdle(ConnectionPool connectionPool, RealConnection realConnection) {
                return connectionPool.connectionBecameIdle(realConnection);
            }

            @Override
            public final RealConnection get(ConnectionPool connectionPool, Address address, StreamAllocation streamAllocation, Route route) {
                return connectionPool.get(address, streamAllocation, route);
            }

            @Override
            public final boolean equalsNonHost(Address address, Address address2) {
                return address.equalsNonHost(address2);
            }

            @Override
            public final Socket deduplicate(ConnectionPool connectionPool, Address address, StreamAllocation streamAllocation) {
                return connectionPool.deduplicate(address, streamAllocation);
            }

            @Override
            public final void put(ConnectionPool connectionPool, RealConnection realConnection) {
                connectionPool.put(realConnection);
            }

            @Override
            public final RouteDatabase routeDatabase(ConnectionPool connectionPool) {
                return connectionPool.routeDatabase;
            }

            @Override
            public final int code(Response.Builder builder) {
                return builder.code;
            }

            @Override
            public final void apply(ConnectionSpec connectionSpec, SSLSocket sSLSocket, boolean bl) {
                connectionSpec.apply(sSLSocket, bl);
            }

            @Override
            public final boolean isInvalidHttpUrlHost(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException.getMessage().startsWith(z);
            }

            @Override
            public final StreamAllocation streamAllocation(Call call) {
                return ((RealCall)call).streamAllocation();
            }

            @Override
            public final Call newWebSocketCall(OkHttpClient okHttpClient, Request request) {
                return RealCall.newRealCall(okHttpClient, request, true);
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                char[] cArray;
                block10: {
                    int n2;
                    int n3;
                    char[] cArray2;
                    int n4;
                    block9: {
                        char[] cArray3 = "6\u0014\u0012{D\u0016\u001eDOz3Z\fu[\u000b".toCharArray();
                        n4 = 0;
                        int n5 = cArray3.length;
                        cArray2 = cArray3;
                        n3 = n5;
                        if (n5 <= 1) break block9;
                        cArray = cArray2;
                        n2 = n3;
                        if (n3 <= n4) break block10;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n6 = n4;
                        while (true) {
                            int n7;
                            char c2 = cArray4[n6];
                            switch (n4 % 5) {
                                case 0: {
                                    n7 = 127;
                                    break;
                                }
                                case 1: {
                                    n7 = 122;
                                    break;
                                }
                                case 2: {
                                    n7 = 100;
                                    break;
                                }
                                case 3: {
                                    n7 = 26;
                                    break;
                                }
                                default: {
                                    n7 = 40;
                                }
                            }
                            cArray4[n6] = (char)(c2 ^ n7);
                            ++n4;
                            cArray2 = cArray5;
                            n3 = n3;
                            if (n3 != 0) break;
                            cArray5 = cArray2;
                            n2 = n3;
                            n6 = n3;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n2 = n3;
                    } while (n3 > n4);
                }
                z = new String(cArray).intern();
            }
        };
    }

    public static final class Builder {
        Dispatcher dispatcher;
        @Nullable
        Proxy proxy;
        List<Protocol> protocols;
        List<ConnectionSpec> connectionSpecs;
        final List<Interceptor> interceptors = new ArrayList<Interceptor>();
        final List<Interceptor> networkInterceptors = new ArrayList<Interceptor>();
        EventListener.Factory eventListenerFactory;
        ProxySelector proxySelector;
        CookieJar cookieJar;
        @Nullable
        Cache cache;
        @Nullable
        InternalCache internalCache;
        SocketFactory socketFactory;
        @Nullable
        SSLSocketFactory sslSocketFactory;
        @Nullable
        CertificateChainCleaner certificateChainCleaner;
        HostnameVerifier hostnameVerifier;
        CertificatePinner certificatePinner;
        Authenticator proxyAuthenticator;
        Authenticator authenticator;
        ConnectionPool connectionPool;
        Dns dns;
        boolean followSslRedirects;
        boolean followRedirects;
        boolean retryOnConnectionFailure;
        int connectTimeout;
        int readTimeout;
        int writeTimeout;
        int pingInterval;
        private static final String[] z;

        public Builder() {
            this.dispatcher = new Dispatcher();
            this.protocols = DEFAULT_PROTOCOLS;
            this.connectionSpecs = DEFAULT_CONNECTION_SPECS;
            this.eventListenerFactory = EventListener.factory(EventListener.NONE);
            this.proxySelector = ProxySelector.getDefault();
            this.cookieJar = CookieJar.NO_COOKIES;
            this.socketFactory = SocketFactory.getDefault();
            this.hostnameVerifier = OkHostnameVerifier.INSTANCE;
            this.certificatePinner = CertificatePinner.DEFAULT;
            this.proxyAuthenticator = Authenticator.NONE;
            this.authenticator = Authenticator.NONE;
            this.connectionPool = new ConnectionPool();
            this.dns = Dns.SYSTEM;
            this.followSslRedirects = true;
            this.followRedirects = true;
            this.retryOnConnectionFailure = true;
            this.connectTimeout = 10000;
            this.readTimeout = 10000;
            this.writeTimeout = 10000;
            this.pingInterval = 0;
        }

        Builder(OkHttpClient okHttpClient) {
            this.dispatcher = okHttpClient.dispatcher;
            this.proxy = okHttpClient.proxy;
            this.protocols = okHttpClient.protocols;
            this.connectionSpecs = okHttpClient.connectionSpecs;
            this.interceptors.addAll(okHttpClient.interceptors);
            this.networkInterceptors.addAll(okHttpClient.networkInterceptors);
            this.eventListenerFactory = okHttpClient.eventListenerFactory;
            this.proxySelector = okHttpClient.proxySelector;
            this.cookieJar = okHttpClient.cookieJar;
            this.internalCache = okHttpClient.internalCache;
            this.cache = okHttpClient.cache;
            this.socketFactory = okHttpClient.socketFactory;
            this.sslSocketFactory = okHttpClient.sslSocketFactory;
            this.certificateChainCleaner = okHttpClient.certificateChainCleaner;
            this.hostnameVerifier = okHttpClient.hostnameVerifier;
            this.certificatePinner = okHttpClient.certificatePinner;
            this.proxyAuthenticator = okHttpClient.proxyAuthenticator;
            this.authenticator = okHttpClient.authenticator;
            this.connectionPool = okHttpClient.connectionPool;
            this.dns = okHttpClient.dns;
            this.followSslRedirects = okHttpClient.followSslRedirects;
            this.followRedirects = okHttpClient.followRedirects;
            this.retryOnConnectionFailure = okHttpClient.retryOnConnectionFailure;
            this.connectTimeout = okHttpClient.connectTimeout;
            this.readTimeout = okHttpClient.readTimeout;
            this.writeTimeout = okHttpClient.writeTimeout;
            this.pingInterval = okHttpClient.pingInterval;
        }

        public final Builder connectTimeout(long l2, TimeUnit timeUnit) {
            this.connectTimeout = Util.checkDuration(z[1], l2, timeUnit);
            return this;
        }

        public final Builder readTimeout(long l2, TimeUnit timeUnit) {
            this.readTimeout = Util.checkDuration(z[1], l2, timeUnit);
            return this;
        }

        public final Builder writeTimeout(long l2, TimeUnit timeUnit) {
            this.writeTimeout = Util.checkDuration(z[1], l2, timeUnit);
            return this;
        }

        public final Builder pingInterval(long l2, TimeUnit timeUnit) {
            this.pingInterval = Util.checkDuration(z[2], l2, timeUnit);
            return this;
        }

        public final Builder proxy(@Nullable Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public final Builder proxySelector(ProxySelector proxySelector) {
            this.proxySelector = proxySelector;
            return this;
        }

        public final Builder cookieJar(CookieJar cookieJar) {
            if (cookieJar == null) {
                throw new NullPointerException(z[7]);
            }
            this.cookieJar = cookieJar;
            return this;
        }

        final void setInternalCache(@Nullable InternalCache internalCache) {
            this.internalCache = internalCache;
            this.cache = null;
        }

        public final Builder cache(@Nullable Cache cache) {
            this.cache = cache;
            this.internalCache = null;
            return this;
        }

        public final Builder dns(Dns dns) {
            if (dns == null) {
                throw new NullPointerException(z[12]);
            }
            this.dns = dns;
            return this;
        }

        public final Builder socketFactory(SocketFactory socketFactory) {
            if (socketFactory == null) {
                throw new NullPointerException(z[13]);
            }
            this.socketFactory = socketFactory;
            return this;
        }

        public final Builder sslSocketFactory(SSLSocketFactory sSLSocketFactory) {
            if (sSLSocketFactory == null) {
                throw new NullPointerException(z[14]);
            }
            this.sslSocketFactory = sSLSocketFactory;
            this.certificateChainCleaner = Platform.get().buildCertificateChainCleaner(sSLSocketFactory);
            return this;
        }

        public final Builder sslSocketFactory(SSLSocketFactory sSLSocketFactory, X509TrustManager x509TrustManager) {
            if (sSLSocketFactory == null) {
                throw new NullPointerException(z[14]);
            }
            if (x509TrustManager == null) {
                throw new NullPointerException(z[15]);
            }
            this.sslSocketFactory = sSLSocketFactory;
            this.certificateChainCleaner = CertificateChainCleaner.get(x509TrustManager);
            return this;
        }

        public final Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            if (hostnameVerifier == null) {
                throw new NullPointerException(z[19]);
            }
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public final Builder certificatePinner(CertificatePinner certificatePinner) {
            if (certificatePinner == null) {
                throw new NullPointerException(z[18]);
            }
            this.certificatePinner = certificatePinner;
            return this;
        }

        public final Builder authenticator(Authenticator authenticator) {
            if (authenticator == null) {
                throw new NullPointerException(z[16]);
            }
            this.authenticator = authenticator;
            return this;
        }

        public final Builder proxyAuthenticator(Authenticator authenticator) {
            if (authenticator == null) {
                throw new NullPointerException(z[17]);
            }
            this.proxyAuthenticator = authenticator;
            return this;
        }

        public final Builder connectionPool(ConnectionPool connectionPool) {
            if (connectionPool == null) {
                throw new NullPointerException(z[10]);
            }
            this.connectionPool = connectionPool;
            return this;
        }

        public final Builder followSslRedirects(boolean bl) {
            this.followSslRedirects = bl;
            return this;
        }

        public final Builder followRedirects(boolean bl) {
            this.followRedirects = bl;
            return this;
        }

        public final Builder retryOnConnectionFailure(boolean bl) {
            this.retryOnConnectionFailure = bl;
            return this;
        }

        public final Builder dispatcher(Dispatcher dispatcher) {
            if (dispatcher == null) {
                throw new IllegalArgumentException(z[11]);
            }
            this.dispatcher = dispatcher;
            return this;
        }

        public final Builder protocols(List<Protocol> list) {
            if (!(list = new ArrayList<Protocol>(list)).contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) && !list.contains((Object)Protocol.HTTP_1_1)) {
                throw new IllegalArgumentException(z[3] + list);
            }
            if (list.contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) && list.size() > 1) {
                throw new IllegalArgumentException(z[6] + list);
            }
            if (list.contains((Object)Protocol.HTTP_1_0)) {
                throw new IllegalArgumentException(z[5] + list);
            }
            if (list.contains(null)) {
                throw new IllegalArgumentException(z[4]);
            }
            list.remove((Object)Protocol.SPDY_3);
            this.protocols = Collections.unmodifiableList(list);
            return this;
        }

        public final Builder connectionSpecs(List<ConnectionSpec> list) {
            this.connectionSpecs = Util.immutableList(list);
            return this;
        }

        public final List<Interceptor> interceptors() {
            return this.interceptors;
        }

        public final Builder addInterceptor(Interceptor interceptor) {
            if (interceptor == null) {
                throw new IllegalArgumentException(z[9]);
            }
            this.interceptors.add(interceptor);
            return this;
        }

        public final List<Interceptor> networkInterceptors() {
            return this.networkInterceptors;
        }

        public final Builder addNetworkInterceptor(Interceptor interceptor) {
            if (interceptor == null) {
                throw new IllegalArgumentException(z[9]);
            }
            this.networkInterceptors.add(interceptor);
            return this;
        }

        public final Builder eventListener(EventListener eventListener) {
            if (eventListener == null) {
                throw new NullPointerException(z[8]);
            }
            this.eventListenerFactory = EventListener.factory(eventListener);
            return this;
        }

        public final Builder eventListenerFactory(EventListener.Factory factory) {
            if (factory == null) {
                throw new NullPointerException(z[0]);
            }
            this.eventListenerFactory = factory;
            return this;
        }

        public final OkHttpClient build() {
            return new OkHttpClient(this);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[20];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "$y`T\u001a\rfvN\u000b/jw|\u000f\"{jH\u0017a28\u001a\u00004ci";
            int n3 = -1;
            block27: while (true) {
                char[] cArray;
                block32: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block31: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block31;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block32;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 65;
                                    break;
                                }
                                case 1: {
                                    n9 = 15;
                                    break;
                                }
                                case 2: {
                                    n9 = 5;
                                    break;
                                }
                                case 3: {
                                    n9 = 58;
                                    break;
                                }
                                default: {
                                    n9 = 110;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "5fh_\u00014{";
                        n3 = 0;
                        continue block27;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "(aq_\u001c7ni";
                        n3 = 1;
                        continue block27;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "1}jN\u0001\"`iIN,zvNN\"`kN\u000f(a%R\\\u001e\u007fwS\u00013PnT\u00016c`^\t$/jHN){qJAp!4\u0000N";
                        n3 = 2;
                        continue block27;
                    }
                    case 2: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = "1}jN\u0001\"`iIN,zvNN/`q\u001a\r.aq[\u0007//kO\u0002-";
                        n3 = 3;
                        continue block27;
                    }
                    case 3: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 5;
                        string2 = "1}jN\u0001\"`iIN,zvNN/`q\u001a\r.aq[\u0007//mN\u001a1 4\u0014^{/";
                        n3 = 4;
                        continue block27;
                    }
                    case 4: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 6;
                        string2 = "1}jN\u0001\"`iIN\"`kN\u000f(alT\tag7e\u001e3fjH1*ajM\u0002$kb_N\"nkT\u00015/pI\u000ba`qR\u000b3/uH\u00015`fU\u000225%";
                        n3 = 5;
                        continue block27;
                    }
                    case 5: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 7;
                        string2 = "\"`jQ\u0007$EdHN|2%T\u001b-c";
                        n3 = 6;
                        continue block27;
                    }
                    case 6: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 8;
                        string2 = "$y`T\u001a\rfvN\u000b/jw\u001aS|/kO\u0002-";
                        n3 = 7;
                        continue block27;
                    }
                    case 7: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 9;
                        string2 = "(aq_\u001c\"juN\u00013/8\u0007N/ziV";
                        n3 = 8;
                        continue block27;
                    }
                    case 8: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 10;
                        string2 = "\"`kT\u000b\"{lU\u0000\u0011`jVN|2%T\u001b-c";
                        n3 = 9;
                        continue block27;
                    }
                    case 9: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 11;
                        string2 = "%fvJ\u000f5lm_\u001ca28\u001a\u00004ci";
                        n3 = 10;
                        continue block27;
                    }
                    case 10: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 12;
                        string2 = "%av\u001aS|/kO\u0002-";
                        n3 = 11;
                        continue block27;
                    }
                    case 11: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 13;
                        string2 = "2`fQ\u000b5IdY\u001a.}|\u001aS|/kO\u0002-";
                        n3 = 12;
                        continue block27;
                    }
                    case 12: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 14;
                        string2 = "2|ii\u0001\"d`N( lqU\u001c8/8\u0007N/ziV";
                        n3 = 13;
                        continue block27;
                    }
                    case 13: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 15;
                        string2 = "5}pI\u001a\fnk[\t$}%\u0007SaapV\u0002";
                        n3 = 14;
                        continue block27;
                    }
                    case 14: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 16;
                        string2 = " zqR\u000b/{lY\u000f5`w\u001aS|/kO\u0002-";
                        n3 = 15;
                        continue block27;
                    }
                    case 15: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 17;
                        string2 = "1}jB\u0017\u0000zqR\u000b/{lY\u000f5`w\u001aS|/kO\u0002-";
                        n3 = 16;
                        continue block27;
                    }
                    case 16: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 18;
                        string2 = "\"jwN\u0007'ff[\u001a$_lT\u0000$}%\u0007SaapV\u0002";
                        n3 = 17;
                        continue block27;
                    }
                    case 17: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 19;
                        string2 = ")`vN\u0000 b`l\u000b3fcS\u000b3/8\u0007N/ziV";
                        n3 = 18;
                        continue block27;
                    }
                    case 18: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

