/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.MediaType;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.ByteString;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public abstract class ResponseBody
implements Closeable {
    private Reader reader;
    private static final String[] z;

    @Nullable
    public abstract MediaType contentType();

    public abstract long contentLength();

    public final InputStream byteStream() {
        return this.source().inputStream();
    }

    public abstract BufferedSource source();

    public final byte[] bytes() throws IOException {
        byte[] byArray;
        long l2 = this.contentLength();
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException(z[2] + l2);
        }
        BufferedSource bufferedSource = this.source();
        try {
            byArray = bufferedSource.readByteArray();
        }
        finally {
            Util.closeQuietly(bufferedSource);
        }
        if (l2 != -1L && l2 != (long)byArray.length) {
            throw new IOException(z[3] + l2 + z[0] + byArray.length + z[1]);
        }
        return byArray;
    }

    public final Reader charStream() {
        Reader reader = this.reader;
        if (reader != null) {
            return reader;
        }
        this.reader = new BomAwareReader(this.source(), this.charset());
        return this.reader;
    }

    public final String string() throws IOException {
        BufferedSource bufferedSource = this.source();
        try {
            Object object = Util.bomAwareCharset(bufferedSource, this.charset());
            object = bufferedSource.readString((Charset)object);
            return object;
        }
        finally {
            Util.closeQuietly(bufferedSource);
        }
    }

    private Charset charset() {
        MediaType mediaType = this.contentType();
        if (mediaType != null) {
            return mediaType.charset(Util.UTF_8);
        }
        return Util.UTF_8;
    }

    @Override
    public void close() {
        Util.closeQuietly(this.source());
    }

    public static ResponseBody create(@Nullable MediaType mediaType, String object) {
        Charset charset = Util.UTF_8;
        if (mediaType != null && (charset = mediaType.charset()) == null) {
            charset = Util.UTF_8;
            mediaType = MediaType.parse(mediaType + z[5]);
        }
        object = new Buffer().writeString((String)object, charset);
        return ResponseBody.create(mediaType, ((Buffer)object).size(), (BufferedSource)object);
    }

    public static ResponseBody create(@Nullable MediaType mediaType, byte[] byArray) {
        Buffer buffer = new Buffer().write(byArray);
        return ResponseBody.create(mediaType, byArray.length, buffer);
    }

    public static ResponseBody create(@Nullable MediaType mediaType, ByteString byteString) {
        Buffer buffer = new Buffer().write(byteString);
        return ResponseBody.create(mediaType, byteString.size(), buffer);
    }

    public static ResponseBody create(final @Nullable MediaType mediaType, final long l2, final BufferedSource bufferedSource) {
        if (bufferedSource == null) {
            throw new NullPointerException(z[4]);
        }
        return new ResponseBody(){

            @Override
            @Nullable
            public final MediaType contentType() {
                return mediaType;
            }

            @Override
            public final long contentLength() {
                return l2;
            }

            @Override
            public final BufferedSource source() {
                return bufferedSource;
            }
        };
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "C-Wk+J~Bw*\u000b`\u0016i*\u0004jBmoB";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 106;
                                break;
                            }
                            case 1: {
                                n9 = 13;
                                break;
                            }
                            case 2: {
                                n9 = 54;
                                break;
                            }
                            case 3: {
                                n9 = 5;
                                break;
                            }
                            default: {
                                n9 = 79;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "C-Rl<\u000bjD`*";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = ")lXk \u001e-Tp)\fhD%*\u0004y_w*JoYa6JkYwo\tbXq*\u0004y\u0016i*\u0004jBmuJ";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ")bXq*\u0004y\u001bI*\u0004jBmoB";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0019bCw,\u000f-\u000b8o\u0004xZi";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "Q-Um.\u0018~Sqr\u001fyP(w";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    static final class BomAwareReader
    extends Reader {
        private final BufferedSource source;
        private final Charset charset;
        private boolean closed;
        private Reader delegate;
        private static final String z;

        BomAwareReader(BufferedSource bufferedSource, Charset charset) {
            this.source = bufferedSource;
            this.charset = charset;
        }

        @Override
        public final int read(char[] cArray, int n2, int n3) throws IOException {
            if (this.closed) {
                throw new IOException(z);
            }
            Object object = this.delegate;
            if (object == null) {
                object = Util.bomAwareCharset(this.source, this.charset);
                this.delegate = new InputStreamReader(this.source.inputStream(), (Charset)object);
                object = this.delegate;
            }
            return ((Reader)object).read(cArray, n2, n3);
        }

        @Override
        public final void close() throws IOException {
            this.closed = true;
            if (this.delegate != null) {
                this.delegate.close();
                return;
            }
            this.source.close();
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "0\u0011c=O\u000eEr4A\u0010\u0000u".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 99;
                                break;
                            }
                            case 1: {
                                n7 = 101;
                                break;
                            }
                            case 2: {
                                n7 = 17;
                                break;
                            }
                            case 3: {
                                n7 = 88;
                                break;
                            }
                            default: {
                                n7 = 46;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }
}

