/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.connection;

import cn.jmessage.support.okhttp3.Address;
import cn.jmessage.support.okhttp3.Call;
import cn.jmessage.support.okhttp3.EventListener;
import cn.jmessage.support.okhttp3.HttpUrl;
import cn.jmessage.support.okhttp3.Route;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.connection.RouteDatabase;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

public final class RouteSelector {
    private final Address address;
    private final RouteDatabase routeDatabase;
    private final Call call;
    private final EventListener eventListener;
    private List<Proxy> proxies = Collections.emptyList();
    private int nextProxyIndex;
    private List<InetSocketAddress> inetSocketAddresses = Collections.emptyList();
    private final List<Route> postponedRoutes = new ArrayList<Route>();
    private static final String[] z;

    public RouteSelector(Address address, RouteDatabase routeDatabase, Call call, EventListener eventListener) {
        this.address = address;
        this.routeDatabase = routeDatabase;
        this.call = call;
        this.eventListener = eventListener;
        this.resetNextProxy(address.url(), address.proxy());
    }

    public final boolean hasNext() {
        return this.hasNextProxy() || !this.postponedRoutes.isEmpty();
    }

    public final Selection next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ArrayList<Route> arrayList = new ArrayList<Route>();
        while (this.hasNextProxy()) {
            Proxy proxy = this.nextProxy();
            int n2 = this.inetSocketAddresses.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Route route = new Route(this.address, proxy, this.inetSocketAddresses.get(i2));
                if (this.routeDatabase.shouldPostpone(route)) {
                    this.postponedRoutes.add(route);
                    continue;
                }
                arrayList.add(route);
            }
            if (arrayList.isEmpty()) continue;
        }
        if (arrayList.isEmpty()) {
            arrayList.addAll(this.postponedRoutes);
            this.postponedRoutes.clear();
        }
        return new Selection(arrayList);
    }

    public final void connectFailed(Route route, IOException iOException) {
        if (route.proxy().type() != Proxy.Type.DIRECT && this.address.proxySelector() != null) {
            this.address.proxySelector().connectFailed(this.address.url().uri(), route.proxy().address(), iOException);
        }
        this.routeDatabase.failed(route);
    }

    private void resetNextProxy(HttpUrl object, Proxy proxy) {
        List<Proxy> list;
        RouteSelector routeSelector;
        if (proxy != null) {
            routeSelector = this;
            list = Collections.singletonList(proxy);
        } else {
            object = this.address.proxySelector().select(((HttpUrl)object).uri());
            routeSelector = this;
            list = object != null && !object.isEmpty() ? Util.immutableList(object) : Util.immutableList(Proxy.NO_PROXY);
        }
        routeSelector.proxies = list;
        this.nextProxyIndex = 0;
    }

    private boolean hasNextProxy() {
        return this.nextProxyIndex < this.proxies.size();
    }

    private Proxy nextProxy() throws IOException {
        if (!this.hasNextProxy()) {
            throw new SocketException(z[1] + this.address.url().host() + z[0] + this.proxies);
        }
        Proxy proxy = this.proxies.get(this.nextProxyIndex++);
        this.resetNextInetSocketAddress(proxy);
        return proxy;
    }

    private void resetNextInetSocketAddress(Proxy proxy) throws IOException {
        Object object;
        int n2;
        Object object2;
        this.inetSocketAddresses = new ArrayList<InetSocketAddress>();
        if (proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.SOCKS) {
            object2 = this.address.url().host();
            n2 = this.address.url().port();
        } else {
            object = proxy.address();
            if (!(object instanceof InetSocketAddress)) {
                throw new IllegalArgumentException(z[4] + object.getClass());
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)object;
            object2 = RouteSelector.getHostString(inetSocketAddress);
            n2 = inetSocketAddress.getPort();
        }
        if (n2 <= 0 || n2 > 65535) {
            throw new SocketException(z[1] + (String)object2 + ":" + n2 + z[3]);
        }
        if (proxy.type() == Proxy.Type.SOCKS) {
            this.inetSocketAddresses.add(InetSocketAddress.createUnresolved((String)object2, n2));
            return;
        }
        this.eventListener.dnsStart(this.call, (String)object2);
        object = this.address.dns().lookup((String)object2);
        if (object.isEmpty()) {
            throw new UnknownHostException(this.address.dns() + z[2] + (String)object2);
        }
        this.eventListener.dnsEnd(this.call, (String)object2, (List<InetAddress>)object);
        int n3 = object.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            object2 = (InetAddress)object.get(i2);
            this.inetSocketAddresses.add(new InetSocketAddress((InetAddress)object2, n2));
        }
    }

    static String getHostString(InetSocketAddress inetSocketAddress) {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            return inetSocketAddress.getHostName();
        }
        return inetAddress.getHostAddress();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u000bX2\u0004VQ\r$\b[TX'\u000eQH\u0001w\u001fQ^\u001e>\u001bKB\u0019#\u0015Q^\u000bm\\";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 48;
                                break;
                            }
                            case 1: {
                                n9 = 120;
                                break;
                            }
                            case 2: {
                                n9 = 87;
                                break;
                            }
                            case 3: {
                                n9 = 124;
                                break;
                            }
                            default: {
                                n9 = 62;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "~\u0017w\u000eQE\f2\\J_X";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0010\n2\bKB\u00162\u0018\u001e^\u0017w\u001dZT\n2\u000fMU\u000bw\u001aQBX";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u000bX'\u0013LDX>\u000f\u001e_\r#\\QVX%\u001dPW\u001d";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "`\n8\u0004G\u001e\u00193\u0018LU\u000b$T\u0017\u0010\u0011$\\P_\fw\u001dP\u001019\u0019Jc\u00174\u0017[D93\u0018LU\u000b$F\u001e";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    public static final class Selection {
        private final List<Route> routes;
        private int nextRouteIndex = 0;

        Selection(List<Route> list) {
            this.routes = list;
        }

        public final boolean hasNext() {
            return this.nextRouteIndex < this.routes.size();
        }

        public final Route next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.routes.get(this.nextRouteIndex++);
        }

        public final List<Route> getAll() {
            return new ArrayList<Route>(this.routes);
        }
    }
}

