/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.connection;

import cn.jmessage.support.okhttp3.Address;
import cn.jmessage.support.okhttp3.Call;
import cn.jmessage.support.okhttp3.Connection;
import cn.jmessage.support.okhttp3.ConnectionPool;
import cn.jmessage.support.okhttp3.EventListener;
import cn.jmessage.support.okhttp3.Interceptor;
import cn.jmessage.support.okhttp3.OkHttpClient;
import cn.jmessage.support.okhttp3.Route;
import cn.jmessage.support.okhttp3.internal.Internal;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.connection.RealConnection;
import cn.jmessage.support.okhttp3.internal.connection.RouteDatabase;
import cn.jmessage.support.okhttp3.internal.connection.RouteException;
import cn.jmessage.support.okhttp3.internal.connection.RouteSelector;
import cn.jmessage.support.okhttp3.internal.http.HttpCodec;
import cn.jmessage.support.okhttp3.internal.http2.ConnectionShutdownException;
import cn.jmessage.support.okhttp3.internal.http2.ErrorCode;
import cn.jmessage.support.okhttp3.internal.http2.StreamResetException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.Socket;

public final class StreamAllocation {
    public final Address address;
    private RouteSelector.Selection routeSelection;
    private Route route;
    private final ConnectionPool connectionPool;
    public final Call call;
    public final EventListener eventListener;
    private final Object callStackTrace;
    private final RouteSelector routeSelector;
    private int refusedStreamCount;
    private RealConnection connection;
    private boolean reportedAcquired;
    private boolean released;
    private boolean canceled;
    private HttpCodec codec;
    private static final String[] z;

    public StreamAllocation(ConnectionPool connectionPool, Address address, Call call, EventListener eventListener, Object object) {
        this.connectionPool = connectionPool;
        this.address = address;
        this.call = call;
        this.eventListener = eventListener;
        this.routeSelector = new RouteSelector(address, this.routeDatabase(), call, eventListener);
        this.callStackTrace = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpCodec newStream(OkHttpClient object, Interceptor.Chain object2, boolean bl) {
        int n2 = object2.connectTimeoutMillis();
        int n3 = object2.readTimeoutMillis();
        int n4 = object2.writeTimeoutMillis();
        int n5 = ((OkHttpClient)object).pingIntervalMillis();
        boolean bl2 = ((OkHttpClient)object).retryOnConnectionFailure();
        try {
            object = this.findHealthyConnection(n2, n3, n4, n5, bl2, bl).newCodec((OkHttpClient)object, (Interceptor.Chain)object2, this);
            object2 = this.connectionPool;
            synchronized (object2) {
                this.codec = object;
                return object;
            }
        }
        catch (IOException iOException) {
            throw new RouteException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findHealthyConnection(int n2, int n3, int n4, int n5, boolean bl, boolean bl2) throws IOException {
        RealConnection realConnection;
        while (true) {
            realConnection = this.findConnection(n2, n3, n4, n5, bl);
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                if (realConnection.successCount == 0) {
                    return realConnection;
                }
            }
            if (realConnection.isHealthy(bl2)) break;
            this.noNewStreams();
        }
        return realConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findConnection(int n2, int n3, int n4, int n5, boolean bl) throws IOException {
        Object object;
        Object object2;
        boolean bl2 = false;
        RealConnection realConnection = null;
        Route route = null;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (this.released) {
                throw new IllegalStateException(z[2]);
            }
            if (this.codec != null) {
                throw new IllegalStateException(z[3]);
            }
            if (this.canceled) {
                throw new IOException(z[4]);
            }
            object2 = this.connection;
            object = this.releaseIfNoNewStreams();
            if (this.connection != null) {
                realConnection = this.connection;
                object2 = null;
            }
            if (!this.reportedAcquired) {
                object2 = null;
            }
            if (realConnection == null) {
                Internal.instance.get(this.connectionPool, this.address, this, null);
                if (this.connection != null) {
                    bl2 = true;
                    realConnection = this.connection;
                } else {
                    route = this.route;
                }
            }
        }
        Util.closeQuietly((Socket)object);
        if (object2 != null) {
            this.eventListener.connectionReleased(this.call, (Connection)object2);
        }
        if (bl2) {
            this.eventListener.connectionAcquired(this.call, realConnection);
        }
        if (realConnection != null) {
            return realConnection;
        }
        int n6 = 0;
        if (!(route != null || this.routeSelection != null && this.routeSelection.hasNext())) {
            n6 = 1;
            this.routeSelection = this.routeSelector.next();
        }
        object2 = this.connectionPool;
        synchronized (object2) {
            if (this.canceled) {
                throw new IOException(z[4]);
            }
            if (n6 != 0) {
                object = this.routeSelection.getAll();
                int n7 = object.size();
                for (n6 = 0; n6 < n7; ++n6) {
                    Route route2 = (Route)object.get(n6);
                    Internal.instance.get(this.connectionPool, this.address, this, route2);
                    if (this.connection == null) continue;
                    bl2 = true;
                    realConnection = this.connection;
                    this.route = route2;
                    break;
                }
            }
            if (!bl2) {
                if (route == null) {
                    route = this.routeSelection.next();
                }
                this.route = route;
                this.refusedStreamCount = 0;
                realConnection = new RealConnection(this.connectionPool, route);
                this.acquire(realConnection, false);
            }
        }
        if (bl2) {
            this.eventListener.connectionAcquired(this.call, realConnection);
            return realConnection;
        }
        realConnection.connect(n2, n3, n4, n5, bl, this.call, this.eventListener);
        this.routeDatabase().connected(realConnection.route());
        object2 = null;
        object = this.connectionPool;
        synchronized (object) {
            this.reportedAcquired = true;
            Internal.instance.put(this.connectionPool, realConnection);
            if (realConnection.isMultiplexed()) {
                object2 = Internal.instance.deduplicate(this.connectionPool, this.address, this);
                realConnection = this.connection;
            }
        }
        Util.closeQuietly((Socket)object2);
        this.eventListener.connectionAcquired(this.call, realConnection);
        return realConnection;
    }

    private Socket releaseIfNoNewStreams() {
        assert (Thread.holdsLock(this.connectionPool));
        RealConnection realConnection = this.connection;
        if (realConnection != null && realConnection.noNewStreams) {
            return this.deallocate(false, false, true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void streamFinished(boolean bl, HttpCodec object, long l2, IOException iOException) {
        boolean bl2;
        Socket socket;
        this.eventListener.responseBodyEnd(this.call, l2);
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (object == null || object != this.codec) {
                throw new IllegalStateException(z[1] + this.codec + z[0] + object);
            }
            if (!bl) {
                ++this.connection.successCount;
            }
            object = this.connection;
            socket = this.deallocate(bl, false, true);
            if (this.connection != null) {
                object = null;
            }
            bl2 = this.released;
        }
        Util.closeQuietly(socket);
        if (object != null) {
            this.eventListener.connectionReleased(this.call, (Connection)object);
        }
        if (iOException != null) {
            this.eventListener.callFailed(this.call, iOException);
            return;
        }
        if (bl2) {
            this.eventListener.callEnd(this.call);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpCodec codec() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            return this.codec;
        }
    }

    private RouteDatabase routeDatabase() {
        return Internal.instance.routeDatabase(this.connectionPool);
    }

    public final Route route() {
        return this.route;
    }

    public final synchronized RealConnection connection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        Socket socket;
        RealConnection realConnection;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            realConnection = this.connection;
            socket = this.deallocate(false, true, false);
            if (this.connection != null) {
                realConnection = null;
            }
        }
        Util.closeQuietly(socket);
        if (realConnection != null) {
            this.eventListener.connectionReleased(this.call, realConnection);
            this.eventListener.callEnd(this.call);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void noNewStreams() {
        Socket socket;
        RealConnection realConnection;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            realConnection = this.connection;
            socket = this.deallocate(true, false, false);
            if (this.connection != null) {
                realConnection = null;
            }
        }
        Util.closeQuietly(socket);
        if (realConnection != null) {
            this.eventListener.connectionReleased(this.call, realConnection);
        }
    }

    private Socket deallocate(boolean bl, boolean bl2, boolean bl3) {
        assert (Thread.holdsLock(this.connectionPool));
        if (bl3) {
            this.codec = null;
        }
        if (bl2) {
            this.released = true;
        }
        Socket socket = null;
        if (this.connection != null) {
            if (bl) {
                this.connection.noNewStreams = true;
            }
            if (this.codec == null && (this.released || this.connection.noNewStreams)) {
                this.release(this.connection);
                if (this.connection.allocations.isEmpty()) {
                    this.connection.idleAtNanos = System.nanoTime();
                    if (Internal.instance.connectionBecameIdle(this.connectionPool, this.connection)) {
                        socket = this.connection.socket();
                    }
                }
                this.connection = null;
            }
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        RealConnection realConnection;
        HttpCodec httpCodec;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            this.canceled = true;
            httpCodec = this.codec;
            realConnection = this.connection;
        }
        if (httpCodec != null) {
            httpCodec.cancel();
            return;
        }
        if (realConnection != null) {
            realConnection.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void streamFailed(IOException object) {
        RealConnection realConnection;
        boolean bl = false;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            block13: {
                block14: {
                    block11: {
                        block12: {
                            if (!(object instanceof StreamResetException)) break block11;
                            object = ((StreamResetException)object).errorCode;
                            if (object != ErrorCode.REFUSED_STREAM) break block12;
                            ++this.refusedStreamCount;
                            if (this.refusedStreamCount <= 1) break block13;
                            bl = true;
                            break block14;
                        }
                        if (object != ErrorCode.CANCEL) {
                            bl = true;
                            this.route = null;
                        }
                        break block13;
                    }
                    if (this.connection == null || this.connection.isMultiplexed() && !(object instanceof ConnectionShutdownException)) break block13;
                    bl = true;
                    if (this.connection.successCount != 0) break block13;
                    if (this.route != null && object != null) {
                        this.routeSelector.connectFailed(this.route, (IOException)object);
                    }
                }
                this.route = null;
            }
            realConnection = this.connection;
            object = this.deallocate(bl, false, true);
            if (this.connection != null || !this.reportedAcquired) {
                realConnection = null;
            }
        }
        Util.closeQuietly((Socket)object);
        if (realConnection != null) {
            this.eventListener.connectionReleased(this.call, realConnection);
        }
    }

    public final void acquire(RealConnection realConnection, boolean bl) {
        assert (Thread.holdsLock(this.connectionPool));
        if (this.connection != null) {
            throw new IllegalStateException();
        }
        this.connection = realConnection;
        this.reportedAcquired = bl;
        realConnection.allocations.add(new StreamAllocationReference(this, this.callStackTrace));
    }

    private void release(RealConnection realConnection) {
        int n2 = realConnection.allocations.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (realConnection.allocations.get(i2).get() != this) continue;
            realConnection.allocations.remove(i2);
            return;
        }
        throw new IllegalStateException();
    }

    public final Socket releaseAndAcquire(RealConnection realConnection) {
        assert (Thread.holdsLock(this.connectionPool));
        if (this.codec != null || this.connection.allocations.size() != 1) {
            throw new IllegalStateException();
        }
        Reference<StreamAllocation> reference = this.connection.allocations.get(0);
        Socket socket = this.deallocate(true, false, false);
        this.connection = realConnection;
        realConnection.allocations.add(reference);
        return socket;
    }

    public final boolean hasMoreRoutes() {
        return this.route != null || this.routeSelection != null && this.routeSelection.hasNext() || this.routeSelector.hasNext();
    }

    public final String toString() {
        RealConnection realConnection = this.connection();
        if (realConnection != null) {
            return realConnection.toString();
        }
        return this.address.toString();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\\\t,m_\u000b\n*9";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 124;
                                break;
                            }
                            case 1: {
                                n9 = 107;
                                break;
                            }
                            case 2: {
                                n9 = 89;
                                break;
                            }
                            case 3: {
                                n9 = 25;
                                break;
                            }
                            default: {
                                n9 = 127;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0019\u0013)|\u001c\b\u000e=9";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u000e\u000e5|\u001e\u000f\u000e=";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u001f\u0004=|\u001c\\Jd9\u0011\t\u00075";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "?\n7z\u001a\u0010\u000e=";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    public static final class StreamAllocationReference
    extends WeakReference<StreamAllocation> {
        public final Object callStackTrace;

        StreamAllocationReference(StreamAllocation streamAllocation, Object object) {
            super(streamAllocation);
            this.callStackTrace = object;
        }
    }
}

