/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.http;

import cn.jmessage.support.okhttp3.Challenge;
import cn.jmessage.support.okhttp3.Cookie;
import cn.jmessage.support.okhttp3.CookieJar;
import cn.jmessage.support.okhttp3.Headers;
import cn.jmessage.support.okhttp3.HttpUrl;
import cn.jmessage.support.okhttp3.Request;
import cn.jmessage.support.okhttp3.Response;
import cn.jmessage.support.okhttp3.internal.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HttpHeaders {
    private static final String TOKEN;
    private static final String QUOTED_STRING;
    private static final Pattern PARAMETER;
    private static final String[] z;

    private HttpHeaders() {
    }

    public static long contentLength(Response response) {
        return HttpHeaders.contentLength(response.headers());
    }

    public static long contentLength(Headers headers) {
        return HttpHeaders.stringToLong(headers.get(z[0]));
    }

    private static long stringToLong(String string) {
        if (string == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static boolean varyMatches(Response object, Headers headers, Request request) {
        for (String string : HttpHeaders.varyFields((Response)object)) {
            if (Util.equal(headers.values(string), request.headers(string))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVaryAll(Response response) {
        return HttpHeaders.hasVaryAll(response.headers());
    }

    public static boolean hasVaryAll(Headers headers) {
        return HttpHeaders.varyFields(headers).contains("*");
    }

    private static Set<String> varyFields(Response response) {
        return HttpHeaders.varyFields(response.headers());
    }

    public static Set<String> varyFields(Headers headers) {
        Set<String> set = Collections.emptySet();
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!z[4].equalsIgnoreCase(headers.name(i2))) continue;
            String[] stringArray = headers.value(i2);
            if (set.isEmpty()) {
                set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            for (String string : stringArray.split(",")) {
                set.add(string.trim());
            }
        }
        return set;
    }

    public static Headers varyHeaders(Response object) {
        Headers headers = ((Response)object).networkResponse().request().headers();
        object = ((Response)object).headers();
        return HttpHeaders.varyHeaders(headers, (Headers)object);
    }

    public static Headers varyHeaders(Headers headers, Headers object) {
        if ((object = HttpHeaders.varyFields((Headers)object)).isEmpty()) {
            return new Headers.Builder().build();
        }
        Headers.Builder builder = new Headers.Builder();
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = headers.name(i2);
            if (!object.contains(string)) continue;
            builder.add(string, headers.value(i2));
        }
        return builder.build();
    }

    public static List<Challenge> parseChallenges(Headers object, String string2) {
        ArrayList<Challenge> arrayList = new ArrayList<Challenge>();
        for (String string2 : ((Headers)object).values(string2)) {
            int n2 = string2.indexOf(32);
            if (n2 == -1) continue;
            String string3 = string2.substring(0, n2);
            String string4 = null;
            String string5 = null;
            Matcher matcher = PARAMETER.matcher(string2);
            while (matcher.find(n2)) {
                if (string2.regionMatches(true, matcher.start(1), z[7], 0, 5)) {
                    string4 = matcher.group(3);
                } else if (string2.regionMatches(true, matcher.start(1), z[6], 0, 7)) {
                    string5 = matcher.group(3);
                }
                if (string4 != null && string5 != null) break;
                n2 = matcher.end();
            }
            if (string4 == null) continue;
            Challenge challenge = new Challenge(string3, string4);
            if (string5 != null) {
                if (!string5.equalsIgnoreCase(z[5])) continue;
                challenge = challenge.withCharset(Util.UTF_8);
            }
            arrayList.add(challenge);
        }
        return arrayList;
    }

    public static void receiveHeaders(CookieJar cookieJar, HttpUrl httpUrl, Headers object) {
        if (cookieJar == CookieJar.NO_COOKIES) {
            return;
        }
        if ((object = Cookie.parseAll(httpUrl, (Headers)object)).isEmpty()) {
            return;
        }
        cookieJar.saveFromResponse(httpUrl, (List<Cookie>)object);
    }

    public static boolean hasBody(Response response) {
        if (response.request().method().equals(z[3])) {
            return false;
        }
        int n2 = response.code();
        if ((n2 < 100 || n2 >= 200) && n2 != 204 && n2 != 304) {
            return true;
        }
        return HttpHeaders.contentLength(response) != -1L || z[2].equalsIgnoreCase(response.header(z[1]));
    }

    public static int skipUntil(String string, int n2, String string2) {
        while (n2 < string.length() && string2.indexOf(string.charAt(n2)) == -1) {
            ++n2;
        }
        return n2;
    }

    public static int skipWhitespace(String string, int n2) {
        char c2;
        while (n2 < string.length() && ((c2 = string.charAt(n2)) == ' ' || c2 == '\t')) {
            ++n2;
        }
        return n2;
    }

    public static int parseSeconds(String string, int n2) {
        long l2;
        block3: {
            try {
                l2 = Long.parseLong(string);
                if (l2 > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                if (l2 >= 0L) break block3;
                return 0;
            }
            catch (NumberFormatException numberFormatException) {
                return n2;
            }
        }
        return (int)l2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block33: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block32: {
                String string;
                String[] stringArray = new String[8];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n5 = 0;
                String string2 = "M&\\\u0007MX (\u000e";
                int n6 = 7;
                block23: while (true) {
                    char[] cArray3;
                    block31: {
                        int n7;
                        int n8;
                        char[] cArray4;
                        block30: {
                            char[] cArray5 = string2.toCharArray();
                            n4 = 0;
                            int n9 = cArray5.length;
                            cArray4 = cArray5;
                            n8 = n9;
                            if (n9 <= 1) break block30;
                            cArray3 = cArray4;
                            n7 = n8;
                            if (n8 <= n4) break block31;
                        }
                        do {
                            char[] cArray6 = cArray4;
                            char[] cArray7 = cArray4;
                            int n10 = n4;
                            while (true) {
                                int n11;
                                char c2 = cArray6[n10];
                                switch (n4 % 5) {
                                    case 0: {
                                        n11 = 101;
                                        break;
                                    }
                                    case 1: {
                                        n11 = 125;
                                        break;
                                    }
                                    case 2: {
                                        n11 = 2;
                                        break;
                                    }
                                    case 3: {
                                        n11 = 39;
                                        break;
                                    }
                                    default: {
                                        n11 = 111;
                                    }
                                }
                                cArray6[n10] = (char)(c2 ^ n11);
                                ++n4;
                                cArray4 = cArray7;
                                n8 = n8;
                                if (n8 != 0) break;
                                cArray7 = cArray4;
                                n7 = n8;
                                n10 = n8;
                                cArray6 = cArray4;
                            }
                            cArray3 = cArray4;
                            n7 = n8;
                        } while (n8 > n4);
                    }
                    string = new String(cArray3);
                    switch (n6) {
                        case 7: {
                            TOKEN = string.intern();
                            string2 = "GUYyM8W+\u0005";
                            n6 = 8;
                            continue block23;
                        }
                        case 8: {
                            QUOTED_STRING = string.intern();
                            string2 = "&\u0012lS\n\u000b\t/k\n\u000b\u001avO";
                            n6 = -1;
                            continue block23;
                        }
                        default: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 1;
                            string2 = "1\u000fcI\u001c\u0003\u0018p\n*\u000b\u001emC\u0006\u000b\u001a";
                            n6 = 0;
                            continue block23;
                        }
                        case 0: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 2;
                            string2 = "\u0006\u0015wI\u0004\u0000\u0019";
                            n6 = 1;
                            continue block23;
                        }
                        case 1: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 3;
                            string2 = "-8Cc";
                            n6 = 2;
                            continue block23;
                        }
                        case 2: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 4;
                            string2 = "3\u001cp^";
                            n6 = 3;
                            continue block23;
                        }
                        case 3: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 5;
                            string2 = "0)D\nW";
                            n6 = 4;
                            continue block23;
                        }
                        case 4: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 6;
                            string2 = "\u0006\u0015cU\u001c\u0000\t";
                            n6 = 5;
                            continue block23;
                        }
                        case 5: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 7;
                            string2 = "\u0017\u0018cK\u0002";
                            n6 = 6;
                            continue block23;
                        }
                        case 6: 
                    }
                    break;
                }
                stringArray2[n5] = string.intern();
                z = stringArray3;
                char[] cArray8 = "EV*|1E_?zEL@*\u001dPGUYyM8W+\u0005\u0013M&\\\u0007MX (\u000eFEW*\u001dPI\u0001&\u000e".toCharArray();
                n4 = 0;
                int n12 = cArray8.length;
                cArray2 = cArray8;
                n3 = n12;
                if (n12 <= 1) break block32;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block33;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n13 = n4;
                while (true) {
                    int n14;
                    char c3 = cArray9[n13];
                    switch (n4 % 5) {
                        case 0: {
                            n14 = 101;
                            break;
                        }
                        case 1: {
                            n14 = 125;
                            break;
                        }
                        case 2: {
                            n14 = 2;
                            break;
                        }
                        case 3: {
                            n14 = 39;
                            break;
                        }
                        default: {
                            n14 = 111;
                        }
                    }
                    cArray9[n13] = (char)(c3 ^ n14);
                    ++n4;
                    cArray2 = cArray10;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray10 = cArray2;
                    n2 = n3;
                    n13 = n3;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        PARAMETER = Pattern.compile(new String(cArray).intern());
    }
}

