/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.http;

import cn.jmessage.support.okhttp3.Address;
import cn.jmessage.support.okhttp3.Call;
import cn.jmessage.support.okhttp3.CertificatePinner;
import cn.jmessage.support.okhttp3.EventListener;
import cn.jmessage.support.okhttp3.HttpUrl;
import cn.jmessage.support.okhttp3.Interceptor;
import cn.jmessage.support.okhttp3.OkHttpClient;
import cn.jmessage.support.okhttp3.Request;
import cn.jmessage.support.okhttp3.RequestBody;
import cn.jmessage.support.okhttp3.Response;
import cn.jmessage.support.okhttp3.Route;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.connection.RouteException;
import cn.jmessage.support.okhttp3.internal.connection.StreamAllocation;
import cn.jmessage.support.okhttp3.internal.http.HttpMethod;
import cn.jmessage.support.okhttp3.internal.http.RealInterceptorChain;
import cn.jmessage.support.okhttp3.internal.http.UnrepeatableRequestBody;
import cn.jmessage.support.okhttp3.internal.http2.ConnectionShutdownException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpRetryException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public final class RetryAndFollowUpInterceptor
implements Interceptor {
    private static final int MAX_FOLLOW_UPS = 20;
    private final OkHttpClient client;
    private final boolean forWebSocket;
    private volatile StreamAllocation streamAllocation;
    private Object callStackTrace;
    private volatile boolean canceled;
    private static final String[] z;

    public RetryAndFollowUpInterceptor(OkHttpClient okHttpClient, boolean bl) {
        this.client = okHttpClient;
        this.forWebSocket = bl;
    }

    public final void cancel() {
        this.canceled = true;
        StreamAllocation streamAllocation = this.streamAllocation;
        if (streamAllocation != null) {
            streamAllocation.cancel();
        }
    }

    public final boolean isCanceled() {
        return this.canceled;
    }

    public final void setCallStackTrace(Object object) {
        this.callStackTrace = object;
    }

    public final StreamAllocation streamAllocation() {
        return this.streamAllocation;
    }

    @Override
    public final Response intercept(Interceptor.Chain chain) throws IOException {
        StreamAllocation streamAllocation;
        Object object = chain.request();
        chain = (RealInterceptorChain)chain;
        Call call = ((RealInterceptorChain)chain).call();
        EventListener eventListener = ((RealInterceptorChain)chain).eventListener();
        this.streamAllocation = streamAllocation = new StreamAllocation(this.client.connectionPool(), this.createAddress(((Request)object).url()), call, eventListener, this.callStackTrace);
        int n2 = 0;
        Response response = null;
        while (true) {
            Object object2;
            Response response2;
            if (this.canceled) {
                streamAllocation.release();
                throw new IOException(z[1]);
            }
            try {
                try {
                    response2 = ((RealInterceptorChain)chain).proceed((Request)object, streamAllocation, null, null);
                }
                catch (RouteException routeException) {
                    if (this.recover(routeException.getLastConnectException(), streamAllocation, false, (Request)object)) continue;
                    throw routeException.getFirstConnectException();
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    boolean bl = !(iOException instanceof ConnectionShutdownException);
                    if (this.recover((IOException)object2, streamAllocation, bl, (Request)object)) continue;
                    throw object2;
                }
            }
            catch (Throwable throwable) {
                streamAllocation.streamFailed(null);
                streamAllocation.release();
                throw throwable;
            }
            if (response != null) {
                response2 = response2.newBuilder().priorResponse(response.newBuilder().body(null).build()).build();
            }
            try {
                object2 = this.followUpRequest(response2, streamAllocation.route());
            }
            catch (IOException iOException) {
                streamAllocation.release();
                throw iOException;
            }
            if (object2 == null) {
                if (!this.forWebSocket) {
                    streamAllocation.release();
                }
                return response2;
            }
            Util.closeQuietly(response2.body());
            if (++n2 > 20) {
                streamAllocation.release();
                throw new ProtocolException(z[4] + n2);
            }
            if (((Request)object2).body() instanceof UnrepeatableRequestBody) {
                streamAllocation.release();
                throw new HttpRetryException(z[3], response2.code());
            }
            if (!this.sameConnection(response2, ((Request)object2).url())) {
                streamAllocation.release();
                this.streamAllocation = streamAllocation = new StreamAllocation(this.client.connectionPool(), this.createAddress(((Request)object2).url()), call, eventListener, this.callStackTrace);
            } else if (streamAllocation.codec() != null) {
                throw new IllegalStateException(z[2] + response2 + z[0]);
            }
            object = object2;
            response = response2;
        }
    }

    private Address createAddress(HttpUrl httpUrl) {
        SSLSocketFactory sSLSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (httpUrl.isHttps()) {
            sSLSocketFactory = this.client.sslSocketFactory();
            hostnameVerifier = this.client.hostnameVerifier();
            certificatePinner = this.client.certificatePinner();
        }
        return new Address(httpUrl.host(), httpUrl.port(), this.client.dns(), this.client.socketFactory(), sSLSocketFactory, hostnameVerifier, certificatePinner, this.client.proxyAuthenticator(), this.client.proxy(), this.client.protocols(), this.client.connectionSpecs(), this.client.proxySelector());
    }

    private boolean recover(IOException iOException, StreamAllocation streamAllocation, boolean bl, Request request) {
        streamAllocation.streamFailed(iOException);
        if (!this.client.retryOnConnectionFailure()) {
            return false;
        }
        if (bl && request.body() instanceof UnrepeatableRequestBody) {
            return false;
        }
        if (!this.isRecoverable(iOException, bl)) {
            return false;
        }
        return streamAllocation.hasMoreRoutes();
    }

    private boolean isRecoverable(IOException iOException, boolean bl) {
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return iOException instanceof SocketTimeoutException && !bl;
        }
        if (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        return !(iOException instanceof SSLPeerUnverifiedException);
    }

    private Request followUpRequest(Response response, Route object) throws IOException {
        if (response == null) {
            throw new IllegalStateException();
        }
        int n2 = response.code();
        String string = response.request().method();
        switch (n2) {
            case 407: {
                if ((object != null ? ((Route)object).proxy() : this.client.proxy()).type() != Proxy.Type.HTTP) {
                    throw new ProtocolException(z[14]);
                }
                return this.client.proxyAuthenticator().authenticate((Route)object, response);
            }
            case 401: {
                return this.client.authenticator().authenticate((Route)object, response);
            }
            case 307: 
            case 308: {
                if (!string.equals(z[7]) && !string.equals(z[13])) {
                    return null;
                }
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                if (!this.client.followRedirects()) {
                    return null;
                }
                object = response.header(z[9]);
                if (object == null) {
                    return null;
                }
                object = response.request().url().resolve((String)object);
                if (object == null) {
                    return null;
                }
                if (!((HttpUrl)object).scheme().equals(response.request().url().scheme()) && !this.client.followSslRedirects()) {
                    return null;
                }
                Request.Builder builder = response.request().newBuilder();
                if (HttpMethod.permitsRequestBody(string)) {
                    boolean bl = HttpMethod.redirectsWithBody(string);
                    if (HttpMethod.redirectsToGet(string)) {
                        builder.method(z[7], null);
                    } else {
                        RequestBody requestBody = bl ? response.request().body() : null;
                        builder.method(string, requestBody);
                    }
                    if (!bl) {
                        builder.removeHeader(z[12]);
                        builder.removeHeader(z[8]);
                        builder.removeHeader(z[10]);
                    }
                }
                if (!this.sameConnection(response, (HttpUrl)object)) {
                    builder.removeHeader(z[11]);
                }
                return builder.url((HttpUrl)object).build();
            }
            case 408: {
                if (!this.client.retryOnConnectionFailure()) {
                    return null;
                }
                if (response.request().body() instanceof UnrepeatableRequestBody) {
                    return null;
                }
                if (response.priorResponse() != null && response.priorResponse().code() == 408) {
                    return null;
                }
                if (this.retryAfter(response, 0) > 0) {
                    return null;
                }
                return response.request();
            }
            case 503: {
                if (response.priorResponse() != null && response.priorResponse().code() == 503) {
                    return null;
                }
                if (this.retryAfter(response, Integer.MAX_VALUE) == 0) {
                    return response.request();
                }
                return null;
            }
        }
        return null;
    }

    private int retryAfter(Response object, int n2) {
        if ((object = ((Response)object).header(z[6])) == null) {
            return n2;
        }
        if (((String)object).matches(z[5])) {
            return Integer.valueOf((String)object);
        }
        return Integer.MAX_VALUE;
    }

    private boolean sameConnection(Response object, HttpUrl httpUrl) {
        return ((HttpUrl)(object = ((Response)object).request().url())).host().equals(httpUrl.host()) && ((HttpUrl)object).port() == httpUrl.port() && ((HttpUrl)object).scheme().equals(httpUrl.scheme());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[15];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "}@\"I6zPkN42W.\r1)WkO9>O\"C?}W?_=<Ie\r\u001a<@kD6)A9N=-P$_g";
        int n3 = -1;
        block22: while (true) {
            char[] cArray;
            block27: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block26: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block26;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block27;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 93;
                                break;
                            }
                            case 1: {
                                n9 = 36;
                                break;
                            }
                            case 2: {
                                n9 = 75;
                                break;
                            }
                            case 3: {
                                n9 = 45;
                                break;
                            }
                            default: {
                                n9 = 88;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u001eE%N=1A/";
                    n3 = 0;
                    continue block22;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u001eH$^13CkY08\u0004)B<$\u0004$Kx";
                    n3 = 1;
                    continue block22;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u001eE%C7)\u00049H,/]k^,/A*@=9\u0004\u0003y\f\r\u0004)B<$";
                    n3 = 2;
                    continue block22;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\tK$\r5<J2\r>2H'B/pQ;\r*8U>H+)Wq\r";
                    n3 = 3;
                    continue block22;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0001@`";
                    n3 = 4;
                    continue block22;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u000fA?_!pe-Y=/";
                    n3 = 5;
                    continue block22;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u001aa\u001f";
                    n3 = 6;
                    continue block22;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u001eK%Y=3Pfa=3C?E";
                    n3 = 7;
                    continue block22;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0011K(L,4K%";
                    n3 = 8;
                    continue block22;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u001eK%Y=3Pfy!-A";
                    n3 = 9;
                    continue block22;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u001cQ?E7/M1L,4K%";
                    n3 = 10;
                    continue block22;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\tV*C+;A9\u0000\u001d3G$I13C";
                    n3 = 11;
                    continue block22;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u0015a\ni";
                    n3 = 12;
                    continue block22;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\u000fA(H1+A/\r\u0010\tp\u001br\b\u000fk\u0013t\u0007\u001cq\u001fexu\u0010{\u001aq}G$I=}S#D48\u0004%B,}Q8D6:\u0004;_7%]";
                    n3 = 13;
                    continue block22;
                }
                case 13: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

