/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.http2;

import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.http2.Header;
import cn.jmessage.support.okhttp3.internal.http2.Huffman;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.ByteString;
import cn.jmessage.support.okio.Okio;
import cn.jmessage.support.okio.Source;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class Hpack {
    private static final int PREFIX_4_BITS = 15;
    private static final int PREFIX_5_BITS = 31;
    private static final int PREFIX_6_BITS = 63;
    private static final int PREFIX_7_BITS = 127;
    static final Header[] STATIC_HEADER_TABLE;
    static final Map<ByteString, Integer> NAME_TO_FIRST_INDEX;
    private static final String[] z;

    private Hpack() {
    }

    private static Map<ByteString, Integer> nameToFirstIndex() {
        LinkedHashMap<ByteString, Integer> linkedHashMap = new LinkedHashMap<ByteString, Integer>(STATIC_HEADER_TABLE.length);
        for (int i2 = 0; i2 < STATIC_HEADER_TABLE.length; ++i2) {
            if (linkedHashMap.containsKey(Hpack.STATIC_HEADER_TABLE[i2].name)) continue;
            linkedHashMap.put(Hpack.STATIC_HEADER_TABLE[i2].name, i2);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    static ByteString checkLowercase(ByteString byteString) throws IOException {
        int n2 = byteString.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byteString.getByte(i2);
            if (by < 65 || by > 90) continue;
            throw new IOException(z[0] + byteString.utf8());
        }
        return byteString;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[61];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0004\u001a\rF@\u0017\u0007\u000eMJ\u0006\u001a\r@/&-1b`:;'2b5$$}}9-&(/9!:wkt+#ajt&#\u007fjnh";
        int n3 = -1;
        block68: while (true) {
            char[] cArray;
            block73: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block72: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block72;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block73;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 84;
                                break;
                            }
                            case 1: {
                                n9 = 72;
                                break;
                            }
                            case 2: {
                                n9 = 66;
                                break;
                            }
                            case 3: {
                                n9 = 18;
                                break;
                            }
                            default: {
                                n9 = 15;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "&-6`vy)$fj&";
                    n3 = 0;
                    continue block68;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "32+b#t,'tc5<'";
                    n3 = 1;
                    continue block68;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "{!,vj,f*fb8";
                    n3 = 2;
                    continue block68;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "fxr";
                    n3 = 3;
                    continue block68;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "5$.}x";
                    n3 = 4;
                    continue block68;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "0)6w";
                    n3 = 5;
                    continue block68;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "7',fj:<o~j:/6z";
                    n3 = 6;
                    continue block68;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "fxv";
                    n3 = 7;
                    continue block68;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "2:-\u007f";
                    n3 = 8;
                    continue block68;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\")0k";
                    n3 = 9;
                    continue block68;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "'<0{l e6`n:;2}} e1wl!:+fv";
                    n3 = 10;
                    continue block68;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "<'1f";
                    n3 = 11;
                    continue block68;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "7',fj:<o~`7)6{`:";
                    n3 = 12;
                    continue block68;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "&-$w}1:";
                    n3 = 13;
                    continue block68;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "5+!w\u007f e.sa3=#uj";
                    n3 = 14;
                    continue block68;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = " :#||2-0?j:+-vf:/";
                    n3 = 15;
                    continue block68;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "\u0013\r\u0016";
                    n3 = 16;
                    continue block68;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "`xv";
                    n3 = 17;
                    continue block68;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "5+!w\u007f ";
                    n3 = 18;
                    continue block68;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "5=6z`&!8s{=',";
                    n3 = 19;
                    continue block68;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "102wl ";
                    n3 = 20;
                    continue block68;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "`xr";
                    n3 = 21;
                    continue block68;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "&-$`j' ";
                    n3 = 22;
                    continue block68;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "5+!w\u007f e0sa3-1";
                    n3 = 23;
                    continue block68;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "5+!w|'e!}a :-~\"5$.}xy'0{h=&";
                    n3 = 24;
                    continue block68;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "=.o|`:-o\u007fn +*";
                    n3 = 25;
                    continue block68;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "8'!s{=',";
                    n3 = 26;
                    continue block68;
                }
                case 26: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 28;
                    string2 = "=.o`n:/'";
                    n3 = 27;
                    continue block68;
                }
                case 27: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 29;
                    string2 = "5/'";
                    n3 = 28;
                    continue block68;
                }
                case 28: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 30;
                    string2 = "\u0004\u0007\u0011F";
                    n3 = 29;
                    continue block68;
                }
                case 29: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 31;
                    string2 = "'-6?l;'){j";
                    n3 = 30;
                    continue block68;
                }
                case 30: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 32;
                    string2 = "=.o\u007fn +*";
                    n3 = 31;
                    continue block68;
                }
                case 31: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 33;
                    string2 = "=.o\u007f`0!${j0e1{a7-";
                    n3 = 32;
                    continue block68;
                }
                case 32: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 34;
                    string2 = "$:-jvy)7fg1&6{l5<'";
                    n3 = 33;
                    continue block68;
                }
                case 33: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 35;
                    string2 = "5+!w\u007f e'|l;,+|h";
                    n3 = 34;
                    continue block68;
                }
                case 34: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 36;
                    string2 = "1<#u";
                    n3 = 35;
                    continue block68;
                }
                case 35: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 37;
                    string2 = "<<6b";
                    n3 = 36;
                    continue block68;
                }
                case 36: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 38;
                    string2 = "7'-yf1";
                    n3 = 37;
                    continue block68;
                }
                case 37: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 39;
                    string2 = "7',fj:<owa7'&{a3";
                    n3 = 38;
                    continue block68;
                }
                case 38: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 40;
                    string2 = "7',fj:<o~n:/7sh1";
                    n3 = 39;
                    continue block68;
                }
                case 39: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 41;
                    string2 = "=.oga9'&{i=-&?|=&!w";
                    n3 = 40;
                    continue block68;
                }
                case 40: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 42;
                    string2 = "7)!zjy+-|{&'.";
                    n3 = 41;
                    continue block68;
                }
                case 41: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 43;
                    string2 = "&),uj";
                    n3 = 42;
                    continue block68;
                }
                case 42: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 44;
                    string2 = "$:-jvy)7fg;:+hn !-|";
                    n3 = 43;
                    continue block68;
                }
                case 43: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 45;
                    string2 = "fxt";
                    n3 = 44;
                    continue block68;
                }
                case 44: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 46;
                    string2 = "5+!w\u007f e!zn&;'f";
                    n3 = 45;
                    continue block68;
                }
                case 45: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 47;
                    string2 = "#?5?n!<*wa !!s{1";
                    n3 = 46;
                    continue block68;
                }
                case 46: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 48;
                    string2 = "!;'`\"5/'|{";
                    n3 = 47;
                    continue block68;
                }
                case 47: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 49;
                    string2 = "8!,y";
                    n3 = 48;
                    continue block68;
                }
                case 48: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 50;
                    string2 = "<<6b|";
                    n3 = 49;
                    continue block68;
                }
                case 49: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 51;
                    string2 = "7',fj:<ofv$-";
                    n3 = 50;
                    continue block68;
                }
                case 50: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 52;
                    string2 = "'-0dj&";
                    n3 = 51;
                    continue block68;
                }
                case 51: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 53;
                    string2 = "7',fj:<ovf'8-af !-|";
                    n3 = 52;
                    continue block68;
                }
                case 52: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 54;
                    string2 = "axr";
                    n3 = 53;
                    continue block68;
                }
                case 53: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 55;
                    string2 = "7',fj:<o`n:/'";
                    n3 = 54;
                    continue block68;
                }
                case 54: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 56;
                    string2 = "\"!#";
                    n3 = 55;
                    continue block68;
                }
                case 55: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 57;
                    string2 = "8)1f\"9'&{i=-&";
                    n3 = 56;
                    continue block68;
                }
                case 56: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 58;
                    string2 = "102{}1;";
                    n3 = 57;
                    continue block68;
                }
                case 57: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 59;
                    string2 = "9):?i;:5s}0;";
                    n3 = 58;
                    continue block68;
                }
                case 58: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 60;
                    string2 = "gxv";
                    n3 = 59;
                    continue block68;
                }
                case 59: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        STATIC_HEADER_TABLE = new Header[]{new Header(Header.TARGET_AUTHORITY, ""), new Header(Header.TARGET_METHOD, z[17]), new Header(Header.TARGET_METHOD, z[30]), new Header(Header.TARGET_PATH, "/"), new Header(Header.TARGET_PATH, z[3]), new Header(Header.TARGET_SCHEME, z[37]), new Header(Header.TARGET_SCHEME, z[50]), new Header(Header.RESPONSE_STATUS, z[4]), new Header(Header.RESPONSE_STATUS, z[8]), new Header(Header.RESPONSE_STATUS, z[45]), new Header(Header.RESPONSE_STATUS, z[60]), new Header(Header.RESPONSE_STATUS, z[22]), new Header(Header.RESPONSE_STATUS, z[18]), new Header(Header.RESPONSE_STATUS, z[54]), new Header(z[46], ""), new Header(z[35], z[2]), new Header(z[15], ""), new Header(z[24], ""), new Header(z[19], ""), new Header(z[25], ""), new Header(z[29], ""), new Header(z[5], ""), new Header(z[20], ""), new Header(z[42], ""), new Header(z[53], ""), new Header(z[39], ""), new Header(z[40], ""), new Header(z[7], ""), new Header(z[13], ""), new Header(z[55], ""), new Header(z[51], ""), new Header(z[38], ""), new Header(z[6], ""), new Header(z[36], ""), new Header(z[21], ""), new Header(z[58], ""), new Header(z[9], ""), new Header(z[12], ""), new Header(z[32], ""), new Header(z[33], ""), new Header(z[26], ""), new Header(z[28], ""), new Header(z[41], ""), new Header(z[57], ""), new Header(z[49], ""), new Header(z[27], ""), new Header(z[59], ""), new Header(z[34], ""), new Header(z[44], ""), new Header(z[43], ""), new Header(z[14], ""), new Header(z[23], ""), new Header(z[1], ""), new Header(z[52], ""), new Header(z[31], ""), new Header(z[11], ""), new Header(z[16], ""), new Header(z[48], ""), new Header(z[10], ""), new Header(z[56], ""), new Header(z[47], "")};
        NAME_TO_FIRST_INDEX = Hpack.nameToFirstIndex();
    }

    static final class Writer {
        private static final int SETTINGS_HEADER_TABLE_SIZE = 4096;
        private static final int SETTINGS_HEADER_TABLE_SIZE_LIMIT = 16384;
        private final Buffer out;
        private final boolean useCompression;
        private int smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
        private boolean emitDynamicTableSizeUpdate;
        int headerTableSizeSetting;
        int maxDynamicTableByteCount;
        Header[] dynamicTable = new Header[8];
        int nextHeaderIndex = this.dynamicTable.length - 1;
        int headerCount = 0;
        int dynamicTableByteCount = 0;

        Writer(Buffer buffer) {
            this(4096, true, buffer);
        }

        Writer(int n2, boolean bl, Buffer buffer) {
            this.headerTableSizeSetting = n2;
            this.maxDynamicTableByteCount = n2;
            this.useCompression = bl;
            this.out = buffer;
        }

        private void clearDynamicTable() {
            Arrays.fill(this.dynamicTable, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private int evictToRecoverBytes(int n2) {
            int n3 = 0;
            if (n2 > 0) {
                for (int i2 = this.dynamicTable.length - 1; i2 >= this.nextHeaderIndex && n2 > 0; --i2) {
                    n2 -= this.dynamicTable[i2].hpackSize;
                    this.dynamicTableByteCount -= this.dynamicTable[i2].hpackSize;
                    --this.headerCount;
                    ++n3;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + n3, this.headerCount);
                Arrays.fill(this.dynamicTable, this.nextHeaderIndex + 1, this.nextHeaderIndex + 1 + n3, null);
                this.nextHeaderIndex += n3;
            }
            return n3;
        }

        private void insertIntoDynamicTable(Header header) {
            int n2 = header.hpackSize;
            if (n2 > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int n3 = this.dynamicTableByteCount + n2 - this.maxDynamicTableByteCount;
            this.evictToRecoverBytes(n3);
            if (this.headerCount + 1 > this.dynamicTable.length) {
                Header[] headerArray = new Header[this.dynamicTable.length * 2];
                System.arraycopy(this.dynamicTable, 0, headerArray, this.dynamicTable.length, this.dynamicTable.length);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = headerArray;
            }
            n3 = this.nextHeaderIndex--;
            this.dynamicTable[n3] = header;
            ++this.headerCount;
            this.dynamicTableByteCount += n2;
        }

        final void writeHeaders(List<Header> list) throws IOException {
            if (this.emitDynamicTableSizeUpdate) {
                if (this.smallestHeaderTableSizeSetting < this.maxDynamicTableByteCount) {
                    this.writeInt(this.smallestHeaderTableSizeSetting, 31, 32);
                }
                this.emitDynamicTableSizeUpdate = false;
                this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
                this.writeInt(this.maxDynamicTableByteCount, 31, 32);
            }
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Header header = list.get(i2);
                ByteString byteString = header.name.toAsciiLowercase();
                ByteString byteString2 = header.value;
                int n3 = -1;
                int n4 = -1;
                Integer n5 = NAME_TO_FIRST_INDEX.get(byteString);
                if (n5 != null && (n4 = n5 + 1) > 1 && n4 < 8) {
                    if (Util.equal(Hpack.STATIC_HEADER_TABLE[n4 - 1].value, byteString2)) {
                        n3 = n4;
                    } else if (Util.equal(Hpack.STATIC_HEADER_TABLE[n4].value, byteString2)) {
                        n3 = n4 + 1;
                    }
                }
                if (n3 == -1) {
                    int n6 = this.dynamicTable.length;
                    for (int i3 = this.nextHeaderIndex + 1; i3 < n6; ++i3) {
                        if (!Util.equal(this.dynamicTable[i3].name, byteString)) continue;
                        if (Util.equal(this.dynamicTable[i3].value, byteString2)) {
                            n3 = i3 - this.nextHeaderIndex + STATIC_HEADER_TABLE.length;
                            break;
                        }
                        if (n4 != -1) continue;
                        n4 = i3 - this.nextHeaderIndex + STATIC_HEADER_TABLE.length;
                    }
                }
                if (n3 != -1) {
                    this.writeInt(n3, 127, 128);
                    continue;
                }
                if (n4 == -1) {
                    this.out.writeByte(64);
                    this.writeByteString(byteString);
                    this.writeByteString(byteString2);
                    this.insertIntoDynamicTable(header);
                    continue;
                }
                if (byteString.startsWith(Header.PSEUDO_PREFIX) && !Header.TARGET_AUTHORITY.equals(byteString)) {
                    this.writeInt(n4, 15, 0);
                    this.writeByteString(byteString2);
                    continue;
                }
                this.writeInt(n4, 63, 64);
                this.writeByteString(byteString2);
                this.insertIntoDynamicTable(header);
            }
        }

        final void writeInt(int n2, int n3, int n4) {
            if (n2 < n3) {
                this.out.writeByte(n4 | n2);
                return;
            }
            this.out.writeByte(n4 | n3);
            n2 -= n3;
            while (n2 >= 128) {
                n3 = n2 & 0x7F;
                this.out.writeByte(n3 | 0x80);
                n2 >>>= 7;
            }
            this.out.writeByte(n2);
        }

        final void writeByteString(ByteString byteString) throws IOException {
            if (this.useCompression && Huffman.get().encodedLength(byteString) < byteString.size()) {
                Buffer buffer = new Buffer();
                Huffman.get().encode(byteString, buffer);
                byteString = buffer.readByteString();
                this.writeInt(byteString.size(), 127, 128);
                this.out.write(byteString);
                return;
            }
            this.writeInt(byteString.size(), 127, 0);
            this.out.write(byteString);
        }

        final void setHeaderTableSizeSetting(int n2) {
            this.headerTableSizeSetting = n2;
            if (this.maxDynamicTableByteCount == (n2 = Math.min(n2, 16384))) {
                return;
            }
            if (n2 < this.maxDynamicTableByteCount) {
                this.smallestHeaderTableSizeSetting = Math.min(this.smallestHeaderTableSizeSetting, n2);
            }
            this.emitDynamicTableSizeUpdate = true;
            this.maxDynamicTableByteCount = n2;
            this.adjustDynamicTableByteCount();
        }

        private void adjustDynamicTableByteCount() {
            if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
                if (this.maxDynamicTableByteCount == 0) {
                    this.clearDynamicTable();
                    return;
                }
                this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
            }
        }
    }

    static final class Reader {
        private final List<Header> headerList = new ArrayList<Header>();
        private final BufferedSource source;
        private final int headerTableSizeSetting;
        private int maxDynamicTableByteCount;
        Header[] dynamicTable = new Header[8];
        int nextHeaderIndex = this.dynamicTable.length - 1;
        int headerCount = 0;
        int dynamicTableByteCount = 0;
        private static final String[] z;

        Reader(int n2, Source source) {
            this(n2, n2, source);
        }

        Reader(int n2, int n3, Source source) {
            this.headerTableSizeSetting = n2;
            this.maxDynamicTableByteCount = n3;
            this.source = Okio.buffer(source);
        }

        final int maxDynamicTableByteCount() {
            return this.maxDynamicTableByteCount;
        }

        private void adjustDynamicTableByteCount() {
            if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
                if (this.maxDynamicTableByteCount == 0) {
                    this.clearDynamicTable();
                    return;
                }
                this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
            }
        }

        private void clearDynamicTable() {
            Arrays.fill(this.dynamicTable, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private int evictToRecoverBytes(int n2) {
            int n3 = 0;
            if (n2 > 0) {
                for (int i2 = this.dynamicTable.length - 1; i2 >= this.nextHeaderIndex && n2 > 0; --i2) {
                    n2 -= this.dynamicTable[i2].hpackSize;
                    this.dynamicTableByteCount -= this.dynamicTable[i2].hpackSize;
                    --this.headerCount;
                    ++n3;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + n3, this.headerCount);
                this.nextHeaderIndex += n3;
            }
            return n3;
        }

        final void readHeaders() throws IOException {
            while (!this.source.exhausted()) {
                int n2 = this.source.readByte() & 0xFF;
                if (n2 == 128) {
                    throw new IOException(z[2]);
                }
                if ((n2 & 0x80) == 128) {
                    n2 = this.readInt(n2, 127);
                    this.readIndexedHeader(n2 - 1);
                    continue;
                }
                if (n2 == 64) {
                    this.readLiteralHeaderWithIncrementalIndexingNewName();
                    continue;
                }
                if ((n2 & 0x40) == 64) {
                    n2 = this.readInt(n2, 63);
                    this.readLiteralHeaderWithIncrementalIndexingIndexedName(n2 - 1);
                    continue;
                }
                if ((n2 & 0x20) == 32) {
                    this.maxDynamicTableByteCount = this.readInt(n2, 31);
                    if (this.maxDynamicTableByteCount < 0 || this.maxDynamicTableByteCount > this.headerTableSizeSetting) {
                        throw new IOException(z[1] + this.maxDynamicTableByteCount);
                    }
                    this.adjustDynamicTableByteCount();
                    continue;
                }
                if (n2 == 16 || n2 == 0) {
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                n2 = this.readInt(n2, 15);
                this.readLiteralHeaderWithoutIndexingIndexedName(n2 - 1);
            }
        }

        public final List<Header> getAndResetHeaderList() {
            ArrayList<Header> arrayList = new ArrayList<Header>(this.headerList);
            this.headerList.clear();
            return arrayList;
        }

        private void readIndexedHeader(int n2) throws IOException {
            if (this.isStaticHeader(n2)) {
                Header header = STATIC_HEADER_TABLE[n2];
                this.headerList.add(header);
                return;
            }
            int n3 = this.dynamicTableIndex(n2 - STATIC_HEADER_TABLE.length);
            if (n3 < 0 || n3 >= this.dynamicTable.length) {
                throw new IOException(z[0] + (n2 + 1));
            }
            this.headerList.add(this.dynamicTable[n3]);
        }

        private int dynamicTableIndex(int n2) {
            return this.nextHeaderIndex + 1 + n2;
        }

        private void readLiteralHeaderWithoutIndexingIndexedName(int n2) throws IOException {
            ByteString byteString = this.getName(n2);
            ByteString byteString2 = this.readByteString();
            this.headerList.add(new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            ByteString byteString = Hpack.checkLowercase(this.readByteString());
            ByteString byteString2 = this.readByteString();
            this.headerList.add(new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithIncrementalIndexingIndexedName(int n2) throws IOException {
            ByteString byteString = this.getName(n2);
            ByteString byteString2 = this.readByteString();
            this.insertIntoDynamicTable(-1, new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            ByteString byteString = Hpack.checkLowercase(this.readByteString());
            ByteString byteString2 = this.readByteString();
            this.insertIntoDynamicTable(-1, new Header(byteString, byteString2));
        }

        private ByteString getName(int n2) throws IOException {
            if (this.isStaticHeader(n2)) {
                return Hpack.STATIC_HEADER_TABLE[n2].name;
            }
            int n3 = this.dynamicTableIndex(n2 - STATIC_HEADER_TABLE.length);
            if (n3 < 0 || n3 >= this.dynamicTable.length) {
                throw new IOException(z[0] + (n2 + 1));
            }
            return this.dynamicTable[n3].name;
        }

        private boolean isStaticHeader(int n2) {
            return n2 >= 0 && n2 <= STATIC_HEADER_TABLE.length - 1;
        }

        private void insertIntoDynamicTable(int n2, Header header) {
            this.headerList.add(header);
            int n3 = header.hpackSize;
            if (n2 != -1) {
                n3 -= this.dynamicTable[this.dynamicTableIndex((int)n2)].hpackSize;
            }
            if (n3 > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int n4 = this.dynamicTableByteCount + n3 - this.maxDynamicTableByteCount;
            n4 = this.evictToRecoverBytes(n4);
            if (n2 == -1) {
                if (this.headerCount + 1 > this.dynamicTable.length) {
                    Header[] headerArray = new Header[this.dynamicTable.length * 2];
                    System.arraycopy(this.dynamicTable, 0, headerArray, this.dynamicTable.length, this.dynamicTable.length);
                    this.nextHeaderIndex = this.dynamicTable.length - 1;
                    this.dynamicTable = headerArray;
                }
                n2 = this.nextHeaderIndex--;
                this.dynamicTable[n2] = header;
                ++this.headerCount;
            } else {
                n2 += this.dynamicTableIndex(n2) + n4;
                this.dynamicTable[n2] = header;
            }
            this.dynamicTableByteCount += n3;
        }

        private int readByte() throws IOException {
            return this.source.readByte() & 0xFF;
        }

        final int readInt(int n2, int n3) throws IOException {
            int n4;
            if ((n2 &= n3) < n3) {
                return n2;
            }
            n2 = n3;
            n3 = 0;
            while (((n4 = this.readByte()) & 0x80) != 0) {
                n2 += (n4 & 0x7F) << n3;
                n3 += 7;
            }
            return n2 + (n4 << n3);
        }

        final ByteString readByteString() throws IOException {
            int n2 = this.readByte();
            boolean bl = (n2 & 0x80) == 128;
            n2 = this.readInt(n2, 127);
            if (bl) {
                return ByteString.of(Huffman.get().decode(this.source.readByteArray(n2)));
            }
            return this.source.readByteString(n2);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[3];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "6!\\\u00137\fdT\u00196\u001b<\u001d\u0003=\u0011dQ\u0016 \u0019!\u001d";
            int n3 = -1;
            block10: while (true) {
                char[] cArray;
                block15: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block14: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block14;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block15;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 126;
                                    break;
                                }
                                case 1: {
                                    n9 = 68;
                                    break;
                                }
                                case 2: {
                                    n9 = 61;
                                    break;
                                }
                                case 3: {
                                    n9 = 119;
                                    break;
                                }
                                default: {
                                    n9 = 82;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "7*K\u0016>\u0017 \u001d\u0013+\u0010%P\u001e1^0\\\u0015>\u001bdN\u001e(\u001bdH\u00076\u001f0XW";
                        n3 = 0;
                        continue block10;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "\u0017*Y\u0012*^y\u0000Wb";
                        n3 = 1;
                        continue block10;
                    }
                    case 1: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

