/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.http2;

import cn.jmessage.support.okhttp3.Protocol;
import cn.jmessage.support.okhttp3.internal.NamedRunnable;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.http2.ConnectionShutdownException;
import cn.jmessage.support.okhttp3.internal.http2.ErrorCode;
import cn.jmessage.support.okhttp3.internal.http2.Header;
import cn.jmessage.support.okhttp3.internal.http2.Http2Reader;
import cn.jmessage.support.okhttp3.internal.http2.Http2Stream;
import cn.jmessage.support.okhttp3.internal.http2.Http2Writer;
import cn.jmessage.support.okhttp3.internal.http2.PushObserver;
import cn.jmessage.support.okhttp3.internal.http2.Settings;
import cn.jmessage.support.okhttp3.internal.platform.Platform;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSink;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.ByteString;
import cn.jmessage.support.okio.Okio;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Http2Connection
implements Closeable {
    static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    private static final ExecutorService listenerExecutor;
    final boolean client;
    final Listener listener;
    final Map<Integer, Http2Stream> streams = new LinkedHashMap<Integer, Http2Stream>();
    final String hostname;
    int lastGoodStreamId;
    int nextStreamId;
    boolean shutdown;
    private final ScheduledExecutorService writerExecutor;
    private final ExecutorService pushExecutor;
    final PushObserver pushObserver;
    private boolean awaitingPong;
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    Settings okHttpSettings = new Settings();
    final Settings peerSettings = new Settings();
    boolean receivedInitialPeerSettings = false;
    final Socket socket;
    final Http2Writer writer;
    final ReaderRunnable readerRunnable;
    final Set<Integer> currentPushRequests = new LinkedHashSet<Integer>();
    private static final String[] z;

    Http2Connection(Builder builder) {
        this.pushObserver = builder.pushObserver;
        this.client = builder.client;
        this.listener = builder.listener;
        int n2 = this.nextStreamId = builder.client ? 1 : 2;
        if (builder.client) {
            this.nextStreamId += 2;
        }
        if (builder.client) {
            this.okHttpSettings.set(7, 0x1000000);
        }
        this.hostname = builder.hostname;
        this.writerExecutor = new ScheduledThreadPoolExecutor(1, Util.threadFactory(Util.format(z[2], this.hostname), false));
        if (builder.pingIntervalMillis != 0) {
            this.writerExecutor.scheduleAtFixedRate(new PingRunnable(false, 0, 0), builder.pingIntervalMillis, builder.pingIntervalMillis, TimeUnit.MILLISECONDS);
        }
        this.pushExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory(Util.format(z[1], this.hostname), true));
        this.peerSettings.set(7, 65535);
        this.peerSettings.set(5, 16384);
        this.bytesLeftInWriteWindow = this.peerSettings.getInitialWindowSize();
        this.socket = builder.socket;
        this.writer = new Http2Writer(builder.sink, this.client);
        this.readerRunnable = new ReaderRunnable(new Http2Reader(builder.source, this.client));
    }

    public final Protocol getProtocol() {
        return Protocol.HTTP_2;
    }

    public final synchronized int openStreamCount() {
        return this.streams.size();
    }

    final synchronized Http2Stream getStream(int n2) {
        return this.streams.get(n2);
    }

    final synchronized Http2Stream removeStream(int n2) {
        Http2Stream http2Stream = this.streams.remove(n2);
        this.notifyAll();
        return http2Stream;
    }

    public final synchronized int maxConcurrentStreams() {
        return this.peerSettings.getMaxConcurrentStreams(Integer.MAX_VALUE);
    }

    final synchronized void updateConnectionFlowControl(long l2) {
        this.unacknowledgedBytesRead += l2;
        if (this.unacknowledgedBytesRead >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            this.writeWindowUpdateLater(0, this.unacknowledgedBytesRead);
            this.unacknowledgedBytesRead = 0L;
        }
    }

    public final Http2Stream pushStream(int n2, List<Header> list, boolean bl) throws IOException {
        if (this.client) {
            throw new IllegalStateException(z[0]);
        }
        return this.newStream(n2, list, bl);
    }

    public final Http2Stream newStream(List<Header> list, boolean bl) throws IOException {
        return this.newStream(0, list, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Http2Stream newStream(int n2, List<Header> list, boolean bl) throws IOException {
        Http2Stream http2Stream;
        boolean bl2 = !bl;
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int n3;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.nextStreamId > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.REFUSED_STREAM);
                }
                if (this.shutdown) {
                    throw new ConnectionShutdownException();
                }
                n3 = this.nextStreamId;
                this.nextStreamId += 2;
                http2Stream = new Http2Stream(n3, this, bl2, false, list);
                boolean bl3 = bl = !bl || this.bytesLeftInWriteWindow == 0L || http2Stream.bytesLeftInWriteWindow == 0L;
                if (http2Stream.isOpen()) {
                    this.streams.put(n3, http2Stream);
                }
            }
            if (n2 == 0) {
                this.writer.synStream(bl2, n3, n2, list);
            } else {
                if (this.client) {
                    throw new IllegalArgumentException(z[3]);
                }
                this.writer.pushPromise(n2, n3, list);
            }
        }
        if (bl) {
            this.writer.flush();
        }
        return http2Stream;
    }

    final void writeSynReply(int n2, boolean bl, List<Header> list) throws IOException {
        this.writer.synReply(bl, n2, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeData(int n2, boolean bl, Buffer buffer, long l2) throws IOException {
        if (l2 == 0L) {
            this.writer.data(bl, n2, buffer, 0);
            return;
        }
        while (l2 > 0L) {
            int n3;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                try {
                    while (this.bytesLeftInWriteWindow <= 0L) {
                        if (!this.streams.containsKey(n2)) {
                            throw new IOException(z[10]);
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
                n3 = Math.min((int)Math.min(l2, this.bytesLeftInWriteWindow), this.writer.maxDataLength());
                this.bytesLeftInWriteWindow -= (long)n3;
            }
            this.writer.data(bl && (l2 -= (long)n3) == 0L, n2, buffer, n3);
        }
    }

    final void writeSynResetLater(final int n2, final ErrorCode errorCode) {
        try {
            this.writerExecutor.execute(new NamedRunnable(z[11], new Object[]{this.hostname, n2}){

                @Override
                public void execute() {
                    try {
                        Http2Connection.this.writeSynReset(n2, errorCode);
                        return;
                    }
                    catch (IOException iOException) {
                        Http2Connection.this.failConnection();
                        return;
                    }
                }
            });
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    final void writeSynReset(int n2, ErrorCode errorCode) throws IOException {
        this.writer.rstStream(n2, errorCode);
    }

    final void writeWindowUpdateLater(final int n2, final long l2) {
        try {
            this.writerExecutor.execute(new NamedRunnable(z[6], new Object[]{this.hostname, n2}){

                @Override
                public void execute() {
                    try {
                        Http2Connection.this.writer.windowUpdate(n2, l2);
                        return;
                    }
                    catch (IOException iOException) {
                        Http2Connection.this.failConnection();
                        return;
                    }
                }
            });
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void writePing(boolean bl, int n2, int n3) {
        if (!bl) {
            boolean bl2;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                bl2 = this.awaitingPong;
                this.awaitingPong = true;
            }
            if (bl2) {
                this.failConnection();
                return;
            }
        }
        try {
            this.writer.ping(bl, n2, n3);
            return;
        }
        catch (IOException iOException) {
            this.failConnection();
            return;
        }
    }

    final void writePingAndAwaitPong() throws InterruptedException {
        this.writePing(false, 1330343787, -257978967);
        this.awaitPong();
    }

    final synchronized void awaitPong() throws InterruptedException {
        while (this.awaitingPong) {
            this.wait();
        }
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(ErrorCode errorCode) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int n2;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                n2 = this.lastGoodStreamId;
            }
            this.writer.goAway(n2, errorCode, Util.EMPTY_BYTE_ARRAY);
            return;
        }
    }

    @Override
    public final void close() throws IOException {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close(ErrorCode http2StreamArray, ErrorCode errorCode) throws IOException {
        IOException iOException;
        block16: {
            assert (!Thread.holdsLock(this));
            iOException = null;
            try {
                this.shutdown((ErrorCode)http2StreamArray);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            http2StreamArray = null;
            Object object = this;
            synchronized (object) {
                if (!this.streams.isEmpty()) {
                    http2StreamArray = this.streams.values().toArray(new Http2Stream[this.streams.size()]);
                    this.streams.clear();
                }
            }
            if (http2StreamArray != null) {
                object = http2StreamArray;
                int n2 = http2StreamArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Http2Connection http2Connection = object[i2];
                    try {
                        ((Http2Stream)((Object)http2Connection)).close(errorCode);
                        continue;
                    }
                    catch (IOException iOException3) {
                        if (iOException == null) continue;
                        iOException = iOException3;
                    }
                }
            }
            try {
                this.writer.close();
            }
            catch (IOException iOException4) {
                if (iOException != null) break block16;
                iOException = iOException4;
            }
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException5) {
            // empty catch block
        }
        this.writerExecutor.shutdown();
        this.pushExecutor.shutdown();
        if (iOException != null) {
            throw iOException;
        }
    }

    private void failConnection() {
        try {
            this.close(ErrorCode.PROTOCOL_ERROR, ErrorCode.PROTOCOL_ERROR);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public final void start() throws IOException {
        this.start(true);
    }

    final void start(boolean n2) throws IOException {
        if (n2) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            n2 = this.okHttpSettings.getInitialWindowSize();
            if (n2 != 65535) {
                this.writer.windowUpdate(0, n2 - 65535);
            }
        }
        new Thread(this.readerRunnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSettings(Settings settings) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.shutdown) {
                    throw new ConnectionShutdownException();
                }
                this.okHttpSettings.merge(settings);
            }
            this.writer.settings(settings);
            return;
        }
    }

    public final synchronized boolean isShutdown() {
        return this.shutdown;
    }

    final boolean pushedStream(int n2) {
        return n2 != 0 && (n2 & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void pushRequestLater(final int n2, final List<Header> list) {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            if (this.currentPushRequests.contains(n2)) {
                this.writeSynResetLater(n2, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(n2);
        }
        try {
            this.pushExecutorExecute(new NamedRunnable(z[9], new Object[]{this.hostname, n2}){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute() {
                    boolean bl = Http2Connection.this.pushObserver.onRequest(n2, list);
                    try {
                        if (bl) {
                            Http2Connection.this.writer.rstStream(n2, ErrorCode.CANCEL);
                            Http2Connection http2Connection = Http2Connection.this;
                            synchronized (http2Connection) {
                                Http2Connection.this.currentPushRequests.remove(n2);
                                return;
                            }
                        }
                        return;
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            });
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    final void pushHeadersLater(final int n2, final List<Header> list, final boolean bl) {
        try {
            this.pushExecutorExecute(new NamedRunnable(z[8], new Object[]{this.hostname, n2}){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute() {
                    boolean bl2 = Http2Connection.this.pushObserver.onHeaders(n2, list, bl);
                    try {
                        if (bl2) {
                            Http2Connection.this.writer.rstStream(n2, ErrorCode.CANCEL);
                        }
                        if (bl2 || bl) {
                            Http2Connection http2Connection = Http2Connection.this;
                            synchronized (http2Connection) {
                                Http2Connection.this.currentPushRequests.remove(n2);
                                return;
                            }
                        }
                        return;
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            });
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    final void pushDataLater(final int n2, BufferedSource bufferedSource, final int n3, final boolean bl) throws IOException {
        final Buffer buffer = new Buffer();
        bufferedSource.require(n3);
        bufferedSource.read(buffer, n3);
        if (buffer.size() != (long)n3) {
            throw new IOException(buffer.size() + z[5] + n3);
        }
        this.pushExecutorExecute(new NamedRunnable(z[4], new Object[]{this.hostname, n2}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                try {
                    boolean bl2 = Http2Connection.this.pushObserver.onData(n2, buffer, n3, bl);
                    if (bl2) {
                        Http2Connection.this.writer.rstStream(n2, ErrorCode.CANCEL);
                    }
                    if (bl2 || bl) {
                        Http2Connection http2Connection = Http2Connection.this;
                        synchronized (http2Connection) {
                            Http2Connection.this.currentPushRequests.remove(n2);
                            return;
                        }
                    }
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
        });
    }

    final void pushResetLater(final int n2, final ErrorCode errorCode) {
        this.pushExecutorExecute(new NamedRunnable(z[7], new Object[]{this.hostname, n2}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                Http2Connection.this.pushObserver.onReset(n2, errorCode);
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.currentPushRequests.remove(n2);
                    return;
                }
            }
        });
    }

    private synchronized void pushExecutorExecute(NamedRunnable namedRunnable) {
        if (!this.isShutdown()) {
            this.pushExecutor.execute(namedRunnable);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[13];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "*2e\fa\u001d~o\ba\u00071xI\u007f\u001c-dI}\f/y\f|\u001d-\"";
        int n3 = -1;
        block20: while (true) {
            char[] cArray;
            block25: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block24: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block24;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block25;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 105;
                                break;
                            }
                            case 1: {
                                n9 = 94;
                                break;
                            }
                            case 2: {
                                n9 = 12;
                                break;
                            }
                            case 3: {
                                n9 = 105;
                                break;
                            }
                            default: {
                                n9 = 15;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "&5D\u001d{\u0019~)\u001a/9+\u007f\u0001/&<\u007f\f}\u001f;~";
                    n3 = 0;
                    continue block20;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "&5D\u001d{\u0019~)\u001a/>,e\u001dj\u001b";
                    n3 = 1;
                    continue block20;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\n2e\fa\u001d~\u007f\u001d}\f?a\u001a/\u001a6c\u001cc\r0+\u001d/\u0001?z\f/\b-\u007f\u0006l\u0000?x\fkI-x\u001bj\b3, K\u001a";
                    n3 = 2;
                    continue block20;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "&5D\u001d{\u0019~)\u001a/9+\u007f\u0001/-?x\bTL-Q";
                    n3 = 3;
                    continue block20;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "I\u007f1I";
                    n3 = 4;
                    continue block20;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "&5D\u001d{\u0019~[\u0000a\r1{IZ\u0019:m\u001djI{\u007fI|\u001d,i\bbI{h";
                    n3 = 5;
                    continue block20;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "&5D\u001d{\u0019~)\u001a/9+\u007f\u0001/;;\u007f\f{2{\u007f4";
                    n3 = 6;
                    continue block20;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "&5D\u001d{\u0019~)\u001a/9+\u007f\u0001/!;m\rj\u001b-WL|4";
                    n3 = 7;
                    continue block20;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "&5D\u001d{\u0019~)\u001a/9+\u007f\u0001/;;}\u001cj\u001a*WL|4";
                    n3 = 8;
                    continue block20;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u001a*~\fn\u0004~o\u0005`\u001a;h";
                    n3 = 9;
                    continue block20;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "&5D\u001d{\u0019~)\u001a/\u001a*~\fn\u0004~)\r";
                    n3 = 10;
                    continue block20;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "&5D\u001d{\u0019~D\u001d{\u0019lO\u0006a\u0007;o\u001df\u00060";
                    n3 = 11;
                    continue block20;
                }
                case 11: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        listenerExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory(z[12], true));
    }

    public static abstract class Listener {
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            @Override
            public final void onStream(Http2Stream http2Stream) throws IOException {
                http2Stream.close(ErrorCode.REFUSED_STREAM);
            }
        };

        public abstract void onStream(Http2Stream var1) throws IOException;

        public void onSettings(Http2Connection http2Connection) {
        }
    }

    class ReaderRunnable
    extends NamedRunnable
    implements Http2Reader.Handler {
        final Http2Reader reader;
        private static final String[] z;

        ReaderRunnable(Http2Reader http2Reader) {
            super(z[2], Http2Connection.this.hostname);
            this.reader = http2Reader;
        }

        /*
         * Loose catch block
         */
        @Override
        protected void execute() {
            ErrorCode errorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode errorCode2 = ErrorCode.INTERNAL_ERROR;
            this.reader.readConnectionPreface(this);
            while (this.reader.nextFrame(false, this)) {
            }
            errorCode = ErrorCode.NO_ERROR;
            errorCode2 = ErrorCode.CANCEL;
            try {
                Http2Connection.this.close(errorCode, errorCode2);
            }
            catch (IOException iOException) {}
            Util.closeQuietly(this.reader);
            return;
            catch (IOException iOException) {
                try {
                    errorCode = ErrorCode.PROTOCOL_ERROR;
                    errorCode2 = ErrorCode.PROTOCOL_ERROR;
                }
                catch (Throwable throwable) {
                    try {
                        Http2Connection.this.close(errorCode, errorCode2);
                    }
                    catch (IOException iOException2) {}
                    Util.closeQuietly(this.reader);
                    throw throwable;
                }
                try {
                    Http2Connection.this.close(errorCode, errorCode2);
                }
                catch (IOException iOException3) {}
                Util.closeQuietly(this.reader);
                return;
            }
        }

        @Override
        public void data(boolean bl, int n2, BufferedSource bufferedSource, int n3) throws IOException {
            if (Http2Connection.this.pushedStream(n2)) {
                Http2Connection.this.pushDataLater(n2, bufferedSource, n3, bl);
                return;
            }
            Http2Stream http2Stream = Http2Connection.this.getStream(n2);
            if (http2Stream == null) {
                Http2Connection.this.writeSynResetLater(n2, ErrorCode.PROTOCOL_ERROR);
                Http2Connection.this.updateConnectionFlowControl(n3);
                bufferedSource.skip(n3);
                return;
            }
            http2Stream.receiveData(bufferedSource, n3);
            if (bl) {
                http2Stream.receiveFin();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean bl, int n2, int n3, List<Header> list) {
            Http2Stream http2Stream;
            if (Http2Connection.this.pushedStream(n2)) {
                Http2Connection.this.pushHeadersLater(n2, list, bl);
                return;
            }
            Http2Connection http2Connection = Http2Connection.this;
            synchronized (http2Connection) {
                http2Stream = Http2Connection.this.getStream(n2);
                if (http2Stream == null) {
                    if (Http2Connection.this.shutdown) {
                        return;
                    }
                    if (n2 <= Http2Connection.this.lastGoodStreamId) {
                        return;
                    }
                    if (n2 % 2 == Http2Connection.this.nextStreamId % 2) {
                        return;
                    }
                    final Http2Stream http2Stream2 = new Http2Stream(n2, Http2Connection.this, false, bl, list);
                    Http2Connection.this.lastGoodStreamId = n2;
                    Http2Connection.this.streams.put(n2, http2Stream2);
                    listenerExecutor.execute(new NamedRunnable(z[0], new Object[]{Http2Connection.this.hostname, n2}){
                        private static final String z;

                        @Override
                        public void execute() {
                            try {
                                Http2Connection.this.listener.onStream(http2Stream2);
                                return;
                            }
                            catch (IOException iOException) {
                                Platform.get().log(4, z + Http2Connection.this.hostname, iOException);
                                try {
                                    http2Stream2.close(ErrorCode.PROTOCOL_ERROR);
                                    return;
                                }
                                catch (IOException iOException2) {
                                    return;
                                }
                            }
                        }

                        /*
                         * Handled impossible loop by duplicating code
                         * Enabled aggressive block sorting
                         */
                        static {
                            char[] cArray;
                            block10: {
                                int n2;
                                int n3;
                                char[] cArray2;
                                int n4;
                                block9: {
                                    char[] cArray3 = "Y<sXzR'iF-r<nG&?\u0004n[<t&bZhw)nD=c-'N'ch".toCharArray();
                                    n4 = 0;
                                    int n5 = cArray3.length;
                                    cArray2 = cArray3;
                                    n3 = n5;
                                    if (n5 <= 1) break block9;
                                    cArray = cArray2;
                                    n2 = n3;
                                    if (n3 <= n4) break block10;
                                }
                                do {
                                    char[] cArray4 = cArray2;
                                    char[] cArray5 = cArray2;
                                    int n6 = n4;
                                    while (true) {
                                        int n7;
                                        char c2 = cArray4[n6];
                                        switch (n4 % 5) {
                                            case 0: {
                                                n7 = 17;
                                                break;
                                            }
                                            case 1: {
                                                n7 = 72;
                                                break;
                                            }
                                            case 2: {
                                                n7 = 7;
                                                break;
                                            }
                                            case 3: {
                                                n7 = 40;
                                                break;
                                            }
                                            default: {
                                                n7 = 72;
                                            }
                                        }
                                        cArray4[n6] = (char)(c2 ^ n7);
                                        ++n4;
                                        cArray2 = cArray5;
                                        n3 = n3;
                                        if (n3 != 0) break;
                                        cArray5 = cArray2;
                                        n2 = n3;
                                        n6 = n3;
                                        cArray4 = cArray2;
                                    }
                                    cArray = cArray2;
                                    n2 = n3;
                                } while (n3 > n4);
                            }
                            z = new String(cArray).intern();
                        }
                    });
                    return;
                }
            }
            http2Stream.receiveHeaders(list);
            if (bl) {
                http2Stream.receiveFin();
            }
        }

        @Override
        public void rstStream(int n2, ErrorCode errorCode) {
            if (Http2Connection.this.pushedStream(n2)) {
                Http2Connection.this.pushResetLater(n2, errorCode);
                return;
            }
            Http2Stream http2Stream = Http2Connection.this.removeStream(n2);
            if (http2Stream != null) {
                http2Stream.receiveRstStream(errorCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void settings(boolean n2, Settings object) {
            Http2Stream http2Stream;
            long l2 = 0L;
            Object object2 = null;
            Http2Stream[] http2StreamArray = Http2Connection.this;
            // MONITORENTER : Http2Connection.this
            int n3 = Http2Connection.this.peerSettings.getInitialWindowSize();
            if (n2 != 0) {
                Http2Connection.this.peerSettings.clear();
            }
            Http2Connection.this.peerSettings.merge((Settings)((Object)http2Stream));
            this.applyAndAckSettings((Settings)((Object)http2Stream));
            n2 = Http2Connection.this.peerSettings.getInitialWindowSize();
            if (n2 != -1 && n2 != n3) {
                l2 = n2 - n3;
                if (!Http2Connection.this.receivedInitialPeerSettings) {
                    Http2Connection.this.receivedInitialPeerSettings = true;
                }
                if (!Http2Connection.this.streams.isEmpty()) {
                    object2 = Http2Connection.this.streams.values().toArray(new Http2Stream[Http2Connection.this.streams.size()]);
                }
            }
            listenerExecutor.execute(new NamedRunnable(z[3], new Object[]{Http2Connection.this.hostname}){

                @Override
                public void execute() {
                    Http2Connection.this.listener.onSettings(Http2Connection.this);
                }
            });
            // MONITOREXIT : http2StreamArray
            if (object2 == null) return;
            if (l2 == 0L) return;
            http2StreamArray = object2;
            n3 = ((Http2Stream[])object2).length;
            n2 = 0;
            while (n2 < n3) {
                http2Stream = http2StreamArray[n2];
                object2 = http2Stream;
                // MONITORENTER : http2Stream
                http2Stream.addBytesToWriteWindow(l2);
                // MONITOREXIT : object2
                ++n2;
            }
        }

        private void applyAndAckSettings(final Settings settings) {
            try {
                Http2Connection.this.writerExecutor.execute(new NamedRunnable(z[1], new Object[]{Http2Connection.this.hostname}){

                    @Override
                    public void execute() {
                        try {
                            Http2Connection.this.writer.applyAndAckSettings(settings);
                            return;
                        }
                        catch (IOException iOException) {
                            Http2Connection.this.failConnection();
                            return;
                        }
                    }
                });
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                return;
            }
        }

        @Override
        public void ackSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ping(boolean bl, int n2, int n3) {
            if (bl) {
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.awaitingPong = false;
                    Http2Connection.this.notifyAll();
                    return;
                }
            }
            try {
                Http2Connection.this.writerExecutor.execute(new PingRunnable(true, n2, n3));
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int n2, ErrorCode http2StreamArray, ByteString http2StreamArray2) {
            http2StreamArray2.size();
            http2StreamArray2 = Http2Connection.this;
            synchronized (http2StreamArray2) {
                http2StreamArray = Http2Connection.this.streams.values().toArray(new Http2Stream[Http2Connection.this.streams.size()]);
                Http2Connection.this.shutdown = true;
            }
            http2StreamArray2 = http2StreamArray;
            int n3 = http2StreamArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Http2Stream http2Stream = http2StreamArray2[i2];
                if (http2Stream.getId() <= n2 || !http2Stream.isLocallyInitiated()) continue;
                http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                Http2Connection.this.removeStream(http2Stream.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int n2, long l2) {
            if (n2 == 0) {
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.bytesLeftInWriteWindow += l2;
                    Http2Connection.this.notifyAll();
                    return;
                }
            }
            Http2Stream http2Stream = Http2Connection.this.getStream(n2);
            if (http2Stream != null) {
                Http2Stream http2Stream2 = http2Stream;
                synchronized (http2Stream2) {
                    http2Stream.addBytesToWriteWindow(l2);
                    return;
                }
            }
        }

        @Override
        public void priority(int n2, int n3, int n4, boolean bl) {
        }

        @Override
        public void pushPromise(int n2, int n3, List<Header> list) {
            Http2Connection.this.pushRequestLater(n3, list);
        }

        @Override
        public void alternateService(int n2, String string, ByteString byteString, String string2, int n3, long l2) {
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[4];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "\u0001A\u00152u>\nx5!=^/#`#\nx\"";
            int n3 = -1;
            block11: while (true) {
                char[] cArray;
                block16: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block15: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block15;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block16;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 78;
                                    break;
                                }
                                case 1: {
                                    n9 = 42;
                                    break;
                                }
                                case 2: {
                                    n9 = 93;
                                    break;
                                }
                                case 3: {
                                    n9 = 70;
                                    break;
                                }
                                default: {
                                    n9 = 1;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "\u0001A\u00152u>\nx5!\u000fi\u0016fR+^)/o)Y";
                        n3 = 0;
                        continue block11;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "\u0001A\u00152u>\nx5";
                        n3 = 1;
                        continue block11;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "\u0001A\u00152u>\nx5!=O)2h M.";
                        n3 = 2;
                        continue block11;
                    }
                    case 2: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }

    public static class Builder {
        Socket socket;
        String hostname;
        BufferedSource source;
        BufferedSink sink;
        Listener listener = Listener.REFUSE_INCOMING_STREAMS;
        PushObserver pushObserver = PushObserver.CANCEL;
        boolean client;
        int pingIntervalMillis;

        public Builder(boolean bl) {
            this.client = bl;
        }

        public Builder socket(Socket socket) throws IOException {
            return this.socket(socket, ((InetSocketAddress)socket.getRemoteSocketAddress()).getHostName(), Okio.buffer(Okio.source(socket)), Okio.buffer(Okio.sink(socket)));
        }

        public Builder socket(Socket socket, String string, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.socket = socket;
            this.hostname = string;
            this.source = bufferedSource;
            this.sink = bufferedSink;
            return this;
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder pushObserver(PushObserver pushObserver) {
            this.pushObserver = pushObserver;
            return this;
        }

        public Builder pingIntervalMillis(int n2) {
            this.pingIntervalMillis = n2;
            return this;
        }

        public Http2Connection build() {
            return new Http2Connection(this);
        }
    }

    final class PingRunnable
    extends NamedRunnable {
        final boolean reply;
        final int payload1;
        final int payload2;
        private static final String z;

        PingRunnable(boolean bl, int n2, int n3) {
            super(z, Http2Connection.this.hostname, n2, n3);
            this.reply = bl;
            this.payload1 = n2;
            this.payload2 = n3;
        }

        @Override
        public final void execute() {
            Http2Connection.this.writePing(this.reply, this.payload1, this.payload2);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "}^\u0014bZB\u0015ye\u000eB\\2q\u000e\u0017\u0005dn\u000b\u0002\r$".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 50;
                                break;
                            }
                            case 1: {
                                n7 = 53;
                                break;
                            }
                            case 2: {
                                n7 = 92;
                                break;
                            }
                            case 3: {
                                n7 = 22;
                                break;
                            }
                            default: {
                                n7 = 46;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }
}

