/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.http2;

import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.http2.ErrorCode;
import cn.jmessage.support.okhttp3.internal.http2.Header;
import cn.jmessage.support.okhttp3.internal.http2.Hpack;
import cn.jmessage.support.okhttp3.internal.http2.Http2;
import cn.jmessage.support.okhttp3.internal.http2.Settings;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.ByteString;
import cn.jmessage.support.okio.Source;
import cn.jmessage.support.okio.Timeout;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Http2Reader
implements Closeable {
    static final Logger logger;
    private final BufferedSource source;
    private final ContinuationSource continuation;
    private final boolean client;
    final Hpack.Reader hpackReader;
    private static final String[] z;

    Http2Reader(BufferedSource bufferedSource, boolean bl) {
        this.source = bufferedSource;
        this.client = bl;
        this.continuation = new ContinuationSource(this.source);
        this.hpackReader = new Hpack.Reader(4096, this.continuation);
    }

    public final void readConnectionPreface(Handler object) throws IOException {
        if (this.client) {
            if (!this.nextFrame(true, (Handler)object)) {
                throw Http2.ioException(z[19], new Object[0]);
            }
        } else {
            object = this.source.readByteString(Http2.CONNECTION_PREFACE.size());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Util.format(z[18], ((ByteString)object).hex()));
            }
            if (!Http2.CONNECTION_PREFACE.equals(object)) {
                throw Http2.ioException(z[17], ((ByteString)object).utf8());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean nextFrame(boolean bl, Handler handler) throws IOException {
        try {
            this.source.require(9L);
        }
        catch (IOException iOException) {
            return false;
        }
        int n2 = Http2Reader.readMedium(this.source);
        if (n2 < 0 || n2 > 16384) {
            throw Http2.ioException(z[27], n2);
        }
        byte by = (byte)(this.source.readByte() & 0xFF);
        if (bl && by != 4) {
            throw Http2.ioException(z[26], by);
        }
        byte by2 = (byte)(this.source.readByte() & 0xFF);
        int n3 = this.source.readInt() & Integer.MAX_VALUE;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.frameLog(true, n3, n2, by, by2));
        }
        switch (by) {
            case 0: {
                void var2_3;
                this.readData((Handler)var2_3, n2, by2, n3);
                break;
            }
            case 1: {
                void var2_3;
                this.readHeaders((Handler)var2_3, n2, by2, n3);
                break;
            }
            case 2: {
                void var2_3;
                this.readPriority((Handler)var2_3, n2, by2, n3);
                break;
            }
            case 3: {
                void var2_3;
                this.readRstStream((Handler)var2_3, n2, by2, n3);
                break;
            }
            case 4: {
                void var2_3;
                this.readSettings((Handler)var2_3, n2, by2, n3);
                break;
            }
            case 5: {
                void var2_3;
                this.readPushPromise((Handler)var2_3, n2, by2, n3);
                break;
            }
            case 6: {
                void var2_3;
                this.readPing((Handler)var2_3, n2, by2, n3);
                break;
            }
            case 7: {
                void var2_3;
                this.readGoAway((Handler)var2_3, n2, by2, n3);
                break;
            }
            case 8: {
                void var2_3;
                this.readWindowUpdate((Handler)var2_3, n2, by2, n3);
                break;
            }
            default: {
                this.source.skip(n2);
            }
        }
        return true;
    }

    private void readHeaders(Handler handler, int n2, byte by, int n3) throws IOException {
        short s2;
        if (n3 == 0) {
            throw Http2.ioException(z[25], new Object[0]);
        }
        boolean bl = (by & 1) != 0;
        short s3 = s2 = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        if ((by & 0x20) != 0) {
            this.readPriority(handler, n3);
            n2 -= 5;
        }
        n2 = Http2Reader.lengthWithoutPadding(n2, by, s2);
        List<Header> list = this.readHeaderBlock(n2, s2, by, n3);
        handler.headers(bl, n3, -1, list);
    }

    private List<Header> readHeaderBlock(int n2, short s2, byte by, int n3) throws IOException {
        this.continuation.length = this.continuation.left = n2;
        this.continuation.padding = s2;
        this.continuation.flags = by;
        this.continuation.streamId = n3;
        this.hpackReader.readHeaders();
        return this.hpackReader.getAndResetHeaderList();
    }

    private void readData(Handler handler, int n2, byte by, int n3) throws IOException {
        if (n3 == 0) {
            throw Http2.ioException(z[9], new Object[0]);
        }
        boolean bl = (by & 1) != 0;
        if ((by & 0x20) != 0) {
            throw Http2.ioException(z[10], new Object[0]);
        }
        short s2 = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        n2 = Http2Reader.lengthWithoutPadding(n2, by, s2);
        handler.data(bl, n3, this.source, n2);
        this.source.skip(s2);
    }

    private void readPriority(Handler handler, int n2, byte by, int n3) throws IOException {
        if (n2 != 5) {
            throw Http2.ioException(z[11], n2);
        }
        if (n3 == 0) {
            throw Http2.ioException(z[12], new Object[0]);
        }
        this.readPriority(handler, n3);
    }

    private void readPriority(Handler handler, int n2) throws IOException {
        int n3 = this.source.readInt();
        boolean bl = (n3 & Integer.MIN_VALUE) != 0;
        int n4 = (this.source.readByte() & 0xFF) + 1;
        handler.priority(n2, n3 &= Integer.MAX_VALUE, n4, bl);
    }

    private void readRstStream(Handler handler, int n2, byte by, int n3) throws IOException {
        if (n2 != 4) {
            throw Http2.ioException(z[7], n2);
        }
        if (n3 == 0) {
            throw Http2.ioException(z[6], new Object[0]);
        }
        n2 = this.source.readInt();
        ErrorCode errorCode = ErrorCode.fromHttp2(n2);
        if (errorCode == null) {
            throw Http2.ioException(z[8], n2);
        }
        handler.rstStream(n3, errorCode);
    }

    private void readSettings(Handler handler, int n2, byte by, int n3) throws IOException {
        if (n3 != 0) {
            throw Http2.ioException(z[3], new Object[0]);
        }
        if ((by & 1) != 0) {
            if (n2 != 0) {
                throw Http2.ioException(z[1], new Object[0]);
            }
            handler.ackSettings();
            return;
        }
        if (n2 % 6 != 0) {
            throw Http2.ioException(z[4], n2);
        }
        Settings settings = new Settings();
        for (n3 = 0; n3 < n2; n3 += 6) {
            int n4 = this.source.readShort() & 0xFFFF;
            int n5 = this.source.readInt();
            switch (n4) {
                case 1: {
                    break;
                }
                case 2: {
                    if (n5 == 0 || n5 == 1) break;
                    throw Http2.ioException(z[5], new Object[0]);
                }
                case 3: {
                    n4 = 4;
                    break;
                }
                case 4: {
                    n4 = 7;
                    if (n5 >= 0) break;
                    throw Http2.ioException(z[0], new Object[0]);
                }
                case 5: {
                    if (n5 >= 16384 && n5 <= 0xFFFFFF) break;
                    throw Http2.ioException(z[2], n5);
                }
            }
            settings.set(n4, n5);
        }
        handler.settings(false, settings);
    }

    private void readPushPromise(Handler handler, int n2, byte by, int n3) throws IOException {
        if (n3 == 0) {
            throw Http2.ioException(z[13], new Object[0]);
        }
        short s2 = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        int n4 = this.source.readInt() & Integer.MAX_VALUE;
        n2 -= 4;
        n2 = Http2Reader.lengthWithoutPadding(n2, by, s2);
        List<Header> list = this.readHeaderBlock(n2, s2, by, n3);
        handler.pushPromise(n3, n4, list);
    }

    private void readPing(Handler handler, int n2, byte by, int n3) throws IOException {
        if (n2 != 8) {
            throw Http2.ioException(z[23], n2);
        }
        if (n3 != 0) {
            throw Http2.ioException(z[22], new Object[0]);
        }
        n2 = this.source.readInt();
        n3 = this.source.readInt();
        by = (by & 1) != 0 ? (byte)1 : 0;
        handler.ping(by != 0, n2, n3);
    }

    private void readGoAway(Handler handler, int n2, byte by, int n3) throws IOException {
        if (n2 < 8) {
            throw Http2.ioException(z[16], n2);
        }
        if (n3 != 0) {
            throw Http2.ioException(z[14], new Object[0]);
        }
        by = (byte)this.source.readInt();
        n3 = this.source.readInt();
        n2 -= 8;
        ErrorCode errorCode = ErrorCode.fromHttp2(n3);
        if (errorCode == null) {
            throw Http2.ioException(z[15], n3);
        }
        ByteString byteString = ByteString.EMPTY;
        if (n2 > 0) {
            byteString = this.source.readByteString(n2);
        }
        handler.goAway(by, errorCode, byteString);
    }

    private void readWindowUpdate(Handler handler, int n2, byte by, int n3) throws IOException {
        if (n2 != 4) {
            throw Http2.ioException(z[20], n2);
        }
        long l2 = (long)this.source.readInt() & Integer.MAX_VALUE;
        if (l2 == 0L) {
            throw Http2.ioException(z[21], l2);
        }
        handler.windowUpdate(n3, l2);
    }

    @Override
    public final void close() throws IOException {
        this.source.close();
    }

    static int readMedium(BufferedSource bufferedSource) throws IOException {
        return (bufferedSource.readByte() & 0xFF) << 16 | (bufferedSource.readByte() & 0xFF) << 8 | bufferedSource.readByte() & 0xFF;
    }

    static int lengthWithoutPadding(int n2, byte by, short s2) throws IOException {
        if ((by & 8) != 0) {
            --n2;
        }
        if (s2 > n2) {
            throw Http2.ioException(z[24], s2, n2);
        }
        return (short)(n2 - s2);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[28];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "~zW4hmgT?b|zW2\u0007}mL4n`oK?n`aL)fbwO)ijgO?tgr]@\u0019\u000e\u001aFS\u0016\u000e\u00058Q";
        int n3 = -1;
        block35: while (true) {
            char[] cArray;
            block40: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block39: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block39;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block40;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 46;
                                break;
                            }
                            case 1: {
                                n9 = 40;
                                break;
                            }
                            case 2: {
                                n9 = 24;
                                break;
                            }
                            case 3: {
                                n9 = 96;
                                break;
                            }
                            default: {
                                n9 = 39;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "hzY-bq{Q:bqmJ2h|\by\u0003L\u000eNj\u0001JK\bk\bH[D|@EK\b}\rWZQ9";
                    n3 = 0;
                    continue block35;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "~zW4hmgT?b|zW2\u0007}mL4n`oK?jopG&uoe]?tgr]Z\u0007\u000b[";
                    n3 = 1;
                    continue block35;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "zqH%x}mL4n`oK@TZZ}\u0001JgL8A\u001a\u000e\u0018";
                    n3 = 2;
                    continue block35;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "zqH%x}mL4n`oK@KKF\u007f\u0014O\u000e\r=@\u0011\u000e\t%@\u0017\u0014\b=\u0013";
                    n3 = 3;
                    continue block35;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "~zW4hmgT?b|zW2\u0007}mL4n`oK?b`iZ,bqxM3o\u000e\t%@\u0017\u000eGj@\u0016";
                    n3 = 4;
                    continue block35;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "zqH%x|{L?tzz]!j\u000e[l\u0012BOEQ\u0004\u0007\u0013\u00158P";
                    n3 = 5;
                    continue block35;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "zqH%x|{L?tzz]!j\u000eD}\u000e@Z@\"@\u0002J\b9]\u0007\u001a";
                    n3 = 6;
                    continue block35;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "zqH%x|{L?tzz]!j\u000e]v\u0005_^M{\u0014BJ\b}\u0012UAZ8\u0003HJM\"@\u0002J";
                    n3 = 7;
                    continue block35;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "~zW4hmgT?b|zW2\u001d\u000e|A0bqlY4f\u000e[l\u0012BOEQ\u0004\u0007\u0013\u00158P";
                    n3 = 8;
                    continue block35;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "~zW4hmgT?b|zW2\u001d\u000enT!`qkW-w|mK3bj\bo\tSFGm\u0014\u0007}mL4n`oK?daeH2b}{G$fzi";
                    n3 = 9;
                    continue block35;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "zqH%x~zQ/ug|A@KKF\u007f\u0014O\u0014\b=\u0004\u0007\u000f\u00158U";
                    n3 = 10;
                    continue block35;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "zqH%x~zQ/ug|A@TZZ}\u0001JgL8]\u001a\u000e\u0018";
                    n3 = 11;
                    continue block35;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "~zW4hmgT?b|zW2\u001d\u000e|A0bqxM3oqxJ/jg{]@TZZ}\u0001JgL8]\u001a\u000e\u0018";
                    n3 = 12;
                    continue block35;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "zqH%xigY7fw\bk\u0014UKIu)C\u000e\t%@\u0017";
                    n3 = 13;
                    continue block35;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "zqH%xigY7fw\bm\u000eBVX}\u0003SKL8\u0005U\\Gj@DAL}Z\u0007\u000bL";
                    n3 = 14;
                    continue block35;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "zqH%xigY7fw\bt\u0005II\\p@\u001b\u000e\u0010\"@\u0002]";
                    n3 = 15;
                    continue block35;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "kPh\u0005DZM|@F\u000eKw\u000eIKKl\tH@\bp\u0005FJMj@E[\\8\u0017F]\b=\u0013";
                    n3 = 16;
                    continue block35;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "\u0012\u00148#h`f]#sggV@\u0002]";
                    n3 = 17;
                    continue block35;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "|Mi\u0015N\\M|@tk|L)ii{8\u0010UKNy\u0003B\u000eFw\u0014\u0007\\M{\u0005NXM|";
                    n3 = 18;
                    continue block35;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "zqH%xyaV$hywM0co|]@KKF\u007f\u0014O\u000e\t%T\u001d\u000e\rk";
                    n3 = 19;
                    continue block35;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "YAv\u0004HY{q\u001aBgF{\u0012BCMv\u0014\u0007YIk@\u0017";
                    n3 = 20;
                    continue block35;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "zqH%x~aV'\u0007]\\j\u0005FCa|@\u0006\u0013\b(";
                    n3 = 21;
                    continue block35;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "zqH%x~aV'\u0007BMv\u0007SF\b9]\u0007\u0016\u00128ET";
                    n3 = 22;
                    continue block35;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "~zW4hmgT?b|zW2\u0007^I|\u0004N@O8ET\u000e\u00168\u0012BCIq\u000eN@O8\fB@Ol\b\u0007\u000b[";
                    n3 = 23;
                    continue block35;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "~zW4hmgT?b|zW2\u001d\u000e|A0bq`]!ckzK@TZZ}\u0001JgL8]\u001a\u000e\u0018";
                    n3 = 24;
                    continue block35;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "kPh\u0005DZM|@F\u000e{]4sgf_3\u0007HZy\rB\u000eJm\u0014\u0007YIk@\u0002]";
                    n3 = 25;
                    continue block35;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "hzY-bq{Q:bqmJ2h|\u00128ET";
                    n3 = 26;
                    continue block35;
                }
                case 26: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        logger = Logger.getLogger(Http2.class.getName());
    }

    static interface Handler {
        public void data(boolean var1, int var2, BufferedSource var3, int var4) throws IOException;

        public void headers(boolean var1, int var2, int var3, List<Header> var4);

        public void rstStream(int var1, ErrorCode var2);

        public void settings(boolean var1, Settings var2);

        public void ackSettings();

        public void ping(boolean var1, int var2, int var3);

        public void goAway(int var1, ErrorCode var2, ByteString var3);

        public void windowUpdate(int var1, long var2);

        public void priority(int var1, int var2, int var3, boolean var4);

        public void pushPromise(int var1, int var2, List<Header> var3) throws IOException;

        public void alternateService(int var1, String var2, ByteString var3, String var4, int var5, long var6);
    }

    static final class ContinuationSource
    implements Source {
        private final BufferedSource source;
        int length;
        byte flags;
        int streamId;
        int left;
        short padding;
        private static final String[] z;

        ContinuationSource(BufferedSource bufferedSource) {
            this.source = bufferedSource;
        }

        @Override
        public final long read(Buffer buffer, long l2) throws IOException {
            while (this.left == 0) {
                this.source.skip(this.padding);
                this.padding = 0;
                if ((this.flags & 4) != 0) {
                    return -1L;
                }
                this.readContinuationHeader();
            }
            long l3 = this.source.read(buffer, Math.min(l2, (long)this.left));
            if (l3 == -1L) {
                return -1L;
            }
            this.left = (int)((long)this.left - l3);
            return l3;
        }

        @Override
        public final Timeout timeout() {
            return this.source.timeout();
        }

        @Override
        public final void close() throws IOException {
        }

        private void readContinuationHeader() throws IOException {
            int n2 = this.streamId;
            this.length = this.left = Http2Reader.readMedium(this.source);
            byte by = (byte)(this.source.readByte() & 0xFF);
            this.flags = (byte)(this.source.readByte() & 0xFF);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Http2.frameLog(true, this.streamId, this.length, by, this.flags));
            }
            this.streamId = this.source.readInt() & Integer.MAX_VALUE;
            if (by != 9) {
                throw Http2.ioException(z[1], by);
            }
            if (this.streamId != n2) {
                throw Http2.ioException(z[0], new Object[0]);
            }
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "\u000b\u007fn\u0016\u0015\u001cip\u0007\u0003\u0011s\u007f\u0007\u0003\u0010h\u001e >-C_>\u0003;\u0006];+1A[7";
            int n3 = -1;
            block9: while (true) {
                char[] cArray;
                block14: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block13: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block13;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block14;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 95;
                                    break;
                                }
                                case 1: {
                                    n9 = 38;
                                    break;
                                }
                                case 2: {
                                    n9 = 62;
                                    break;
                                }
                                case 3: {
                                    n9 = 83;
                                    break;
                                }
                                default: {
                                    n9 = 74;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "zU\u001erw\u007frg\u0003\u000f\u0000eq\u001d\u001e\u0016hk\u0012\u001e\u0016ip";
                        n3 = 0;
                        continue block9;
                    }
                    case 0: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

