/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.tls;

import cn.jmessage.support.okhttp3.internal.Util;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public final class OkHostnameVerifier
implements HostnameVerifier {
    public static final OkHostnameVerifier INSTANCE;
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_IPA_NAME = 7;
    private static final String[] z;

    private OkHostnameVerifier() {
    }

    @Override
    public final boolean verify(String string, SSLSession certificateArray) {
        try {
            certificateArray = certificateArray.getPeerCertificates();
            return this.verify(string, (X509Certificate)certificateArray[0]);
        }
        catch (SSLException sSLException) {
            return false;
        }
    }

    public final boolean verify(String string, X509Certificate x509Certificate) {
        if (Util.verifyAsIpAddress(string)) {
            return this.verifyIpAddress(string, x509Certificate);
        }
        return this.verifyHostname(string, x509Certificate);
    }

    private boolean verifyIpAddress(String string, X509Certificate object) {
        object = OkHostnameVerifier.getSubjectAltNames((X509Certificate)object, 7);
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equalsIgnoreCase((String)object.get(i2))) continue;
            return true;
        }
        return false;
    }

    private boolean verifyHostname(String string, X509Certificate object) {
        string = string.toLowerCase(Locale.US);
        for (String string2 : OkHostnameVerifier.getSubjectAltNames((X509Certificate)object, 2)) {
            if (!this.verifyHostname(string, string2)) continue;
            return true;
        }
        return false;
    }

    public static List<String> allSubjectAltNames(X509Certificate object) {
        List<String> list = OkHostnameVerifier.getSubjectAltNames((X509Certificate)object, 7);
        object = OkHostnameVerifier.getSubjectAltNames((X509Certificate)object, 2);
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + object.size());
        arrayList.addAll(list);
        arrayList.addAll((Collection<String>)object);
        return arrayList;
    }

    private static List<String> getSubjectAltNames(X509Certificate iterator, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            iterator = ((X509Certificate)((Object)iterator)).getSubjectAlternativeNames();
            if (iterator == null) {
                return Collections.emptyList();
            }
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Integer n3;
                Object object = (List)iterator.next();
                if (object == null || object.size() < 2 || (n3 = (Integer)object.get(0)) == null || n3 != n2 || (object = (String)object.get(1)) == null) continue;
                arrayList.add((String)object);
            }
            return arrayList;
        }
        catch (CertificateParsingException certificateParsingException) {
            return Collections.emptyList();
        }
    }

    public final boolean verifyHostname(String string, String string2) {
        if (string == null || string.length() == 0 || string.startsWith(".") || string.endsWith(z[0])) {
            return false;
        }
        if (string2 == null || string2.length() == 0 || string2.startsWith(".") || string2.endsWith(z[0])) {
            return false;
        }
        if (!string.endsWith(".")) {
            string = string + '.';
        }
        if (!string2.endsWith(".")) {
            string2 = string2 + '.';
        }
        if (!(string2 = string2.toLowerCase(Locale.US)).contains("*")) {
            return string.equals(string2);
        }
        if (!string2.startsWith(z[1]) || string2.indexOf(42, 1) != -1) {
            return false;
        }
        if (string.length() < string2.length()) {
            return false;
        }
        if (z[1].equals(string2)) {
            return false;
        }
        if (!string.endsWith(string2 = string2.substring(1))) {
            return false;
        }
        int n2 = string.length() - string2.length();
        return n2 <= 0 || string.lastIndexOf(46, n2 - 1) == -1;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "T@";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 122;
                                break;
                            }
                            case 1: {
                                n9 = 110;
                                break;
                            }
                            case 2: {
                                n9 = 74;
                                break;
                            }
                            case 3: {
                                n9 = 104;
                                break;
                            }
                            default: {
                                n9 = 58;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "P@";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        INSTANCE = new OkHostnameVerifier();
    }
}

