/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.ws;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okhttp3.Call;
import cn.jmessage.support.okhttp3.Callback;
import cn.jmessage.support.okhttp3.EventListener;
import cn.jmessage.support.okhttp3.OkHttpClient;
import cn.jmessage.support.okhttp3.Protocol;
import cn.jmessage.support.okhttp3.Request;
import cn.jmessage.support.okhttp3.Response;
import cn.jmessage.support.okhttp3.WebSocket;
import cn.jmessage.support.okhttp3.WebSocketListener;
import cn.jmessage.support.okhttp3.internal.Internal;
import cn.jmessage.support.okhttp3.internal.Util;
import cn.jmessage.support.okhttp3.internal.connection.StreamAllocation;
import cn.jmessage.support.okhttp3.internal.ws.WebSocketProtocol;
import cn.jmessage.support.okhttp3.internal.ws.WebSocketReader;
import cn.jmessage.support.okhttp3.internal.ws.WebSocketWriter;
import cn.jmessage.support.okio.BufferedSink;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.ByteString;
import cn.jmessage.support.okio.Okio;
import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class RealWebSocket
implements WebSocket,
WebSocketReader.FrameCallback {
    private static final List<Protocol> ONLY_HTTP1;
    private static final long MAX_QUEUE_SIZE = 0x1000000L;
    private static final long CANCEL_AFTER_CLOSE_MILLIS = 60000L;
    private final Request originalRequest;
    final WebSocketListener listener;
    private final Random random;
    private final long pingIntervalMillis;
    private final String key;
    private Call call;
    private final Runnable writerRunnable;
    private WebSocketReader reader;
    private WebSocketWriter writer;
    private ScheduledExecutorService executor;
    private Streams streams;
    private final ArrayDeque<ByteString> pongQueue = new ArrayDeque();
    private final ArrayDeque<Object> messageAndCloseQueue = new ArrayDeque();
    private long queueSize;
    private boolean enqueuedClose;
    private ScheduledFuture<?> cancelFuture;
    private int receivedCloseCode = -1;
    private String receivedCloseReason;
    private boolean failed;
    private int sentPingCount;
    private int receivedPingCount;
    private int receivedPongCount;
    private boolean awaitingPong;
    private static final String[] z;

    public RealWebSocket(Request object, WebSocketListener webSocketListener, Random random, long l2) {
        if (!z[16].equals(((Request)object).method())) {
            throw new IllegalArgumentException(z[17] + ((Request)object).method());
        }
        this.originalRequest = object;
        this.listener = webSocketListener;
        this.random = random;
        this.pingIntervalMillis = l2;
        object = new byte[16];
        random.nextBytes((byte[])object);
        this.key = ByteString.of((byte[])object).base64();
        this.writerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    while (RealWebSocket.this.writeOneFrame()) {
                    }
                    return;
                }
                catch (IOException iOException) {
                    RealWebSocket.this.failWebSocket(iOException, null);
                    return;
                }
            }
        };
    }

    @Override
    public final Request request() {
        return this.originalRequest;
    }

    @Override
    public final synchronized long queueSize() {
        return this.queueSize;
    }

    @Override
    public final void cancel() {
        this.call.cancel();
    }

    public final void connect(OkHttpClient okHttpClient) {
        okHttpClient = okHttpClient.newBuilder().eventListener(EventListener.NONE).protocols(ONLY_HTTP1).build();
        final Request request = this.originalRequest.newBuilder().header(z[6], z[3]).header(z[1], z[6]).header(z[2], this.key).header(z[5], z[4]).build();
        this.call = Internal.instance.newWebSocketCall(okHttpClient, request);
        this.call.enqueue(new Callback(){
            private static final String z;

            @Override
            public void onResponse(Call object, Response object2) {
                try {
                    RealWebSocket.this.checkResponse((Response)object2);
                }
                catch (ProtocolException protocolException) {
                    RealWebSocket.this.failWebSocket(protocolException, (Response)object2);
                    Util.closeQuietly((Closeable)object2);
                    return;
                }
                object = Internal.instance.streamAllocation((Call)object);
                ((StreamAllocation)object).noNewStreams();
                Streams streams = ((StreamAllocation)object).connection().newWebSocketStreams((StreamAllocation)object);
                try {
                    RealWebSocket.this.listener.onOpen(RealWebSocket.this, (Response)object2);
                    object2 = z + request.url().redact();
                    RealWebSocket.this.initReaderAndWriter((String)object2, streams);
                    ((StreamAllocation)object).connection().socket().setSoTimeout(0);
                    RealWebSocket.this.loopReader();
                    return;
                }
                catch (Exception exception) {
                    RealWebSocket.this.failWebSocket(exception, null);
                    return;
                }
            }

            @Override
            public void onFailure(Call call, IOException iOException) {
                RealWebSocket.this.failWebSocket(iOException, null);
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                char[] cArray;
                block10: {
                    int n2;
                    int n3;
                    char[] cArray2;
                    int n4;
                    block9: {
                        char[] cArray3 = "V0@Aci{_PuJ4k^rm{".toCharArray();
                        n4 = 0;
                        int n5 = cArray3.length;
                        cArray2 = cArray3;
                        n3 = n5;
                        if (n5 <= 1) break block9;
                        cArray = cArray2;
                        n2 = n3;
                        if (n3 <= n4) break block10;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n6 = n4;
                        while (true) {
                            int n7;
                            char c2 = cArray4[n6];
                            switch (n4 % 5) {
                                case 0: {
                                    n7 = 25;
                                    break;
                                }
                                case 1: {
                                    n7 = 91;
                                    break;
                                }
                                case 2: {
                                    n7 = 8;
                                    break;
                                }
                                case 3: {
                                    n7 = 53;
                                    break;
                                }
                                default: {
                                    n7 = 23;
                                }
                            }
                            cArray4[n6] = (char)(c2 ^ n7);
                            ++n4;
                            cArray2 = cArray5;
                            n3 = n3;
                            if (n3 != 0) break;
                            cArray5 = cArray2;
                            n2 = n3;
                            n6 = n3;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n2 = n3;
                    } while (n3 > n4);
                }
                z = new String(cArray).intern();
            }
        });
    }

    final void checkResponse(Response object) throws ProtocolException {
        if (((Response)object).code() != 101) {
            throw new ProtocolException(z[14] + ((Response)object).code() + " " + ((Response)object).message() + "'");
        }
        String string = ((Response)object).header(z[1]);
        if (!z[6].equalsIgnoreCase(string)) {
            throw new ProtocolException(z[8] + string + "'");
        }
        string = ((Response)object).header(z[6]);
        if (!z[3].equalsIgnoreCase(string)) {
            throw new ProtocolException(z[9] + string + "'");
        }
        object = ((Response)object).header(z[11]);
        string = ByteString.encodeUtf8(this.key + z[12]).sha1().base64();
        if (!string.equals(object)) {
            throw new ProtocolException(z[10] + string + z[13] + (String)object + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initReaderAndWriter(String string, Streams streams) throws IOException {
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            this.streams = streams;
            this.writer = new WebSocketWriter(streams.client, streams.sink, this.random);
            this.executor = new ScheduledThreadPoolExecutor(1, Util.threadFactory(string, false));
            if (this.pingIntervalMillis != 0L) {
                this.executor.scheduleAtFixedRate(new PingRunnable(), this.pingIntervalMillis, this.pingIntervalMillis, TimeUnit.MILLISECONDS);
            }
            if (!this.messageAndCloseQueue.isEmpty()) {
                this.runWriter();
            }
        }
        this.reader = new WebSocketReader(streams.client, streams.source, this);
    }

    public final void loopReader() throws IOException {
        while (this.receivedCloseCode == -1) {
            this.reader.processNextFrame();
        }
    }

    final boolean processNextFrame() throws IOException {
        try {
            this.reader.processNextFrame();
            return this.receivedCloseCode == -1;
        }
        catch (Exception exception) {
            this.failWebSocket(exception, null);
            return false;
        }
    }

    final void awaitTermination(int n2, TimeUnit timeUnit) throws InterruptedException {
        this.executor.awaitTermination(n2, timeUnit);
    }

    final void tearDown() throws InterruptedException {
        if (this.cancelFuture != null) {
            this.cancelFuture.cancel(false);
        }
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    final synchronized int sentPingCount() {
        return this.sentPingCount;
    }

    final synchronized int receivedPingCount() {
        return this.receivedPingCount;
    }

    final synchronized int receivedPongCount() {
        return this.receivedPongCount;
    }

    @Override
    public final void onReadMessage(String string) throws IOException {
        this.listener.onMessage((WebSocket)this, string);
    }

    @Override
    public final void onReadMessage(ByteString byteString) throws IOException {
        this.listener.onMessage((WebSocket)this, byteString);
    }

    @Override
    public final synchronized void onReadPing(ByteString byteString) {
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return;
        }
        this.pongQueue.add(byteString);
        this.runWriter();
        ++this.receivedPingCount;
    }

    @Override
    public final synchronized void onReadPong(ByteString byteString) {
        ++this.receivedPongCount;
        this.awaitingPong = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onReadClose(int n2, String string) {
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        Streams streams = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.receivedCloseCode != -1) {
                throw new IllegalStateException(z[7]);
            }
            this.receivedCloseCode = n2;
            this.receivedCloseReason = string;
            if (this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
                streams = this.streams;
                this.streams = null;
                if (this.cancelFuture != null) {
                    this.cancelFuture.cancel(false);
                }
                this.executor.shutdown();
            }
        }
        try {
            this.listener.onClosing(this, n2, string);
            if (streams != null) {
                this.listener.onClosed(this, n2, string);
            }
            return;
        }
        finally {
            Util.closeQuietly(streams);
        }
    }

    @Override
    public final boolean send(String string) {
        if (string == null) {
            throw new NullPointerException(z[0]);
        }
        return this.send(ByteString.encodeUtf8(string), 1);
    }

    @Override
    public final boolean send(ByteString byteString) {
        if (byteString == null) {
            throw new NullPointerException(z[21]);
        }
        return this.send(byteString, 2);
    }

    private synchronized boolean send(ByteString byteString, int n2) {
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        if (this.queueSize + (long)byteString.size() > 0x1000000L) {
            this.close(1001, null);
            return false;
        }
        this.queueSize += (long)byteString.size();
        this.messageAndCloseQueue.add(new Message(n2, byteString));
        this.runWriter();
        return true;
    }

    final synchronized boolean pong(ByteString byteString) {
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return false;
        }
        this.pongQueue.add(byteString);
        this.runWriter();
        return true;
    }

    @Override
    public final boolean close(int n2, String string) {
        return this.close(n2, string, 60000L);
    }

    final synchronized boolean close(int n2, String string, long l2) {
        WebSocketProtocol.validateCloseCode(n2);
        ByteString byteString = null;
        if (string != null && (long)(byteString = ByteString.encodeUtf8(string)).size() > 123L) {
            throw new IllegalArgumentException(z[15] + string);
        }
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        this.enqueuedClose = true;
        this.messageAndCloseQueue.add(new Close(n2, byteString, l2));
        this.runWriter();
        return true;
    }

    private void runWriter() {
        assert (Thread.holdsLock(this));
        if (this.executor != null) {
            this.executor.execute(this.writerRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean writeOneFrame() throws IOException {
        ByteString byteString;
        Object object;
        Object object2 = null;
        int n2 = 0;
        String string = null;
        Streams streams = null;
        Object object3 = this;
        synchronized (object3) {
            if (this.failed) {
                return false;
            }
            object = this.writer;
            byteString = this.pongQueue.poll();
            if (byteString == null) {
                object2 = this.messageAndCloseQueue.poll();
                if (object2 instanceof Close) {
                    n2 = this.receivedCloseCode;
                    string = this.receivedCloseReason;
                    if (n2 != -1) {
                        streams = this.streams;
                        this.streams = null;
                        this.executor.shutdown();
                    } else {
                        this.cancelFuture = this.executor.schedule(new CancelRunnable(), ((Close)object2).cancelAfterCloseMillis, TimeUnit.MILLISECONDS);
                    }
                } else if (object2 == null) {
                    return false;
                }
            }
        }
        try {
            if (byteString != null) {
                ((WebSocketWriter)object).writePong(byteString);
            } else if (object2 instanceof Message) {
                object3 = ((Message)object2).data;
                object = Okio.buffer(((WebSocketWriter)object).newMessageSink(((Message)object2).formatOpcode, ((ByteString)object3).size()));
                object.write((ByteString)object3);
                object.close();
                object = this;
                synchronized (object) {
                    this.queueSize -= (long)((ByteString)object3).size();
                }
            } else if (object2 instanceof Close) {
                object3 = (Close)object2;
                ((WebSocketWriter)object).writeClose(((Close)object3).code, ((Close)object3).reason);
                if (streams != null) {
                    this.listener.onClosed(this, n2, string);
                }
            } else {
                throw new AssertionError();
            }
            return true;
        }
        finally {
            Util.closeQuietly(streams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void writePingFrame() {
        int n2;
        WebSocketWriter webSocketWriter;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.failed) {
                return;
            }
            webSocketWriter = this.writer;
            n2 = this.awaitingPong ? this.sentPingCount : -1;
            ++this.sentPingCount;
            this.awaitingPong = true;
        }
        if (n2 != -1) {
            this.failWebSocket(new SocketTimeoutException(z[19] + this.pingIntervalMillis + z[18] + (n2 - 1) + z[20]), null);
            return;
        }
        try {
            webSocketWriter.writePing(ByteString.EMPTY);
            return;
        }
        catch (IOException iOException) {
            this.failWebSocket(iOException, null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void failWebSocket(Exception exception, @Nullable Response response) {
        Streams streams;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.failed) {
                return;
            }
            this.failed = true;
            streams = this.streams;
            this.streams = null;
            if (this.cancelFuture != null) {
                this.cancelFuture.cancel(false);
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }
        try {
            this.listener.onFailure(this, exception, response);
            return;
        }
        finally {
            Util.closeQuietly(streams);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[22];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0018(^S\u0002Qp\u0006IW\u0000!";
        int n3 = -1;
        block29: while (true) {
            char[] cArray;
            block34: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block33: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block33;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block34;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 108;
                                break;
                            }
                            case 1: {
                                n9 = 77;
                                break;
                            }
                            case 2: {
                                n9 = 38;
                                break;
                            }
                            case 3: {
                                n9 = 39;
                                break;
                            }
                            default: {
                                n9 = 34;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "/\"HIG\u000f9OHL";
                    n3 = 0;
                    continue block29;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "?(E\nu\t/uHA\u0007(R\ni\t4";
                    n3 = 1;
                    continue block29;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u001b(DTM\u000f&CS";
                    n3 = 2;
                    continue block29;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "]~";
                    n3 = 3;
                    continue block29;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "?(E\nu\t/uHA\u0007(R\nt\t?UNM\u0002";
                    n3 = 4;
                    continue block29;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "9=AUC\b(";
                    n3 = 5;
                    continue block29;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\r!TBC\b4\u0006DN\u0003>CC";
                    n3 = 6;
                    continue block29;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = ")5VBA\u0018(B\u0007\u0005/\"HIG\u000f9OHLKmNBC\b(T\u0007T\r!SB\u0002K\u0018V@P\r)C\u0000\u0002\u000e8R\u0007U\r>\u0006\u0000";
                    n3 = 7;
                    continue block29;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = ")5VBA\u0018(B\u0007\u00059=AUC\b(\u0001\u0007J\t,BBPL;GKW\tm\u0001PG\u000e>IDI\t9\u0001\u0007@\u00199\u0006PC\u001fm\u0001";
                    n3 = 8;
                    continue block29;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = ")5VBA\u0018(B\u0007\u0005?(E\nu\t/uHA\u0007(R\nc\u000f.CWVKmNBC\b(T\u0007T\r!SB\u0002K";
                    n3 = 9;
                    continue block29;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "?(E\nu\t/uHA\u0007(R\nc\u000f.CWV";
                    n3 = 10;
                    continue block29;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "^x\u001ebc*\f\u0013\ngU|\u0012\n\u0016[\tg\n\u001bY\u000eg\naY\fd\u0017f/u\u0013e\u0013]";
                    n3 = 11;
                    continue block29;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "KmDRVL:GT\u0002K";
                    n3 = 12;
                    continue block29;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = ")5VBA\u0018(B\u0007j8\u0019v\u0007\u0013\\|\u0006UG\u001f=IIQ\tmDRVL:GT\u0002K";
                    n3 = 13;
                    continue block29;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u001e(GTM\u0002cUNX\te\u000f\u0007\u001cL|\u0014\u0014\u0018L";
                    n3 = 14;
                    continue block29;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "+\br";
                    n3 = 15;
                    continue block29;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = ">(WRG\u001f9\u0006JW\u001f9\u0006EGL\ncs\u0018L";
                    n3 = 16;
                    continue block29;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "\u0001>\u0006\u000fC\n9CU\u0002";
                    n3 = 17;
                    continue block29;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "\u001f(HS\u0002\u001c$H@\u0002\u000e8R\u0007F\u0005)H\u0000VL?CDG\u0005;C\u0007R\u0003#A\u0007U\u00059NNLL";
                    n3 = 18;
                    continue block29;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "L>SDA\t>UAW\u0000mVNL\u000bbVHL\u000b>\u000f";
                    n3 = 19;
                    continue block29;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "\u000e4RBQLp\u001b\u0007L\u0019!J";
                    n3 = 20;
                    continue block29;
                }
                case 20: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        ONLY_HTTP1 = Collections.singletonList(Protocol.HTTP_1_1);
    }

    final class CancelRunnable
    implements Runnable {
        CancelRunnable() {
        }

        @Override
        public final void run() {
            RealWebSocket.this.cancel();
        }
    }

    public static abstract class Streams
    implements Closeable {
        public final boolean client;
        public final BufferedSource source;
        public final BufferedSink sink;

        public Streams(boolean bl, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.client = bl;
            this.source = bufferedSource;
            this.sink = bufferedSink;
        }
    }

    static final class Close {
        final int code;
        final ByteString reason;
        final long cancelAfterCloseMillis;

        Close(int n2, ByteString byteString, long l2) {
            this.code = n2;
            this.reason = byteString;
            this.cancelAfterCloseMillis = l2;
        }
    }

    static final class Message {
        final int formatOpcode;
        final ByteString data;

        Message(int n2, ByteString byteString) {
            this.formatOpcode = n2;
            this.data = byteString;
        }
    }

    private final class PingRunnable
    implements Runnable {
        PingRunnable() {
        }

        @Override
        public final void run() {
            RealWebSocket.this.writePingFrame();
        }
    }
}

