/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okhttp3.internal.ws;

import cn.jmessage.support.okhttp3.internal.ws.WebSocketProtocol;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.ByteString;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;

final class WebSocketReader {
    final boolean isClient;
    final BufferedSource source;
    final FrameCallback frameCallback;
    boolean closed;
    int opcode;
    long frameLength;
    boolean isFinalFrame;
    boolean isControlFrame;
    private final Buffer controlFrameBuffer = new Buffer();
    private final Buffer messageFrameBuffer = new Buffer();
    private final byte[] maskKey;
    private final Buffer.UnsafeCursor maskCursor;
    private static final String[] z;

    WebSocketReader(boolean bl, BufferedSource bufferedSource, FrameCallback frameCallback) {
        if (bufferedSource == null) {
            throw new NullPointerException(z[1]);
        }
        if (frameCallback == null) {
            throw new NullPointerException(z[0]);
        }
        this.isClient = bl;
        this.source = bufferedSource;
        this.frameCallback = frameCallback;
        this.maskKey = bl ? null : new byte[4];
        this.maskCursor = bl ? null : new Buffer.UnsafeCursor();
    }

    final void processNextFrame() throws IOException {
        this.readHeader();
        if (this.isControlFrame) {
            this.readControlFrame();
            return;
        }
        this.readMessageFrame();
    }

    private void readHeader() throws IOException {
        int n2;
        if (this.closed) {
            throw new IOException(z[7]);
        }
        long l2 = this.source.timeout().timeoutNanos();
        this.source.timeout().clearTimeout();
        try {
            n2 = this.source.readByte() & 0xFF;
        }
        finally {
            this.source.timeout().timeout(l2, TimeUnit.NANOSECONDS);
        }
        this.opcode = n2 & 0xF;
        this.isFinalFrame = (n2 & 0x80) != 0;
        boolean bl = this.isControlFrame = (n2 & 8) != 0;
        if (this.isControlFrame && !this.isFinalFrame) {
            throw new ProtocolException(z[6]);
        }
        boolean bl2 = (n2 & 0x40) != 0;
        boolean bl3 = (n2 & 0x20) != 0;
        int n3 = n2 = (n2 & 0x10) != 0 ? 1 : 0;
        if (bl2 || bl3 || n2 != 0) {
            throw new ProtocolException(z[8]);
        }
        n2 = this.source.readByte() & 0xFF;
        bl3 = (n2 & 0x80) != 0;
        if (bl3 == this.isClient) {
            throw new ProtocolException(this.isClient ? z[4] : z[9]);
        }
        this.frameLength = n2 & 0x7F;
        if (this.frameLength == 126L) {
            this.frameLength = (long)this.source.readShort() & 0xFFFFL;
        } else if (this.frameLength == 127L) {
            this.frameLength = this.source.readLong();
            if (this.frameLength < 0L) {
                throw new ProtocolException(z[3] + Long.toHexString(this.frameLength) + z[2]);
            }
        }
        if (this.isControlFrame && this.frameLength > 125L) {
            throw new ProtocolException(z[5]);
        }
        if (bl3) {
            this.source.readFully(this.maskKey);
        }
    }

    private void readControlFrame() throws IOException {
        if (this.frameLength > 0L) {
            this.source.readFully(this.controlFrameBuffer, this.frameLength);
            if (!this.isClient) {
                this.controlFrameBuffer.readAndWriteUnsafe(this.maskCursor);
                this.maskCursor.seek(0L);
                WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        }
        switch (this.opcode) {
            case 9: {
                this.frameCallback.onReadPing(this.controlFrameBuffer.readByteString());
                return;
            }
            case 10: {
                this.frameCallback.onReadPong(this.controlFrameBuffer.readByteString());
                return;
            }
            case 8: {
                int n2 = 1005;
                String string = "";
                long l2 = this.controlFrameBuffer.size();
                if (l2 == 1L) {
                    throw new ProtocolException(z[12]);
                }
                if (l2 != 0L) {
                    n2 = this.controlFrameBuffer.readShort();
                    string = this.controlFrameBuffer.readUtf8();
                    String string2 = WebSocketProtocol.closeCodeExceptionMessage(n2);
                    if (string2 != null) {
                        throw new ProtocolException(string2);
                    }
                }
                this.frameCallback.onReadClose(n2, string);
                this.closed = true;
                return;
            }
        }
        throw new ProtocolException(z[13] + Integer.toHexString(this.opcode));
    }

    private void readMessageFrame() throws IOException {
        int n2 = this.opcode;
        if (n2 != 1 && n2 != 2) {
            throw new ProtocolException(z[11] + Integer.toHexString(n2));
        }
        this.readMessage();
        if (n2 == 1) {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readUtf8());
            return;
        }
        this.frameCallback.onReadMessage(this.messageFrameBuffer.readByteString());
    }

    private void readUntilNonControlFrame() throws IOException {
        while (!this.closed) {
            this.readHeader();
            if (!this.isControlFrame) break;
            this.readControlFrame();
        }
    }

    private void readMessage() throws IOException {
        block4: {
            do {
                if (this.closed) {
                    throw new IOException(z[7]);
                }
                if (this.frameLength > 0L) {
                    this.source.readFully(this.messageFrameBuffer, this.frameLength);
                    if (!this.isClient) {
                        this.messageFrameBuffer.readAndWriteUnsafe(this.maskCursor);
                        this.maskCursor.seek(this.messageFrameBuffer.size() - this.frameLength);
                        WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                        this.maskCursor.close();
                    }
                }
                if (this.isFinalFrame) break block4;
                this.readUntilNonControlFrame();
            } while (this.opcode == 0);
            throw new ProtocolException(z[10] + Integer.toHexString(this.opcode));
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[14];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u000e\\\"\u001eY+O/\u001f^\tM(S\u0001U\u000e-\u0006P\u0004";
        int n3 = -1;
        block21: while (true) {
            char[] cArray;
            block26: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block25: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block25;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block26;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 104;
                                break;
                            }
                            case 1: {
                                n9 = 46;
                                break;
                            }
                            case 2: {
                                n9 = 67;
                                break;
                            }
                            case 3: {
                                n9 = 115;
                                break;
                            }
                            default: {
                                n9 = 60;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u001bA6\u0001_\r\u000e~N\u001c\u0006[/\u001f";
                    n3 = 0;
                    continue block21;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "H\u0010cCD_h\u00055z.h\u00055z.h\u00055z.";
                    n3 = 1;
                    continue block21;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ".\\\"\u001eYHB&\u001d[\u001cFcCD";
                    n3 = 2;
                    continue block21;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = ";K1\u0005Y\u001a\u00030\u0016R\u001c\u000e%\u0001]\u0005K0SQ\u001d]7SR\u0007Zc\u0011YHC\"\u0000W\rJm";
                    n3 = 3;
                    continue block21;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "+A-\u0007N\u0007Bc\u0015N\tC&SQ\u001d]7S^\r\u000e/\u0016O\u001b\u000e7\u001b]\u0006\u000erA\t*\u0000";
                    n3 = 4;
                    continue block21;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "+A-\u0007N\u0007Bc\u0015N\tC&\u0000\u001c\u0005[0\u0007\u001c\nKc\u0015U\u0006O/]";
                    n3 = 5;
                    continue block21;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u000bB,\u0000Y\f";
                    n3 = 6;
                    continue block21;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = ":K0\u0016N\u001eK'SZ\u0004O$\u0000\u001c\t\\&SI\u0006]6\u0003L\u0007\\7\u0016XF";
                    n3 = 7;
                    continue block21;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "+B*\u0016R\u001c\u00030\u0016R\u001c\u000e%\u0001]\u0005K0SQ\u001d]7S^\r\u000e.\u0012O\u0003K']";
                    n3 = 8;
                    continue block21;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "-V3\u0016_\u001cK'S_\u0007@7\u001aR\u001dO7\u001aS\u0006\u000e,\u0003_\u0007J&]\u001c/A7I\u001c";
                    n3 = 9;
                    continue block21;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "=@(\u001dS\u001f@c\u001cL\u000bA'\u0016\u0006H";
                    n3 = 10;
                    continue block21;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "%O/\u0015S\u001aC&\u0017\u001c\u000bB,\u0000YH^\"\nP\u0007O'SP\r@$\u0007THA%S\rF";
                    n3 = 11;
                    continue block21;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "=@(\u001dS\u001f@c\u0010S\u0006Z1\u001cPHA3\u0010S\fKyS";
                    n3 = 12;
                    continue block21;
                }
                case 12: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    public static interface FrameCallback {
        public void onReadMessage(String var1) throws IOException;

        public void onReadMessage(ByteString var1) throws IOException;

        public void onReadPing(ByteString var1);

        public void onReadPong(ByteString var1);

        public void onReadClose(int var1, String var2);
    }
}

