/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okio;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.Segment;
import cn.jmessage.support.okio.Sink;
import cn.jmessage.support.okio.Source;
import cn.jmessage.support.okio.Timeout;
import cn.jmessage.support.okio.Util;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;

public class AsyncTimeout
extends Timeout {
    private static final int TIMEOUT_WRITE_SIZE = 65536;
    private static final long IDLE_TIMEOUT_MILLIS;
    private static final long IDLE_TIMEOUT_NANOS;
    @Nullable
    static AsyncTimeout head;
    private boolean inQueue;
    @Nullable
    private AsyncTimeout next;
    private long timeoutAt;
    private static final String[] z;

    public final void enter() {
        if (this.inQueue) {
            throw new IllegalStateException(z[1]);
        }
        long l2 = this.timeoutNanos();
        boolean bl = this.hasDeadline();
        if (l2 == 0L && !bl) {
            return;
        }
        this.inQueue = true;
        AsyncTimeout.scheduleTimeout(this, l2, bl);
    }

    private static synchronized void scheduleTimeout(AsyncTimeout asyncTimeout, long l2, boolean bl) {
        if (head == null) {
            head = new AsyncTimeout();
            new Watchdog().start();
        }
        long l3 = System.nanoTime();
        if (l2 != 0L && bl) {
            asyncTimeout.timeoutAt = l3 + Math.min(l2, asyncTimeout.deadlineNanoTime() - l3);
        } else if (l2 != 0L) {
            asyncTimeout.timeoutAt = l3 + l2;
        } else if (bl) {
            asyncTimeout.timeoutAt = asyncTimeout.deadlineNanoTime();
        } else {
            throw new AssertionError();
        }
        long l4 = asyncTimeout.remainingNanos(l3);
        AsyncTimeout asyncTimeout2 = head;
        while (true) {
            if (asyncTimeout2.next == null || l4 < asyncTimeout2.next.remainingNanos(l3)) {
                asyncTimeout.next = asyncTimeout2.next;
                asyncTimeout2.next = asyncTimeout;
                if (asyncTimeout2 != head) break;
                AsyncTimeout.class.notify();
                return;
            }
            asyncTimeout2 = asyncTimeout2.next;
        }
    }

    public final boolean exit() {
        if (!this.inQueue) {
            return false;
        }
        this.inQueue = false;
        return AsyncTimeout.cancelScheduledTimeout(this);
    }

    private static synchronized boolean cancelScheduledTimeout(AsyncTimeout asyncTimeout) {
        AsyncTimeout asyncTimeout2 = head;
        while (asyncTimeout2 != null) {
            if (asyncTimeout2.next == asyncTimeout) {
                asyncTimeout2.next = asyncTimeout.next;
                asyncTimeout.next = null;
                return false;
            }
            asyncTimeout2 = asyncTimeout2.next;
        }
        return true;
    }

    private long remainingNanos(long l2) {
        return this.timeoutAt - l2;
    }

    protected void timedOut() {
    }

    public final Sink sink(final Sink sink) {
        return new Sink(){
            private static final String z;

            @Override
            public void write(Buffer buffer, long l2) throws IOException {
                Util.checkOffsetAndCount(buffer.size, 0L, l2);
                while (l2 > 0L) {
                    long l3 = 0L;
                    Segment segment = buffer.head;
                    while (l3 < 65536L) {
                        int n2 = segment.limit - segment.pos;
                        if ((l3 += (long)n2) >= l2) {
                            l3 = l2;
                            break;
                        }
                        segment = segment.next;
                    }
                    AsyncTimeout.this.enter();
                    try {
                        sink.write(buffer, l3);
                        l2 -= l3;
                    }
                    catch (IOException iOException) {
                        try {
                            throw AsyncTimeout.this.exit(iOException);
                        }
                        catch (Throwable throwable) {
                            AsyncTimeout.this.exit(false);
                            throw throwable;
                        }
                    }
                    AsyncTimeout.this.exit(true);
                }
            }

            @Override
            public void flush() throws IOException {
                AsyncTimeout.this.enter();
                try {
                    sink.flush();
                }
                catch (IOException iOException) {
                    try {
                        throw AsyncTimeout.this.exit(iOException);
                    }
                    catch (Throwable throwable) {
                        AsyncTimeout.this.exit(false);
                        throw throwable;
                    }
                }
                AsyncTimeout.this.exit(true);
                return;
            }

            @Override
            public void close() throws IOException {
                AsyncTimeout.this.enter();
                try {
                    sink.close();
                }
                catch (IOException iOException) {
                    try {
                        throw AsyncTimeout.this.exit(iOException);
                    }
                    catch (Throwable throwable) {
                        AsyncTimeout.this.exit(false);
                        throw throwable;
                    }
                }
                AsyncTimeout.this.exit(true);
                return;
            }

            @Override
            public Timeout timeout() {
                return AsyncTimeout.this;
            }

            public String toString() {
                return z + sink + ")";
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                char[] cArray;
                block10: {
                    int n2;
                    int n3;
                    char[] cArray2;
                    int n4;
                    block9: {
                        char[] cArray3 = "\u0010\u000f\u0013>@\u0005\u0015\u00075L$\bD#J?\u0017B".toCharArray();
                        n4 = 0;
                        int n5 = cArray3.length;
                        cArray2 = cArray3;
                        n3 = n5;
                        if (n5 <= 1) break block9;
                        cArray = cArray2;
                        n2 = n3;
                        if (n3 <= n4) break block10;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n6 = n4;
                        while (true) {
                            int n7;
                            char c2 = cArray4[n6];
                            switch (n4 % 5) {
                                case 0: {
                                    n7 = 81;
                                    break;
                                }
                                case 1: {
                                    n7 = 124;
                                    break;
                                }
                                case 2: {
                                    n7 = 106;
                                    break;
                                }
                                case 3: {
                                    n7 = 80;
                                    break;
                                }
                                default: {
                                    n7 = 35;
                                }
                            }
                            cArray4[n6] = (char)(c2 ^ n7);
                            ++n4;
                            cArray2 = cArray5;
                            n3 = n3;
                            if (n3 != 0) break;
                            cArray5 = cArray2;
                            n2 = n3;
                            n6 = n3;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n2 = n3;
                    } while (n3 > n4);
                }
                z = new String(cArray).intern();
            }
        };
    }

    public final Source source(final Source source) {
        return new Source(){
            private static final String z;

            @Override
            public long read(Buffer buffer, long l2) throws IOException {
                long l3;
                AsyncTimeout.this.enter();
                try {
                    l3 = source.read(buffer, l2);
                }
                catch (IOException iOException) {
                    try {
                        throw AsyncTimeout.this.exit(iOException);
                    }
                    catch (Throwable throwable) {
                        AsyncTimeout.this.exit(false);
                        throw throwable;
                    }
                }
                AsyncTimeout.this.exit(true);
                return l3;
            }

            @Override
            public void close() throws IOException {
                try {
                    source.close();
                }
                catch (IOException iOException) {
                    try {
                        throw AsyncTimeout.this.exit(iOException);
                    }
                    catch (Throwable throwable) {
                        AsyncTimeout.this.exit(false);
                        throw throwable;
                    }
                }
                AsyncTimeout.this.exit(true);
                return;
            }

            @Override
            public Timeout timeout() {
                return AsyncTimeout.this;
            }

            public String toString() {
                return z + source + ")";
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                char[] cArray;
                block10: {
                    int n2;
                    int n3;
                    char[] cArray2;
                    int n4;
                    block9: {
                        char[] cArray3 = "f\u0010\u0011\u001brs\n\u0005\u0010~R\u0017F\u0006~R\u0011\u000b\u00109".toCharArray();
                        n4 = 0;
                        int n5 = cArray3.length;
                        cArray2 = cArray3;
                        n3 = n5;
                        if (n5 <= 1) break block9;
                        cArray = cArray2;
                        n2 = n3;
                        if (n3 <= n4) break block10;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n6 = n4;
                        while (true) {
                            int n7;
                            char c2 = cArray4[n6];
                            switch (n4 % 5) {
                                case 0: {
                                    n7 = 39;
                                    break;
                                }
                                case 1: {
                                    n7 = 99;
                                    break;
                                }
                                case 2: {
                                    n7 = 104;
                                    break;
                                }
                                case 3: {
                                    n7 = 117;
                                    break;
                                }
                                default: {
                                    n7 = 17;
                                }
                            }
                            cArray4[n6] = (char)(c2 ^ n7);
                            ++n4;
                            cArray2 = cArray5;
                            n3 = n3;
                            if (n3 != 0) break;
                            cArray5 = cArray2;
                            n2 = n3;
                            n6 = n3;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n2 = n3;
                    } while (n3 > n4);
                }
                z = new String(cArray).intern();
            }
        };
    }

    final void exit(boolean bl) throws IOException {
        if (this.exit() && bl) {
            throw this.newTimeoutException(null);
        }
    }

    final IOException exit(IOException iOException) throws IOException {
        if (!this.exit()) {
            return iOException;
        }
        return this.newTimeoutException(iOException);
    }

    protected IOException newTimeoutException(@Nullable IOException iOException) {
        InterruptedIOException interruptedIOException = new InterruptedIOException(z[0]);
        if (iOException != null) {
            interruptedIOException.initCause(iOException);
        }
        return interruptedIOException;
    }

    @Nullable
    static AsyncTimeout awaitTimeout() throws InterruptedException {
        AsyncTimeout asyncTimeout = AsyncTimeout.head.next;
        if (asyncTimeout == null) {
            long l2 = System.nanoTime();
            AsyncTimeout.class.wait(IDLE_TIMEOUT_MILLIS);
            if (AsyncTimeout.head.next == null && System.nanoTime() - l2 >= IDLE_TIMEOUT_NANOS) {
                return head;
            }
            return null;
        }
        long l3 = asyncTimeout.remainingNanos(System.nanoTime());
        if (l3 > 0L) {
            long l4 = l3 / 1000000L;
            AsyncTimeout.class.wait(l4, (int)(l3 -= l4 * 1000000L));
            return null;
        }
        AsyncTimeout.head.next = asyncTimeout.next;
        asyncTimeout.next = null;
        return asyncTimeout;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "L\u0015\u0017>@M\b";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 56;
                                break;
                            }
                            case 1: {
                                n9 = 124;
                                break;
                            }
                            case 2: {
                                n9 = 122;
                                break;
                            }
                            case 3: {
                                n9 = 91;
                                break;
                            }
                            default: {
                                n9 = 47;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "m\u0012\u0018:CY\u0012\u0019>K\u0018\u0019\u0014/JJS\u001f#FL";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        IDLE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
        IDLE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(IDLE_TIMEOUT_MILLIS);
    }

    private static final class Watchdog
    extends Thread {
        private static final String z;

        Watchdog() {
            super(z);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public final void run() {
            while (true) {
                try {
                    while (true) {
                        Class<AsyncTimeout> clazz = AsyncTimeout.class;
                        // MONITORENTER : cn.jmessage.support.okio.AsyncTimeout.class
                        AsyncTimeout asyncTimeout = AsyncTimeout.awaitTimeout();
                        if (asyncTimeout == null) {
                            // MONITOREXIT : clazz
                            continue;
                        }
                        if (asyncTimeout == head) {
                            head = null;
                            // MONITOREXIT : clazz
                            return;
                        }
                        // MONITOREXIT : clazz
                        asyncTimeout.timedOut();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "\u0001/k$J\u0019%v(\u0002*+e".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 78;
                                break;
                            }
                            case 1: {
                                n7 = 68;
                                break;
                            }
                            case 2: {
                                n7 = 2;
                                break;
                            }
                            case 3: {
                                n7 = 75;
                                break;
                            }
                            default: {
                                n7 = 106;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }
}

