/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okio;

import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.InflaterSource;
import cn.jmessage.support.okio.Okio;
import cn.jmessage.support.okio.Segment;
import cn.jmessage.support.okio.Source;
import cn.jmessage.support.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Inflater;

public final class GzipSource
implements Source {
    private static final byte FHCRC = 1;
    private static final byte FEXTRA = 2;
    private static final byte FNAME = 3;
    private static final byte FCOMMENT = 4;
    private static final byte SECTION_HEADER = 0;
    private static final byte SECTION_BODY = 1;
    private static final byte SECTION_TRAILER = 2;
    private static final byte SECTION_DONE = 3;
    private int section = 0;
    private final BufferedSource source;
    private final Inflater inflater;
    private final InflaterSource inflaterSource;
    private final CRC32 crc = new CRC32();
    private static final String[] z;

    public GzipSource(Source source) {
        if (source == null) {
            throw new IllegalArgumentException(z[2]);
        }
        this.inflater = new Inflater(true);
        this.source = Okio.buffer(source);
        this.inflaterSource = new InflaterSource(this.source, this.inflater);
    }

    @Override
    public final long read(Buffer buffer, long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException(z[4] + l2);
        }
        if (l2 == 0L) {
            return 0L;
        }
        if (this.section == 0) {
            this.consumeHeader();
            this.section = 1;
        }
        if (this.section == 1) {
            long l3 = buffer.size;
            long l4 = this.inflaterSource.read(buffer, l2);
            if (l4 != -1L) {
                this.updateCrc(buffer, l3, l4);
                return l4;
            }
            this.section = 2;
        }
        if (this.section == 2) {
            this.consumeTrailer();
            this.section = 3;
            if (!this.source.exhausted()) {
                throw new IOException(z[3]);
            }
        }
        return -1L;
    }

    private void consumeHeader() throws IOException {
        this.source.require(10L);
        byte by = this.source.buffer().getByte(3L);
        boolean bl = (by >> 1 & 1) == 1;
        if (bl) {
            this.updateCrc(this.source.buffer(), 0L, 10L);
        }
        short s2 = this.source.readShort();
        this.checkEqual(z[1], 8075, s2);
        this.source.skip(8L);
        if ((by >> 2 & 1) == 1) {
            this.source.require(2L);
            if (bl) {
                this.updateCrc(this.source.buffer(), 0L, 2L);
            }
            short s3 = this.source.buffer().readShortLe();
            this.source.require(s3);
            if (bl) {
                this.updateCrc(this.source.buffer(), 0L, s3);
            }
            this.source.skip(s3);
        }
        if ((by >> 3 & 1) == 1) {
            long l2 = this.source.indexOf((byte)0);
            if (l2 == -1L) {
                throw new EOFException();
            }
            if (bl) {
                this.updateCrc(this.source.buffer(), 0L, l2 + 1L);
            }
            this.source.skip(l2 + 1L);
        }
        if ((by >> 4 & 1) == 1) {
            long l3 = this.source.indexOf((byte)0);
            if (l3 == -1L) {
                throw new EOFException();
            }
            if (bl) {
                this.updateCrc(this.source.buffer(), 0L, l3 + 1L);
            }
            this.source.skip(l3 + 1L);
        }
        if (bl) {
            this.checkEqual(z[0], this.source.readShortLe(), (short)this.crc.getValue());
            this.crc.reset();
        }
    }

    private void consumeTrailer() throws IOException {
        this.checkEqual(z[5], this.source.readIntLe(), (int)this.crc.getValue());
        this.checkEqual(z[6], this.source.readIntLe(), (int)this.inflater.getBytesWritten());
    }

    @Override
    public final Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public final void close() throws IOException {
        this.inflaterSource.close();
    }

    private void updateCrc(Buffer object, long l2, long l3) {
        object = ((Buffer)object).head;
        while (l2 >= (long)(((Segment)object).limit - ((Segment)object).pos)) {
            l2 -= (long)(((Segment)object).limit - ((Segment)object).pos);
            object = ((Segment)object).next;
        }
        while (l3 > 0L) {
            int n2 = (int)((long)((Segment)object).pos + l2);
            int n3 = (int)Math.min((long)(((Segment)object).limit - n2), l3);
            this.crc.update(((Segment)object).data, n2, n3);
            l3 -= (long)n3;
            l2 = 0L;
            object = ((Segment)object).next;
        }
    }

    private void checkEqual(String string, int n2, int n3) throws IOException {
        if (n3 != n2) {
            throw new IOException(String.format(z[7], string, n3, n2));
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "%>UDS";
        int n3 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block19;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 99;
                                break;
                            }
                            case 1: {
                                n9 = 118;
                                break;
                            }
                            case 2: {
                                n9 = 22;
                                break;
                            }
                            case 3: {
                                n9 = 22;
                                break;
                            }
                            default: {
                                n9 = 16;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "*2'_TQ";
                    n3 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0010\u0019cds\u0006V++0\r\u0003zz";
                    n3 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0004\f\u007ff0\u0005\u001fx\u007fc\u000b\u0013r6g\n\u0002~ye\u0017Vsnx\u0002\u0003eby\r\u00116e\u007f\u0016\u0004us";
                    n3 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0001\u000fbsS\f\u0003xb0_V&,0";
                    n3 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = " $U";
                    n3 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "*%_LU";
                    n3 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "F\u0005,6q\u0000\u0002cw|CFn3 [\u000e67-C\u0013nfu\u0000\u0002sr0S\u000e3&(\u001b";
                    n3 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

