/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okio;

import cn.jmessage.support.annotation.Nullable;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSource;
import cn.jmessage.support.okio.ByteString;
import cn.jmessage.support.okio.Options;
import cn.jmessage.support.okio.Sink;
import cn.jmessage.support.okio.Source;
import cn.jmessage.support.okio.Timeout;
import cn.jmessage.support.okio.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

final class RealBufferedSource
implements BufferedSource {
    public final Buffer buffer = new Buffer();
    public final Source source;
    boolean closed;
    private static final String[] z;

    RealBufferedSource(Source source) {
        if (source == null) {
            throw new NullPointerException(z[10]);
        }
        this.source = source;
    }

    @Override
    public final Buffer buffer() {
        return this.buffer;
    }

    @Override
    public final long read(Buffer buffer, long l2) throws IOException {
        if (buffer == null) {
            throw new IllegalArgumentException(z[5]);
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException(z[1] + l2);
        }
        if (this.closed) {
            throw new IllegalStateException(z[0]);
        }
        if (this.buffer.size == 0L && this.source.read(this.buffer, 8192L) == -1L) {
            return -1L;
        }
        long l3 = Math.min(l2, this.buffer.size);
        return this.buffer.read(buffer, l3);
    }

    @Override
    public final boolean exhausted() throws IOException {
        if (this.closed) {
            throw new IllegalStateException(z[0]);
        }
        return this.buffer.exhausted() && this.source.read(this.buffer, 8192L) == -1L;
    }

    @Override
    public final void require(long l2) throws IOException {
        if (!this.request(l2)) {
            throw new EOFException();
        }
    }

    @Override
    public final boolean request(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException(z[1] + l2);
        }
        if (this.closed) {
            throw new IllegalStateException(z[0]);
        }
        while (this.buffer.size < l2) {
            if (this.source.read(this.buffer, 8192L) != -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public final byte readByte() throws IOException {
        this.require(1L);
        return this.buffer.readByte();
    }

    @Override
    public final ByteString readByteString() throws IOException {
        this.buffer.writeAll(this.source);
        return this.buffer.readByteString();
    }

    @Override
    public final ByteString readByteString(long l2) throws IOException {
        this.require(l2);
        return this.buffer.readByteString(l2);
    }

    @Override
    public final int select(Options options) throws IOException {
        int n2;
        block3: {
            if (this.closed) {
                throw new IllegalStateException(z[0]);
            }
            do {
                if ((n2 = this.buffer.selectPrefix(options, true)) == -1) {
                    return -1;
                }
                if (n2 != -2) break block3;
            } while (this.source.read(this.buffer, 8192L) != -1L);
            return -1;
        }
        int n3 = options.byteStrings[n2].size();
        this.buffer.skip(n3);
        return n2;
    }

    @Override
    public final byte[] readByteArray() throws IOException {
        this.buffer.writeAll(this.source);
        return this.buffer.readByteArray();
    }

    @Override
    public final byte[] readByteArray(long l2) throws IOException {
        this.require(l2);
        return this.buffer.readByteArray(l2);
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        try {
            this.require(byArray.length);
        }
        catch (EOFException eOFException) {
            int n2 = 0;
            while (this.buffer.size > 0L) {
                int n3 = this.buffer.read(byArray, n2, (int)this.buffer.size);
                if (n3 == -1) {
                    throw new AssertionError();
                }
                n2 += n3;
            }
            throw eOFException;
        }
        this.buffer.readFully(byArray);
    }

    @Override
    public final int read(byte[] byArray, int n2, int n3) throws IOException {
        Util.checkOffsetAndCount(byArray.length, n2, n3);
        if (this.buffer.size == 0L && this.source.read(this.buffer, 8192L) == -1L) {
            return -1;
        }
        n3 = (int)Math.min((long)n3, this.buffer.size);
        return this.buffer.read(byArray, n2, n3);
    }

    @Override
    public final int read(ByteBuffer byteBuffer) throws IOException {
        if (this.buffer.size == 0L && this.source.read(this.buffer, 8192L) == -1L) {
            return -1;
        }
        return this.buffer.read(byteBuffer);
    }

    @Override
    public final void readFully(Buffer buffer, long l2) throws IOException {
        try {
            this.require(l2);
        }
        catch (EOFException eOFException) {
            buffer.writeAll(this.buffer);
            throw eOFException;
        }
        this.buffer.readFully(buffer, l2);
    }

    @Override
    public final long readAll(Sink sink) throws IOException {
        if (sink == null) {
            throw new IllegalArgumentException(z[5]);
        }
        long l2 = 0L;
        while (this.source.read(this.buffer, 8192L) != -1L) {
            long l3 = this.buffer.completeSegmentByteCount();
            if (l3 <= 0L) continue;
            l2 += l3;
            sink.write(this.buffer, l3);
        }
        if (this.buffer.size() > 0L) {
            l2 += this.buffer.size();
            sink.write(this.buffer, this.buffer.size());
        }
        return l2;
    }

    @Override
    public final String readUtf8() throws IOException {
        this.buffer.writeAll(this.source);
        return this.buffer.readUtf8();
    }

    @Override
    public final String readUtf8(long l2) throws IOException {
        this.require(l2);
        return this.buffer.readUtf8(l2);
    }

    @Override
    public final String readString(Charset charset) throws IOException {
        if (charset == null) {
            throw new IllegalArgumentException(z[3]);
        }
        this.buffer.writeAll(this.source);
        return this.buffer.readString(charset);
    }

    @Override
    public final String readString(long l2, Charset charset) throws IOException {
        this.require(l2);
        if (charset == null) {
            throw new IllegalArgumentException(z[3]);
        }
        return this.buffer.readString(l2, charset);
    }

    @Override
    @Nullable
    public final String readUtf8Line() throws IOException {
        long l2 = this.indexOf((byte)10);
        if (l2 == -1L) {
            if (this.buffer.size != 0L) {
                return this.readUtf8(this.buffer.size);
            }
            return null;
        }
        return this.buffer.readUtf8Line(l2);
    }

    @Override
    public final String readUtf8LineStrict() throws IOException {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public final String readUtf8LineStrict(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException(z[7] + l2);
        }
        long l3 = l2 == Long.MAX_VALUE ? Long.MAX_VALUE : l2 + 1L;
        long l4 = this.indexOf((byte)10, 0L, l3);
        if (l4 != -1L) {
            return this.buffer.readUtf8Line(l4);
        }
        if (l3 < Long.MAX_VALUE && this.request(l3) && this.buffer.getByte(l3 - 1L) == 13 && this.request(l3 + 1L) && this.buffer.getByte(l3) == 10) {
            return this.buffer.readUtf8Line(l3);
        }
        Buffer buffer = new Buffer();
        this.buffer.copyTo(buffer, 0L, Math.min(32L, this.buffer.size()));
        throw new EOFException(z[6] + Math.min(this.buffer.size(), l2) + z[8] + buffer.readByteString().hex() + '\u2026');
    }

    @Override
    public final int readUtf8CodePoint() throws IOException {
        this.require(1L);
        byte by = this.buffer.getByte(0L);
        if ((by & 0xE0) == 192) {
            this.require(2L);
        } else if ((by & 0xF0) == 224) {
            this.require(3L);
        } else if ((by & 0xF8) == 240) {
            this.require(4L);
        }
        return this.buffer.readUtf8CodePoint();
    }

    @Override
    public final short readShort() throws IOException {
        this.require(2L);
        return this.buffer.readShort();
    }

    @Override
    public final short readShortLe() throws IOException {
        this.require(2L);
        return this.buffer.readShortLe();
    }

    @Override
    public final int readInt() throws IOException {
        this.require(4L);
        return this.buffer.readInt();
    }

    @Override
    public final int readIntLe() throws IOException {
        this.require(4L);
        return this.buffer.readIntLe();
    }

    @Override
    public final long readLong() throws IOException {
        this.require(8L);
        return this.buffer.readLong();
    }

    @Override
    public final long readLongLe() throws IOException {
        this.require(8L);
        return this.buffer.readLongLe();
    }

    @Override
    public final long readDecimalLong() throws IOException {
        this.require(1L);
        int n2 = 0;
        while (this.request(n2 + 1)) {
            byte by = this.buffer.getByte(n2);
            if (!(by >= 48 && by <= 57 || n2 == 0 && by == 45)) {
                if (n2 != 0) break;
                throw new NumberFormatException(String.format(z[11], by));
            }
            ++n2;
        }
        return this.buffer.readDecimalLong();
    }

    @Override
    public final long readHexadecimalUnsignedLong() throws IOException {
        this.require(1L);
        int n2 = 0;
        while (this.request(n2 + 1)) {
            byte by = this.buffer.getByte(n2);
            if (!(by >= 48 && by <= 57 || by >= 97 && by <= 102 || by >= 65 && by <= 70)) {
                if (n2 != 0) break;
                throw new NumberFormatException(String.format(z[9], by));
            }
            ++n2;
        }
        return this.buffer.readHexadecimalUnsignedLong();
    }

    @Override
    public final void skip(long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException(z[0]);
        }
        while (l2 > 0L) {
            if (this.buffer.size == 0L && this.source.read(this.buffer, 8192L) == -1L) {
                throw new EOFException();
            }
            long l3 = Math.min(l2, this.buffer.size());
            this.buffer.skip(l3);
            l2 -= l3;
        }
    }

    @Override
    public final long indexOf(byte by) throws IOException {
        return this.indexOf(by, 0L, Long.MAX_VALUE);
    }

    @Override
    public final long indexOf(byte by, long l2) throws IOException {
        return this.indexOf(by, l2, Long.MAX_VALUE);
    }

    @Override
    public final long indexOf(byte by, long l2, long l3) throws IOException {
        if (this.closed) {
            throw new IllegalStateException(z[0]);
        }
        if (l2 < 0L || l3 < l2) {
            throw new IllegalArgumentException(String.format(z[4], l2, l3));
        }
        while (l2 < l3) {
            long l4 = this.buffer.indexOf(by, l2, l3);
            if (l4 != -1L) {
                return l4;
            }
            long l5 = this.buffer.size;
            if (l5 >= l3 || this.source.read(this.buffer, 8192L) == -1L) {
                return -1L;
            }
            l2 = Math.max(l2, l5);
        }
        return -1L;
    }

    @Override
    public final long indexOf(ByteString byteString) throws IOException {
        return this.indexOf(byteString, 0L);
    }

    @Override
    public final long indexOf(ByteString byteString, long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException(z[0]);
        }
        long l3;
        while ((l3 = this.buffer.indexOf(byteString, l2)) == -1L) {
            long l4 = this.buffer.size;
            if (this.source.read(this.buffer, 8192L) == -1L) {
                return -1L;
            }
            l2 = Math.max(l2, l4 - (long)byteString.size() + 1L);
        }
        return l3;
    }

    @Override
    public final long indexOfElement(ByteString byteString) throws IOException {
        return this.indexOfElement(byteString, 0L);
    }

    @Override
    public final long indexOfElement(ByteString byteString, long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException(z[0]);
        }
        long l3;
        while ((l3 = this.buffer.indexOfElement(byteString, l2)) == -1L) {
            long l4 = this.buffer.size;
            if (this.source.read(this.buffer, 8192L) == -1L) {
                return -1L;
            }
            l2 = Math.max(l2, l4);
        }
        return l3;
    }

    @Override
    public final boolean rangeEquals(long l2, ByteString byteString) throws IOException {
        return this.rangeEquals(l2, byteString, 0, byteString.size());
    }

    @Override
    public final boolean rangeEquals(long l2, ByteString byteString, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IllegalStateException(z[0]);
        }
        if (l2 < 0L || n2 < 0 || n3 < 0 || byteString.size() - n2 < n3) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            long l3 = l2 + (long)i2;
            if (!this.request(l3 + 1L)) {
                return false;
            }
            if (this.buffer.getByte(l3) == byteString.getByte(n2 + i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final InputStream inputStream() {
        return new InputStream(){
            private static final String[] z;

            @Override
            public int read() throws IOException {
                if (RealBufferedSource.this.closed) {
                    throw new IOException(z[0]);
                }
                if (RealBufferedSource.this.buffer.size == 0L && RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 8192L) == -1L) {
                    return -1;
                }
                return RealBufferedSource.this.buffer.readByte() & 0xFF;
            }

            @Override
            public int read(byte[] byArray, int n2, int n3) throws IOException {
                if (RealBufferedSource.this.closed) {
                    throw new IOException(z[0]);
                }
                Util.checkOffsetAndCount(byArray.length, n2, n3);
                if (RealBufferedSource.this.buffer.size == 0L && RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 8192L) == -1L) {
                    return -1;
                }
                return RealBufferedSource.this.buffer.read(byArray, n2, n3);
            }

            @Override
            public int available() throws IOException {
                if (RealBufferedSource.this.closed) {
                    throw new IOException(z[0]);
                }
                return (int)Math.min(RealBufferedSource.this.buffer.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() throws IOException {
                RealBufferedSource.this.close();
            }

            public String toString() {
                return RealBufferedSource.this + z[1];
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                String string;
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n2 = 0;
                String string2 = "P~_\u001fhW";
                int n3 = -1;
                block9: while (true) {
                    char[] cArray;
                    block14: {
                        int n4;
                        int n5;
                        char[] cArray2;
                        int n6;
                        block13: {
                            char[] cArray3 = string2.toCharArray();
                            n6 = 0;
                            int n7 = cArray3.length;
                            cArray2 = cArray3;
                            n5 = n7;
                            if (n7 <= 1) break block13;
                            cArray = cArray2;
                            n4 = n5;
                            if (n5 <= n6) break block14;
                        }
                        do {
                            char[] cArray4 = cArray2;
                            char[] cArray5 = cArray2;
                            int n8 = n6;
                            while (true) {
                                int n9;
                                char c2 = cArray4[n8];
                                switch (n6 % 5) {
                                    case 0: {
                                        n9 = 51;
                                        break;
                                    }
                                    case 1: {
                                        n9 = 18;
                                        break;
                                    }
                                    case 2: {
                                        n9 = 48;
                                        break;
                                    }
                                    case 3: {
                                        n9 = 108;
                                        break;
                                    }
                                    default: {
                                        n9 = 13;
                                    }
                                }
                                cArray4[n8] = (char)(c2 ^ n9);
                                ++n6;
                                cArray2 = cArray5;
                                n5 = n5;
                                if (n5 != 0) break;
                                cArray5 = cArray2;
                                n4 = n5;
                                n8 = n5;
                                cArray4 = cArray2;
                            }
                            cArray = cArray2;
                            n4 = n5;
                        } while (n5 > n6);
                    }
                    string = new String(cArray);
                    switch (n3) {
                        default: {
                            stringArray2[n2] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n2 = 1;
                            string2 = "\u001d{^\u001cxGAD\u001ehR\u007f\u0018E";
                            n3 = 0;
                            continue block9;
                        }
                        case 0: 
                    }
                    break;
                }
                stringArray2[n2] = string.intern();
                z = stringArray3;
            }
        };
    }

    @Override
    public final boolean isOpen() {
        return !this.closed;
    }

    @Override
    public final void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.close();
        this.buffer.clear();
    }

    @Override
    public final Timeout timeout() {
        return this.source.timeout();
    }

    public final String toString() {
        return z[2] + this.source + ")";
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[12];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u000bT\u001b\u0016\t\f";
        int n3 = -1;
        block19: while (true) {
            char[] cArray;
            block24: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block23: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block23;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block24;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 104;
                                break;
                            }
                            case 1: {
                                n9 = 56;
                                break;
                            }
                            case 2: {
                                n9 = 116;
                                break;
                            }
                            case 3: {
                                n9 = 101;
                                break;
                            }
                            default: {
                                n9 = 108;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\nA\u0000\u0000/\u0007M\u001a\u0011LT\u0018D_L";
                    n3 = 0;
                    continue block19;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\nM\u0012\u0003\t\u001a\u0010";
                    n3 = 1;
                    continue block19;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u000bP\u0015\u0017\u001f\rLTXQHV\u0001\t\u0000";
                    n3 = 2;
                    continue block19;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u000eJ\u001b\b%\u0006\\\u0011\u001dQMKT\u0011\u0003!V\u0010\u0000\u0014U\u001d\u0007";
                    n3 = 3;
                    continue block19;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u001bQ\u001a\u000eLU\u0005T\u000b\u0019\u0004T";
                    n3 = 4;
                    continue block19;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "4VT\u000b\u0003\u001c\u0018\u0012\n\u0019\u0006\\NE\u0000\u0001U\u001d\u0011Q";
                    n3 = 5;
                    continue block19;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u0004Q\u0019\f\u0018H\u0004TUVH";
                    n3 = 6;
                    continue block19;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "H[\u001b\u000b\u0018\rV\u0000X";
                    n3 = 7;
                    continue block19;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "-@\u0004\u0000\u000f\u001c]\u0010E\u0000\rY\u0010\f\u0002\u000f\u0018/UAQYY\u0003-E~)E\u000f\u0000Y\u0006\u0004\u000f\u001c]\u0006E\u000e\u001dLT\u0012\r\u001b\u0018QF\u0014";
                    n3 = 8;
                    continue block19;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u001bW\u0001\u0017\u000f\r\u0018IXL\u0006M\u0018\t";
                    n3 = 9;
                    continue block19;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "-@\u0004\u0000\u000f\u001c]\u0010E\u0000\rY\u0010\f\u0002\u000f\u0018/UAQeT\n\u001eH\u001fYBL\u000bP\u0015\u0017\r\u000bL\u0011\u0017L\nM\u0000E\u001b\tKT@O\u0010";
                    n3 = 10;
                    continue block19;
                }
                case 10: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

