/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;

public class Timeout {
    public static final Timeout NONE;
    private boolean hasDeadline;
    private long deadlineNanoTime;
    private long timeoutNanos;
    private static final String[] z;

    public Timeout timeout(long l2, TimeUnit timeUnit) {
        if (l2 < 0L) {
            throw new IllegalArgumentException(z[4] + l2);
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(z[1]);
        }
        this.timeoutNanos = timeUnit.toNanos(l2);
        return this;
    }

    public long timeoutNanos() {
        return this.timeoutNanos;
    }

    public boolean hasDeadline() {
        return this.hasDeadline;
    }

    public long deadlineNanoTime() {
        if (!this.hasDeadline) {
            throw new IllegalStateException(z[5]);
        }
        return this.deadlineNanoTime;
    }

    public Timeout deadlineNanoTime(long l2) {
        this.hasDeadline = true;
        this.deadlineNanoTime = l2;
        return this;
    }

    public final Timeout deadline(long l2, TimeUnit timeUnit) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException(z[0] + l2);
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(z[1]);
        }
        return this.deadlineNanoTime(System.nanoTime() + timeUnit.toNanos(l2));
    }

    public Timeout clearTimeout() {
        this.timeoutNanos = 0L;
        return this;
    }

    public Timeout clearDeadline() {
        this.hasDeadline = false;
        return this;
    }

    public void throwIfReached() throws IOException {
        if (Thread.interrupted()) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException(z[3]);
        }
        if (this.hasDeadline && this.deadlineNanoTime - System.nanoTime() <= 0L) {
            throw new InterruptedIOException(z[6]);
        }
    }

    public final void waitUntilNotified(Object object) throws InterruptedIOException {
        try {
            long l2;
            long l3;
            boolean bl = this.hasDeadline();
            long l4 = this.timeoutNanos();
            if (!bl && l4 == 0L) {
                object.wait();
                return;
            }
            long l5 = System.nanoTime();
            if (bl && l4 != 0L) {
                l3 = this.deadlineNanoTime() - l5;
                l2 = Math.min(l4, l3);
            } else {
                l2 = bl ? this.deadlineNanoTime() - l5 : l4;
            }
            l3 = 0L;
            if (l2 > 0L) {
                long l6 = l2 / 1000000L;
                object.wait(l6, (int)(l2 - l6 * 1000000L));
                l3 = System.nanoTime() - l5;
            }
            if (l3 >= l2) {
                throw new InterruptedIOException(z[2]);
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException(z[3]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0015g\u001e!\u000b\u0018}\u0002`CL2\\z_";
        int n3 = -1;
        block14: while (true) {
            char[] cArray;
            block19: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block18: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block18;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block19;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 113;
                                break;
                            }
                            case 1: {
                                n9 = 18;
                                break;
                            }
                            case 2: {
                                n9 = 108;
                                break;
                            }
                            case 3: {
                                n9 = 64;
                                break;
                            }
                            default: {
                                n9 = 127;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0004|\u00054_L/L.\n\u001d~";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0005{\u0001%\u0010\u0004f";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0018|\u0018%\r\u0003g\u001c4\u001a\u0015";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0005{\u0001%\u0010\u0004fL|_A(L";
                    n3 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "?}L$\u001a\u0010v\u0000)\u0011\u0014";
                    n3 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0015w\r$\u0013\u0018|\t`\r\u0014s\u000f(\u001a\u0015";
                    n3 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        NONE = new Timeout(){

            @Override
            public final Timeout timeout(long l2, TimeUnit timeUnit) {
                return this;
            }

            @Override
            public final Timeout deadlineNanoTime(long l2) {
                return this;
            }

            @Override
            public final void throwIfReached() throws IOException {
            }
        };
    }
}

