/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.qiniu.android.collect;

import cn.jmessage.support.okhttp3.MediaType;
import cn.jmessage.support.okhttp3.OkHttpClient;
import cn.jmessage.support.okhttp3.Request;
import cn.jmessage.support.okhttp3.RequestBody;
import cn.jmessage.support.okhttp3.Response;
import cn.jmessage.support.qiniu.android.collect.Config;
import cn.jmessage.support.qiniu.android.http.UserAgent;
import cn.jmessage.support.qiniu.android.storage.UpToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public final class UploadInfoCollector {
    private static ExecutorService singleServer;
    private static OkHttpClient httpClient;
    private static UploadInfoCollector httpCollector;
    private final String serverURL;
    private final String recordFileName;
    private File recordFile = null;
    private long lastUpload;
    private static final String[] z;

    private UploadInfoCollector(String string, String string2) {
        this.recordFileName = string;
        this.serverURL = string2;
        try {
            this.reset0();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static UploadInfoCollector getHttpCollector() {
        if (httpCollector == null) {
            httpCollector = new UploadInfoCollector(z[4], z[5]);
        }
        return httpCollector;
    }

    public static void clean() {
        try {
            if (singleServer != null) {
                singleServer.shutdown();
            }
        }
        catch (Exception exception) {}
        singleServer = null;
        httpClient = null;
        try {
            UploadInfoCollector.getHttpCollector().clean0();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        httpCollector = null;
    }

    public static void reset() {
        try {
            UploadInfoCollector.getHttpCollector().reset0();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void handleHttp(UpToken upToken, RecordMsg recordMsg) {
        try {
            if (Config.isRecord) {
                UploadInfoCollector.getHttpCollector().handle0(upToken, recordMsg);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public static void handleUpload(UpToken upToken, RecordMsg recordMsg) {
        UploadInfoCollector.handleHttp(upToken, recordMsg);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeToFile(File file, String string, boolean bl) {
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(file, bl);
        fileOutputStream.write(string.getBytes(Charset.forName(z[6])));
        fileOutputStream.flush();
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            if (fileOutputStream == null) return;
            try {
                fileOutputStream.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            if (fileOutputStream == null) return;
            {
                catch (Throwable throwable) {
                    if (fileOutputStream == null) throw throwable;
                    try {
                        fileOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
            }
            try {
                fileOutputStream.close();
                return;
            }
            catch (IOException iOException3) {
                return;
            }
        }
    }

    private static OkHttpClient getHttpClient() {
        if (httpClient == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.connectTimeout(10L, TimeUnit.SECONDS);
            builder.readTimeout(15L, TimeUnit.SECONDS);
            builder.writeTimeout((Config.interval / 2 + 1) * 60 - 10, TimeUnit.SECONDS);
            httpClient = builder.build();
        }
        return httpClient;
    }

    private void clean0() {
        try {
            if (this.recordFile != null) {
                this.recordFile.delete();
            } else {
                new File(this.getRecordDir(Config.recordDir), this.recordFileName).delete();
            }
        }
        catch (Exception exception) {}
        this.recordFile = null;
    }

    private void reset0() throws IOException {
        if (Config.isRecord) {
            this.initRecordFile(this.getRecordDir(Config.recordDir));
        }
        if (!Config.isRecord && singleServer != null) {
            singleServer.shutdown();
        }
        if (Config.isRecord && (singleServer == null || singleServer.isShutdown())) {
            singleServer = Executors.newSingleThreadExecutor();
        }
    }

    private File getRecordDir(String string) {
        return new File(string);
    }

    private void initRecordFile(File file) throws IOException {
        if (file == null) {
            throw new IOException(z[1]);
        }
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new IOException(z[0] + file.getAbsolutePath());
            }
            return;
        }
        if (!file.isDirectory()) {
            throw new IOException(file.getAbsolutePath() + z[2]);
        }
        this.recordFile = new File(file, this.recordFileName);
    }

    private void handle0(UpToken object, RecordMsg object2) {
        if (singleServer != null && !singleServer.isShutdown()) {
            object2 = new Runnable((RecordMsg)object2){
                final /* synthetic */ RecordMsg val$record;
                {
                    this.val$record = recordMsg;
                }

                @Override
                public void run() {
                    if (Config.isRecord) {
                        try {
                            UploadInfoCollector.this.tryRecode(this.val$record.toRecordMsg(), UploadInfoCollector.this.recordFile);
                            return;
                        }
                        catch (Throwable throwable) {}
                    }
                }
            };
            singleServer.submit((Runnable)object2);
            if (Config.isUpload && object != UpToken.NULL) {
                object = new Runnable((UpToken)object){
                    final /* synthetic */ UpToken val$upToken;
                    {
                        this.val$upToken = upToken;
                    }

                    @Override
                    public void run() {
                        if (Config.isRecord && Config.isUpload) {
                            try {
                                UploadInfoCollector.this.tryUploadAndClean(this.val$upToken, UploadInfoCollector.this.recordFile);
                                return;
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                };
                singleServer.submit((Runnable)object);
            }
        }
    }

    private void tryRecode(String string, File file) {
        if (Config.isRecord && file.length() < (long)Config.maxRecordFileSize) {
            UploadInfoCollector.writeToFile(file, string + "\n", true);
        }
    }

    private void tryUploadAndClean(UpToken upToken, File file) {
        long l2;
        if (Config.isUpload && file.length() > (long)Config.uploadThreshold && (l2 = new Date().getTime()) > this.lastUpload + (long)(Config.interval * 60 * 1000)) {
            this.lastUpload = l2;
            if (this.upload(upToken, file)) {
                UploadInfoCollector.writeToFile(file, "", false);
                UploadInfoCollector.writeToFile(file, "", false);
            }
        }
    }

    private boolean upload(UpToken object, File object2) {
        boolean bl;
        OkHttpClient okHttpClient = UploadInfoCollector.getHttpClient();
        object2 = RequestBody.create(MediaType.parse(z[8]), (File)object2);
        object = new Request.Builder().url(this.serverURL).addHeader(z[7], z[9] + ((UpToken)object).token).addHeader(z[10], UserAgent.instance().getUa(((UpToken)object).accessKey)).post((RequestBody)object2).build();
        object = okHttpClient.newCall((Request)object).execute();
        try {
            bl = this.isOk((Response)object);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Response)object).body().close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        try {
            ((Response)object).body().close();
        }
        catch (Exception exception) {}
        return bl;
    }

    private boolean isOk(Response response) {
        return response.isSuccessful() && response.header(z[3]) != null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[11];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u00159\u0016\u000eJX4\u0013\u000eT\u001d6HG";
        int n3 = -1;
        block18: while (true) {
            char[] cArray;
            block23: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block22: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block22;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block23;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 120;
                                break;
                            }
                            case 1: {
                                n9 = 82;
                                break;
                            }
                            case 2: {
                                n9 = 114;
                                break;
                            }
                            case 3: {
                                n9 = 103;
                                break;
                            }
                            default: {
                                n9 = 56;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\n7\u0011\bJ\u001cu\u0001G\\\u0011 R\u000eKX<\u001d\u0013\u0018\u000b7\u0006\u0013]\u001c";
                    n3 = 0;
                    continue block18;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "X;\u0001GV\u0017&R\u0006\u0018\u001c;\u0000";
                    n3 = 1;
                    continue block18;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = " \u007f \u0002I\u00116";
                    n3 = 2;
                    continue block18;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "'#\u001b\tQ\r\r\u0000\u0002[\u0017 \u00168^\u0011>\u00178P\u000bg\b^T\u0017e\u0013\t@Ha";
                    n3 = 3;
                    continue block18;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0010&\u0006\u0017KB}]\u0012H\u0014=\u0015II\u001a=\nIU\u001d}\u001e\b_Wa";
                    n3 = 4;
                    continue block18;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "-\u00064J\u0000";
                    n3 = 5;
                    continue block18;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "9'\u0006\u000fW\n;\b\u0006L\u0011=\u001c";
                    n3 = 6;
                    continue block18;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\f7\n\u0013\u0017\b>\u0013\u000eV";
                    n3 = 7;
                    continue block18;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "-\"&\bS\u001d<R";
                    n3 = 8;
                    continue block18;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "-!\u0017\u0015\u001595\u0017\tL";
                    n3 = 9;
                    continue block18;
                }
                case 9: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        singleServer = null;
        httpClient = null;
    }

    public static abstract class RecordMsg {
        public abstract String toRecordMsg();
    }
}

