/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.qiniu.android.dns.local;

import cn.jmessage.support.qiniu.android.dns.DnsException;
import cn.jmessage.support.qiniu.android.dns.Record;
import cn.jmessage.support.qiniu.android.dns.util.BitSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.IDN;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;

public final class DnsMessage {
    private static final String[] z;

    public static byte[] buildQuery(String string, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        BitSet bitSet = new BitSet();
        bitSet.set(8);
        try {
            dataOutputStream.writeShort((short)n2);
            dataOutputStream.writeShort((short)bitSet.value());
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
            dataOutputStream.flush();
            DnsMessage.writeQuestion(byteArrayOutputStream, string);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static void writeDomain(OutputStream outputStream, String stringArray) throws IOException {
        stringArray = stringArray.split(z[4]);
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte[] byArray = IDN.toASCII(stringArray[i2]).getBytes();
            outputStream.write(byArray.length);
            outputStream.write(byArray, 0, byArray.length);
        }
        outputStream.write(0);
    }

    private static void writeQuestion(OutputStream outputStream, String string) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        DnsMessage.writeDomain(outputStream, string);
        dataOutputStream.writeShort(1);
        dataOutputStream.writeShort(1);
    }

    public static Record[] parseResponse(byte[] byArray, int n2, String string) throws IOException {
        InputStream inputStream = new ByteArrayInputStream(byArray);
        int n3 = ((DataInputStream)(inputStream = new DataInputStream(inputStream))).readUnsignedShort();
        if (n3 != n2) {
            throw new DnsException(string, z[0] + n3 + z[1] + n2);
        }
        n2 = ((DataInputStream)inputStream).readUnsignedShort();
        n3 = (n2 >> 8 & 1) == 1 ? 1 : 0;
        if (!((n2 >> 7 & 1) == 1) || n3 == 0) {
            throw new DnsException(string, z[2]);
        }
        n2 = ((DataInputStream)inputStream).readUnsignedShort();
        int n4 = ((DataInputStream)inputStream).readUnsignedShort();
        ((DataInputStream)inputStream).readUnsignedShort();
        ((DataInputStream)inputStream).readUnsignedShort();
        DnsMessage.readQuestions((DataInputStream)inputStream, byArray, n2);
        return DnsMessage.readAnswers((DataInputStream)inputStream, byArray, n4);
    }

    private static String readName(DataInputStream object, byte[] byArray) throws IOException {
        int n2 = ((DataInputStream)object).readUnsignedByte();
        if ((n2 & 0xC0) == 192) {
            n2 = ((n2 & 0x3F) << 8) + ((DataInputStream)object).readUnsignedByte();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(n2);
            return DnsMessage.readName(byArray, n2, hashSet);
        }
        if (n2 == 0) {
            return "";
        }
        byte[] byArray2 = new byte[n2];
        ((DataInputStream)object).readFully(byArray2);
        String string = IDN.toUnicode(new String(byArray2));
        object = DnsMessage.readName((DataInputStream)object, byArray);
        if (((String)object).length() > 0) {
            string = string + "." + (String)object;
        }
        return string;
    }

    private static String readName(byte[] object, int n2, HashSet<Integer> hashSet) throws IOException {
        int n3;
        while (((n3 = object[n2] & 0xFF) & 0xC0) == 192) {
            if (hashSet.contains(n3 = ((n3 & 0x3F) << 8) + (object[n2 + 1] & 0xFF))) {
                throw new DnsException("", z[5]);
            }
            hashSet.add(n3);
            n2 = n3;
        }
        if (n3 == 0) {
            return "";
        }
        String string = new String((byte[])object, n2 + 1, n3);
        String string2 = DnsMessage.readName(object, n2 + 1 + n3, hashSet);
        object = string2;
        if (string2.length() > 0) {
            string = string + "." + (String)object;
        }
        return string;
    }

    private static void readQuestions(DataInputStream dataInputStream, byte[] byArray, int n2) throws IOException {
        while (n2-- > 0) {
            DnsMessage.readName(dataInputStream, byArray);
            dataInputStream.readUnsignedShort();
            dataInputStream.readUnsignedShort();
        }
    }

    private static Record[] readAnswers(DataInputStream dataInputStream, byte[] byArray, int n2) throws IOException {
        int n3 = 0;
        Record[] recordArray = new Record[n2];
        while (n2-- > 0) {
            recordArray[n3++] = DnsMessage.readRecord(dataInputStream, byArray);
        }
        return recordArray;
    }

    private static Record readRecord(DataInputStream dataInputStream, byte[] object) throws IOException {
        DnsMessage.readName(dataInputStream, object);
        int n2 = dataInputStream.readUnsignedShort();
        dataInputStream.readUnsignedShort();
        long l2 = ((long)dataInputStream.readUnsignedShort() << 16) + (long)dataInputStream.readUnsignedShort();
        int n3 = dataInputStream.readUnsignedShort();
        switch (n2) {
            case 1: {
                object = new byte[4];
                dataInputStream.readFully((byte[])object);
                object = InetAddress.getByAddress(object).getHostAddress();
                break;
            }
            case 5: {
                object = DnsMessage.readName(dataInputStream, object);
                break;
            }
            default: {
                object = null;
                for (int i2 = 0; i2 < n3; ++i2) {
                    dataInputStream.readByte();
                }
            }
        }
        if (object == null) {
            throw new UnknownHostException(z[3]);
        }
        return new Record((String)object, n2, (int)l2, System.currentTimeMillis() / 1000L);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "_pkMKEky\bX\u000bqjM";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 43;
                                break;
                            }
                            case 1: {
                                n9 = 24;
                                break;
                            }
                            case 2: {
                                n9 = 14;
                                break;
                            }
                            case 3: {
                                n9 = 109;
                                break;
                            }
                            default: {
                                n9 = 42;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u000bq}MDDl.\u0000K_{fM";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "_pkMNEk.\u001eOYnk\u001f\nHy`\u0019\nXm~\u001dEYl.\u001fOHm|\u001eCDv.";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "Ew.\u001fOHw|\t";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "p6\u300c\uff63\uff4bv";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "ham\u0001CH8a\u000bLX}z\u001e\nO}z\bI_}jC";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

