/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.qiniu.android.dns.local;

import cn.jmessage.support.qiniu.android.dns.Domain;
import cn.jmessage.support.qiniu.android.dns.IResolver;
import cn.jmessage.support.qiniu.android.dns.NetworkInfo;
import cn.jmessage.support.qiniu.android.dns.Record;
import cn.jmessage.support.qiniu.android.dns.local.DnshijackingException;
import cn.jmessage.support.qiniu.android.dns.local.Resolver;
import java.io.IOException;

public final class HijackingDetectWrapper
implements IResolver {
    private final Resolver resolver;

    public HijackingDetectWrapper(Resolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public final Record[] resolve(Domain domain, NetworkInfo recordArray) throws IOException {
        int n2;
        recordArray = this.resolver.resolve(domain, (NetworkInfo)recordArray);
        if (domain.hasCname) {
            boolean bl = false;
            Record[] recordArray2 = recordArray;
            n2 = recordArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!recordArray2[i2].isCname()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new DnshijackingException(domain.domain, this.resolver.address.getHostAddress());
            }
        }
        if (domain.maxTtl != 0) {
            Record[] recordArray3 = recordArray;
            int n3 = recordArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Record record = recordArray3[n2];
                if (record.isCname() || record.ttl <= domain.maxTtl) continue;
                throw new DnshijackingException(domain.domain, this.resolver.address.getHostAddress(), record.ttl);
            }
        }
        return recordArray;
    }
}

