/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.qiniu.android.http;

import cn.jmessage.support.okhttp3.MediaType;
import cn.jmessage.support.okhttp3.RequestBody;
import cn.jmessage.support.okio.Buffer;
import cn.jmessage.support.okio.BufferedSink;
import cn.jmessage.support.okio.ForwardingSink;
import cn.jmessage.support.okio.Okio;
import cn.jmessage.support.okio.Sink;
import cn.jmessage.support.qiniu.android.http.CancellationHandler;
import cn.jmessage.support.qiniu.android.http.ProgressHandler;
import cn.jmessage.support.qiniu.android.utils.AsyncRun;
import java.io.IOException;

public final class CountingRequestBody
extends RequestBody {
    private static final int SEGMENT_SIZE = 2048;
    private final RequestBody body;
    private final ProgressHandler progress;
    private final long totalSize;
    private final CancellationHandler cancellationHandler;

    public CountingRequestBody(RequestBody requestBody, ProgressHandler progressHandler, long l2, CancellationHandler cancellationHandler) {
        this.body = requestBody;
        this.progress = progressHandler;
        this.totalSize = l2;
        this.cancellationHandler = cancellationHandler;
    }

    @Override
    public final long contentLength() throws IOException {
        return this.body.contentLength();
    }

    @Override
    public final MediaType contentType() {
        return this.body.contentType();
    }

    @Override
    public final void writeTo(BufferedSink bufferedSink) throws IOException {
        bufferedSink = Okio.buffer(new CountingSink(bufferedSink));
        this.body.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    protected final class CountingSink
    extends ForwardingSink {
        private int bytesWritten;

        public CountingSink(Sink sink) {
            super(sink);
            this.bytesWritten = 0;
        }

        @Override
        public final void write(Buffer buffer, long l2) throws IOException {
            if (CountingRequestBody.this.cancellationHandler == null && CountingRequestBody.this.progress == null) {
                super.write(buffer, l2);
                return;
            }
            if (CountingRequestBody.this.cancellationHandler != null && CountingRequestBody.this.cancellationHandler.isCancelled()) {
                throw new CancellationHandler.CancellationException();
            }
            super.write(buffer, l2);
            this.bytesWritten = (int)((long)this.bytesWritten + l2);
            if (CountingRequestBody.this.progress != null) {
                AsyncRun.runInMain(new Runnable(){

                    @Override
                    public void run() {
                        CountingRequestBody.this.progress.onProgress(CountingSink.this.bytesWritten, CountingRequestBody.this.totalSize);
                    }
                });
            }
        }
    }
}

