/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.qiniu.android.storage;

import cn.jmessage.support.qiniu.android.common.AutoZone;
import cn.jmessage.support.qiniu.android.common.Zone;
import cn.jmessage.support.qiniu.android.dns.DnsManager;
import cn.jmessage.support.qiniu.android.dns.Domain;
import cn.jmessage.support.qiniu.android.dns.IResolver;
import cn.jmessage.support.qiniu.android.dns.NetworkInfo;
import cn.jmessage.support.qiniu.android.dns.local.AndroidDnsServer;
import cn.jmessage.support.qiniu.android.dns.local.Resolver;
import cn.jmessage.support.qiniu.android.http.Dns;
import cn.jmessage.support.qiniu.android.http.ProxyConfiguration;
import cn.jmessage.support.qiniu.android.http.UrlConverter;
import cn.jmessage.support.qiniu.android.storage.KeyGenerator;
import cn.jmessage.support.qiniu.android.storage.Recorder;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Configuration {
    public static final int BLOCK_SIZE = 0x400000;
    public final Recorder recorder;
    public final KeyGenerator keyGen;
    public final ProxyConfiguration proxy;
    public final int chunkSize;
    public final int putThreshold;
    public final int connectTimeout;
    public final int responseTimeout;
    public final int retryMax;
    public UrlConverter urlConverter;
    public Dns dns;
    public Zone zone;
    public boolean useHttps;

    private Configuration(Builder builder) {
        this.useHttps = builder.useHttps;
        this.chunkSize = builder.chunkSize;
        this.putThreshold = builder.putThreshold;
        this.connectTimeout = builder.connectTimeout;
        this.responseTimeout = builder.responseTimeout;
        this.recorder = builder.recorder;
        this.keyGen = this.getKeyGen(builder.keyGen);
        this.retryMax = builder.retryMax;
        this.proxy = builder.proxy;
        this.urlConverter = builder.urlConverter;
        this.zone = builder.zone == null ? AutoZone.autoZone : builder.zone;
        this.dns = builder.dns;
    }

    private KeyGenerator getKeyGen(KeyGenerator keyGenerator) {
        if (keyGenerator == null) {
            keyGenerator = new KeyGenerator(){
                private static final String z;

                @Override
                public String gen(String string, File file) {
                    return string + z + new StringBuffer(file.getAbsolutePath()).reverse();
                }

                /*
                 * Handled impossible loop by duplicating code
                 * Enabled aggressive block sorting
                 */
                static {
                    char[] cArray;
                    block10: {
                        int n2;
                        int n3;
                        char[] cArray2;
                        int n4;
                        block9: {
                            char[] cArray3 = "?OJ".toCharArray();
                            n4 = 0;
                            int n5 = cArray3.length;
                            cArray2 = cArray3;
                            n3 = n5;
                            if (n5 <= 1) break block9;
                            cArray = cArray2;
                            n2 = n3;
                            if (n3 <= n4) break block10;
                        }
                        do {
                            char[] cArray4 = cArray2;
                            char[] cArray5 = cArray2;
                            int n6 = n4;
                            while (true) {
                                int n7;
                                char c2 = cArray4[n6];
                                switch (n4 % 5) {
                                    case 0: {
                                        n7 = 96;
                                        break;
                                    }
                                    case 1: {
                                        n7 = 97;
                                        break;
                                    }
                                    case 2: {
                                        n7 = 21;
                                        break;
                                    }
                                    case 3: {
                                        n7 = 46;
                                        break;
                                    }
                                    default: {
                                        n7 = 74;
                                    }
                                }
                                cArray4[n6] = (char)(c2 ^ n7);
                                ++n4;
                                cArray2 = cArray5;
                                n3 = n3;
                                if (n3 != 0) break;
                                cArray5 = cArray2;
                                n2 = n3;
                                n6 = n3;
                                cArray4 = cArray2;
                            }
                            cArray = cArray2;
                            n2 = n3;
                        } while (n3 > n4);
                    }
                    z = new String(cArray).intern();
                }
            };
        }
        return keyGenerator;
    }

    public static class Builder {
        private Zone zone = null;
        private Recorder recorder = null;
        private KeyGenerator keyGen = null;
        private ProxyConfiguration proxy = null;
        private boolean useHttps = true;
        private int chunkSize = 0x200000;
        private int putThreshold = 0x400000;
        private int connectTimeout = 10;
        private int responseTimeout = 60;
        private int retryMax = 3;
        private UrlConverter urlConverter = null;
        private Dns dns = null;
        private static final String z;

        public Builder() {
            this.buildDefaultDns();
        }

        private void buildDefaultDns() {
            Object object = AndroidDnsServer.defaultResolver();
            Resolver resolver = null;
            try {
                resolver = new Resolver(InetAddress.getByName(z));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            object = new DnsManager(NetworkInfo.normal, new IResolver[]{object, resolver});
            this.dns = new Dns((DnsManager)object){
                final /* synthetic */ DnsManager val$happlyDns;
                private static final String z;
                {
                    this.val$happlyDns = dnsManager;
                }

                @Override
                public List<InetAddress> lookup(String arrayList) throws UnknownHostException {
                    InetAddress[] inetAddressArray;
                    try {
                        inetAddressArray = this.val$happlyDns.queryInetAdress(new Domain((String)((Object)arrayList)));
                    }
                    catch (IOException iOException) {
                        arrayList = iOException;
                        iOException.printStackTrace();
                        throw new UnknownHostException(((Throwable)((Object)arrayList)).getMessage());
                    }
                    if (inetAddressArray == null) {
                        throw new UnknownHostException(arrayList + z);
                    }
                    arrayList = new ArrayList<InetAddress>();
                    Collections.addAll(arrayList, inetAddressArray);
                    return arrayList;
                }

                /*
                 * Handled impossible loop by duplicating code
                 * Enabled aggressive block sorting
                 */
                static {
                    char[] cArray;
                    block10: {
                        int n2;
                        int n3;
                        char[] cArray2;
                        int n4;
                        block9: {
                            char[] cArray3 = "ChzXr\u000flz\u000b{\u0002ssNyM".toCharArray();
                            n4 = 0;
                            int n5 = cArray3.length;
                            cArray2 = cArray3;
                            n3 = n5;
                            if (n5 <= 1) break block9;
                            cArray = cArray2;
                            n2 = n3;
                            if (n3 <= n4) break block10;
                        }
                        do {
                            char[] cArray4 = cArray2;
                            char[] cArray5 = cArray2;
                            int n6 = n4;
                            while (true) {
                                int n7;
                                char c2 = cArray4[n6];
                                switch (n4 % 5) {
                                    case 0: {
                                        n7 = 99;
                                        break;
                                    }
                                    case 1: {
                                        n7 = 26;
                                        break;
                                    }
                                    case 2: {
                                        n7 = 31;
                                        break;
                                    }
                                    case 3: {
                                        n7 = 43;
                                        break;
                                    }
                                    default: {
                                        n7 = 29;
                                    }
                                }
                                cArray4[n6] = (char)(c2 ^ n7);
                                ++n4;
                                cArray2 = cArray5;
                                n3 = n3;
                                if (n3 != 0) break;
                                cArray5 = cArray2;
                                n2 = n3;
                                n6 = n3;
                                cArray4 = cArray2;
                            }
                            cArray = cArray2;
                            n2 = n3;
                        } while (n3 > n4);
                    }
                    z = new String(cArray).intern();
                }
            };
        }

        public Builder zone(Zone zone) {
            this.zone = zone;
            return this;
        }

        public Builder recorder(Recorder recorder) {
            this.recorder = recorder;
            return this;
        }

        public Builder recorder(Recorder recorder, KeyGenerator keyGenerator) {
            this.recorder = recorder;
            this.keyGen = keyGenerator;
            return this;
        }

        public Builder proxy(ProxyConfiguration proxyConfiguration) {
            this.proxy = proxyConfiguration;
            return this;
        }

        public Builder chunkSize(int n2) {
            this.chunkSize = n2;
            return this;
        }

        public Builder putThreshhold(int n2) {
            this.putThreshold = n2;
            return this;
        }

        public Builder connectTimeout(int n2) {
            this.connectTimeout = n2;
            return this;
        }

        public Builder responseTimeout(int n2) {
            this.responseTimeout = n2;
            return this;
        }

        public Builder retryMax(int n2) {
            this.retryMax = n2;
            return this;
        }

        public Builder urlConverter(UrlConverter urlConverter) {
            this.urlConverter = urlConverter;
            return this;
        }

        public Builder dns(Dns dns) {
            this.dns = dns;
            return this;
        }

        public Builder useHttps(boolean bl) {
            this.useHttps = bl;
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = ";a$\u0017r3~/\u0000n8i".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 10;
                                break;
                            }
                            case 1: {
                                n7 = 80;
                                break;
                            }
                            case 2: {
                                n7 = 29;
                                break;
                            }
                            case 3: {
                                n7 = 57;
                                break;
                            }
                            default: {
                                n7 = 64;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    }
}

