/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.qiniu.android.storage;

import cn.jmessage.support.qiniu.android.http.Client;
import cn.jmessage.support.qiniu.android.http.CompletionHandler;
import cn.jmessage.support.qiniu.android.http.ProgressHandler;
import cn.jmessage.support.qiniu.android.http.ResponseInfo;
import cn.jmessage.support.qiniu.android.storage.Configuration;
import cn.jmessage.support.qiniu.android.storage.UpCancellationSignal;
import cn.jmessage.support.qiniu.android.storage.UpCompletionHandler;
import cn.jmessage.support.qiniu.android.storage.UpToken;
import cn.jmessage.support.qiniu.android.storage.UploadOptions;
import cn.jmessage.support.qiniu.android.utils.AndroidNetwork;
import cn.jmessage.support.qiniu.android.utils.Crc32;
import cn.jmessage.support.qiniu.android.utils.StringMap;
import cn.jmessage.support.qiniu.android.utils.StringUtils;
import cn.jmessage.support.qiniu.android.utils.UrlSafeBase64;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

final class ResumeUploader
implements Runnable {
    private final long totalSize;
    private final String key;
    private final UpCompletionHandler completionHandler;
    private final UploadOptions options;
    private final Client client;
    private final Configuration config;
    private final byte[] chunkBuffer;
    private final String[] contexts;
    private final StringMap headers;
    private final long modifyTime;
    private final String recorderKey;
    private RandomAccessFile file;
    private File f;
    private long crc32;
    private UpToken token;
    private static final String[] z;

    ResumeUploader(Client client, Configuration configuration, File file, String string, UpToken upToken, final UpCompletionHandler upCompletionHandler, UploadOptions uploadOptions, String string2) {
        this.client = client;
        this.config = configuration;
        this.f = file;
        this.recorderKey = string2;
        this.totalSize = file.length();
        this.key = string;
        this.headers = new StringMap().put(z[15], z[14] + upToken.token);
        this.file = null;
        this.completionHandler = new UpCompletionHandler(){

            @Override
            public void complete(String string, ResponseInfo responseInfo, JSONObject jSONObject) {
                if (ResumeUploader.this.file != null) {
                    try {
                        ResumeUploader.this.file.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                upCompletionHandler.complete(string, responseInfo, jSONObject);
            }
        };
        this.options = uploadOptions != null ? uploadOptions : UploadOptions.defaultOptions();
        this.chunkBuffer = new byte[configuration.chunkSize];
        long l2 = (this.totalSize + 0x400000L - 1L) / 0x400000L;
        this.contexts = new String[(int)l2];
        this.modifyTime = file.lastModified();
        this.token = upToken;
    }

    private static boolean isChunkOK(ResponseInfo responseInfo, JSONObject jSONObject) {
        return responseInfo.statusCode == 200 && responseInfo.error == null && (responseInfo.hasReqId() || ResumeUploader.isChunkResOK(jSONObject));
    }

    private static boolean isChunkResOK(JSONObject jSONObject) {
        try {
            jSONObject.getString(z[7]);
            jSONObject.getLong(z[6]);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static boolean isNotChunkToQiniu(ResponseInfo responseInfo, JSONObject jSONObject) {
        return responseInfo.statusCode < 500 && responseInfo.statusCode >= 200 && !responseInfo.hasReqId() && !ResumeUploader.isChunkResOK(jSONObject);
    }

    @Override
    public final void run() {
        long l2 = this.recoveryFromRecord();
        try {
            this.file = new RandomAccessFile(this.f, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            fileNotFoundException.printStackTrace();
            this.completionHandler.complete(this.key, ResponseInfo.fileError(fileNotFoundException2, this.token), null);
            return;
        }
        this.nextTask(l2, 0, this.config.zone.upHost(this.token.token, this.config.useHttps, null));
    }

    private void makeBlock(String string, long l2, int n2, int n3, ProgressHandler progressHandler, CompletionHandler completionHandler, UpCancellationSignal upCancellationSignal) {
        String string2 = String.format(Locale.ENGLISH, z[9], n2);
        try {
            this.file.seek(l2);
            this.file.read(this.chunkBuffer, 0, n3);
        }
        catch (IOException iOException) {
            this.completionHandler.complete(this.key, ResponseInfo.fileError(iOException, this.token), null);
            return;
        }
        this.crc32 = Crc32.bytes(this.chunkBuffer, 0, n3);
        string = String.format(z[1], string, string2);
        this.post(string, this.chunkBuffer, 0, n3, progressHandler, completionHandler, upCancellationSignal);
    }

    private void putChunk(String string, long l2, int n2, String string2, ProgressHandler progressHandler, CompletionHandler completionHandler, UpCancellationSignal upCancellationSignal) {
        int n3 = (int)(l2 % 0x400000L);
        string2 = String.format(Locale.ENGLISH, z[8], string2, n3);
        try {
            this.file.seek(l2);
            this.file.read(this.chunkBuffer, 0, n2);
        }
        catch (IOException iOException) {
            this.completionHandler.complete(this.key, ResponseInfo.fileError(iOException, this.token), null);
            return;
        }
        this.crc32 = Crc32.bytes(this.chunkBuffer, 0, n2);
        string = String.format(z[1], string, string2);
        this.post(string, this.chunkBuffer, 0, n2, progressHandler, completionHandler, upCancellationSignal);
    }

    private void makeFile(String string, CompletionHandler completionHandler, UpCancellationSignal upCancellationSignal) {
        String string2 = String.format(Locale.ENGLISH, z[3], UrlSafeBase64.encodeToString(this.options.mimeType), UrlSafeBase64.encodeToString(this.f.getName()));
        String string3 = "";
        if (this.key != null) {
            string3 = String.format(z[5], UrlSafeBase64.encodeToString(this.key));
        }
        Object object2 = "";
        if (this.options.params.size() != 0) {
            object2 = new String[this.options.params.size()];
            int n2 = 0;
            for (Map.Entry<String, String> object3 : this.options.params.entrySet()) {
                object2[n2++] = String.format(Locale.ENGLISH, z[4], object3.getKey(), UrlSafeBase64.encodeToString(object3.getValue()));
            }
            object2 = "/" + StringUtils.join(object2, "/");
        }
        object2 = String.format(Locale.ENGLISH, z[2], this.totalSize, string2, string3, object2);
        Object object4 = StringUtils.join(this.contexts, ",").getBytes();
        String string4 = String.format(z[1], string, object2);
        this.post(string4, (byte[])object4, 0, ((Object)object4).length, null, completionHandler, upCancellationSignal);
    }

    private void post(String string, byte[] byArray, int n2, int n3, ProgressHandler progressHandler, CompletionHandler completionHandler, UpCancellationSignal upCancellationSignal) {
        this.client.asyncPost(string, byArray, n2, n3, this.headers, this.token, this.totalSize, progressHandler, completionHandler, upCancellationSignal);
    }

    private long calcPutSize(long l2) {
        long l3 = this.totalSize - l2;
        if (l3 < (long)this.config.chunkSize) {
            return l3;
        }
        return this.config.chunkSize;
    }

    private long calcBlockSize(long l2) {
        long l3 = this.totalSize - l2;
        if (l3 < 0x400000L) {
            return l3;
        }
        return 0x400000L;
    }

    private boolean isCancelled() {
        return this.options.cancellationSignal.isCancelled();
    }

    private void nextTask(final long l2, final int n2, final String string) {
        if (this.isCancelled()) {
            ResponseInfo responseInfo = ResponseInfo.cancelled(this.token);
            this.completionHandler.complete(this.key, responseInfo, null);
            return;
        }
        if (l2 == this.totalSize) {
            CompletionHandler completionHandler = new CompletionHandler(){

                @Override
                public void complete(ResponseInfo responseInfo, JSONObject jSONObject) {
                    String string2;
                    if (responseInfo.isNetworkBroken() && !AndroidNetwork.isNetWorkReady()) {
                        ((ResumeUploader)ResumeUploader.this).options.netReadyHandler.waitReady();
                        if (!AndroidNetwork.isNetWorkReady()) {
                            ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, responseInfo, jSONObject);
                            return;
                        }
                    }
                    if (responseInfo.isOK()) {
                        ResumeUploader.this.removeRecord();
                        ((ResumeUploader)ResumeUploader.this).options.progressHandler.progress(ResumeUploader.this.key, 1.0);
                        ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, responseInfo, jSONObject);
                        return;
                    }
                    if (responseInfo.needRetry() && n2 < ((ResumeUploader)ResumeUploader.this).config.retryMax + 1 && (string2 = ((ResumeUploader)ResumeUploader.this).config.zone.upHost(((ResumeUploader)ResumeUploader.this).token.token, ((ResumeUploader)ResumeUploader.this).config.useHttps, string)) != null) {
                        ResumeUploader.this.nextTask(l2, n2 + 1, string2);
                        return;
                    }
                    ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, responseInfo, jSONObject);
                }
            };
            this.makeFile(string, completionHandler, this.options.cancellationSignal);
            return;
        }
        final int n3 = (int)this.calcPutSize(l2);
        ProgressHandler progressHandler = new ProgressHandler(){

            @Override
            public void onProgress(long l22, long l3) {
                double d2;
                double d3 = (double)(l2 + l22) / (double)l3;
                if (d2 > 0.95) {
                    d3 = 0.95;
                }
                ((ResumeUploader)ResumeUploader.this).options.progressHandler.progress(ResumeUploader.this.key, d3);
            }
        };
        CompletionHandler completionHandler = new CompletionHandler(){
            private static final String[] z;

            @Override
            public void complete(ResponseInfo object, JSONObject jSONObject) {
                if (((ResponseInfo)object).isNetworkBroken() && !AndroidNetwork.isNetWorkReady()) {
                    ((ResumeUploader)ResumeUploader.this).options.netReadyHandler.waitReady();
                    if (!AndroidNetwork.isNetWorkReady()) {
                        ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, (ResponseInfo)object, jSONObject);
                        return;
                    }
                }
                if (((ResponseInfo)object).isCancelled()) {
                    ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, (ResponseInfo)object, jSONObject);
                    return;
                }
                if (!ResumeUploader.isChunkOK((ResponseInfo)object, jSONObject)) {
                    String string3 = ((ResumeUploader)ResumeUploader.this).config.zone.upHost(((ResumeUploader)ResumeUploader.this).token.token, ((ResumeUploader)ResumeUploader.this).config.useHttps, string);
                    if (((ResponseInfo)object).statusCode == 701 && n2 < ((ResumeUploader)ResumeUploader.this).config.retryMax) {
                        ResumeUploader.this.nextTask(l2 / 0x400000L * 0x400000L, n2 + 1, string);
                        return;
                    }
                    if (string3 != null && (ResumeUploader.isNotChunkToQiniu((ResponseInfo)object, jSONObject) || ((ResponseInfo)object).needRetry()) && n2 < ((ResumeUploader)ResumeUploader.this).config.retryMax) {
                        ResumeUploader.this.nextTask(l2, n2 + 1, string3);
                        return;
                    }
                    ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, (ResponseInfo)object, jSONObject);
                    return;
                }
                String string4 = null;
                if (jSONObject == null && n2 < ((ResumeUploader)ResumeUploader.this).config.retryMax) {
                    String string2 = ((ResumeUploader)ResumeUploader.this).config.zone.upHost(((ResumeUploader)ResumeUploader.this).token.token, ((ResumeUploader)ResumeUploader.this).config.useHttps, string);
                    ResumeUploader.this.nextTask(l2, n2 + 1, string2);
                    return;
                }
                long l22 = 0L;
                try {
                    string4 = jSONObject.getString(z[1]);
                    l22 = jSONObject.getLong(z[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if ((string4 == null || l22 != ResumeUploader.this.crc32) && n2 < ((ResumeUploader)ResumeUploader.this).config.retryMax) {
                    object = ((ResumeUploader)ResumeUploader.this).config.zone.upHost(((ResumeUploader)ResumeUploader.this).token.token, ((ResumeUploader)ResumeUploader.this).config.useHttps, string);
                    ResumeUploader.this.nextTask(l2, n2 + 1, (String)object);
                    return;
                }
                ((ResumeUploader)ResumeUploader.this).contexts[(int)(l2 / 0x400000L)] = string4;
                ResumeUploader.this.record(l2 + (long)n3);
                ResumeUploader.this.nextTask(l2 + (long)n3, n2, string);
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                String string3;
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n22 = 0;
                String string2 = "}D\u0014\u001ex";
                int n32 = -1;
                block9: while (true) {
                    char[] cArray;
                    block14: {
                        int n4;
                        int n5;
                        char[] cArray2;
                        int n6;
                        block13: {
                            char[] cArray3 = string2.toCharArray();
                            n6 = 0;
                            int n7 = cArray3.length;
                            cArray2 = cArray3;
                            n5 = n7;
                            if (n7 <= 1) break block13;
                            cArray = cArray2;
                            n4 = n5;
                            if (n5 <= n6) break block14;
                        }
                        do {
                            char[] cArray4 = cArray2;
                            char[] cArray5 = cArray2;
                            int n8 = n6;
                            while (true) {
                                int n9;
                                char c2 = cArray4[n8];
                                switch (n6 % 5) {
                                    case 0: {
                                        n9 = 30;
                                        break;
                                    }
                                    case 1: {
                                        n9 = 54;
                                        break;
                                    }
                                    case 2: {
                                        n9 = 119;
                                        break;
                                    }
                                    case 3: {
                                        n9 = 45;
                                        break;
                                    }
                                    default: {
                                        n9 = 74;
                                    }
                                }
                                cArray4[n8] = (char)(c2 ^ n9);
                                ++n6;
                                cArray2 = cArray5;
                                n5 = n5;
                                if (n5 != 0) break;
                                cArray5 = cArray2;
                                n4 = n5;
                                n8 = n5;
                                cArray4 = cArray2;
                            }
                            cArray = cArray2;
                            n4 = n5;
                        } while (n5 > n6);
                    }
                    string3 = new String(cArray);
                    switch (n32) {
                        default: {
                            stringArray2[n22] = string3.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n22 = 1;
                            string2 = "}B\u000f";
                            n32 = 0;
                            continue block9;
                        }
                        case 0: 
                    }
                    break;
                }
                stringArray2[n22] = string3.intern();
                z = stringArray3;
            }
        };
        if (l2 % 0x400000L == 0L) {
            int n4 = (int)this.calcBlockSize(l2);
            this.makeBlock(string, l2, n4, n3, progressHandler, completionHandler, this.options.cancellationSignal);
            return;
        }
        String string2 = this.contexts[(int)(l2 / 0x400000L)];
        this.putChunk(string, l2, n3, string2, progressHandler, completionHandler, this.options.cancellationSignal);
    }

    private long recoveryFromRecord() {
        if (this.config.recorder == null) {
            return 0L;
        }
        Object object = this.config.recorder.get(this.recorderKey);
        if (object == null) {
            return 0L;
        }
        object = new String((byte[])object);
        try {
            object = new JSONObject((String)object);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return 0L;
        }
        long l2 = object.optLong(z[12], 0L);
        long l3 = object.optLong(z[10], 0L);
        long l4 = object.optLong(z[11], 0L);
        object = object.optJSONArray(z[13]);
        if (l2 == 0L || l3 != this.modifyTime || l4 != this.totalSize || object == null || object.length() == 0) {
            return 0L;
        }
        for (int i2 = 0; i2 < object.length(); ++i2) {
            this.contexts[i2] = object.optString(i2);
        }
        return l2;
    }

    private void removeRecord() {
        if (this.config.recorder != null) {
            this.config.recorder.del(this.recorderKey);
        }
    }

    private void record(long l2) {
        if (this.config.recorder == null || l2 == 0L) {
            return;
        }
        String string = String.format(Locale.ENGLISH, z[0], this.totalSize, l2, this.modifyTime, StringUtils.jsonJoin(this.contexts));
        this.config.recorder.set(this.recorderKey, string.getBytes());
    }

    private URI newURI(URI uRI, String string) {
        try {
            return new URI(uRI.getScheme(), null, uRI.getHost(), uRI.getPort(), string, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return uRI;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[16];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "& xWR8 1\u001bLq dXN.g\u007f\u001c\u0012xf'\u001e\n0moWN$]\u007fWE8 1\u001bLq\")]G3vnF\\. 1e\r._v";
        int n3 = -1;
        block23: while (true) {
            char[] cArray;
            block28: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block27: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block27;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block28;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 93;
                                break;
                            }
                            case 1: {
                                n9 = 2;
                                break;
                            }
                            case 2: {
                                n9 = 11;
                                break;
                            }
                            case 3: {
                                n9 = 62;
                                break;
                            }
                            default: {
                                n9 = 40;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "xq.M";
                    n3 = 0;
                    continue block23;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "ro`XA1g$\u001bLxq.M\r.";
                    n3 = 1;
                    continue block23;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "robSM\t{{[\u0007xq$XF<on\u0011\r.";
                    n3 = 2;
                    continue block23;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "xq$\u001b[";
                    n3 = 3;
                    continue block23;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "rinG\u0007xq";
                    n3 = 4;
                    continue block23;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = ">ph\r\u001a";
                    n3 = 5;
                    continue block23;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ">vs";
                    n3 = 6;
                    continue block23;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "r`{K\\r'x\u0011\r9";
                    n3 = 7;
                    continue block23;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "ro`\\D6-.Z";
                    n3 = 8;
                    continue block23;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "0moWN$]\u007fWE8";
                    n3 = 9;
                    continue block23;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = ".kq[";
                    n3 = 10;
                    continue block23;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "2dmMM)";
                    n3 = 11;
                    continue block23;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = ">meJM%vx";
                    n3 = 12;
                    continue block23;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\br_QC8l+";
                    n3 = 13;
                    continue block23;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u001cw\u007fVG/kq_\\4me";
                    n3 = 14;
                    continue block23;
                }
                case 14: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

