/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.im.android.eventbus;

import android.os.Looper;
import cn.jpush.im.android.e.j;
import cn.jpush.im.android.eventbus.AsyncPoster;
import cn.jpush.im.android.eventbus.BackgroundPoster;
import cn.jpush.im.android.eventbus.EventBusBuilder;
import cn.jpush.im.android.eventbus.EventBusException;
import cn.jpush.im.android.eventbus.HandlerPoster;
import cn.jpush.im.android.eventbus.NoSubscriberEvent;
import cn.jpush.im.android.eventbus.PendingPost;
import cn.jpush.im.android.eventbus.SubscriberExceptionEvent;
import cn.jpush.im.android.eventbus.SubscriberMethod;
import cn.jpush.im.android.eventbus.SubscriberMethodFinder;
import cn.jpush.im.android.eventbus.Subscription;
import cn.jpush.im.android.eventbus.ThreadMode;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;

public class EventBus {
    public static String TAG;
    static volatile EventBus defaultInstance;
    private static final EventBusBuilder DEFAULT_BUILDER;
    private static final Map<Class<?>, List<Class<?>>> eventTypesCache;
    private final Map<Class<?>, CopyOnWriteArrayList<Subscription>> subscriptionsByEventType;
    private final Map<Object, List<Class<?>>> typesBySubscriber;
    private final Map<Class<?>, Object> stickyEvents;
    private final ThreadLocal<PostingThreadState> currentPostingThreadState = new ThreadLocal<PostingThreadState>(){

        @Override
        protected PostingThreadState initialValue() {
            return new PostingThreadState();
        }
    };
    private final HandlerPoster mainThreadPoster;
    private final BackgroundPoster backgroundPoster;
    private final AsyncPoster asyncPoster;
    private final SubscriberMethodFinder subscriberMethodFinder;
    private final ExecutorService executorService;
    private final boolean throwSubscriberException;
    private final boolean logSubscriberExceptions;
    private final boolean logNoSubscriberMessages;
    private final boolean sendSubscriberExceptionEvent;
    private final boolean sendNoSubscriberEvent;
    private final boolean eventInheritance;
    private static final String[] z;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventBus getDefault() {
        if (defaultInstance != null) return defaultInstance;
        Class<EventBus> clazz = EventBus.class;
        synchronized (EventBus.class) {
            if (defaultInstance != null) return defaultInstance;
            defaultInstance = new EventBus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }

    public static EventBusBuilder builder() {
        return new EventBusBuilder();
    }

    public static void clearCaches() {
        SubscriberMethodFinder.clearCaches();
        eventTypesCache.clear();
    }

    public EventBus() {
        this(DEFAULT_BUILDER);
    }

    EventBus(EventBusBuilder eventBusBuilder) {
        this.subscriptionsByEventType = new HashMap();
        this.typesBySubscriber = new HashMap();
        this.stickyEvents = new ConcurrentHashMap();
        this.mainThreadPoster = new HandlerPoster(this, Looper.getMainLooper(), 10);
        this.backgroundPoster = new BackgroundPoster(this);
        this.asyncPoster = new AsyncPoster(this);
        this.subscriberMethodFinder = new SubscriberMethodFinder(eventBusBuilder.skipMethodVerificationForClasses);
        this.logSubscriberExceptions = eventBusBuilder.logSubscriberExceptions;
        this.logNoSubscriberMessages = eventBusBuilder.logNoSubscriberMessages;
        this.sendSubscriberExceptionEvent = eventBusBuilder.sendSubscriberExceptionEvent;
        this.sendNoSubscriberEvent = eventBusBuilder.sendNoSubscriberEvent;
        this.throwSubscriberException = eventBusBuilder.throwSubscriberException;
        this.eventInheritance = eventBusBuilder.eventInheritance;
        this.executorService = eventBusBuilder.executorService;
    }

    public void register(Object object) {
        this.register(object, false, 0);
    }

    public void register(Object object, int n2) {
        this.register(object, false, n2);
    }

    public void registerSticky(Object object) {
        this.register(object, true, 0);
    }

    public void registerSticky(Object object, int n2) {
        this.register(object, true, n2);
    }

    private synchronized void register(Object object, boolean bl, int n2) {
        for (SubscriberMethod subscriberMethod : this.subscriberMethodFinder.findSubscriberMethods(object.getClass())) {
            this.subscribe(object, subscriberMethod, bl, n2);
        }
    }

    private void subscribe(Object object, SubscriberMethod object2, boolean bl, int n2) {
        List<Class<?>> list;
        int n3;
        Class<?> clazz = ((SubscriberMethod)object2).eventType;
        CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.subscriptionsByEventType.get(clazz);
        object2 = new Subscription(object, (SubscriberMethod)object2, n3);
        if (copyOnWriteArrayList == null) {
            copyOnWriteArrayList = new CopyOnWriteArrayList();
            this.subscriptionsByEventType.put(clazz, copyOnWriteArrayList);
        } else if (copyOnWriteArrayList.contains(object2)) {
            throw new EventBusException(z[1] + object.getClass() + z[0] + clazz);
        }
        n3 = copyOnWriteArrayList.size();
        for (int i2 = 0; i2 <= n3; ++i2) {
            if (i2 != n3 && ((Subscription)object2).priority <= copyOnWriteArrayList.get((int)i2).priority) continue;
            copyOnWriteArrayList.add(i2, (Subscription)object2);
            break;
        }
        if ((list = this.typesBySubscriber.get(object)) == null) {
            list = new ArrayList();
            this.typesBySubscriber.put(object, list);
        }
        list.add(clazz);
        if (bl) {
            if (this.eventInheritance) {
                for (Map.Entry entry : this.stickyEvents.entrySet()) {
                    Class clazz2 = (Class)entry.getKey();
                    if (!clazz.isAssignableFrom(clazz2)) continue;
                    Object v2 = entry.getValue();
                    this.checkPostStickyEventToSubscription((Subscription)object2, v2);
                }
                return;
            }
            object = this.stickyEvents.get(clazz);
            this.checkPostStickyEventToSubscription((Subscription)object2, object);
        }
    }

    private void checkPostStickyEventToSubscription(Subscription subscription, Object object) {
        if (object != null) {
            this.postToSubscription(subscription, object, Looper.getMainLooper() == Looper.myLooper());
        }
    }

    public synchronized boolean isRegistered(Object object) {
        return this.typesBySubscriber.containsKey(object);
    }

    private void unubscribeByEventType(Object object, Class<?> object2) {
        if ((object2 = (List)this.subscriptionsByEventType.get(object2)) != null) {
            int n2 = object2.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Subscription subscription = (Subscription)object2.get(i2);
                if (subscription.subscriber != object) continue;
                subscription.active = false;
                object2.remove(i2);
                --i2;
                --n2;
            }
        }
    }

    public synchronized void unregister(Object object) {
        List<Class<?>> list = this.typesBySubscriber.get(object);
        if (list != null) {
            for (Class clazz : list) {
                this.unubscribeByEventType(object, clazz);
            }
            this.typesBySubscriber.remove(object);
            return;
        }
        j.g(TAG, z[12] + object.getClass());
    }

    public void post(Object object) {
        PostingThreadState postingThreadState = this.currentPostingThreadState.get();
        List<Object> list = postingThreadState.eventQueue;
        list.add(object);
        if (!postingThreadState.isPosting) {
            postingThreadState.isMainThread = Looper.getMainLooper() == Looper.myLooper();
            postingThreadState.isPosting = true;
            if (postingThreadState.canceled) {
                throw new EventBusException(z[2]);
            }
            try {
                while (!list.isEmpty()) {
                    this.postSingleEvent(list.remove(0), postingThreadState);
                }
                return;
            }
            finally {
                postingThreadState.isPosting = false;
                postingThreadState.isMainThread = false;
            }
        }
    }

    public void cancelEventDelivery(Object object) {
        PostingThreadState postingThreadState = this.currentPostingThreadState.get();
        if (!postingThreadState.isPosting) {
            throw new EventBusException(z[16]);
        }
        if (object == null) {
            throw new EventBusException(z[17]);
        }
        if (postingThreadState.event != object) {
            throw new EventBusException(z[14]);
        }
        if (postingThreadState.subscription.subscriberMethod.threadMode != ThreadMode.PostThread) {
            throw new EventBusException(z[15]);
        }
        postingThreadState.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSticky(Object object) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            this.stickyEvents.put(object.getClass(), object);
        }
        this.post(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getStickyEvent(Class<T> clazz) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            return clazz.cast(this.stickyEvents.get(clazz));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T removeStickyEvent(Class<T> clazz) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            return clazz.cast(this.stickyEvents.remove(clazz));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStickyEvent(Object object) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            Class<?> clazz = object.getClass();
            Object object2 = this.stickyEvents.get(clazz);
            if (object.equals(object2)) {
                this.stickyEvents.remove(clazz);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllStickyEvents() {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            this.stickyEvents.clear();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubscriberForEvent(Class<?> object) {
        if ((object = this.lookupAllEventTypes((Class<?>)object)) != null) {
            int n2 = object.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Serializable serializable = (Class)object.get(i2);
                EventBus eventBus = this;
                synchronized (eventBus) {
                    serializable = this.subscriptionsByEventType.get(serializable);
                }
                if (serializable == null || ((CopyOnWriteArrayList)serializable).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private void postSingleEvent(Object object, PostingThreadState postingThreadState) throws Error {
        Class<?> clazz = object.getClass();
        boolean bl = false;
        if (this.eventInheritance) {
            List<Class<?>> list = this.lookupAllEventTypes(clazz);
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Class<?> clazz2 = list.get(i2);
                bl |= this.postSingleEventForEventType(object, postingThreadState, clazz2);
            }
        } else {
            bl = this.postSingleEventForEventType(object, postingThreadState, clazz);
        }
        if (!bl) {
            if (this.logNoSubscriberMessages) {
                j.c(TAG, z[11] + clazz);
            }
            if (this.sendNoSubscriberEvent && clazz != NoSubscriberEvent.class && clazz != SubscriberExceptionEvent.class) {
                this.post(new NoSubscriberEvent(this, object));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean postSingleEventForEventType(Object object, PostingThreadState postingThreadState, Class<?> serializable) {
        Object object2 = this;
        synchronized (object2) {
            serializable = this.subscriptionsByEventType.get(serializable);
        }
        if (serializable != null && !((CopyOnWriteArrayList)serializable).isEmpty()) {
            object2 = ((CopyOnWriteArrayList)serializable).iterator();
            while (object2.hasNext()) {
                boolean bl;
                Subscription subscription = (Subscription)object2.next();
                postingThreadState.event = object;
                postingThreadState.subscription = subscription;
                try {
                    this.postToSubscription(subscription, object, postingThreadState.isMainThread);
                    bl = postingThreadState.canceled;
                }
                finally {
                    postingThreadState.event = null;
                    postingThreadState.subscription = null;
                    postingThreadState.canceled = false;
                }
                if (!bl) continue;
            }
            return true;
        }
        return false;
    }

    private void postToSubscription(Subscription subscription, Object object, boolean bl) {
        switch (subscription.subscriberMethod.threadMode) {
            case PostThread: {
                this.invokeSubscriber(subscription, object);
                return;
            }
            case MainThread: {
                if (bl) {
                    this.invokeSubscriber(subscription, object);
                    return;
                }
                this.mainThreadPoster.enqueue(subscription, object);
                return;
            }
            case BackgroundThread: {
                if (bl) {
                    this.backgroundPoster.enqueue(subscription, object);
                    return;
                }
                this.invokeSubscriber(subscription, object);
                return;
            }
            case Async: {
                this.asyncPoster.enqueue(subscription, object);
                return;
            }
        }
        throw new IllegalStateException(z[10] + (Object)((Object)subscription.subscriberMethod.threadMode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Class<?>> lookupAllEventTypes(Class<?> clazz) {
        Map<Class<?>, List<Class<?>>> map = eventTypesCache;
        synchronized (map) {
            List<Class<?>> list = eventTypesCache.get(clazz);
            if (list == null) {
                list = new ArrayList();
                for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                    list.add(clazz2);
                    EventBus.addInterfaces(list, clazz2.getInterfaces());
                }
                eventTypesCache.put(clazz, list);
            }
            return list;
        }
    }

    static void addInterfaces(List<Class<?>> list, Class<?>[] classArray) {
        for (Class<?> clazz : classArray) {
            if (list.contains(clazz)) continue;
            list.add(clazz);
            EventBus.addInterfaces(list, clazz.getInterfaces());
        }
    }

    void invokeSubscriber(PendingPost pendingPost) {
        Object object = pendingPost.event;
        Subscription subscription = pendingPost.subscription;
        PendingPost.releasePendingPost(pendingPost);
        if (subscription.active) {
            this.invokeSubscriber(subscription, object);
        }
    }

    void invokeSubscriber(Subscription subscription, Object object) {
        try {
            subscription.subscriberMethod.method.invoke(subscription.subscriber, object);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleSubscriberException(subscription, object, invocationTargetException.getCause());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(z[13], illegalAccessException);
        }
    }

    private void handleSubscriberException(Subscription object, Object object2, Throwable throwable) {
        if (object2 instanceof SubscriberExceptionEvent) {
            if (this.logSubscriberExceptions) {
                j.d(TAG, z[5] + ((Subscription)object).subscriber.getClass() + z[8], throwable);
                object = (SubscriberExceptionEvent)object2;
                j.d(TAG, z[4] + ((SubscriberExceptionEvent)object).causingEvent + z[3] + ((SubscriberExceptionEvent)object).causingSubscriber, ((SubscriberExceptionEvent)object).throwable);
                return;
            }
        } else {
            if (this.throwSubscriberException) {
                throw new EventBusException(z[7], throwable);
            }
            if (this.logSubscriberExceptions) {
                j.d(TAG, z[6] + object2.getClass() + z[9] + ((Subscription)object).subscriber.getClass(), throwable);
            }
            if (this.sendSubscriberExceptionEvent) {
                object = new SubscriberExceptionEvent(this, throwable, object2, ((Subscription)object).subscriber);
                this.post(object);
            }
        }
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block41: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block40: {
                String string;
                String[] stringArray = new String[18];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n5 = 0;
                String string2 = "{J|3\":Oia5>Ly23>Yu%g/D0$1>Eda";
                int n6 = -1;
                block31: while (true) {
                    char[] cArray3;
                    block39: {
                        int n7;
                        int n8;
                        char[] cArray4;
                        block38: {
                            char[] cArray5 = string2.toCharArray();
                            n4 = 0;
                            int n9 = cArray5.length;
                            cArray4 = cArray5;
                            n8 = n9;
                            if (n9 <= 1) break block38;
                            cArray3 = cArray4;
                            n7 = n8;
                            if (n8 <= n4) break block39;
                        }
                        do {
                            char[] cArray6 = cArray4;
                            char[] cArray7 = cArray4;
                            int n10 = n4;
                            while (true) {
                                int n11;
                                char c2 = cArray6[n10];
                                switch (n4 % 5) {
                                    case 0: {
                                        n11 = 91;
                                        break;
                                    }
                                    case 1: {
                                        n11 = 43;
                                        break;
                                    }
                                    case 2: {
                                        n11 = 16;
                                        break;
                                    }
                                    case 3: {
                                        n11 = 65;
                                        break;
                                    }
                                    default: {
                                        n11 = 71;
                                    }
                                }
                                cArray6[n10] = (char)(c2 ^ n11);
                                ++n4;
                                cArray4 = cArray7;
                                n8 = n8;
                                if (n8 != 0) break;
                                cArray7 = cArray4;
                                n7 = n8;
                                n10 = n8;
                                cArray6 = cArray4;
                            }
                            cArray3 = cArray4;
                            n7 = n8;
                        } while (n8 > n4);
                    }
                    string = new String(cArray3);
                    switch (n6) {
                        default: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 1;
                            string2 = "\b^r2$)Br$5{";
                            n6 = 0;
                            continue block31;
                        }
                        case 0: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 2;
                            string2 = "\u0012Ed$55J|a\")Y\u007f3i{jr.5/\u000bc5&/N06&(\u000b~.3{Yu2\"/";
                            n6 = 1;
                            continue block31;
                        }
                        case 1: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 3;
                            string2 = "{Hq44>O0$?8N`5.4E0(){";
                            n6 = 2;
                            continue block31;
                        }
                        case 2: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 4;
                            string2 = "\u0012Ey5.:G0$1>Eda";
                            n6 = 3;
                            continue block31;
                        }
                        case 3: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 5;
                            string2 = "\b^r2$)Br$5\u001eSs$7/B\u007f/\u0002-N~5g(^r2$)Br$5{";
                            n6 = 4;
                            continue block31;
                        }
                        case 4: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 6;
                            string2 = "\u0018De-#{E\u007f5g?Bc1&/Hxa\"-N~5}{";
                            n6 = 5;
                            continue block31;
                        }
                        case 5: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 7;
                            string2 = "\u0012Ef.,2Ewa4.Ic\"52Iu3g=Jy-\"?";
                            n6 = 6;
                            continue block31;
                        }
                        case 6: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 8;
                            string2 = "{_x3\",\u000bq/g>Ss$7/B\u007f/";
                            n6 = 7;
                            continue block31;
                        }
                        case 7: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 9;
                            string2 = "{_\u007fa4.Ic\"52Iy/ {H| 4(\u000b";
                            n6 = 8;
                            continue block31;
                        }
                        case 8: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 10;
                            string2 = "\u000eE{/(,E05/)Nq%g6Dt$}{";
                            n6 = 9;
                            continue block31;
                        }
                        case 9: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 11;
                            string2 = "\u0015D0229Xs3.9Nb2g)Nw(4/Nb$#{M\u007f3g>]u/3{";
                            n6 = 10;
                            continue block31;
                        }
                        case 10: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 12;
                            string2 = "\b^r2$)Br$5{_\u007fa25Yu&.(_u3g,Jca)4_03\"<Bc5\")Nta%>M\u007f3\"a\u000b";
                            n6 = 11;
                            continue block31;
                        }
                        case 11: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 13;
                            string2 = "\u000eEu97>Hd$#{Nh\"\"+_y.)";
                            n6 = 12;
                            continue block31;
                        }
                        case 12: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 14;
                            string2 = "\u0014E|8g/Cua$.Yb$)/Gia/:Et-\"?\u000bu7\"5_0,&\"\u000br$g:I\u007f33>O";
                            n6 = 13;
                            continue block31;
                        }
                        case 13: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 15;
                            string2 = "{Nf$)/\u000bx )?Gu34{Fq8g4E|8g:I\u007f33{_x$g2Es.*2Ewa\"-N~5";
                            n6 = 14;
                            continue block31;
                        }
                        case 14: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 16;
                            string2 = "\u000fCy2g6Nd)(?\u000b} >{D~->{Iua$:G|$#{Mb.*{B~2.?N0$1>Eda/:Et-.5L0,\"/C\u007f%4{D~a33N01((_y/ {_x3\":O";
                            n6 = 15;
                            continue block31;
                        }
                        case 15: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 17;
                            string2 = "\u001e]u/3{Fq8g5Dda%>\u000b~4+7";
                            n6 = 16;
                            continue block31;
                        }
                        case 16: 
                    }
                    break;
                }
                stringArray2[n5] = string.intern();
                z = stringArray3;
                char[] cArray8 = "\u001e]u/3".toCharArray();
                n4 = 0;
                int n12 = cArray8.length;
                cArray2 = cArray8;
                n3 = n12;
                if (n12 <= 1) break block40;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block41;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n13 = n4;
                while (true) {
                    int n14;
                    char c3 = cArray9[n13];
                    switch (n4 % 5) {
                        case 0: {
                            n14 = 91;
                            break;
                        }
                        case 1: {
                            n14 = 43;
                            break;
                        }
                        case 2: {
                            n14 = 16;
                            break;
                        }
                        case 3: {
                            n14 = 65;
                            break;
                        }
                        default: {
                            n14 = 71;
                        }
                    }
                    cArray9[n13] = (char)(c3 ^ n14);
                    ++n4;
                    cArray2 = cArray10;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray10 = cArray2;
                    n2 = n3;
                    n13 = n3;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        TAG = new String(cArray).intern();
        DEFAULT_BUILDER = new EventBusBuilder();
        eventTypesCache = new HashMap();
    }

    static interface PostCallback {
        public void onPostCompleted(List<SubscriberExceptionEvent> var1);
    }

    static final class PostingThreadState {
        final List<Object> eventQueue = new ArrayList<Object>();
        boolean isPosting;
        boolean isMainThread;
        Subscription subscription;
        Object event;
        boolean canceled;

        PostingThreadState() {
        }
    }
}

