/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush;

import com.google.gson.jpush.JsonElement;
import com.google.gson.jpush.internal.$Gson$Preconditions;
import com.google.gson.jpush.internal.LazilyParsedNumber;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class JsonPrimitive
extends JsonElement {
    private static final Class<?>[] PRIMITIVE_TYPES = new Class[]{Integer.TYPE, Long.TYPE, Short.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE, Boolean.TYPE, Character.TYPE, Integer.class, Long.class, Short.class, Float.class, Double.class, Byte.class, Boolean.class, Character.class};
    private Object value;

    public JsonPrimitive(Boolean bl) {
        this.setValue(bl);
    }

    public JsonPrimitive(Number number) {
        this.setValue(number);
    }

    public JsonPrimitive(String string) {
        this.setValue(string);
    }

    public JsonPrimitive(Character c2) {
        this.setValue(c2);
    }

    JsonPrimitive(Object object) {
        this.setValue(object);
    }

    @Override
    final JsonPrimitive deepCopy() {
        return this;
    }

    final void setValue(Object object) {
        if (object instanceof Character) {
            char c2 = ((Character)object).charValue();
            this.value = String.valueOf(c2);
            return;
        }
        $Gson$Preconditions.checkArgument(object instanceof Number || JsonPrimitive.isPrimitiveOrString(object));
        this.value = object;
    }

    public final boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    @Override
    final Boolean getAsBooleanWrapper() {
        return (Boolean)this.value;
    }

    @Override
    public final boolean getAsBoolean() {
        if (this.isBoolean()) {
            return this.getAsBooleanWrapper();
        }
        return Boolean.parseBoolean(this.getAsString());
    }

    public final boolean isNumber() {
        return this.value instanceof Number;
    }

    @Override
    public final Number getAsNumber() {
        if (this.value instanceof String) {
            return new LazilyParsedNumber((String)this.value);
        }
        return (Number)this.value;
    }

    public final boolean isString() {
        return this.value instanceof String;
    }

    @Override
    public final String getAsString() {
        if (this.isNumber()) {
            return this.getAsNumber().toString();
        }
        if (this.isBoolean()) {
            return this.getAsBooleanWrapper().toString();
        }
        return (String)this.value;
    }

    @Override
    public final double getAsDouble() {
        if (this.isNumber()) {
            return this.getAsNumber().doubleValue();
        }
        return Double.parseDouble(this.getAsString());
    }

    @Override
    public final BigDecimal getAsBigDecimal() {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        return new BigDecimal(this.value.toString());
    }

    @Override
    public final BigInteger getAsBigInteger() {
        if (this.value instanceof BigInteger) {
            return (BigInteger)this.value;
        }
        return new BigInteger(this.value.toString());
    }

    @Override
    public final float getAsFloat() {
        if (this.isNumber()) {
            return this.getAsNumber().floatValue();
        }
        return Float.parseFloat(this.getAsString());
    }

    @Override
    public final long getAsLong() {
        if (this.isNumber()) {
            return this.getAsNumber().longValue();
        }
        return Long.parseLong(this.getAsString());
    }

    @Override
    public final short getAsShort() {
        if (this.isNumber()) {
            return this.getAsNumber().shortValue();
        }
        return Short.parseShort(this.getAsString());
    }

    @Override
    public final int getAsInt() {
        if (this.isNumber()) {
            return this.getAsNumber().intValue();
        }
        return Integer.parseInt(this.getAsString());
    }

    @Override
    public final byte getAsByte() {
        if (this.isNumber()) {
            return this.getAsNumber().byteValue();
        }
        return Byte.parseByte(this.getAsString());
    }

    @Override
    public final char getAsCharacter() {
        return this.getAsString().charAt(0);
    }

    private static boolean isPrimitiveOrString(Object clazz) {
        if (clazz instanceof String) {
            return true;
        }
        clazz = clazz.getClass();
        Class<?>[] classArray = PRIMITIVE_TYPES;
        int n2 = PRIMITIVE_TYPES.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!classArray[i2].isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public final int hashCode() {
        if (this.value == null) {
            return 31;
        }
        if (JsonPrimitive.isIntegral(this)) {
            long l2 = this.getAsNumber().longValue();
            return (int)(l2 ^ l2 >>> 32);
        }
        if (this.value instanceof Number) {
            long l3 = Double.doubleToLongBits(this.getAsNumber().doubleValue());
            return (int)(l3 ^ l3 >>> 32);
        }
        return this.value.hashCode();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (JsonPrimitive)object;
        if (this.value == null) {
            return ((JsonPrimitive)object).value == null;
        }
        if (JsonPrimitive.isIntegral(this) && JsonPrimitive.isIntegral((JsonPrimitive)object)) {
            return this.getAsNumber().longValue() == ((JsonPrimitive)object).getAsNumber().longValue();
        }
        if (this.value instanceof Number && ((JsonPrimitive)object).value instanceof Number) {
            double d2;
            double d3 = this.getAsNumber().doubleValue();
            return d3 == (d2 = ((JsonPrimitive)object).getAsNumber().doubleValue()) || Double.isNaN(d3) && Double.isNaN(d2);
        }
        return this.value.equals(((JsonPrimitive)object).value);
    }

    private static boolean isIntegral(JsonPrimitive object) {
        if (((JsonPrimitive)object).value instanceof Number) {
            object = (Number)((JsonPrimitive)object).value;
            return object instanceof BigInteger || object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte;
        }
        return false;
    }
}

