/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush.internal.bind;

import com.google.gson.jpush.JsonArray;
import com.google.gson.jpush.JsonElement;
import com.google.gson.jpush.JsonNull;
import com.google.gson.jpush.JsonObject;
import com.google.gson.jpush.JsonPrimitive;
import com.google.gson.jpush.stream.JsonReader;
import com.google.gson.jpush.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class JsonTreeReader
extends JsonReader {
    private static final Reader UNREADABLE_READER;
    private static final Object SENTINEL_CLOSED;
    private final List<Object> stack = new ArrayList<Object>();
    private static final String[] z;

    public JsonTreeReader(JsonElement jsonElement) {
        super(UNREADABLE_READER);
        this.stack.add(jsonElement);
    }

    @Override
    public final void beginArray() throws IOException {
        this.expect(JsonToken.BEGIN_ARRAY);
        JsonArray jsonArray = (JsonArray)this.peekStack();
        this.stack.add(jsonArray.iterator());
    }

    @Override
    public final void endArray() throws IOException {
        this.expect(JsonToken.END_ARRAY);
        this.popStack();
        this.popStack();
    }

    @Override
    public final void beginObject() throws IOException {
        this.expect(JsonToken.BEGIN_OBJECT);
        JsonObject jsonObject = (JsonObject)this.peekStack();
        this.stack.add(jsonObject.entrySet().iterator());
    }

    @Override
    public final void endObject() throws IOException {
        this.expect(JsonToken.END_OBJECT);
        this.popStack();
        this.popStack();
    }

    @Override
    public final boolean hasNext() throws IOException {
        JsonToken jsonToken = this.peek();
        return jsonToken != JsonToken.END_OBJECT && jsonToken != JsonToken.END_ARRAY;
    }

    @Override
    public final JsonToken peek() throws IOException {
        Object object;
        block12: {
            boolean bl;
            while (true) {
                if (this.stack.isEmpty()) {
                    return JsonToken.END_DOCUMENT;
                }
                object = this.peekStack();
                if (!(object instanceof Iterator)) break block12;
                bl = this.stack.get(this.stack.size() - 2) instanceof JsonObject;
                if (!(object = (Iterator)object).hasNext()) break;
                if (bl) {
                    return JsonToken.NAME;
                }
                this.stack.add(object.next());
            }
            if (bl) {
                return JsonToken.END_OBJECT;
            }
            return JsonToken.END_ARRAY;
        }
        if (object instanceof JsonObject) {
            return JsonToken.BEGIN_OBJECT;
        }
        if (object instanceof JsonArray) {
            return JsonToken.BEGIN_ARRAY;
        }
        if (object instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)object;
            if (jsonPrimitive.isString()) {
                return JsonToken.STRING;
            }
            if (jsonPrimitive.isBoolean()) {
                return JsonToken.BOOLEAN;
            }
            if (jsonPrimitive.isNumber()) {
                return JsonToken.NUMBER;
            }
            throw new AssertionError();
        }
        if (object instanceof JsonNull) {
            return JsonToken.NULL;
        }
        if (object == SENTINEL_CLOSED) {
            throw new IllegalStateException(z[3]);
        }
        throw new AssertionError();
    }

    private Object peekStack() {
        return this.stack.get(this.stack.size() - 1);
    }

    private Object popStack() {
        return this.stack.remove(this.stack.size() - 1);
    }

    private void expect(JsonToken jsonToken) throws IOException {
        if (this.peek() != jsonToken) {
            throw new IllegalStateException(z[0] + (Object)((Object)jsonToken) + z[1] + (Object)((Object)this.peek()));
        }
    }

    @Override
    public final String nextName() throws IOException {
        this.expect(JsonToken.NAME);
        Map.Entry entry = (Map.Entry)((Iterator)this.peekStack()).next();
        this.stack.add(entry.getValue());
        return (String)entry.getKey();
    }

    @Override
    public final String nextString() throws IOException {
        JsonToken jsonToken = this.peek();
        if (jsonToken != JsonToken.STRING && jsonToken != JsonToken.NUMBER) {
            throw new IllegalStateException(z[0] + (Object)((Object)JsonToken.STRING) + z[1] + (Object)((Object)jsonToken));
        }
        return ((JsonPrimitive)this.popStack()).getAsString();
    }

    @Override
    public final boolean nextBoolean() throws IOException {
        this.expect(JsonToken.BOOLEAN);
        return ((JsonPrimitive)this.popStack()).getAsBoolean();
    }

    @Override
    public final void nextNull() throws IOException {
        this.expect(JsonToken.NULL);
        this.popStack();
    }

    @Override
    public final double nextDouble() throws IOException {
        JsonToken jsonToken = this.peek();
        if (jsonToken != JsonToken.NUMBER && jsonToken != JsonToken.STRING) {
            throw new IllegalStateException(z[0] + (Object)((Object)JsonToken.NUMBER) + z[1] + (Object)((Object)jsonToken));
        }
        double d2 = ((JsonPrimitive)this.peekStack()).getAsDouble();
        if (!this.isLenient() && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            throw new NumberFormatException(z[2] + d2);
        }
        this.popStack();
        return d2;
    }

    @Override
    public final long nextLong() throws IOException {
        JsonToken jsonToken = this.peek();
        if (jsonToken != JsonToken.NUMBER && jsonToken != JsonToken.STRING) {
            throw new IllegalStateException(z[0] + (Object)((Object)JsonToken.NUMBER) + z[1] + (Object)((Object)jsonToken));
        }
        long l2 = ((JsonPrimitive)this.peekStack()).getAsLong();
        this.popStack();
        return l2;
    }

    @Override
    public final int nextInt() throws IOException {
        JsonToken jsonToken = this.peek();
        if (jsonToken != JsonToken.NUMBER && jsonToken != JsonToken.STRING) {
            throw new IllegalStateException(z[0] + (Object)((Object)JsonToken.NUMBER) + z[1] + (Object)((Object)jsonToken));
        }
        int n2 = ((JsonPrimitive)this.peekStack()).getAsInt();
        this.popStack();
        return n2;
    }

    @Override
    public final void close() throws IOException {
        this.stack.clear();
        this.stack.add(SENTINEL_CLOSED);
    }

    @Override
    public final void skipValue() throws IOException {
        if (this.peek() == JsonToken.NAME) {
            this.nextName();
            return;
        }
        this.popStack();
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName();
    }

    public final void promoteNameToValue() throws IOException {
        this.expect(JsonToken.NAME);
        Map.Entry entry = (Map.Entry)((Iterator)this.peekStack()).next();
        this.stack.add(entry.getValue());
        this.stack.add(new JsonPrimitive((String)entry.getKey()));
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "D]<\u0013\u0014u@(V";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 1;
                                break;
                            }
                            case 1: {
                                n9 = 37;
                                break;
                            }
                            case 2: {
                                n9 = 76;
                                break;
                            }
                            case 3: {
                                n9 = 118;
                                break;
                            }
                            default: {
                                n9 = 119;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "!G9\u0002WvD?V";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "Kv\u00038WgJ>\u0014\u001eeVl8\u0016O\u0005-\u0018\u0013!L\"\u0010\u001eoL8\u001f\u0012r\u001fl";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "KV#\u0018%dD(\u0013\u0005!L?V\u0014mJ?\u0013\u0013";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        UNREADABLE_READER = new Reader(){

            @Override
            public final int read(char[] cArray, int n2, int n3) throws IOException {
                throw new AssertionError();
            }

            @Override
            public final void close() throws IOException {
                throw new AssertionError();
            }
        };
        SENTINEL_CLOSED = new Object();
    }
}

