/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush.internal.bind;

import com.google.gson.jpush.JsonArray;
import com.google.gson.jpush.JsonElement;
import com.google.gson.jpush.JsonNull;
import com.google.gson.jpush.JsonObject;
import com.google.gson.jpush.JsonPrimitive;
import com.google.gson.jpush.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class JsonTreeWriter
extends JsonWriter {
    private static final Writer UNWRITABLE_WRITER;
    private static final JsonPrimitive SENTINEL_CLOSED;
    private final List<JsonElement> stack = new ArrayList<JsonElement>();
    private String pendingName;
    private JsonElement product = JsonNull.INSTANCE;
    private static final String[] z;

    public JsonTreeWriter() {
        super(UNWRITABLE_WRITER);
    }

    public final JsonElement get() {
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException(z[2] + this.stack);
        }
        return this.product;
    }

    private JsonElement peek() {
        return this.stack.get(this.stack.size() - 1);
    }

    private void put(JsonElement jsonElement) {
        if (this.pendingName != null) {
            if (!jsonElement.isJsonNull() || this.getSerializeNulls()) {
                ((JsonObject)this.peek()).add(this.pendingName, jsonElement);
            }
            this.pendingName = null;
            return;
        }
        if (this.stack.isEmpty()) {
            this.product = jsonElement;
            return;
        }
        JsonElement jsonElement2 = this.peek();
        if (jsonElement2 instanceof JsonArray) {
            ((JsonArray)jsonElement2).add(jsonElement);
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public final JsonWriter beginArray() throws IOException {
        JsonArray jsonArray = new JsonArray();
        this.put(jsonArray);
        this.stack.add(jsonArray);
        return this;
    }

    @Override
    public final JsonWriter endArray() throws IOException {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        if (this.peek() instanceof JsonArray) {
            this.stack.remove(this.stack.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public final JsonWriter beginObject() throws IOException {
        JsonObject jsonObject = new JsonObject();
        this.put(jsonObject);
        this.stack.add(jsonObject);
        return this;
    }

    @Override
    public final JsonWriter endObject() throws IOException {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        if (this.peek() instanceof JsonObject) {
            this.stack.remove(this.stack.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public final JsonWriter name(String string) throws IOException {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        if (this.peek() instanceof JsonObject) {
            this.pendingName = string;
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public final JsonWriter value(String string) throws IOException {
        if (string == null) {
            return this.nullValue();
        }
        this.put(new JsonPrimitive(string));
        return this;
    }

    @Override
    public final JsonWriter nullValue() throws IOException {
        this.put(JsonNull.INSTANCE);
        return this;
    }

    @Override
    public final JsonWriter value(boolean bl) throws IOException {
        this.put(new JsonPrimitive(bl));
        return this;
    }

    @Override
    public final JsonWriter value(double d2) throws IOException {
        if (!this.isLenient() && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            throw new IllegalArgumentException(z[0] + d2);
        }
        this.put(new JsonPrimitive(d2));
        return this;
    }

    @Override
    public final JsonWriter value(long l2) throws IOException {
        this.put(new JsonPrimitive(l2));
        return this;
    }

    @Override
    public final JsonWriter value(Number number) throws IOException {
        double d2;
        if (number == null) {
            return this.nullValue();
        }
        if (!this.isLenient() && (Double.isNaN(d2 = number.doubleValue()) || Double.isInfinite(d2))) {
            throw new IllegalArgumentException(z[0] + number);
        }
        this.put(new JsonPrimitive(number));
        return this;
    }

    @Override
    public final void flush() throws IOException {
    }

    @Override
    public final void close() throws IOException {
        if (!this.stack.isEmpty()) {
            throw new IOException(z[1]);
        }
        this.stack.add(SENTINEL_CLOSED);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u001d\"st\"1\u001eNXk3\u0002\u001ctc\u0019Q]Tfw\u0018R\\k9\u0018HSg$K\u001c";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 87;
                                break;
                            }
                            case 1: {
                                n9 = 113;
                                break;
                            }
                            case 2: {
                                n9 = 60;
                                break;
                            }
                            case 3: {
                                n9 = 58;
                                break;
                            }
                            default: {
                                n9 = 2;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u001e\u001f_Uo'\u001dYNgw\u0015SYw:\u0014RN";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0012\tL_a#\u0014X\u001am9\u0014\u001cpQ\u0018?\u001c_n2\u001cYTvw\u0013IN\" \u0010O\u001a";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "4\u001dSIg3";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        UNWRITABLE_WRITER = new Writer(){

            @Override
            public final void write(char[] cArray, int n2, int n3) {
                throw new AssertionError();
            }

            @Override
            public final void flush() throws IOException {
                throw new AssertionError();
            }

            @Override
            public final void close() throws IOException {
                throw new AssertionError();
            }
        };
        SENTINEL_CLOSED = new JsonPrimitive(z[3]);
    }
}

