/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush.internal.bind;

import com.google.gson.jpush.FieldNamingStrategy;
import com.google.gson.jpush.Gson;
import com.google.gson.jpush.JsonSyntaxException;
import com.google.gson.jpush.TypeAdapter;
import com.google.gson.jpush.TypeAdapterFactory;
import com.google.gson.jpush.annotations.JsonAdapter;
import com.google.gson.jpush.annotations.SerializedName;
import com.google.gson.jpush.internal.$Gson$Types;
import com.google.gson.jpush.internal.ConstructorConstructor;
import com.google.gson.jpush.internal.Excluder;
import com.google.gson.jpush.internal.ObjectConstructor;
import com.google.gson.jpush.internal.Primitives;
import com.google.gson.jpush.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.jpush.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.jpush.reflect.TypeToken;
import com.google.gson.jpush.stream.JsonReader;
import com.google.gson.jpush.stream.JsonToken;
import com.google.gson.jpush.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final Excluder excluder;
    private static final String z;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingStrategy, Excluder excluder) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingStrategy;
        this.excluder = excluder;
    }

    public final boolean excludeField(Field field, boolean bl) {
        return ReflectiveTypeAdapterFactory.excludeField(field, bl, this.excluder);
    }

    static boolean excludeField(Field field, boolean bl, Excluder excluder) {
        return !excluder.excludeClass(field.getType(), bl) && !excluder.excludeField(field, bl);
    }

    private List<String> getFieldNames(Field field) {
        return ReflectiveTypeAdapterFactory.getFieldName(this.fieldNamingPolicy, field);
    }

    static List<String> getFieldName(FieldNamingStrategy stringArray, Field field) {
        SerializedName serializedName = field.getAnnotation(SerializedName.class);
        LinkedList<String> linkedList = new LinkedList<String>();
        if (serializedName == null) {
            linkedList.add(stringArray.translateName(field));
        } else {
            linkedList.add(serializedName.value());
            for (String string : serializedName.alternate()) {
                linkedList.add(string);
            }
        }
        return linkedList;
    }

    @Override
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Class<T> clazz = typeToken.getRawType();
        if (!Object.class.isAssignableFrom(clazz)) {
            return null;
        }
        ObjectConstructor<T> objectConstructor = this.constructorConstructor.get(typeToken);
        return new Adapter(objectConstructor, this.getBoundFields(gson, typeToken, clazz));
    }

    private BoundField createBoundField(final Gson gson, final Field field, String string, final TypeToken<?> typeToken, boolean bl, boolean bl2) {
        final boolean bl3 = Primitives.isPrimitive(typeToken.getRawType());
        return new BoundField(string, bl, bl2){
            final TypeAdapter<?> typeAdapter;
            {
                super(string, bl, bl2);
                this.typeAdapter = ReflectiveTypeAdapterFactory.this.getFieldAdapter(gson, field, typeToken);
            }

            @Override
            void write(JsonWriter jsonWriter, Object object) throws IOException, IllegalAccessException {
                object = field.get(object);
                ((TypeAdapter)new TypeAdapterRuntimeTypeWrapper(gson, this.typeAdapter, typeToken.getType())).write(jsonWriter, object);
            }

            @Override
            void read(JsonReader jsonReader, Object object) throws IOException, IllegalAccessException {
                if ((jsonReader = this.typeAdapter.read(jsonReader)) != null || !bl3) {
                    field.set(object, jsonReader);
                }
            }

            @Override
            public boolean writeField(Object object) throws IOException, IllegalAccessException {
                if (!this.serialized) {
                    return false;
                }
                return field.get(object) != object;
            }
        };
    }

    private TypeAdapter<?> getFieldAdapter(Gson gson, Field typeAdapter, TypeToken<?> typeToken) {
        if ((typeAdapter = ((Field)((Object)typeAdapter)).getAnnotation(JsonAdapter.class)) != null && (typeAdapter = JsonAdapterAnnotationTypeAdapterFactory.getTypeAdapter(this.constructorConstructor, gson, typeToken, (JsonAdapter)((Object)typeAdapter))) != null) {
            return typeAdapter;
        }
        return gson.getAdapter(typeToken);
    }

    private Map<String, BoundField> getBoundFields(Gson gson, TypeToken<?> typeToken, Class<?> clazz) {
        LinkedHashMap<String, BoundField> linkedHashMap = new LinkedHashMap<String, BoundField>();
        if (clazz.isInterface()) {
            return linkedHashMap;
        }
        Type type = typeToken.getType();
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                boolean bl = this.excludeField(field, true);
                boolean bl2 = this.excludeField(field, false);
                if (!bl && !bl2) continue;
                field.setAccessible(true);
                Type type2 = $Gson$Types.resolve(typeToken.getType(), clazz, field.getGenericType());
                List<String> list = this.getFieldNames(field);
                Object object = null;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Object object2 = list.get(i2);
                    if (i2 != 0) {
                        bl = false;
                    }
                    BoundField boundField = this.createBoundField(gson, field, (String)object2, TypeToken.get(type2), bl, bl2);
                    object2 = linkedHashMap.put((String)object2, boundField);
                    if (object != null) continue;
                    object = object2;
                }
                if (object == null) continue;
                throw new IllegalArgumentException(type + z + ((BoundField)object).name);
            }
            typeToken = TypeToken.get($Gson$Types.resolve(typeToken.getType(), clazz, clazz.getGenericSuperclass()));
            clazz = typeToken.getRawType();
        }
        return linkedHashMap;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "`u\u001er\u001f!c\u001ebS-d\u0017e\u001a0}\u001e19\u0013^51\u0015)t\u0017u\u0000`\u007f\u001a|\u0016$1".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 64;
                            break;
                        }
                        case 1: {
                            n7 = 17;
                            break;
                        }
                        case 2: {
                            n7 = 123;
                            break;
                        }
                        case 3: {
                            n7 = 17;
                            break;
                        }
                        default: {
                            n7 = 115;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        z = new String(cArray).intern();
    }

    public static final class Adapter<T>
    extends TypeAdapter<T> {
        private final ObjectConstructor<T> constructor;
        private final Map<String, BoundField> boundFields;

        private Adapter(ObjectConstructor<T> objectConstructor, Map<String, BoundField> map) {
            this.constructor = objectConstructor;
            this.boundFields = map;
        }

        @Override
        public final T read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            T t2 = this.constructor.construct();
            try {
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    Object object = jsonReader.nextName();
                    if ((object = this.boundFields.get(object)) == null || !((BoundField)object).deserialized) {
                        jsonReader.skipValue();
                        continue;
                    }
                    ((BoundField)object).read(jsonReader, t2);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw new JsonSyntaxException(illegalStateException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            jsonReader.endObject();
            return t2;
        }

        @Override
        public final void write(JsonWriter jsonWriter, T t2) throws IOException {
            if (t2 == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            try {
                for (BoundField boundField : this.boundFields.values()) {
                    if (!boundField.writeField(t2)) continue;
                    jsonWriter.name(boundField.name);
                    boundField.write(jsonWriter, t2);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            jsonWriter.endObject();
        }
    }

    static abstract class BoundField {
        final String name;
        final boolean serialized;
        final boolean deserialized;

        protected BoundField(String string, boolean bl, boolean bl2) {
            this.name = string;
            this.serialized = bl;
            this.deserialized = bl2;
        }

        abstract boolean writeField(Object var1) throws IOException, IllegalAccessException;

        abstract void write(JsonWriter var1, Object var2) throws IOException, IllegalAccessException;

        abstract void read(JsonReader var1, Object var2) throws IOException, IllegalAccessException;
    }
}

