/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.jpush;

import com.google.protobuf.jpush.CodedInputStream;
import com.google.protobuf.jpush.CodedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;

public final class ByteString {
    private final byte[] bytes;
    public static final ByteString EMPTY;
    private volatile int hash = 0;
    private static final String[] z;

    private ByteString(byte[] byArray) {
        this.bytes = byArray;
    }

    public final byte byteAt(int n2) {
        return this.bytes[n2];
    }

    public final int size() {
        return this.bytes.length;
    }

    public final boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public static ByteString copyFrom(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return new ByteString(byArray2);
    }

    public static ByteString copyFrom(byte[] byArray) {
        return ByteString.copyFrom(byArray, 0, byArray.length);
    }

    public static ByteString copyFrom(ByteBuffer byteBuffer, int n2) {
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        return new ByteString(byArray);
    }

    public static ByteString copyFrom(ByteBuffer byteBuffer) {
        return ByteString.copyFrom(byteBuffer, byteBuffer.remaining());
    }

    public static ByteString copyFrom(String string, String string2) throws UnsupportedEncodingException {
        return new ByteString(string.getBytes(string2));
    }

    public static ByteString copyFromUtf8(String string) {
        try {
            return new ByteString(string.getBytes(z[1]));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(z[0], unsupportedEncodingException);
        }
    }

    public static ByteString copyFrom(List<ByteString> object) {
        if (object.size() == 0) {
            return EMPTY;
        }
        if (object.size() == 1) {
            return object.get(0);
        }
        int n2 = 0;
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            ByteString byteString = object2.next();
            n2 += byteString.size();
        }
        object2 = new byte[n2];
        int n3 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            ByteString byteString = (ByteString)object.next();
            System.arraycopy(byteString.bytes, 0, object2, n3, byteString.size());
            n3 += byteString.size();
        }
        return new ByteString((byte[])object2);
    }

    public final void copyTo(byte[] byArray, int n2) {
        System.arraycopy(this.bytes, 0, byArray, n2, this.bytes.length);
    }

    public final void copyTo(byte[] byArray, int n2, int n3, int n4) {
        System.arraycopy(this.bytes, n2, byArray, n3, n4);
    }

    public final void copyTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.bytes, 0, this.bytes.length);
    }

    public final byte[] toByteArray() {
        int n2 = this.bytes.length;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.bytes, 0, byArray, 0, n2);
        return byArray;
    }

    public final ByteBuffer asReadOnlyByteBuffer() {
        return ByteBuffer.wrap(this.bytes).asReadOnlyBuffer();
    }

    public final String toString(String string) throws UnsupportedEncodingException {
        return new String(this.bytes, string);
    }

    public final String toStringUtf8() {
        try {
            return new String(this.bytes, z[1]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(z[0], unsupportedEncodingException);
        }
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        object = (ByteString)object;
        int n2 = this.bytes.length;
        if (n2 != ((ByteString)object).bytes.length) {
            return false;
        }
        byte[] byArray = this.bytes;
        object = ((ByteString)object).bytes;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == object[i2]) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            int n3;
            byte[] byArray = this.bytes;
            n2 = n3 = this.bytes.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 = n2 * 31 + byArray[i2];
            }
            if (n2 == 0) {
                n2 = 1;
            }
            this.hash = n2;
        }
        return n2;
    }

    public final InputStream newInput() {
        return new ByteArrayInputStream(this.bytes);
    }

    public final CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.bytes);
    }

    public static Output newOutput(int n2) {
        return new Output(new ByteArrayOutputStream(n2));
    }

    public static Output newOutput() {
        return ByteString.newOutput(32);
    }

    static CodedBuilder newCodedBuilder(int n2) {
        return new CodedBuilder(n2);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\t\u0012'_\u000b|(\u000e\u0006\u0013/3\u0011\u0002\\.2\u0004\u0016\f";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 92;
                                break;
                            }
                            case 1: {
                                n9 = 70;
                                break;
                            }
                            case 2: {
                                n9 = 97;
                                break;
                            }
                            case 3: {
                                n9 = 114;
                                break;
                            }
                            default: {
                                n9 = 51;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\t\u0012'_\u000b";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        EMPTY = new ByteString(new byte[0]);
    }

    static final class CodedBuilder {
        private final CodedOutputStream output;
        private final byte[] buffer;

        private CodedBuilder(int n2) {
            this.buffer = new byte[n2];
            this.output = CodedOutputStream.newInstance(this.buffer);
        }

        public final ByteString build() {
            this.output.checkNoSpaceLeft();
            return new ByteString(this.buffer);
        }

        public final CodedOutputStream getCodedOutput() {
            return this.output;
        }
    }

    public static final class Output
    extends FilterOutputStream {
        private final ByteArrayOutputStream bout;

        private Output(ByteArrayOutputStream byteArrayOutputStream) {
            super(byteArrayOutputStream);
            this.bout = byteArrayOutputStream;
        }

        public final ByteString toByteString() {
            byte[] byArray = this.bout.toByteArray();
            return new ByteString(byArray);
        }
    }
}

