/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jpush.http.entity.mime;

import org.apache.jpush.http.entity.mime.Header;
import org.apache.jpush.http.entity.mime.MinimalField;
import org.apache.jpush.http.entity.mime.content.ContentBody;

public class FormBodyPart {
    private final String name;
    private final Header header;
    private final ContentBody body;
    private static final String[] z;

    public FormBodyPart(String string, ContentBody contentBody) {
        if (string == null) {
            throw new IllegalArgumentException(z[4]);
        }
        if (contentBody == null) {
            throw new IllegalArgumentException(z[3]);
        }
        this.name = string;
        this.body = contentBody;
        this.header = new Header();
        this.generateContentDisp(contentBody);
        this.generateContentType(contentBody);
        this.generateTransferEncoding(contentBody);
    }

    public String getName() {
        return this.name;
    }

    public ContentBody getBody() {
        return this.body;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addField(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException(z[2]);
        }
        this.header.addField(new MinimalField(string, string2));
    }

    protected void generateContentDisp(ContentBody contentBody) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(z[7]);
        stringBuilder.append(this.getName());
        stringBuilder.append("\"");
        if (contentBody.getFilename() != null) {
            stringBuilder.append(z[6]);
            stringBuilder.append(contentBody.getFilename());
            stringBuilder.append("\"");
        }
        this.addField(z[5], stringBuilder.toString());
    }

    protected void generateContentType(ContentBody contentBody) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(contentBody.getMimeType());
        if (contentBody.getCharset() != null) {
            stringBuilder.append(z[0]);
            stringBuilder.append(contentBody.getCharset());
        }
        this.addField(z[1], stringBuilder.toString());
    }

    protected void generateTransferEncoding(ContentBody contentBody) {
        this.addField(z[8], contentBody.getTransferEncoding());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "HOS*K\u0001\u001cU6\u0017";
        int n3 = -1;
        block16: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block20: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block20;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block21;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 115;
                                break;
                            }
                            case 1: {
                                n9 = 111;
                                break;
                            }
                            case 2: {
                                n9 = 48;
                                break;
                            }
                            case 3: {
                                n9 = 66;
                                break;
                            }
                            default: {
                                n9 = 42;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "0\u0000^6O\u001d\u001b\u001d\u0016S\u0003\n";
                    n3 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "5\u0006U.NS\u0001Q/OS\u0002Q;\n\u001d\u0000DbH\u0016O^7F\u001f";
                    n3 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "1\u0000T;\n\u001e\u000eIbD\u001c\u001b\u0010 OS\u0001E.F";
                    n3 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "=\u000e]'\n\u001e\u000eIbD\u001c\u001b\u0010 OS\u0001E.F";
                    n3 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "0\u0000^6O\u001d\u001b\u001d\u0006C\u0000\u001f_1C\u0007\u0006_,";
                    n3 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "HOV+F\u0016\u0001Q/ONM";
                    n3 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u0015\u0000B/\u0007\u0017\u000eD#\u0011S\u0001Q/ONM";
                    n3 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "0\u0000^6O\u001d\u001b\u001d\u0016X\u0012\u0001C$O\u0001Bu,I\u001c\u000bY,M";
                    n3 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

