/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jpush.http.entity.mime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.jpush.http.entity.mime.FormBodyPart;
import org.apache.jpush.http.entity.mime.HttpMultipart;
import org.apache.jpush.http.entity.mime.HttpMultipartMode;
import org.apache.jpush.http.entity.mime.content.ContentBody;

public class MultipartEntity
implements HttpEntity {
    private static final char[] MULTIPART_CHARS;
    private final HttpMultipart multipart;
    private final Header contentType;
    private long length;
    private volatile boolean dirty;
    private static final String[] z;

    public MultipartEntity(HttpMultipartMode httpMultipartMode, String string, Charset charset) {
        if (string == null) {
            string = this.generateBoundary();
        }
        if (httpMultipartMode == null) {
            httpMultipartMode = HttpMultipartMode.STRICT;
        }
        this.multipart = new HttpMultipart(z[1], charset, string, httpMultipartMode);
        this.contentType = new BasicHeader(z[0], this.generateContentType(string, charset));
        this.dirty = true;
    }

    public MultipartEntity(HttpMultipartMode httpMultipartMode) {
        this(httpMultipartMode, null, null);
    }

    public MultipartEntity() {
        this(HttpMultipartMode.STRICT, null, null);
    }

    protected String generateContentType(String string, Charset charset) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(z[3]);
        stringBuilder.append(string);
        if (charset != null) {
            stringBuilder.append(z[4]);
            stringBuilder.append(charset.name());
        }
        return stringBuilder.toString();
    }

    protected String generateBoundary() {
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random();
        int n2 = random.nextInt(11) + 30;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(MULTIPART_CHARS[random.nextInt(MULTIPART_CHARS.length)]);
        }
        return stringBuilder.toString();
    }

    public void addPart(FormBodyPart formBodyPart) {
        this.multipart.addBodyPart(formBodyPart);
        this.dirty = true;
    }

    public void addPart(String string, ContentBody contentBody) {
        this.addPart(new FormBodyPart(string, contentBody));
    }

    public boolean isRepeatable() {
        Iterator<FormBodyPart> iterator = this.multipart.getBodyParts().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getBody().getContentLength() >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean isChunked() {
        return !this.isRepeatable();
    }

    public boolean isStreaming() {
        return !this.isRepeatable();
    }

    public long getContentLength() {
        if (this.dirty) {
            this.length = this.multipart.getTotalLength();
            this.dirty = false;
        }
        return this.length;
    }

    public Header getContentType() {
        return this.contentType;
    }

    public Header getContentEncoding() {
        return null;
    }

    public void consumeContent() throws IOException, UnsupportedOperationException {
        if (this.isStreaming()) {
            throw new UnsupportedOperationException(z[2]);
        }
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException(z[5]);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.multipart.writeTo(outputStream);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block29: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block28: {
                String string;
                String[] stringArray = new String[6];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n5 = 0;
                String string2 = "94\f\u001d8\u0014/O=$\n>";
                int n6 = -1;
                block19: while (true) {
                    char[] cArray3;
                    block27: {
                        int n7;
                        int n8;
                        char[] cArray4;
                        block26: {
                            char[] cArray5 = string2.toCharArray();
                            n4 = 0;
                            int n9 = cArray5.length;
                            cArray4 = cArray5;
                            n8 = n9;
                            if (n9 <= 1) break block26;
                            cArray3 = cArray4;
                            n7 = n8;
                            if (n8 <= n4) break block27;
                        }
                        do {
                            char[] cArray6 = cArray4;
                            char[] cArray7 = cArray4;
                            int n10 = n4;
                            while (true) {
                                int n11;
                                char c2 = cArray6[n10];
                                switch (n4 % 5) {
                                    case 0: {
                                        n11 = 122;
                                        break;
                                    }
                                    case 1: {
                                        n11 = 91;
                                        break;
                                    }
                                    case 2: {
                                        n11 = 98;
                                        break;
                                    }
                                    case 3: {
                                        n11 = 105;
                                        break;
                                    }
                                    default: {
                                        n11 = 93;
                                    }
                                }
                                cArray6[n10] = (char)(c2 ^ n11);
                                ++n4;
                                cArray4 = cArray7;
                                n8 = n8;
                                if (n8 != 0) break;
                                cArray7 = cArray4;
                                n7 = n8;
                                n10 = n8;
                                cArray6 = cArray4;
                            }
                            cArray3 = cArray4;
                            n7 = n8;
                        } while (n8 > n4);
                    }
                    string = new String(cArray3);
                    switch (n6) {
                        default: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 1;
                            string2 = "\u001c4\u0010\u0004p\u001e:\u0016\b";
                            n6 = 0;
                            continue block19;
                        }
                        case 0: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 2;
                            string2 = ")/\u0010\f<\u00172\f\u000e}\u001f5\u0016\u0000)\u0003{\u0006\u00068\t{\f\u0006)Z2\u000f\u00191\u001f6\u0007\u0007)Zx\u0001\u00063\t.\u000f\f\u001e\u00155\u0016\f3\u000esK";
                            n6 = 1;
                            continue block19;
                        }
                        case 1: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 3;
                            string2 = "\u0017.\u000e\u001d4\n:\u0010\u001dr\u001c4\u0010\u0004p\u001e:\u0016\bfZ9\r\u001c3\u001e:\u0010\u0010`";
                            n6 = 2;
                            continue block19;
                        }
                        case 2: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 4;
                            string2 = "A{\u0001\u0001<\b(\u0007\u001d`";
                            n6 = 3;
                            continue block19;
                        }
                        case 3: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 5;
                            string2 = "7.\u000e\u001d4\n:\u0010\u001d}\u001c4\u0010\u0004}\u001f5\u0016\u0000)\u0003{\u0006\u00068\t{\f\u0006)Z2\u000f\u00191\u001f6\u0007\u0007)Zx\u0005\f)\u00194\f\u001d8\u0014/J@";
                            n6 = 4;
                            continue block19;
                        }
                        case 4: 
                    }
                    break;
                }
                stringArray2[n5] = string.intern();
                z = stringArray3;
                char[] cArray8 = "W\u0004S[nNnT^eCk\u0003\u000b>\u001e>\u0004\u000e5\u00131\t\u00050\u00144\u0012\u0018/\t/\u0017\u001f*\u0002\"\u0018(\u001f9\u001f'/\u001a2\u0012(\"\u00117\u0015-9\f(\b6<\u000b-\u0003;3".toCharArray();
                n4 = 0;
                int n12 = cArray8.length;
                cArray2 = cArray8;
                n3 = n12;
                if (n12 <= 1) break block28;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block29;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n13 = n4;
                while (true) {
                    int n14;
                    char c3 = cArray9[n13];
                    switch (n4 % 5) {
                        case 0: {
                            n14 = 122;
                            break;
                        }
                        case 1: {
                            n14 = 91;
                            break;
                        }
                        case 2: {
                            n14 = 98;
                            break;
                        }
                        case 3: {
                            n14 = 105;
                            break;
                        }
                        default: {
                            n14 = 93;
                        }
                    }
                    cArray9[n13] = (char)(c3 ^ n14);
                    ++n4;
                    cArray2 = cArray10;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray10 = cArray2;
                    n2 = n3;
                    n13 = n3;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        MULTIPART_CHARS = new String(cArray).intern().toCharArray();
    }
}

