/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.mob.tools.gui.ViewPagerAdapter;

public class MobViewPager
extends ViewGroup {
    private static final int TOUCH_STATE_REST = 0;
    private static final int TOUCH_STATE_SCROLLING = 1;
    private static final int SNAP_VELOCITY = 500;
    private static final int DECELERATION = 10;
    private int currentScreen;
    private int screenCount;
    private View previousPage;
    private View currentPage;
    private View nextPage;
    private Scroller scroller;
    private int touchSlop;
    private int maximumVelocity;
    private ViewPagerAdapter adapter;
    private VelocityTracker velocityTracker;
    private int touchState;
    private float lastMotionX;
    private float lastMotionY;
    private boolean skipScreen;
    private int flingVelocity;
    private int pageWidth;

    public MobViewPager(Context context) {
        this(context, null);
    }

    public MobViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MobViewPager(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.scroller = new Scroller(context, new Interpolator(){

            public float getInterpolation(float input) {
                return (2.0f - input) * input;
            }
        });
        this.touchState = 0;
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.touchSlop = configuration.getScaledTouchSlop();
        this.maximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    public void setAdapter(ViewPagerAdapter adapter) {
        if (this.adapter != null) {
            this.adapter.setMobViewPager(null);
        }
        this.adapter = adapter;
        if (this.adapter != null) {
            this.adapter.setMobViewPager(this);
        }
        if (adapter == null) {
            this.currentScreen = 0;
            this.removeAllViews();
            return;
        }
        this.screenCount = adapter.getCount();
        if (this.screenCount <= 0) {
            this.currentScreen = 0;
            this.removeAllViews();
            return;
        }
        if (this.screenCount <= this.currentScreen) {
            this.scrollToScreenOnUIThread(this.screenCount - 1, true);
        } else {
            this.removeAllViews();
            if (this.currentScreen > 0) {
                this.previousPage = adapter.getView(this.currentScreen - 1, this.previousPage, this);
                this.addView(this.previousPage);
            }
            this.currentPage = adapter.getView(this.currentScreen, this.currentPage, this);
            this.addView(this.currentPage);
            if (this.currentScreen < this.screenCount - 1) {
                this.nextPage = adapter.getView(this.currentScreen + 1, this.nextPage, this);
                this.addView(this.nextPage);
            }
        }
    }

    public int getCurrentScreen() {
        return this.currentScreen;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.adapter == null || this.screenCount <= 0) {
            return;
        }
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int adjustedWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        int adjustedHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            child.measure(adjustedWidthMeasureSpec, adjustedHeightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.adapter == null || this.screenCount <= 0) {
            return;
        }
        int width = r - l;
        int height = b - t;
        int cLeft = this.currentScreen * width;
        if (this.currentScreen > 0) {
            this.previousPage.layout(cLeft - width, 0, cLeft, height);
        }
        this.currentPage.layout(cLeft, 0, cLeft + width, height);
        if (this.currentScreen < this.screenCount - 1) {
            this.nextPage.layout(cLeft + width, 0, cLeft + width + width, height);
        }
        if (this.pageWidth != this.getWidth()) {
            int tmp = this.pageWidth;
            this.pageWidth = this.getWidth();
            if (tmp != 0) {
                this.adjustScroller();
            }
        }
    }

    private void adjustScroller() {
        this.skipScreen = true;
        if (this.currentPage != null && this.getFocusedChild() == this.currentPage) {
            this.currentPage.clearFocus();
        }
        int newX = this.currentScreen * this.getWidth();
        int delta = newX - this.getScrollX();
        this.scroller.abortAnimation();
        if (delta != 0) {
            this.scroller.startScroll(this.getScrollX(), 0, delta, 0, 0);
        }
        this.invalidate();
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.adapter == null || this.screenCount <= 0) {
            return;
        }
        long drawingTime = this.getDrawingTime();
        if (this.currentScreen > 0) {
            this.drawChild(canvas, this.previousPage, drawingTime);
        }
        this.drawChild(canvas, this.currentPage, drawingTime);
        if (this.currentScreen < this.screenCount - 1) {
            this.drawChild(canvas, this.nextPage, drawingTime);
        }
    }

    public void computeScroll() {
        if (this.adapter == null || this.screenCount <= 0) {
            return;
        }
        if (this.scroller.computeScrollOffset()) {
            this.scrollTo(this.scroller.getCurrX(), this.scroller.getCurrY());
            this.postInvalidate();
        } else {
            int lastScreen = this.currentScreen;
            int scrX = this.scroller.getCurrX();
            int w = this.getWidth();
            int index = scrX / w;
            if (scrX % w > w / 2) {
                ++index;
            }
            this.currentScreen = Math.max(0, Math.min(index, this.screenCount - 1));
            if (lastScreen != this.currentScreen) {
                this.onScreenChange(lastScreen);
            }
        }
        if (this.adapter != null) {
            float position = (float)this.getScrollX() / (float)this.getWidth();
            this.adapter.onScreenChanging(position);
        }
    }

    private void onScreenChange(int lastScreen) {
        if (this.adapter != null) {
            if (this.skipScreen && Math.abs(lastScreen - this.currentScreen) > 2) {
                this.removeAllViews();
                if (this.currentScreen > 0) {
                    this.previousPage = this.adapter.getView(this.currentScreen - 1, this.previousPage, this);
                    this.addView(this.previousPage);
                }
                this.currentPage = this.adapter.getView(this.currentScreen, this.currentPage, this);
                this.addView(this.currentPage);
                if (this.currentScreen < this.screenCount - 1) {
                    this.nextPage = this.adapter.getView(this.currentScreen + 1, this.nextPage, this);
                    this.addView(this.nextPage);
                }
            } else if (this.currentScreen > lastScreen) {
                for (int i = 0; i < this.currentScreen - lastScreen; ++i) {
                    int screen = lastScreen + i + 1;
                    View tmp = this.previousPage;
                    this.previousPage = this.currentPage;
                    this.currentPage = this.nextPage;
                    if (this.getChildCount() >= 3) {
                        this.removeViewAt(0);
                    }
                    if (screen < this.screenCount - 1) {
                        this.nextPage = this.adapter.getView(screen + 1, tmp, this);
                        this.addView(this.nextPage);
                        continue;
                    }
                    this.nextPage = tmp;
                }
            } else {
                for (int i = 0; i < lastScreen - this.currentScreen; ++i) {
                    int screen = lastScreen - i - 1;
                    View tmp = this.nextPage;
                    this.nextPage = this.currentPage;
                    this.currentPage = this.previousPage;
                    if (this.getChildCount() >= 3) {
                        this.removeViewAt(2);
                    }
                    if (screen > 0) {
                        this.previousPage = this.adapter.getView(screen - 1, tmp, this);
                        this.addView(this.previousPage, 0);
                        continue;
                    }
                    this.previousPage = tmp;
                }
            }
            this.adapter.onScreenChange(this.currentScreen, lastScreen);
        }
    }

    public void scrollLeft(boolean immediate) {
        if (this.currentScreen > 0) {
            this.scrollToScreen(this.currentScreen - 1, immediate);
        }
    }

    public void scrollRight(boolean immediate) {
        if (this.currentScreen < this.screenCount - 1) {
            this.scrollToScreen(this.currentScreen + 1, immediate);
        }
    }

    public void scrollToScreen(final int whichScreen, final boolean immediate) {
        this.post(new Runnable(){

            @Override
            public void run() {
                MobViewPager.this.scrollToScreenOnUIThread(whichScreen, immediate);
            }
        });
    }

    @Deprecated
    public void scrollToScreen(int whichScreen, boolean immediate, boolean skip) {
        this.scrollToScreen(whichScreen, immediate);
    }

    private void scrollToScreenOnUIThread(int whichScreen, boolean immediate) {
        this.skipScreen = immediate;
        if (this.currentPage != null && this.getFocusedChild() == this.currentPage) {
            this.currentPage.clearFocus();
        }
        int newX = whichScreen * this.getWidth();
        int delta = newX - this.getScrollX();
        this.scroller.abortAnimation();
        if (delta != 0) {
            int duration = 0;
            if (!immediate) {
                int defDur = Math.abs(delta) / 2;
                if (this.flingVelocity != 0) {
                    int v = Math.abs(this.flingVelocity);
                    int s = Math.abs(delta);
                    duration = (int)(1000.0 * ((double)v - Math.sqrt(v * v - 20 * s)) / 10.0);
                }
                if (duration == 0 || duration > defDur) {
                    duration = defDur;
                }
            }
            this.scroller.startScroll(this.getScrollX(), 0, delta, 0, duration);
        }
        this.invalidate();
    }

    public boolean dispatchUnhandledMove(View focused, int direction) {
        if (this.adapter == null) {
            return super.dispatchUnhandledMove(focused, direction);
        }
        if (direction == 17) {
            if (this.currentScreen > 0) {
                this.scrollToScreenOnUIThread(this.currentScreen - 1, false);
                return true;
            }
        } else if (direction == 66 && this.currentScreen < this.screenCount - 1) {
            this.scrollToScreenOnUIThread(this.currentScreen + 1, false);
            return true;
        }
        return super.dispatchUnhandledMove(focused, direction);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 2 && this.touchState != 0) {
            return true;
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(ev);
        switch (action) {
            case 2: {
                this.handleInterceptMove(ev);
                break;
            }
            case 0: {
                float x1 = ev.getX();
                float y1 = ev.getY();
                this.lastMotionX = x1;
                this.lastMotionY = y1;
                this.touchState = this.scroller.isFinished() ? 0 : 1;
                break;
            }
            case 1: 
            case 3: {
                if (this.velocityTracker != null) {
                    this.velocityTracker.recycle();
                    this.velocityTracker = null;
                }
                this.touchState = 0;
            }
        }
        return this.touchState != 0;
    }

    private void handleInterceptMove(MotionEvent ev) {
        float x = ev.getX();
        float y = ev.getY();
        int xDiff = (int)Math.abs(x - this.lastMotionX);
        int yDiff = (int)Math.abs(y - this.lastMotionY);
        if (yDiff < xDiff && xDiff > this.touchSlop) {
            this.touchState = 1;
            this.lastMotionX = x;
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.adapter == null) {
            return false;
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(ev);
        int action = ev.getAction();
        float x = ev.getX();
        switch (action) {
            case 0: {
                if (this.touchState == 0) break;
                if (!this.scroller.isFinished()) {
                    this.scroller.abortAnimation();
                }
                this.lastMotionX = x;
                break;
            }
            case 2: {
                if (this.touchState == 1) {
                    this.handleScrollMove(ev);
                    break;
                }
                if (!this.onInterceptTouchEvent(ev) || this.touchState != 1) break;
                this.handleScrollMove(ev);
                break;
            }
            case 1: {
                if (this.touchState == 1) {
                    this.velocityTracker.computeCurrentVelocity(1000, (float)this.maximumVelocity);
                    this.flingVelocity = (int)this.velocityTracker.getXVelocity();
                    if (this.flingVelocity > 500 && this.currentScreen > 0) {
                        this.scrollToScreenOnUIThread(this.currentScreen - 1, false);
                    } else if (this.flingVelocity < -500 && this.currentScreen < this.screenCount - 1) {
                        this.scrollToScreenOnUIThread(this.currentScreen + 1, false);
                    } else {
                        int screenWidth = this.getWidth();
                        int whichScreen = (this.getScrollX() + screenWidth / 2) / screenWidth;
                        this.scrollToScreenOnUIThread(whichScreen, false);
                    }
                    if (this.velocityTracker != null) {
                        this.velocityTracker.recycle();
                        this.velocityTracker = null;
                    }
                }
                this.touchState = 0;
                break;
            }
            case 3: {
                this.touchState = 0;
            }
        }
        return true;
    }

    private void handleScrollMove(MotionEvent ev) {
        View lastScr;
        int availableToScroll;
        if (this.adapter == null) {
            return;
        }
        float x1 = ev.getX();
        int deltaX = (int)(this.lastMotionX - x1);
        this.lastMotionX = x1;
        if (deltaX < 0) {
            if (this.getScrollX() > 0) {
                this.scrollBy(Math.max(-this.getScrollX(), deltaX), 0);
            }
        } else if (deltaX > 0 && this.getChildCount() != 0 && (availableToScroll = (lastScr = this.getChildAt(this.getChildCount() - 1)).getRight() - this.getScrollX() - this.getWidth()) > 0) {
            this.scrollBy(Math.min(availableToScroll, deltaX), 0);
        }
    }
}

