/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.mob.tools.gui.OnListStopScrollListener;
import com.mob.tools.gui.PullToRequestBaseAdapter;
import com.mob.tools.gui.PullToRequestBaseListAdapter;
import com.mob.tools.gui.PullToRequestView;
import com.mob.tools.gui.Scrollable;
import com.mob.tools.gui.ScrollableListView;

public abstract class PullToRequestListAdapter
extends PullToRequestBaseListAdapter {
    private ScrollableListView listView = this.onNewListView(this.getContext());
    private PullToRequestBaseAdapter adapter;
    private boolean fling;
    private OnListStopScrollListener osListener;
    private boolean pullUpReady;

    public PullToRequestListAdapter(PullToRequestView view) {
        super(view);
        this.listView.setOnScrollListener(new AbsListView.OnScrollListener(){
            private int firstVisibleItem;
            private int visibleItemCount;

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                PullToRequestListAdapter.this.fling = scrollState == 2;
                if (scrollState == 0) {
                    if (PullToRequestListAdapter.this.osListener != null) {
                        PullToRequestListAdapter.this.osListener.onListStopScrolling(this.firstVisibleItem, this.visibleItemCount);
                    } else if (PullToRequestListAdapter.this.adapter != null) {
                        PullToRequestListAdapter.this.adapter.notifyDataSetChanged();
                    }
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                this.firstVisibleItem = firstVisibleItem;
                this.visibleItemCount = visibleItemCount;
                View v = view.getChildAt(visibleItemCount - 1);
                PullToRequestListAdapter.this.pullUpReady = firstVisibleItem + visibleItemCount == totalItemCount && v != null && v.getBottom() <= view.getBottom();
                PullToRequestListAdapter.this.onScroll(PullToRequestListAdapter.this.listView, firstVisibleItem, visibleItemCount, totalItemCount);
            }
        });
        this.adapter = new PullToRequestBaseAdapter(this);
        this.listView.setAdapter((ListAdapter)this.adapter);
    }

    protected ScrollableListView onNewListView(Context context) {
        return new ScrollableListView(context);
    }

    @Override
    public Scrollable getBodyView() {
        return this.listView;
    }

    public ListView getListView() {
        return this.listView;
    }

    @Override
    public boolean isFling() {
        return this.fling;
    }

    @Override
    public void onScroll(Scrollable scrollable, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
    }

    @Override
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.adapter.notifyDataSetChanged();
    }

    public void setDivider(Drawable divider) {
        this.listView.setDivider(divider);
    }

    public void setDividerHeight(int height) {
        this.listView.setDividerHeight(height);
    }

    @Override
    public boolean isPullDownReady() {
        return this.listView.isReadyToPull();
    }

    @Override
    public boolean isPullUpReady() {
        return this.pullUpReady;
    }
}

