/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.java8;

import com.mob.tools.java8.MapFlow;
import java.util.LinkedList;

public class Commands {
    public static <T> When<T> when(T target) {
        return new When(target);
    }

    public static class When<T> {
        private T target;
        private LinkedList<MapFlow.MapItem<WhenCondition<T>, Then>> cases;

        private When(T target) {
            this.target = target;
            this.cases = new LinkedList();
        }

        public When<T> meetCondition(WhenCondition<T> condition, Then then) {
            this.cases.add(MapFlow.MapItem.of(condition, then));
            return this;
        }

        public When<T> meetCondition(final boolean condition, Then then) {
            return this.meetCondition(new WhenCondition<T>(){

                @Override
                public boolean when(T target) {
                    return condition;
                }
            }, then);
        }

        public When<T> is(final Object value, Then then) {
            return this.meetCondition(new WhenCondition<T>(){

                @Override
                public boolean when(T target) {
                    return target == null && value == null || target != null && target.equals(value);
                }
            }, then);
        }

        public When<T> isNot(final Object value, Then then) {
            return this.meetCondition(new WhenCondition<T>(){

                @Override
                public boolean when(T target) {
                    return target == null && value != null || target != null && !target.equals(value);
                }
            }, then);
        }

        public When<T> isNull(Then then) {
            return this.is(null, then);
        }

        public When<T> isNotNull(Then then) {
            return this.isNot(null, then);
        }

        public When<T> isInstanceOf(final Class<?> type, Then then) {
            return this.meetCondition(new WhenCondition<T>(){

                @Override
                public boolean when(T target) {
                    return type != null && type.isInstance(target);
                }
            }, then);
        }

        public When<T> isNotInstanceOf(final Class<?> type, Then then) {
            return this.meetCondition(new WhenCondition<T>(){

                @Override
                public boolean when(T target) {
                    return type == null || !type.isInstance(target);
                }
            }, then);
        }

        public When<T> isInRange(final double begin, final double end, Then then) {
            return this.meetCondition(new WhenCondition<T>(){

                @Override
                public boolean when(T target) {
                    try {
                        double t = Double.valueOf(String.valueOf(target));
                        return t >= begin && t <= end;
                    }
                    catch (Throwable t) {
                        return false;
                    }
                }
            }, then);
        }

        public When<T> isNotInRage(final double begin, final double end, Then then) {
            return this.meetCondition(new WhenCondition<T>(){

                @Override
                public boolean when(T target) {
                    try {
                        double t = Double.valueOf(String.valueOf(target));
                        return t < begin || t > end;
                    }
                    catch (Throwable t) {
                        return false;
                    }
                }
            }, then);
        }

        public When<T> isGreaterThan(final double value, Then then) {
            return this.meetCondition(new WhenCondition<T>(){

                @Override
                public boolean when(T target) {
                    try {
                        double t = Double.valueOf(String.valueOf(target));
                        return t > value;
                    }
                    catch (Throwable t) {
                        return false;
                    }
                }
            }, then);
        }

        public When<T> isLessThan(final double value, Then then) {
            return this.meetCondition(new WhenCondition<T>(){

                @Override
                public boolean when(T target) {
                    try {
                        double t = Double.valueOf(String.valueOf(target));
                        return t < value;
                    }
                    catch (Throwable t) {
                        return false;
                    }
                }
            }, then);
        }

        public void orElse(Then then) {
            this.evaluate(then);
        }

        private void evaluate(Then elseThen) {
            for (MapFlow.MapItem mapItem : this.cases) {
                if (!((WhenCondition)mapItem.key).when(this.target)) continue;
                ((Then)mapItem.value).then();
                return;
            }
            if (elseThen != null) {
                elseThen.then();
            }
        }

        public void evaluate() {
            this.evaluate(null);
        }

        public static interface Then {
            public void then();
        }

        public static interface WhenCondition<T> {
            public boolean when(T var1);
        }
    }
}

