/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.java8;

import com.mob.tools.java8.Batch;
import com.mob.tools.java8.Collect;
import com.mob.tools.java8.Each;
import com.mob.tools.java8.Filter;
import com.mob.tools.java8.FlowIterator;
import com.mob.tools.java8.Function;
import com.mob.tools.java8.Inject;
import com.mob.tools.java8.Map;
import com.mob.tools.java8.MapFlow;
import com.mob.tools.java8.MapMaker;
import com.mob.tools.java8.NumberFlow;
import com.mob.tools.java8.Optional;
import com.mob.tools.java8.Peek;
import java.io.BufferedReader;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class Flow<T> {
    protected FlowIterator<?> iterator;
    protected LinkedList<Function> functions;

    public static <T> Flow<T> of(FlowIterator<T> iterator) {
        return new Flow<T>(iterator);
    }

    public static <T> Flow<T> of(Iterable<T> iterable) {
        return Flow.of(new FlowIterator.IterableIterator<T>(iterable));
    }

    public static <T> Flow<T> of(Enumeration<T> enumeration) {
        return Flow.of(new FlowIterator.EnumerationIterator<T>(enumeration));
    }

    public static <K, V> MapFlow<K, V> of(java.util.Map<K, V> map) {
        return new MapFlow(Flow.of(new FlowIterator.MapIterator<K, V>(map)));
    }

    public static <T> Flow<T> of(T ... array) {
        return Flow.of(new FlowIterator.ArrayIterator<T>(array));
    }

    public static NumberFlow.ByteFlow of(Byte ... array) {
        return new NumberFlow.ByteFlow(Flow.of(new FlowIterator.ArrayIterator<Byte>(array)));
    }

    public static NumberFlow.ByteFlow of(byte ... array) {
        return new NumberFlow.ByteFlow(Flow.of(new FlowIterator.ByteArrayIterator(array)));
    }

    public static NumberFlow.ShortFlow of(Short ... array) {
        return new NumberFlow.ShortFlow(Flow.of(new FlowIterator.ArrayIterator<Short>(array)));
    }

    public static NumberFlow.ShortFlow of(short ... array) {
        return new NumberFlow.ShortFlow(Flow.of(new FlowIterator.ShortArrayIterator(array)));
    }

    public static NumberFlow.IntFlow of(Integer ... array) {
        return new NumberFlow.IntFlow(Flow.of(new FlowIterator.ArrayIterator<Integer>(array)));
    }

    public static NumberFlow.IntFlow of(int ... array) {
        return new NumberFlow.IntFlow(Flow.of(new FlowIterator.IntArrayIterator(array)));
    }

    public static NumberFlow.LongFlow of(Long ... array) {
        return new NumberFlow.LongFlow(Flow.of(new FlowIterator.ArrayIterator<Long>(array)));
    }

    public static NumberFlow.LongFlow of(long ... array) {
        return new NumberFlow.LongFlow(Flow.of(new FlowIterator.LongArrayIterator(array)));
    }

    public static NumberFlow.FloatFlow of(Float ... array) {
        return new NumberFlow.FloatFlow(Flow.of(new FlowIterator.ArrayIterator<Float>(array)));
    }

    public static NumberFlow.FloatFlow of(float ... array) {
        return new NumberFlow.FloatFlow(Flow.of(new FlowIterator.FloatArrayIterator(array)));
    }

    public static NumberFlow.DoubleFlow of(Double ... array) {
        return new NumberFlow.DoubleFlow(Flow.of(new FlowIterator.ArrayIterator<Double>(array)));
    }

    public static NumberFlow.DoubleFlow of(double ... array) {
        return new NumberFlow.DoubleFlow(Flow.of(new FlowIterator.DoubleArrayIterator(array)));
    }

    public static Flow<Character> of(char ... array) {
        return Flow.of(new FlowIterator.CharArrayIterator(array));
    }

    public static Flow<Boolean> of(boolean ... array) {
        return Flow.of(new FlowIterator.BoolArrayIterator(array));
    }

    public static NumberFlow.IntFlow range(int fromInclude, int toExclude, int step) {
        return new NumberFlow.IntFlow(Flow.of(new FlowIterator.IntRangeIterator(fromInclude, toExclude, step)));
    }

    public static NumberFlow.IntFlow range(int fromInclude, int toExclude) {
        return Flow.range(fromInclude, toExclude, 1);
    }

    public static NumberFlow.DoubleFlow range(double fromInclude, double toExclude, double step) {
        return new NumberFlow.DoubleFlow(Flow.of(new FlowIterator.DoubleRangeIterator(fromInclude, toExclude, step)));
    }

    public static NumberFlow.DoubleFlow range(double fromInclude, double toExclude) {
        return Flow.range(fromInclude, toExclude, 1.0);
    }

    public static Flow<String> of(BufferedReader br) {
        return Flow.of(new FlowIterator.BufferedReaderIterator(br));
    }

    public static Flow<String> of(File file) {
        return Flow.of(file, "utf-8");
    }

    public static Flow<String> of(File file, String charset) {
        return Flow.of(file, Charset.forName(charset));
    }

    public static Flow<String> of(File file, Charset charset) {
        return Flow.of(new FlowIterator.FileReaderIterator(file, charset));
    }

    public static <T> Flow<T> concat(final Flow<? extends T> ... flows) {
        return new Flow<T>(){

            @Override
            protected void evaluate() {
                for (Flow flow : flows) {
                    flow.functions.addAll(this.functions);
                    flow.evaluate();
                }
            }
        };
    }

    private Flow() {
        this.functions = new LinkedList();
    }

    private Flow(FlowIterator<T> iterator) {
        this.iterator = iterator;
        this.functions = new LinkedList();
    }

    private Flow(Flow<?> previous) {
        this.iterator = previous.iterator;
        this.functions = previous.functions;
    }

    private <R> Flow<R> nextFlow(Function fun) {
        this.functions.add(fun);
        return new Flow<T>(this);
    }

    public Flow<T> filter(Filter<T> fun) {
        return this.nextFlow(fun);
    }

    public <R> Flow<R> map(Map<T, R> fun) {
        return this.nextFlow(fun);
    }

    public <R> Flow<R> collect(Collect<T, R> fun) {
        return this.nextFlow(fun);
    }

    public Flow<T> peek(Peek<T> fun) {
        return this.nextFlow(fun);
    }

    public Flow<T> limit(int limit) {
        return this.nextFlow(new Batch.Limit(limit));
    }

    public Flow<T> skip(int skip) {
        return this.nextFlow(new Batch.Skip(skip));
    }

    public Flow<T> distinct() {
        return this.nextFlow(new Filter<T>(){
            private HashSet<T> output = new HashSet();

            @Override
            public boolean filter(T it) {
                if (this.output.contains(it)) {
                    return false;
                }
                this.output.add(it);
                return true;
            }
        });
    }

    public Flow<List<T>> chunk(int chunk) {
        return this.nextFlow(new Batch.Chunk(chunk));
    }

    public Flow<T> sort(final Comparator<T> fun) {
        final Flow self = this;
        return new Flow<T>(){

            @Override
            protected void evaluate() {
                List list = self.toList();
                Collections.sort(list, fun);
                final Iterator it = list.iterator();
                this.iterator = new FlowIterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public T next() {
                        return it.next();
                    }

                    @Override
                    public void finish() {
                    }
                };
                super.evaluate();
            }
        };
    }

    public Flow<T> sort() {
        return this.sort(null);
    }

    public Flow<T> jumble() {
        final Flow self = this;
        return new Flow<T>(){

            @Override
            protected void evaluate() {
                List list = self.toList();
                Random rnd = new Random();
                LinkedList rlist = new LinkedList();
                while (list.size() > 0) {
                    int index = rnd.nextInt(list.size());
                    Object item = list.remove(index);
                    rlist.add(item);
                }
                final Iterator it = rlist.iterator();
                this.iterator = new FlowIterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public T next() {
                        return it.next();
                    }

                    @Override
                    public void finish() {
                    }
                };
                super.evaluate();
            }
        };
    }

    public void each(Each<T> fun) {
        this.nextFlow(fun);
        this.evaluate();
    }

    public Optional<T> first() {
        Batch.Limit fun = new Batch.Limit(1);
        this.nextFlow(fun);
        this.evaluate();
        LinkedList output = fun.output();
        return new Optional<Object>((output.isEmpty() ? null : (Object)output.getFirst()));
    }

    public Optional<T> last() {
        Batch.Limit fun = new Batch.Limit();
        this.nextFlow(fun);
        this.evaluate();
        LinkedList output = fun.output();
        return new Optional<Object>((output.isEmpty() ? null : (Object)output.getLast()));
    }

    public boolean any() {
        Batch.Limit fun = new Batch.Limit(1);
        this.nextFlow(fun);
        this.evaluate();
        return !fun.output().isEmpty();
    }

    protected void evaluate() {
        this.evaluate(this.iterator, 0);
    }

    private void evaluate(FlowIterator<Object> iterator, int fromIndex) {
        while (iterator.hasNext()) {
            boolean shortCutQuit = false;
            LinkedList it = iterator.next();
            int size = this.functions.size();
            for (int i = fromIndex; i < size; ++i) {
                Function fun = this.functions.get(i);
                if (fun instanceof Filter) {
                    Filter filter = (Filter)fun;
                    if (filter.filter(it)) continue;
                    break;
                }
                if (fun instanceof Map) {
                    Map map = (Map)fun;
                    it = map.map(it);
                    continue;
                }
                if (fun instanceof Collect) {
                    Collect collect = (Collect)fun;
                    FlowIterator<Object> subit = collect.collect(it).iterator;
                    this.evaluate(subit, i + 1);
                    break;
                }
                if (fun instanceof Each) {
                    Each each = (Each)fun;
                    each.each(it);
                    continue;
                }
                if (fun instanceof Batch.Limit) {
                    Batch.Limit limit = (Batch.Limit)fun;
                    if (limit.test(it) <= 0) continue;
                    shortCutQuit = true;
                    continue;
                }
                if (fun instanceof Batch.Skip) {
                    Batch.Skip skip = (Batch.Skip)fun;
                    if (skip.test(it) >= 2) continue;
                    break;
                }
                if (fun instanceof Batch.Chunk) {
                    Batch.Chunk chunk = (Batch.Chunk)fun;
                    if (chunk.test(it) < 1 && iterator.hasNext()) break;
                    it = chunk.output();
                    chunk.reset();
                    continue;
                }
                if (!(fun instanceof Peek)) continue;
                Peek peek = (Peek)fun;
                peek.peek(it);
            }
            if (!shortCutQuit) continue;
            break;
        }
        iterator.finish();
    }

    public Set<T> toSet() {
        final HashSet set = new HashSet();
        this.each(new Each<T>(){

            @Override
            public void each(T it) {
                set.add(it);
            }
        });
        return set;
    }

    public List<T> toList() {
        final LinkedList list = new LinkedList();
        this.each(new Each<T>(){

            @Override
            public void each(T it) {
                list.add(it);
            }
        });
        return list;
    }

    public Object[] toArray() {
        return this.toList().toArray();
    }

    public T[] toArray(T[] array) {
        return this.toList().toArray(array);
    }

    public int count() {
        return this.toList().size();
    }

    public <R> R inject(R identity, final Inject<T, R> fun) {
        final Object[] previous = new Object[]{identity};
        this.each(new Each<T>(){

            @Override
            public void each(T it) {
                previous[0] = fun.inject(it, previous[0]);
            }
        });
        return (R)previous[0];
    }

    public <R> R inject(Inject<T, R> fun) {
        return this.inject(null, fun);
    }

    public <K, V> java.util.Map<K, V> toMap(final MapMaker<T, K, V> fun) {
        final HashMap map = new HashMap();
        this.each(new Each<T>(){

            @Override
            public void each(T it) {
                fun.toMap(it, map);
            }
        });
        return map;
    }
}

