/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.java8;

import com.mob.tools.java8.Closure;
import com.mob.tools.java8.MapFlow;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public interface FlowIterator<R> {
    public boolean hasNext();

    public R next();

    public void finish();

    public static class EnumerationIterator<T>
    implements FlowIterator<T> {
        private Enumeration<T> enumeration;

        EnumerationIterator(Enumeration<T> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public T next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void finish() {
        }
    }

    public static class FileReaderIterator
    implements FlowIterator<String> {
        private File file;
        private Charset charset;
        private BufferedReader br;
        private BufferedReaderIterator it;

        FileReaderIterator(File file, Charset charset) {
            this.file = file;
            this.charset = charset;
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.br == null) {
                this.br = Closure.uncheck(new Closure.IClosure<BufferedReader>(){

                    @Override
                    public BufferedReader call() throws Throwable {
                        FileInputStream fis = new FileInputStream(FileReaderIterator.this.file);
                        InputStreamReader isr = new InputStreamReader((InputStream)fis, FileReaderIterator.this.charset);
                        return new BufferedReader(isr);
                    }
                });
                this.it = new BufferedReaderIterator(this.br);
            }
            return this.it != null && this.it.hasNext();
        }

        @Override
        public String next() {
            return this.it == null ? null : this.it.next();
        }

        @Override
        public synchronized void finish() {
            this.it = null;
            if (this.br != null) {
                Closure.uncheck(new Closure.IClosureV(){

                    @Override
                    public void call() throws Throwable {
                        FileReaderIterator.this.br.close();
                        FileReaderIterator.this.br = null;
                    }
                });
            }
        }
    }

    public static class BufferedReaderIterator
    implements FlowIterator<String> {
        private BufferedReader br;
        private String nextLine;

        BufferedReaderIterator(BufferedReader br) {
            this.br = br;
        }

        @Override
        public boolean hasNext() {
            this.nextLine = Closure.uncheck(new Closure.IClosure<String>(){

                @Override
                public String call() throws Throwable {
                    return BufferedReaderIterator.this.br.readLine();
                }
            });
            return this.nextLine != null;
        }

        @Override
        public String next() {
            return this.nextLine;
        }

        @Override
        public void finish() {
        }
    }

    public static class DoubleRangeIterator
    extends RangeIterator<Double> {
        DoubleRangeIterator(Double fromInclude, Double toExclude, Double step) {
            super(fromInclude, toExclude, step);
        }

        @Override
        protected Double increase(Double position, Double step) {
            return position + step;
        }
    }

    public static class IntRangeIterator
    extends RangeIterator<Integer> {
        IntRangeIterator(Integer fromInclude, Integer toExclude, Integer step) {
            super(fromInclude, toExclude, step);
        }

        @Override
        protected Integer increase(Integer position, Integer step) {
            return position + step;
        }
    }

    public static abstract class RangeIterator<T extends Comparable<T>>
    implements FlowIterator<T> {
        private T toExclude;
        private T step;
        private T position;

        RangeIterator(T fromInclude, T toExclude, T step) {
            this.toExclude = toExclude;
            this.step = step;
            this.position = fromInclude;
        }

        @Override
        public boolean hasNext() {
            return this.position.compareTo(this.toExclude) < 0;
        }

        protected abstract T increase(T var1, T var2);

        @Override
        public T next() {
            T next = this.position;
            this.position = this.increase(this.position, this.step);
            return next;
        }

        @Override
        public void finish() {
        }
    }

    public static class CharArrayIterator
    extends PrimitiveArrayIterator<Character> {
        private char[] array;

        CharArrayIterator(char ... array) {
            this.array = array;
        }

        @Override
        protected int length() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        protected Character element(int index) {
            return Character.valueOf(this.array[index]);
        }
    }

    public static class BoolArrayIterator
    extends PrimitiveArrayIterator<Boolean> {
        private boolean[] array;

        BoolArrayIterator(boolean ... array) {
            this.array = array;
        }

        @Override
        protected int length() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        protected Boolean element(int index) {
            return this.array[index];
        }
    }

    public static class DoubleArrayIterator
    extends PrimitiveArrayIterator<Double> {
        private double[] array;

        DoubleArrayIterator(double ... array) {
            this.array = array;
        }

        @Override
        protected int length() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        protected Double element(int index) {
            return this.array[index];
        }
    }

    public static class FloatArrayIterator
    extends PrimitiveArrayIterator<Float> {
        private float[] array;

        FloatArrayIterator(float ... array) {
            this.array = array;
        }

        @Override
        protected int length() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        protected Float element(int index) {
            return Float.valueOf(this.array[index]);
        }
    }

    public static class LongArrayIterator
    extends PrimitiveArrayIterator<Long> {
        private long[] array;

        LongArrayIterator(long ... array) {
            this.array = array;
        }

        @Override
        protected int length() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        protected Long element(int index) {
            return this.array[index];
        }
    }

    public static class IntArrayIterator
    extends PrimitiveArrayIterator<Integer> {
        private int[] array;

        IntArrayIterator(int ... array) {
            this.array = array;
        }

        @Override
        protected int length() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        protected Integer element(int index) {
            return this.array[index];
        }
    }

    public static class ShortArrayIterator
    extends PrimitiveArrayIterator<Short> {
        private short[] array;

        ShortArrayIterator(short ... array) {
            this.array = array;
        }

        @Override
        protected int length() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        protected Short element(int index) {
            return this.array[index];
        }
    }

    public static class ByteArrayIterator
    extends PrimitiveArrayIterator<Byte> {
        private byte[] array;

        ByteArrayIterator(byte ... array) {
            this.array = array;
        }

        @Override
        protected int length() {
            return this.array == null ? 0 : this.array.length;
        }

        @Override
        protected Byte element(int index) {
            return this.array[index];
        }
    }

    public static abstract class PrimitiveArrayIterator<E>
    implements FlowIterator<E> {
        private int index;

        protected abstract int length();

        protected abstract E element(int var1);

        @Override
        public boolean hasNext() {
            return this.index < this.length();
        }

        @Override
        public E next() {
            E it = this.element(this.index);
            ++this.index;
            return it;
        }

        @Override
        public void finish() {
        }
    }

    public static class ArrayIterator<T>
    implements FlowIterator<T> {
        private T[] array;
        private int index;

        ArrayIterator(T ... array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.index < this.array.length;
        }

        @Override
        public T next() {
            T it = this.array[this.index];
            ++this.index;
            return it;
        }

        @Override
        public void finish() {
        }
    }

    public static class MapIterator<K, V>
    implements FlowIterator<MapFlow.MapItem<K, V>> {
        private Iterator<Map.Entry<K, V>> it;

        MapIterator(Map<K, V> map) {
            this.it = map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public MapFlow.MapItem<K, V> next() {
            MapFlow.MapItem item = new MapFlow.MapItem();
            Map.Entry<K, V> entry = this.it.next();
            item.key = entry.getKey();
            item.value = entry.getValue();
            return item;
        }

        @Override
        public void finish() {
        }
    }

    public static class IterableIterator<T>
    implements FlowIterator<T> {
        private Iterator<T> it;

        IterableIterator(Iterable<T> iterable) {
            this.it = iterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.it.next();
        }

        @Override
        public void finish() {
        }
    }
}

