/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.java8;

import com.mob.tools.java8.Collect;
import com.mob.tools.java8.Each;
import com.mob.tools.java8.Filter;
import com.mob.tools.java8.Flow;
import com.mob.tools.java8.Inject;
import com.mob.tools.java8.Map;
import com.mob.tools.java8.MapMaker;
import com.mob.tools.java8.Optional;
import com.mob.tools.java8.Peek;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

abstract class NumberFlow<N, NF extends NumberFlow<N, NF>> {
    private Flow<N> flow;
    private NF self;

    private NumberFlow(Flow<N> flow) {
        this.flow = flow;
        this.self = this;
    }

    public NF filter(Filter<N> fun) {
        this.flow = this.flow.filter(fun);
        return this.self;
    }

    public ByteFlow map(Map.MapByte<N> fun) {
        return new ByteFlow(this.flow.map(fun));
    }

    public ByteFlow mapByte(Map.MapByte<N> fun) {
        return this.map(fun);
    }

    public ShortFlow map(Map.MapShort<N> fun) {
        return new ShortFlow(this.flow.map(fun));
    }

    public ShortFlow mapShort(Map.MapShort<N> fun) {
        return this.map(fun);
    }

    public IntFlow map(Map.MapInt<N> fun) {
        return new IntFlow(this.flow.map(fun));
    }

    public IntFlow mapInt(Map.MapInt<N> fun) {
        return this.map(fun);
    }

    public LongFlow map(Map.MapLong<N> fun) {
        return new LongFlow(this.flow.map(fun));
    }

    public LongFlow mapLong(Map.MapLong<N> fun) {
        return this.map(fun);
    }

    public FloatFlow map(Map.MapFloat<N> fun) {
        return new FloatFlow(this.flow.map(fun));
    }

    public FloatFlow mapFloat(Map.MapFloat<N> fun) {
        return this.map(fun);
    }

    public DoubleFlow map(Map.MapDouble<N> fun) {
        return new DoubleFlow(this.flow.map(fun));
    }

    public DoubleFlow mapDouble(Map.MapDouble<N> fun) {
        return this.map(fun);
    }

    public <R> Flow<R> rawMap(Map<N, R> fun) {
        return this.flow.map(fun);
    }

    public ByteFlow collect(Collect.CollectByte<N> fun) {
        return new ByteFlow(this.flow.collect(fun));
    }

    public ByteFlow collectByte(Collect.CollectByte<N> fun) {
        return this.collect(fun);
    }

    public ShortFlow collect(Collect.CollectShort<N> fun) {
        return new ShortFlow(this.flow.collect(fun));
    }

    public ShortFlow collectByte(Collect.CollectShort<N> fun) {
        return this.collect(fun);
    }

    public IntFlow collect(Collect.CollectInt<N> fun) {
        return new IntFlow(this.flow.collect(fun));
    }

    public IntFlow collectByte(Collect.CollectInt<N> fun) {
        return this.collect(fun);
    }

    public LongFlow collect(Collect.CollectLong<N> fun) {
        return new LongFlow(this.flow.collect(fun));
    }

    public LongFlow collectByte(Collect.CollectLong<N> fun) {
        return this.collect(fun);
    }

    public FloatFlow collect(Collect.CollectFloat<N> fun) {
        return new FloatFlow(this.flow.collect(fun));
    }

    public FloatFlow collectByte(Collect.CollectFloat<N> fun) {
        return this.collect(fun);
    }

    public DoubleFlow collect(Collect.CollectDouble<N> fun) {
        return new DoubleFlow(this.flow.collect(fun));
    }

    public DoubleFlow collectByte(Collect.CollectDouble<N> fun) {
        return this.collect(fun);
    }

    public <R> Flow<R> rawCollect(Collect<N, R> fun) {
        return this.flow.collect(fun);
    }

    public NF peek(Peek<N> fun) {
        this.flow = this.flow.peek(fun);
        return this.self;
    }

    public NF limit(int limit) {
        this.flow = this.flow.limit(limit);
        return this.self;
    }

    public NF skip(int skip) {
        this.flow = this.flow.skip(skip);
        return this.self;
    }

    public NF distinct() {
        this.flow = this.flow.distinct();
        return this.self;
    }

    public Flow<List<N>> chunk(int chunk) {
        return this.flow.chunk(chunk);
    }

    public NF sort(Comparator<N> fun) {
        this.flow = this.flow.sort(fun);
        return this.self;
    }

    public NF sort() {
        return this.sort(null);
    }

    public NF jumble() {
        this.flow = this.flow.jumble();
        return this.self;
    }

    public void each(Each<N> fun) {
        this.flow.each(fun);
    }

    public Optional<N> first() {
        return this.flow.first();
    }

    public Optional<N> min() {
        return this.flow.sort().first();
    }

    public Optional<N> last() {
        return this.flow.last();
    }

    public Optional<N> max() {
        return this.flow.sort().last();
    }

    public boolean any() {
        return this.flow.any();
    }

    public Set<N> toSet() {
        return this.flow.toSet();
    }

    public List<N> toList() {
        return this.flow.toList();
    }

    public abstract N[] toArray();

    public int count() {
        return this.flow.count();
    }

    public <R> R inject(R identity, Inject<N, R> fun) {
        return this.flow.inject(identity, fun);
    }

    public <R> R inject(Inject<N, R> fun) {
        return this.inject(null, fun);
    }

    public <K, V> java.util.Map<K, V> toMap(MapMaker<N, K, V> fun) {
        return this.flow.toMap(fun);
    }

    public abstract N sum();

    public abstract Optional<Double> average();

    public static class DoubleFlow
    extends NumberFlow<Double, DoubleFlow> {
        DoubleFlow(Flow<Double> flow) {
            super(flow);
        }

        public Double[] toArray() {
            List list = this.toList();
            if (list.isEmpty()) {
                return new Double[0];
            }
            return list.toArray(new Double[list.size()]);
        }

        @Override
        public Double sum() {
            return (Double)this.inject((Object)0.0, new Inject<Double, Double>(){

                @Override
                public Double inject(Double it, Double previous) {
                    return it + previous;
                }
            });
        }

        @Override
        public Optional<Double> average() {
            List list = this.toList();
            if (list.isEmpty()) {
                return new Optional<Object>(null);
            }
            double sum = (Double)this.inject((Object)0.0, new Inject<Double, Double>(){

                @Override
                public Double inject(Double it, Double previous) {
                    return it + previous;
                }
            });
            return new Optional<Double>(sum / (double)list.size());
        }
    }

    public static class FloatFlow
    extends NumberFlow<Float, FloatFlow> {
        FloatFlow(Flow<Float> flow) {
            super(flow);
        }

        public Float[] toArray() {
            List list = this.toList();
            if (list.isEmpty()) {
                return new Float[0];
            }
            return list.toArray(new Float[list.size()]);
        }

        @Override
        public Float sum() {
            return (Float)this.inject(Float.valueOf(0.0f), new Inject<Float, Float>(){

                @Override
                public Float inject(Float it, Float previous) {
                    return Float.valueOf(it.floatValue() + previous.floatValue());
                }
            });
        }

        @Override
        public Optional<Double> average() {
            List list = this.toList();
            if (list.isEmpty()) {
                return new Optional<Object>(null);
            }
            double sum = (Double)this.inject((Object)0.0, new Inject<Float, Double>(){

                @Override
                public Double inject(Float it, Double previous) {
                    return (double)it.floatValue() + previous;
                }
            });
            return new Optional<Double>(sum / (double)list.size());
        }
    }

    public static class LongFlow
    extends NumberFlow<Long, LongFlow> {
        LongFlow(Flow<Long> flow) {
            super(flow);
        }

        public Long[] toArray() {
            List list = this.toList();
            if (list.isEmpty()) {
                return new Long[0];
            }
            return list.toArray(new Long[list.size()]);
        }

        @Override
        public Long sum() {
            return (Long)this.inject((Object)0L, new Inject<Long, Long>(){

                @Override
                public Long inject(Long it, Long previous) {
                    return it + previous;
                }
            });
        }

        @Override
        public Optional<Double> average() {
            List list = this.toList();
            if (list.isEmpty()) {
                return new Optional<Object>(null);
            }
            double sum = (Double)this.inject((Object)0.0, new Inject<Long, Double>(){

                @Override
                public Double inject(Long it, Double previous) {
                    return (double)it.longValue() + previous;
                }
            });
            return new Optional<Double>(sum / (double)list.size());
        }
    }

    public static class IntFlow
    extends NumberFlow<Integer, IntFlow> {
        IntFlow(Flow<Integer> flow) {
            super(flow);
        }

        public Integer[] toArray() {
            List list = this.toList();
            if (list.isEmpty()) {
                return new Integer[0];
            }
            return list.toArray(new Integer[list.size()]);
        }

        @Override
        public Integer sum() {
            return (Integer)this.inject((Object)0, new Inject<Integer, Integer>(){

                @Override
                public Integer inject(Integer it, Integer previous) {
                    return it + previous;
                }
            });
        }

        @Override
        public Optional<Double> average() {
            List list = this.toList();
            if (list.isEmpty()) {
                return new Optional<Object>(null);
            }
            double sum = (Double)this.inject((Object)0.0, new Inject<Integer, Double>(){

                @Override
                public Double inject(Integer it, Double previous) {
                    return (double)it.intValue() + previous;
                }
            });
            return new Optional<Double>(sum / (double)list.size());
        }
    }

    public static class ShortFlow
    extends NumberFlow<Short, ShortFlow> {
        ShortFlow(Flow<Short> flow) {
            super(flow);
        }

        public Short[] toArray() {
            List list = this.toList();
            if (list.isEmpty()) {
                return new Short[0];
            }
            return list.toArray(new Short[list.size()]);
        }

        @Override
        public Short sum() {
            return (Short)this.inject((Object)0, new Inject<Short, Short>(){

                @Override
                public Short inject(Short it, Short previous) {
                    return (short)(it + previous);
                }
            });
        }

        @Override
        public Optional<Double> average() {
            List list = this.toList();
            if (list.isEmpty()) {
                return new Optional<Object>(null);
            }
            double sum = (Double)this.inject((Object)0.0, new Inject<Short, Double>(){

                @Override
                public Double inject(Short it, Double previous) {
                    return (double)it.shortValue() + previous;
                }
            });
            return new Optional<Double>(sum / (double)list.size());
        }
    }

    public static class ByteFlow
    extends NumberFlow<Byte, ByteFlow> {
        ByteFlow(Flow<Byte> flow) {
            super(flow);
        }

        public Byte[] toArray() {
            List list = this.toList();
            if (list.isEmpty()) {
                return new Byte[0];
            }
            return list.toArray(new Byte[list.size()]);
        }

        @Override
        public Byte sum() {
            return (Byte)this.inject((Object)0, new Inject<Byte, Byte>(){

                @Override
                public Byte inject(Byte it, Byte previous) {
                    return (byte)(it + previous);
                }
            });
        }

        @Override
        public Optional<Double> average() {
            List list = this.toList();
            if (list.isEmpty()) {
                return new Optional<Object>(null);
            }
            double sum = (Double)this.inject((Object)0.0, new Inject<Byte, Double>(){

                @Override
                public Double inject(Byte it, Double previous) {
                    return (double)it.byteValue() + previous;
                }
            });
            return new Optional<Double>(sum / (double)list.size());
        }
    }
}

