/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.network;

import android.os.Build;
import com.mob.tools.MobLog;
import com.mob.tools.network.HttpConnection;
import com.mob.tools.utils.ReflectHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpConnectionImpl
implements HttpConnection {
    private Object response;

    public HttpConnectionImpl(Object httpResponse) {
        this.response = httpResponse;
    }

    @Override
    public int getResponseCode() throws IOException {
        try {
            Object line = ReflectHelper.invokeInstanceMethod(this.response, "getStatusLine", new Object[0]);
            return (Integer)ReflectHelper.invokeInstanceMethod(line, "getStatusCode", new Object[0]);
        }
        catch (Throwable t) {
            if (Build.VERSION.SDK_INT < 9) {
                throw new IOException(t.getMessage());
            }
            throw new IOException(t);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            Object entity = ReflectHelper.invokeInstanceMethod(this.response, "getEntity", new Object[0]);
            return (InputStream)ReflectHelper.invokeInstanceMethod(entity, "getContent", new Object[0]);
        }
        catch (Throwable t) {
            if (Build.VERSION.SDK_INT < 9) {
                throw new IOException(t.getMessage());
            }
            throw new IOException(t);
        }
    }

    @Override
    public InputStream getErrorStream() throws IOException {
        return this.getInputStream();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() throws IOException {
        try {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            Object allHeaders = ReflectHelper.invokeInstanceMethod(this.response, "getAllHeaders", new Object[0]);
            if (allHeaders != null) {
                Object[] headers = new Object[((Integer)ReflectHelper.getInstanceField(allHeaders, "length")).intValue()];
                System.arraycopy(allHeaders, 0, headers, 0, headers.length);
                for (Object h : headers) {
                    String name = (String)ReflectHelper.invokeInstanceMethod(h, "getName", new Object[0]);
                    String value = (String)ReflectHelper.invokeInstanceMethod(h, "getValue", new Object[0]);
                    value = value == null ? "" : value;
                    String[] values = value.split(",");
                    map.put(name, Arrays.asList(values));
                }
            }
            return map;
        }
        catch (Throwable t) {
            if (Build.VERSION.SDK_INT < 9) {
                throw new IOException(t.getMessage());
            }
            throw new IOException(t);
        }
    }

    static {
        try {
            ReflectHelper.importClass("org.apache.http.HttpResponse");
            ReflectHelper.importClass("org.apache.http.Header");
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
    }
}

