/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.text.TextUtils;
import android.util.Base64;
import com.mob.tools.MobLog;
import com.mob.tools.network.BufferedByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.zip.CRC32;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class Data {
    private static final String CHAT_SET = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static byte[] SHA1(String text) throws Throwable {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        byte[] data = text.getBytes("utf-8");
        return Data.SHA1(data);
    }

    public static byte[] SHA1(byte[] data) throws Throwable {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(data);
        return md.digest();
    }

    public static byte[] SHA1(InputStream data) {
        if (data == null) {
            return null;
        }
        byte[] sha = null;
        try {
            byte[] buf = new byte[1024];
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            int len = data.read(buf);
            while (len != -1) {
                md.update(buf, 0, len);
                len = data.read(buf);
            }
            sha = md.digest();
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            sha = null;
        }
        return sha;
    }

    public static byte[] SHA1(File data) {
        if (data == null || !data.exists()) {
            return null;
        }
        byte[] sha = null;
        try {
            FileInputStream fis = new FileInputStream(data);
            sha = Data.SHA1(fis);
            fis.close();
        }
        catch (Throwable e) {
            MobLog.getInstance().w(e);
        }
        return sha;
    }

    public static byte[] AES128Encode(String key, String text) throws Throwable {
        if (key == null || text == null) {
            return null;
        }
        byte[] keyBytes = key.getBytes("UTF-8");
        byte[] keyBytes16 = new byte[16];
        System.arraycopy(keyBytes, 0, keyBytes16, 0, Math.min(keyBytes.length, 16));
        byte[] data = text.getBytes("UTF-8");
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes16, "AES");
        StringBuilder sb = new StringBuilder();
        sb.append("AES");
        sb.append("/EC");
        sb.append("B/PKCS7P");
        sb.append("adding");
        Cipher cipher = Data.getCipher(sb.toString(), "BC");
        cipher.init(1, keySpec);
        byte[] cipherText = new byte[cipher.getOutputSize(data.length)];
        int ctLength = cipher.update(data, 0, data.length, cipherText, 0);
        cipher.doFinal(cipherText, ctLength);
        return cipherText;
    }

    private static Cipher getCipher(String transformation, String providerName) throws Throwable {
        Cipher cipher = null;
        if (!TextUtils.isEmpty((CharSequence)providerName)) {
            try {
                Provider provider = Security.getProvider(providerName);
                if (provider != null) {
                    cipher = Cipher.getInstance(transformation, provider);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (cipher == null) {
            cipher = Cipher.getInstance(transformation);
        }
        return cipher;
    }

    public static byte[] AES128Encode(byte[] key, String text) throws Throwable {
        if (key == null || text == null) {
            return null;
        }
        byte[] data = text.getBytes("UTF-8");
        return Data.AES128Encode(key, data);
    }

    public static byte[] AES128Encode(byte[] key, byte[] data) throws Throwable {
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        StringBuilder sb = new StringBuilder();
        sb.append("AES");
        sb.append("/EC");
        sb.append("B/PKCS7P");
        sb.append("adding");
        Cipher cipher = Data.getCipher(sb.toString(), "BC");
        cipher.init(1, keySpec);
        byte[] cipherText = new byte[cipher.getOutputSize(data.length)];
        int ctLength = cipher.update(data, 0, data.length, cipherText, 0);
        cipher.doFinal(cipherText, ctLength);
        return cipherText;
    }

    public static String AES128Decode(String key, byte[] cipherText) throws Throwable {
        if (key == null || cipherText == null) {
            return null;
        }
        byte[] keyBytes = key.getBytes("UTF-8");
        byte[] plainText = Data.AES128Decode(keyBytes, cipherText);
        return new String(plainText, "UTF-8");
    }

    public static byte[] AES128Decode(byte[] keyBytes, byte[] cipherText) throws Throwable {
        if (keyBytes == null || cipherText == null) {
            return null;
        }
        byte[] keyBytes16 = new byte[16];
        System.arraycopy(keyBytes, 0, keyBytes16, 0, Math.min(keyBytes.length, 16));
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes16, "AES");
        StringBuilder sb = new StringBuilder();
        sb.append("AES");
        sb.append("/EC");
        sb.append("B/NoP");
        sb.append("adding");
        Cipher cipher = Data.getCipher(sb.toString(), "BC");
        cipher.init(2, keySpec);
        byte[] plainText = new byte[cipher.getOutputSize(cipherText.length)];
        int ptLength = cipher.update(cipherText, 0, cipherText.length, plainText, 0);
        ptLength += cipher.doFinal(plainText, ptLength);
        return plainText;
    }

    public static String byteToHex(byte[] data) {
        return Data.byteToHex(data, 0, data.length);
    }

    public static String byteToHex(byte[] data, int offset, int len) {
        StringBuffer buffer = new StringBuffer();
        if (data == null) {
            return buffer.toString();
        }
        for (int i = offset; i < len; ++i) {
            buffer.append(String.format("%02x", data[i]));
        }
        return buffer.toString();
    }

    public static String base62(long value) {
        String result;
        String string = result = value == 0L ? "0" : "";
        while (value > 0L) {
            int v = (int)(value % 62L);
            value /= 62L;
            result = CHAT_SET.charAt(v) + result;
        }
        return result;
    }

    public static String MD5(String data) {
        if (data == null) {
            return null;
        }
        byte[] tmp = Data.rawMD5(data);
        if (tmp == null) {
            return null;
        }
        return Data.toHex(tmp);
    }

    public static String MD5(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] tmp = Data.rawMD5(data);
        if (tmp == null) {
            return null;
        }
        return Data.toHex(tmp);
    }

    public static String MD5(File data) {
        if (data == null || !data.exists()) {
            return null;
        }
        byte[] md5 = null;
        try {
            FileInputStream fis = new FileInputStream(data);
            md5 = Data.rawMD5(fis);
            fis.close();
        }
        catch (Throwable e) {
            MobLog.getInstance().w(e);
            return null;
        }
        if (md5 == null) {
            return null;
        }
        return Data.toHex(md5);
    }

    public static byte[] rawMD5(String data) {
        if (data == null) {
            return null;
        }
        byte[] md5 = null;
        try {
            md5 = Data.rawMD5(data.getBytes("utf-8"));
        }
        catch (Throwable e) {
            MobLog.getInstance().w(e);
            md5 = null;
        }
        return md5;
    }

    public static byte[] rawMD5(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] md5 = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            md5 = Data.rawMD5(bais);
            bais.close();
        }
        catch (Throwable e) {
            MobLog.getInstance().w(e);
            md5 = null;
        }
        return md5;
    }

    public static byte[] rawMD5(InputStream data) {
        if (data == null) {
            return null;
        }
        byte[] md5 = null;
        try {
            byte[] buf = new byte[1024];
            MessageDigest md = MessageDigest.getInstance("MD5");
            int len = data.read(buf);
            while (len != -1) {
                md.update(buf, 0, len);
                len = data.read(buf);
            }
            md5 = md.digest();
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            md5 = null;
        }
        return md5;
    }

    public static String Base64AES(String msg, String key) {
        if (msg == null || key == null) {
            return null;
        }
        String result = null;
        try {
            result = Base64.encodeToString((byte[])Data.AES128Encode(key, msg), (int)0);
            if (TextUtils.isEmpty((CharSequence)result)) {
                return result;
            }
            if (result.contains("\n")) {
                result = result.replace("\n", "");
            }
        }
        catch (Throwable e) {
            MobLog.getInstance().w(e);
        }
        return result;
    }

    public static String urlEncode(String s, String enc) throws Throwable {
        String text = URLEncoder.encode(s, enc);
        if (TextUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        return text.replace("+", "%20");
    }

    public static String urlEncode(String s) {
        try {
            return Data.urlEncode(s, "utf-8");
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return null;
        }
    }

    public static String CRC32(byte[] data) throws Throwable {
        CRC32 crc = new CRC32();
        crc.update(data);
        long value = crc.getValue();
        StringBuilder sb = new StringBuilder();
        byte b = (byte)(value >>> 56);
        sb.append(String.format("%02x", b & 0xFF));
        b = (byte)(value >>> 48);
        sb.append(String.format("%02x", b & 0xFF));
        b = (byte)(value >>> 40);
        sb.append(String.format("%02x", b & 0xFF));
        b = (byte)(value >>> 32);
        sb.append(String.format("%02x", b & 0xFF));
        b = (byte)(value >>> 24);
        sb.append(String.format("%02x", b & 0xFF));
        b = (byte)(value >>> 16);
        sb.append(String.format("%02x", b & 0xFF));
        b = (byte)(value >>> 8);
        sb.append(String.format("%02x", b & 0xFF));
        b = (byte)value;
        sb.append(String.format("%02x", b & 0xFF));
        while (sb.charAt(0) == '0') {
            sb = sb.deleteCharAt(0);
        }
        return sb.toString().toLowerCase();
    }

    public static byte[] rawRSAEncode(byte[] data, byte[] publicKey, int keySize) throws Throwable {
        int blockSize = keySize / 8 - 11;
        X509EncodedKeySpec spec = new X509EncodedKeySpec(publicKey);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        RSAPublicKey key = (RSAPublicKey)factory.generatePublic(spec);
        Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding");
        cipher.init(1, key);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int offSet = 0;
        while (data.length - offSet > 0) {
            int inputLen = Math.min(data.length - offSet, blockSize);
            byte[] cache = cipher.doFinal(data, offSet, inputLen);
            baos.write(cache, 0, cache.length);
            offSet += blockSize;
        }
        baos.close();
        return baos.toByteArray();
    }

    public static byte[] rawRSADecode(byte[] data, byte[] privateKey, int keySize) throws Throwable {
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec pkeySpec = new PKCS8EncodedKeySpec(privateKey);
        RSAPrivateKey key = (RSAPrivateKey)factory.generatePrivate(pkeySpec);
        Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding");
        cipher.init(2, key);
        int offSet = 0;
        int blockSize = keySize / 8;
        BufferedByteArrayOutputStream baos = new BufferedByteArrayOutputStream();
        while (data.length - offSet > 0) {
            int inputLen = Math.min(data.length - offSet, blockSize);
            byte[] cache = cipher.doFinal(data, offSet, inputLen);
            baos.write(cache, 0, cache.length);
            offSet += blockSize;
        }
        baos.close();
        return baos.toByteArray();
    }

    private static String toHex(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            buffer.append(String.format("%02x", data[i]));
        }
        return buffer.toString();
    }

    private static byte[] hexToBytes(String hex) {
        byte[] b = new byte[hex.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            int index = i * 2;
            b[i] = (byte)Integer.parseInt(hex.substring(index, index + 2), 16);
        }
        return b;
    }
}

