/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class SQLiteHelper {
    public static SingleTableDB getDatabase(Context context, String name) {
        String path = context.getDatabasePath(name).getPath();
        return SQLiteHelper.getDatabase(path, name);
    }

    public static SingleTableDB getDatabase(String path, String name) {
        return new SingleTableDB(path, name);
    }

    public static long insert(SingleTableDB db, ContentValues values) throws Throwable {
        db.open();
        return db.db.replace(db.getName(), null, values);
    }

    public static int delete(SingleTableDB db, String selection, String[] selectionArgs) throws Throwable {
        db.open();
        return db.db.delete(db.getName(), selection, selectionArgs);
    }

    public static int update(SingleTableDB db, ContentValues values, String selection, String[] selectionArgs) throws Throwable {
        db.open();
        return db.db.update(db.getName(), values, selection, selectionArgs);
    }

    public static Cursor query(SingleTableDB db, String[] columns, String selection, String[] selectionArgs, String sortOrder) throws Throwable {
        db.open();
        return db.db.query(db.getName(), columns, selection, selectionArgs, null, null, sortOrder);
    }

    public static void execSQL(SingleTableDB db, String script) throws Throwable {
        db.open();
        db.db.beginTransaction();
        try {
            db.db.execSQL(script);
            db.db.setTransactionSuccessful();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            db.db.endTransaction();
        }
    }

    public static Cursor rawQuery(SingleTableDB db, String script, String[] selectionArgs) throws Throwable {
        db.open();
        return db.db.rawQuery(script, selectionArgs);
    }

    public static int getSize(SingleTableDB db) throws Throwable {
        db.open();
        int count = 0;
        Cursor c = null;
        try {
            c = db.db.query(db.getName(), null, null, null, null, null, null);
            count = c == null ? 0 : c.getCount();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return count;
    }

    public static void close(SingleTableDB db) {
        db.close();
    }

    public static class SingleTableDB {
        private String path;
        private String name;
        private SQLiteDatabase db;
        private LinkedHashMap<String, String> fieldTypes;
        private HashMap<String, Boolean> fieldLimits;
        private String primary;
        private boolean primaryAutoincrement;

        private SingleTableDB(String path, String name) {
            this.path = path;
            this.name = name;
            this.fieldTypes = new LinkedHashMap();
            this.fieldLimits = new HashMap();
        }

        public void addField(String fieldName, String fieldType, boolean notNull) {
            if (this.db == null) {
                this.fieldTypes.put(fieldName, fieldType);
                this.fieldLimits.put(fieldName, notNull);
            }
        }

        public void setPrimary(String fieldName, boolean autoincrement) {
            this.primary = fieldName;
            this.primaryAutoincrement = autoincrement;
        }

        private void open() {
            File file = new File(this.path);
            if (this.db != null && !file.exists()) {
                this.db.close();
                File parentFile = file.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                this.db = null;
            }
            if (this.db == null) {
                this.db = SQLiteDatabase.openOrCreateDatabase((File)file, null);
                Cursor cursor = this.db.query("sqlite_master", null, "type=? and name=?", new String[]{"table", this.name}, null, null, null);
                boolean shouldCreate = true;
                if (cursor != null) {
                    if (cursor.getCount() > 0) {
                        shouldCreate = false;
                    }
                    cursor.close();
                }
                if (shouldCreate) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("create table  ").append(this.name).append("(");
                    for (Map.Entry<String, String> ent : this.fieldTypes.entrySet()) {
                        String field = ent.getKey();
                        String type = ent.getValue();
                        boolean notNull = this.fieldLimits.get(field);
                        boolean primary = field.equals(this.primary);
                        boolean autoincrement = primary ? this.primaryAutoincrement : false;
                        sb.append(field).append(" ").append(type);
                        sb.append(notNull ? " not null" : "");
                        sb.append(primary ? " primary key" : "");
                        sb.append(autoincrement ? " autoincrement," : ",");
                    }
                    sb.replace(sb.length() - 1, sb.length(), ");");
                    this.db.execSQL(sb.toString());
                }
            }
        }

        private void close() {
            if (this.db != null) {
                this.db.close();
                this.db = null;
            }
        }

        private String getName() {
            return this.name;
        }
    }
}

