/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.wechat.utils;

import android.graphics.Bitmap;
import android.os.Bundle;
import cn.sharesdk.framework.utils.e;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public final class WXMediaMessage {
    public static final String ACTION_WXAPPMESSAGE = "com.tencent.mm.sdk.openapi.Intent.ACTION_WXAPPMESSAGE";
    public int sdkVer;
    public String title;
    public String description;
    public byte[] thumbData;
    public IMediaObject mediaObject;

    public WXMediaMessage() {
        this(null);
    }

    public WXMediaMessage(IMediaObject paramIMediaObject) {
        this.mediaObject = paramIMediaObject;
    }

    public final int getType() {
        if (this.mediaObject == null) {
            return 0;
        }
        return this.mediaObject.type();
    }

    public final void setThumbImage(Bitmap paramBitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            paramBitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.thumbData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            e.b().d((Throwable)exception);
            e.b().d((Object)"put thumb failed", new Object[0]);
            return;
        }
    }

    public static interface IMediaObject {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_TEXT = 1;
        public static final int TYPE_IMAGE = 2;
        public static final int TYPE_MUSIC = 3;
        public static final int TYPE_VIDEO = 4;
        public static final int TYPE_URL = 5;
        public static final int TYPE_FILE = 6;
        public static final int TYPE_APPDATA = 7;
        public static final int TYPE_EMOJI = 8;
        public static final int TYPE_MINIPROGRAM = 9;

        public void serialize(Bundle var1);

        public void unserialize(Bundle var1);

        public int type();

        public boolean checkArgs();
    }

    public static class a {
        public static Bundle a(WXMediaMessage wXMediaMessage) {
            Bundle bundle = new Bundle();
            bundle.putInt("_wxobject_sdkVer", wXMediaMessage.sdkVer);
            bundle.putString("_wxobject_title", wXMediaMessage.title);
            bundle.putString("_wxobject_description", wXMediaMessage.description);
            bundle.putByteArray("_wxobject_thumbdata", wXMediaMessage.thumbData);
            if (wXMediaMessage.mediaObject != null) {
                String string = "com.tencent.mm.sdk.openapi." + wXMediaMessage.mediaObject.getClass().getSimpleName();
                bundle.putString("_wxobject_identifier_", string);
                wXMediaMessage.mediaObject.serialize(bundle);
            }
            return bundle;
        }

        public static WXMediaMessage a(Bundle bundle) {
            WXMediaMessage wXMediaMessage = new WXMediaMessage();
            wXMediaMessage.sdkVer = bundle.getInt("_wxobject_sdkVer");
            wXMediaMessage.title = bundle.getString("_wxobject_title");
            wXMediaMessage.description = bundle.getString("_wxobject_description");
            wXMediaMessage.thumbData = bundle.getByteArray("_wxobject_thumbdata");
            String string = bundle.getString("_wxobject_identifier_");
            if (string == null || string.length() <= 0) {
                return wXMediaMessage;
            }
            try {
                string = string.replace("com.tencent.mm.sdk.openapi", "cn.sharesdk.wechat.utils");
                Class<?> clazz = Class.forName(string);
                wXMediaMessage.mediaObject = (IMediaObject)clazz.newInstance();
                wXMediaMessage.mediaObject.unserialize(bundle);
                return wXMediaMessage;
            }
            catch (Exception exception) {
                e.b().d((Throwable)exception);
                e.b().d((Object)("get media object from bundle failed: unknown ident " + string), new Object[0]);
                return wXMediaMessage;
            }
        }
    }
}

