/*
 * Decompiled with CFR 0.152.
 */
package com.mob;

import android.text.TextUtils;
import android.util.Base64;
import com.mob.MobSDK;
import com.mob.commons.MobProductCollector;
import com.mob.tools.MobLog;
import com.mob.tools.RxMob;
import com.mob.tools.network.HTTPPart;
import com.mob.tools.network.HttpConnection;
import com.mob.tools.network.HttpResponseCallback;
import com.mob.tools.network.KVPair;
import com.mob.tools.network.NetworkHelper;
import com.mob.tools.network.StringPart;
import com.mob.tools.proguard.PublicMemberKeeper;
import com.mob.tools.utils.Data;
import com.mob.tools.utils.Hashon;
import com.mob.tools.utils.MobRSA;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPOutputStream;

public final class MobCommunicator
implements PublicMemberKeeper {
    private Random a = new Random();
    private BigInteger b;
    private BigInteger c;
    private MobRSA d;
    private Hashon e;
    private NetworkHelper f;
    private NetworkHelper.NetworkTimeOut g;

    public MobCommunicator(int n, String string, String string2) {
        this.d = new MobRSA(n);
        this.b = new BigInteger(string, 16);
        this.c = new BigInteger(string2, 16);
        this.e = new Hashon();
        this.f = new NetworkHelper();
        this.g = new NetworkHelper.NetworkTimeOut();
        this.g.readTimout = 30000;
        this.g.connectionTimeout = 5000;
    }

    public <T> void request(final HashMap<String, Object> hashMap, final String string, final boolean bl, final Callback<T> callback) {
        RxMob.Subscribable subscribable = RxMob.create((RxMob.OnSubscribe)new RxMob.QuickSubscribe<T>(){

            protected void doNext(RxMob.Subscriber<T> subscriber) throws Throwable {
                Object t = MobCommunicator.this.requestSynchronized(hashMap, string, bl);
                subscriber.onNext(t);
            }
        });
        subscribable.subscribeOnNewThreadAndObserveOnUIThread(new RxMob.Subscriber<T>(){

            public void onNext(T t) {
                callback.onResultOk(t);
            }

            public void onError(Throwable throwable) {
                callback.onResultError(throwable);
            }
        });
    }

    public <T> T requestSynchronized(HashMap<String, Object> hashMap, String string, boolean bl) throws Throwable {
        String string2;
        if (hashMap == null) {
            string2 = "{}";
        } else {
            string2 = this.e.fromHashMap(hashMap);
            if (string2.length() == 0) {
                string2 = "{}";
            }
        }
        return this.requestSynchronized(string2, string, bl);
    }

    public <T> T requestSynchronized(String string, String string2, boolean bl) throws Throwable {
        byte[] byArray = this.a();
        String string3 = this.a(byArray, string, bl);
        int n = string3.getBytes("utf-8").length;
        ArrayList<KVPair<String>> arrayList = this.a(string, n);
        String[] stringArray = new String[1];
        HttpResponseCallback httpResponseCallback = this.a(byArray, stringArray);
        StringPart stringPart = new StringPart();
        stringPart.append(string3);
        MobLog.getInstance().d((Object)(">>>  request: " + string + "\nurl = " + string2 + "\nheader = " + arrayList.toString()), new Object[0]);
        this.f.rawPost(string2, arrayList, (HTTPPart)stringPart, -1, httpResponseCallback, this.g);
        if (stringArray[0] != null) {
            MobLog.getInstance().d((Object)(">>> response: " + stringArray[0]), new Object[0]);
            return (T)this.a(stringArray[0]);
        }
        return null;
    }

    private byte[] a(byte[] byArray) throws Throwable {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(gZIPOutputStream);
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] a() throws Throwable {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.a.setSeed(System.currentTimeMillis());
        dataOutputStream.writeLong(this.a.nextLong());
        dataOutputStream.writeLong(this.a.nextLong());
        dataOutputStream.flush();
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private String a(byte[] byArray, String string, boolean bl) throws Throwable {
        byte[] byArray2 = string.getBytes("utf-8");
        if (bl) {
            byArray2 = this.a(byArray2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray3 = this.d.encode(byArray, this.b, this.c);
        dataOutputStream.writeInt(byArray3.length);
        dataOutputStream.write(byArray3);
        byte[] byArray4 = Data.AES128Encode((byte[])byArray, (byte[])byArray2);
        dataOutputStream.writeInt(byArray4.length);
        dataOutputStream.write(byArray4);
        dataOutputStream.flush();
        dataOutputStream.close();
        return Base64.encodeToString((byte[])byteArrayOutputStream.toByteArray(), (int)2);
    }

    private ArrayList<KVPair<String>> a(String string, int n) throws Throwable {
        if (TextUtils.isEmpty((CharSequence)MobSDK.getAppSecret())) {
            throw new SecurityException("App secret should not be null");
        }
        ArrayList<KVPair<String>> arrayList = new ArrayList<KVPair<String>>();
        arrayList.add(new KVPair("sign", (Object)Data.MD5((String)(string + MobSDK.getAppSecret()))));
        arrayList.add(new KVPair("key", (Object)MobSDK.getAppkey()));
        arrayList.add(new KVPair("Content-Length", (Object)String.valueOf(n)));
        arrayList.add(new KVPair("User-Identity", (Object)MobProductCollector.getUserIdentity()));
        return arrayList;
    }

    private HttpResponseCallback a(final byte[] byArray, final String[] stringArray) {
        return new HttpResponseCallback(){

            public void onResponse(HttpConnection httpConnection) throws Throwable {
                int n = httpConnection.getResponseCode();
                InputStream inputStream = n == 200 ? httpConnection.getInputStream() : httpConnection.getErrorStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[1024];
                int n2 = inputStream.read(byArray2);
                while (n2 != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n2);
                    n2 = inputStream.read(byArray2);
                }
                inputStream.close();
                byteArrayOutputStream.close();
                byArray2 = byteArrayOutputStream.toByteArray();
                if (n != 200) {
                    HashMap hashMap = MobCommunicator.this.e.fromJson(new String(byArray2, "utf-8"));
                    hashMap.put("httpStatus", n);
                    throw new NetworkError(MobCommunicator.this.e.fromHashMap(hashMap));
                }
                long l = MobCommunicator.this.a(httpConnection);
                if (l == -1L || l != (long)byArray2.length) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("httpStatus", n);
                    hashMap.put("status", -2);
                    hashMap.put("error", "Illegal content length");
                    throw new NetworkError(MobCommunicator.this.e.fromHashMap(hashMap));
                }
                stringArray[0] = MobCommunicator.this.a(byArray, byArray2);
            }
        };
    }

    private long a(HttpConnection httpConnection) throws Throwable {
        long l = -1L;
        List<String> list = this.a(httpConnection, "Content-Length");
        if (list != null && list.size() > 0) {
            l = Long.parseLong(list.get(0));
        }
        return l;
    }

    private List<String> a(HttpConnection httpConnection, String string) throws Throwable {
        Map map = httpConnection.getHeaderFields();
        if (map != null && !map.isEmpty()) {
            for (String string2 : map.keySet()) {
                if (string2 == null || !string2.equals(string)) continue;
                return (List)map.get(string2);
            }
        }
        return null;
    }

    private String a(byte[] byArray, byte[] byArray2) throws Throwable {
        byte[] byArray3 = Base64.decode((byte[])byArray2, (int)2);
        byte[] byArray4 = Data.AES128Decode((byte[])byArray, (byte[])byArray3);
        return new String(byArray4, "utf-8");
    }

    private Object a(String string) throws Throwable {
        if (string == null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("status", -1);
            hashMap.put("error", "response is empty");
            throw new NetworkError(this.e.fromHashMap(hashMap));
        }
        HashMap hashMap = this.e.fromJson(string.trim());
        if (hashMap.isEmpty()) {
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put("status", -1);
            hashMap2.put("error", "response is empty");
            throw new NetworkError(this.e.fromHashMap(hashMap2));
        }
        return hashMap.get("res");
    }

    public static class NetworkError
    extends Exception
    implements PublicMemberKeeper {
        private static final long serialVersionUID = -8447657431687664787L;

        public NetworkError(String string) {
            super(string);
        }
    }

    public static class Callback<T>
    implements PublicMemberKeeper {
        public void onResultOk(T t) {
        }

        public void onResultError(Throwable throwable) {
        }
    }
}

